/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.message;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.message.StampyMessageHeader;
import asia.stampy.common.message.StompMessageType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StampyLibrary(libraryName="stampy-core")
public abstract class AbstractMessage<HDR extends StampyMessageHeader>
implements StampyMessage<HDR> {
    private static final long serialVersionUID = -577180637937320507L;
    private HDR header;
    private final StompMessageType messageType;

    protected AbstractMessage(StompMessageType messageType) {
        this.messageType = messageType;
    }

    @Override
    public HDR getHeader() {
        if (this.header == null) {
            this.header = this.createNewHeader();
        }
        return this.header;
    }

    protected abstract HDR createNewHeader();

    @Override
    public StompMessageType getMessageType() {
        return this.messageType;
    }

    @Override
    public final String toStompMessage(boolean validate) {
        if (validate) {
            this.validate();
        }
        StringBuilder builder = new StringBuilder();
        String body = this.postHeader();
        builder.append(this.getMessageType().name());
        String header = this.getHeader().toMessageHeader();
        if (StringUtils.isNotEmpty((String)header)) {
            builder.append("\n");
            builder.append(header);
        }
        builder.append("\n\n");
        builder.append(body);
        builder.append("\u0000");
        return builder.toString();
    }

    @Override
    public abstract void validate();

    protected String postHeader() {
        return null;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

