/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.message;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.message.StampyMessageHeader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StampyLibrary(libraryName="stampy-core")
public abstract class AbstractMessageHeader
implements StampyMessageHeader {
    private static final long serialVersionUID = 4570408820942642173L;
    public static final String CONTENT_LENGTH = "content-length";
    private Map<String, String> headers = new HashMap<String, String>();

    public void setContentLength(int length) {
        this.addHeader(CONTENT_LENGTH, Integer.toString(length));
    }

    public int getContentLength() {
        String length = this.getHeaderValue(CONTENT_LENGTH);
        if (length == null) {
            return -1;
        }
        return Integer.parseInt(length);
    }

    @Override
    public void addHeader(String key, String value) {
        if (!this.hasHeader(key)) {
            this.headers.put(key, value);
        }
    }

    @Override
    public void removeHeader(String key) {
        this.headers.remove(key);
    }

    @Override
    public String getHeaderValue(String key) {
        return this.headers.get(key);
    }

    @Override
    public boolean hasHeader(String key) {
        return this.headers.containsKey(key);
    }

    @Override
    public final String toMessageHeader() {
        boolean first = true;
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            if (!first) {
                builder.append("\n");
            }
            builder.append(entry.getKey());
            builder.append(":");
            builder.append(entry.getValue());
            first = false;
        }
        return builder.toString();
    }

    @Override
    public Map<String, String> getHeaders() {
        return new HashMap<String, String>(this.headers);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        return this.toMessageHeader();
    }
}

