/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.parsing;

import asia.stampy.client.message.abort.AbortMessage;
import asia.stampy.client.message.ack.AckMessage;
import asia.stampy.client.message.begin.BeginMessage;
import asia.stampy.client.message.commit.CommitMessage;
import asia.stampy.client.message.connect.ConnectMessage;
import asia.stampy.client.message.disconnect.DisconnectMessage;
import asia.stampy.client.message.nack.NackMessage;
import asia.stampy.client.message.send.SendMessage;
import asia.stampy.client.message.stomp.StompMessage;
import asia.stampy.client.message.subscribe.SubscribeMessage;
import asia.stampy.client.message.unsubscribe.UnsubscribeMessage;
import asia.stampy.common.StampyLibrary;
import asia.stampy.common.message.AbstractBodyMessage;
import asia.stampy.common.message.AbstractBodyMessageHeader;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.message.StompMessageType;
import asia.stampy.common.parsing.IllegalObjectException;
import asia.stampy.common.parsing.UnparseableException;
import asia.stampy.common.serialization.SerializationUtils;
import asia.stampy.server.message.connected.ConnectedMessage;
import asia.stampy.server.message.error.ErrorMessage;
import asia.stampy.server.message.message.MessageMessage;
import asia.stampy.server.message.receipt.ReceiptMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StampyLibrary(libraryName="stampy-core")
public class StompMessageParser {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String EOM = "\u0000";

    public <MSG extends StampyMessage<?>> MSG parseMessage(String stompMessage) throws UnparseableException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(stompMessage));
            String messageType = reader.readLine();
            StompMessageType type = StompMessageType.valueOf(messageType);
            ArrayList<String> headers = new ArrayList<String>();
            String hdr = reader.readLine();
            while (StringUtils.isNotEmpty((String)hdr)) {
                headers.add(hdr);
                hdr = reader.readLine();
            }
            String body = reader.readLine();
            body = body == null || body.equals(EOM) ? null : this.fillBody(body, reader);
            MSG msg = this.createStampyMessage(type, headers);
            if (!StringUtils.isEmpty((String)body) && msg instanceof AbstractBodyMessage) {
                AbstractBodyMessage abm = (AbstractBodyMessage)msg;
                abm.setBody(this.isText(headers) ? body : this.convertToObject(body, ((AbstractBodyMessageHeader)abm.getHeader()).getContentType()));
            }
            MSG MSG = msg;
            return MSG;
        }
        catch (Exception e) {
            throw new UnparseableException("The message supplied cannot be parsed as a STOMP message", stompMessage, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.warn("Could not close reader", (Throwable)e);
                }
            }
        }
    }

    protected Object convertToObject(String body, String contentType) throws IllegalObjectException, ClassNotFoundException, IOException {
        if (!"java/base64".equals(contentType)) {
            throw new NotImplementedException("Subclass this class and override convertToObject to enable conversion using mime type " + contentType);
        }
        Object o = SerializationUtils.deserializeBase64(body);
        this.illegalObjectCheck(o);
        return o;
    }

    protected void illegalObjectCheck(Object o) throws IllegalObjectException {
    }

    protected boolean isText(List<String> headers) {
        boolean text = false;
        boolean content = false;
        for (String hdr : headers) {
            if (!hdr.contains("content-type")) continue;
            content = true;
            text = hdr.contains("text/");
        }
        return !content || content && text;
    }

    protected <MSG extends StampyMessage<?>> MSG createStampyMessage(StompMessageType type, List<String> headers) throws UnparseableException {
        StampyMessage message = null;
        switch (type) {
            case ABORT: {
                message = new AbortMessage();
                break;
            }
            case ACK: {
                message = new AckMessage();
                break;
            }
            case BEGIN: {
                message = new BeginMessage();
                break;
            }
            case COMMIT: {
                message = new CommitMessage();
                break;
            }
            case CONNECT: {
                message = new ConnectMessage();
                break;
            }
            case CONNECTED: {
                message = new ConnectedMessage();
                break;
            }
            case DISCONNECT: {
                message = new DisconnectMessage();
                break;
            }
            case ERROR: {
                ErrorMessage error = new ErrorMessage();
                message = error;
                break;
            }
            case MESSAGE: {
                MessageMessage mm = new MessageMessage();
                message = mm;
                break;
            }
            case NACK: {
                message = new NackMessage();
                break;
            }
            case RECEIPT: {
                message = new ReceiptMessage();
                break;
            }
            case SEND: {
                SendMessage send = new SendMessage();
                message = send;
                break;
            }
            case STOMP: {
                message = new StompMessage();
                break;
            }
            case SUBSCRIBE: {
                message = new SubscribeMessage();
                break;
            }
            case UNSUBSCRIBE: {
                message = new UnsubscribeMessage();
                break;
            }
        }
        message.getHeader();
        this.addHeaders(message, headers);
        return (MSG)message;
    }

    private <MSG extends StampyMessage<?>> void addHeaders(MSG message, List<String> headers) throws UnparseableException {
        for (String header : headers) {
            StringTokenizer st = new StringTokenizer(header, ":");
            if (st.countTokens() < 2) {
                log.error("Cannot parse STOMP header {}", (Object)header);
                throw new UnparseableException("Cannot parse STOMP header " + header);
            }
            String key = st.nextToken();
            String value = header.substring(key.length() + 1);
            message.getHeader().addHeader(key, value);
        }
    }

    protected String fillBody(String body, BufferedReader reader) throws IOException {
        StringBuilder builder = new StringBuilder(this.trimEOM(body));
        String s = reader.readLine();
        while (s != null) {
            builder.append(this.trimEOM(s));
            s = reader.readLine();
        }
        return builder.toString();
    }

    protected String trimEOM(String s) {
        String trimmed = s;
        if (s.contains(EOM)) {
            int idx = s.indexOf(EOM);
            trimmed = s.substring(0, idx);
        }
        return trimmed;
    }
}

