/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.serialization;

import asia.stampy.common.StampyLibrary;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.binary.Base64;

@StampyLibrary(libraryName="stampy-core")
public class SerializationUtils {
    private static Lock SERIALIZE_LOCK = new ReentrantLock(true);
    private static Lock DESERIALIZE_LOCK = new ReentrantLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serializeBase64(Object o) throws IOException {
        SERIALIZE_LOCK.lock();
        try {
            if (o instanceof byte[]) {
                String string = Base64.encodeBase64String((byte[])((byte[])o));
                return string;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            String string = Base64.encodeBase64String((byte[])baos.toByteArray());
            return string;
        }
        finally {
            SERIALIZE_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeBase64(String s) throws IOException, ClassNotFoundException {
        DESERIALIZE_LOCK.lock();
        try {
            byte[] bytes = Base64.decodeBase64((String)s);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object object = ois.readObject();
            return object;
        }
        finally {
            DESERIALIZE_LOCK.unlock();
        }
    }
}

