/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.server.message.connected;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.message.AbstractMessageHeader;

@StampyLibrary(libraryName="stampy-core")
public class ConnectedHeader
extends AbstractMessageHeader {
    private static final long serialVersionUID = 1548982417648641349L;
    public static final String SESSION = "session";
    public static final String SERVER = "server";
    public static final String HEART_BEAT = "heart-beat";
    public static final String VERSION = "version";

    public void setVersion(String version) {
        this.addHeader(VERSION, version);
    }

    public String getVersion() {
        return this.getHeaderValue(VERSION);
    }

    public void setHeartbeat(int outgoingHeartbeat, int incomingHeartbeat) {
        this.addHeader(HEART_BEAT, Integer.toString(outgoingHeartbeat) + "," + Integer.toString(incomingHeartbeat));
    }

    public int getOutgoingHeartbeat() {
        return this.getHeartbeat(0);
    }

    public int getIncomingHeartbeat() {
        return this.getHeartbeat(1);
    }

    private int getHeartbeat(int pos) {
        String hb = this.getHeaderValue(HEART_BEAT);
        if (hb == null) {
            return 0;
        }
        String[] parts = hb.split(",");
        return Integer.parseInt(parts[pos]);
    }

    public void setServer(String server) {
        this.addHeader(SERVER, server);
    }

    public String getServer() {
        return this.getHeaderValue(SERVER);
    }

    public void setSession(String session) {
        this.addHeader(SESSION, session);
    }

    public String getSession() {
        return this.getHeaderValue(SESSION);
    }
}

