/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.xerces.util.SecuritySupport;

public class ObjectFactory {
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$org$apache$xerces$util$ObjectFactory;

    public static Object createObject(String string, String string2) throws ConfigurationError {
        return ObjectFactory.createObject(string, null, string2);
    }

    public static Object createObject(String string, String string2, String string3) throws ConfigurationError {
        Object object;
        ObjectFactory.debugPrintln("debug is on");
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        try {
            object = securitySupport.getSystemProperty(string);
            if (object != null) {
                ObjectFactory.debugPrintln("found system property, value=" + (String)object);
                return ObjectFactory.newInstance((String)object, classLoader, true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            object = securitySupport.getSystemProperty("java.home");
            String string4 = (String)object + File.separator + "lib" + File.separator + "propertiesFilename";
            FileInputStream fileInputStream = securitySupport.getFileInputStream(new File(string4));
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string5 = properties.getProperty(string);
            if (string5 != null) {
                ObjectFactory.debugPrintln("found in jaxp.properties, value=" + string5);
                return ObjectFactory.newInstance(string5, classLoader, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = ObjectFactory.findJarServiceProvider(string);
        if (object != null) {
            return object;
        }
        if (string3 == null) {
            throw new ConfigurationError("Provider for " + string + " cannot be found", null);
        }
        ObjectFactory.debugPrintln("using fallback, value=" + string3);
        return ObjectFactory.newInstance(string3, classLoader, true);
    }

    private static void debugPrintln(String string) {
    }

    private static ClassLoader findClassLoader() throws ConfigurationError {
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        ClassLoader classLoader = securitySupport.getContextClassLoader();
        if (classLoader == null) {
            classLoader = (class$org$apache$xerces$util$ObjectFactory == null ? (class$org$apache$xerces$util$ObjectFactory = ObjectFactory.class$("org.apache.xerces.util.ObjectFactory")) : class$org$apache$xerces$util$ObjectFactory).getClassLoader();
        }
        return classLoader;
    }

    private static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class<?> clazz;
            if (classLoader == null) {
                clazz = Class.forName(string);
            } else {
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (bl) {
                        classLoader = (class$org$apache$xerces$util$ObjectFactory == null ? (class$org$apache$xerces$util$ObjectFactory = ObjectFactory.class$("org.apache.xerces.util.ObjectFactory")) : class$org$apache$xerces$util$ObjectFactory).getClassLoader();
                        clazz = classLoader.loadClass(string);
                    }
                    throw classNotFoundException;
                }
            }
            Object obj = clazz.newInstance();
            ObjectFactory.debugPrintln("created new instance of " + clazz + " using ClassLoader: " + classLoader);
            return obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    private static Object findJarServiceProvider(String string) throws ConfigurationError {
        BufferedReader bufferedReader;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        String string2 = "META-INF/services/" + string;
        InputStream inputStream = null;
        ClassLoader classLoader = securitySupport.getContextClassLoader();
        if (classLoader != null) {
            inputStream = securitySupport.getResourceAsStream(classLoader, string2);
            if (inputStream == null) {
                classLoader = (class$org$apache$xerces$util$ObjectFactory == null ? (class$org$apache$xerces$util$ObjectFactory = ObjectFactory.class$("org.apache.xerces.util.ObjectFactory")) : class$org$apache$xerces$util$ObjectFactory).getClassLoader();
                inputStream = securitySupport.getResourceAsStream(classLoader, string2);
            }
        } else {
            classLoader = (class$org$apache$xerces$util$ObjectFactory == null ? (class$org$apache$xerces$util$ObjectFactory = ObjectFactory.class$("org.apache.xerces.util.ObjectFactory")) : class$org$apache$xerces$util$ObjectFactory).getClassLoader();
            inputStream = securitySupport.getResourceAsStream(classLoader, string2);
        }
        if (inputStream == null) {
            return null;
        }
        ObjectFactory.debugPrintln("found jar resource=" + string2 + " using ClassLoader: " + classLoader);
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        String string3 = null;
        try {
            string3 = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return null;
        }
        if (string3 != null && !"".equals(string3)) {
            ObjectFactory.debugPrintln("found in resource, value=" + string3);
            return ObjectFactory.newInstance(string3, classLoader, false);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ConfigurationError
    extends Error {
        private Exception exception;

        public ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

