/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildOptionsAdapter;
import org.aspectj.ajde.BuildProgressMonitor;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.ajde.internal.BuildNotifierAdapter;
import org.aspectj.ajdt.ajc.AjdtCommand;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.CountingMessageHandler;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.MessageHandler;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.LangUtil;
import org.eclipse.core.runtime.OperationCanceledException;

public class CompilerAdapter {
    private AjBuildManager buildManager = null;
    private MessageHandlerAdapter messageHandler = null;
    private BuildNotifierAdapter currNotifier = null;
    private boolean initialized = false;
    private boolean structureDirty = true;
    private boolean showInfoMessages = false;
    private boolean nextBuild = false;

    public void showInfoMessages(boolean show) {
        this.showInfoMessages = show;
    }

    public boolean getShowInfoMessages() {
        return this.showInfoMessages;
    }

    public void nextBuildFresh() {
        if (this.nextBuild) {
            this.nextBuild = false;
        }
    }

    public void requestCompileExit() {
        if (this.currNotifier != null) {
            this.currNotifier.cancelBuild();
        } else {
            this.signalText("unable to cancel build process");
        }
    }

    public boolean isStructureDirty() {
        return this.structureDirty;
    }

    public void setStructureDirty(boolean structureDirty) {
        this.structureDirty = structureDirty;
    }

    public boolean compile(String configFile, BuildProgressMonitor progressMonitor) {
        this.init();
        try {
            boolean incrementalEnabled;
            AjBuildConfig buildConfig = this.genBuildConfig(configFile);
            if (null == buildConfig) {
                return false;
            }
            this.currNotifier = new BuildNotifierAdapter(progressMonitor);
            this.buildManager.setProgressListener(this.currNotifier);
            this.messageHandler.setBuildNotifierAdapter(this.currNotifier);
            String rtInfo = this.buildManager.checkRtJar(buildConfig);
            if (rtInfo != null) {
                this.signalWarning("AspectJ Runtime error: " + rtInfo + "  Please place a valid aspectjrt.jar on the classpath.");
                return false;
            }
            boolean bl = incrementalEnabled = buildConfig.isIncrementalMode() || buildConfig.isIncrementalFileMode();
            if (incrementalEnabled && this.nextBuild) {
                return this.buildManager.incrementalBuild(buildConfig, this.messageHandler);
            }
            if (incrementalEnabled) {
                this.nextBuild = incrementalEnabled;
            }
            return this.buildManager.batchBuild(buildConfig, this.messageHandler);
        }
        catch (OperationCanceledException ce) {
            this.signalWarning("build cancelled by user");
            return false;
        }
        catch (AbortException e) {
            IMessage message = e.getIMessage();
            if (null == message) {
                this.signalThrown(e);
            } else if (null != message.getMessage()) {
                this.signalWarning(message.getMessage());
            } else if (null != message.getThrown()) {
                this.signalThrown(message.getThrown());
            } else {
                this.signalThrown(e);
            }
            return false;
        }
        catch (Throwable t) {
            this.signalThrown(t);
            return false;
        }
    }

    public AjBuildConfig genBuildConfig(String configFile) {
        this.init();
        File config = new File(configFile);
        if (!config.exists()) {
            this.signalError("Config file \"" + configFile + "\" does not exist.");
            return null;
        }
        String[] args = new String[]{"@" + config.getAbsolutePath()};
        CountingMessageHandler counter = CountingMessageHandler.makeCountingMessageHandler(this.messageHandler);
        AjBuildConfig local = AjdtCommand.genBuildConfig(args, counter);
        if (counter.hasErrors()) {
            return null;
        }
        local.setConfigFile(config);
        AjBuildConfig global = new AjBuildConfig();
        BuildOptionsAdapter buildOptions = Ajde.getDefault().getBuildManager().getBuildOptions();
        if (!CompilerAdapter.configureBuildOptions(global, buildOptions, counter)) {
            return null;
        }
        ProjectPropertiesAdapter projectOptions = Ajde.getDefault().getProjectProperties();
        this.configureProjectOptions(global, projectOptions);
        local.installGlobals(global);
        String errs = local.configErrors();
        if (null != errs) {
            MessageUtil.error(counter, errs);
            return null;
        }
        local.setGenerateModelMode(true);
        return this.fixupBuildConfig(local, global, buildOptions, projectOptions);
    }

    protected AjBuildConfig fixupBuildConfig(AjBuildConfig local, AjBuildConfig global, BuildOptionsAdapter buildOptions, ProjectPropertiesAdapter projectOptions) {
        return local;
    }

    protected void signalError(String text) {
        Ajde.getDefault().getErrorHandler().handleError(text);
    }

    protected void signalWarning(String text) {
        Ajde.getDefault().getErrorHandler().handleWarning(text);
    }

    protected void signalText(String text) {
        Ajde.getDefault().getIdeUIAdapter().displayStatusInformation(text);
    }

    protected void signalThrown(Throwable t) {
        String text = LangUtil.unqualifiedClassName(t) + " thrown: " + t.getMessage();
        Ajde.getDefault().getErrorHandler().handleError(text, t);
    }

    private static boolean configureBuildOptions(AjBuildConfig config, BuildOptionsAdapter options, IMessageHandler handler) {
        Set debugOptions;
        Set warnings;
        String sourceLevel;
        String compliance;
        String enc;
        LangUtil.throwIaxIfNull(options, "options");
        LangUtil.throwIaxIfNull(config, "config");
        Map javaOptions = config.getJavaOptions();
        LangUtil.throwIaxIfNull(javaOptions, "javaOptions");
        if (options.getSourceOnePointFourMode()) {
            javaOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
            javaOptions.put("org.eclipse.jdt.core.compiler.source", "1.4");
        }
        if (!LangUtil.isEmpty(enc = options.getCharacterEncoding())) {
            javaOptions.put("org.eclipse.jdt.core.encoding", enc);
        }
        if (!LangUtil.isEmpty(compliance = options.getComplianceLevel())) {
            String version = "1.4";
            if (compliance.equals("1.3")) {
                version = "1.3";
            }
            javaOptions.put("org.eclipse.jdt.core.compiler.compliance", version);
            javaOptions.put("org.eclipse.jdt.core.compiler.source", version);
        }
        if (!LangUtil.isEmpty(sourceLevel = options.getSourceCompatibilityLevel())) {
            String setCompliance;
            String slVersion = "1.4";
            if (sourceLevel.equals("1.3")) {
                slVersion = "1.3";
            }
            if (!(setCompliance = (String)javaOptions.get("org.eclipse.jdt.core.compiler.compliance")).equals("1.4") || !slVersion.equals("1.3")) {
                javaOptions.put("org.eclipse.jdt.core.compiler.source", slVersion);
            }
        }
        if (!LangUtil.isEmpty(warnings = options.getWarnings())) {
            CompilerAdapter.disableWarnings(javaOptions);
            CompilerAdapter.enableWarnings(javaOptions, warnings);
        }
        if (!LangUtil.isEmpty(debugOptions = options.getDebugLevel())) {
            boolean sourceLine = false;
            boolean varAttr = false;
            boolean lineNo = false;
            Iterator it = debugOptions.iterator();
            while (it.hasNext()) {
                String debug = (String)it.next();
                if (debug.equals("all")) {
                    sourceLine = true;
                    varAttr = true;
                    lineNo = true;
                    continue;
                }
                if (debug.equals("lines")) {
                    lineNo = true;
                    continue;
                }
                if (debug.equals("source")) {
                    sourceLine = true;
                    continue;
                }
                if (!debug.equals("vars")) continue;
                varAttr = true;
            }
            if (sourceLine) {
                javaOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
            }
            if (varAttr) {
                javaOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
            }
            if (lineNo) {
                javaOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
            }
        }
        if (options.getNoImportError()) {
            javaOptions.put("org.eclipse.jdt.core.compiler.problem.invalidImport", "warning");
        }
        if (options.getPreserveAllLocals()) {
            javaOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        }
        if (!config.isIncrementalMode() && options.getIncrementalMode()) {
            config.setIncrementalMode(true);
        }
        config.setJavaOptions(javaOptions);
        String toAdd = options.getNonStandardOptions();
        return LangUtil.isEmpty(toAdd) ? true : CompilerAdapter.configureNonStandardOptions(config, toAdd, handler);
    }

    private static void disableWarnings(Map options) {
        options.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
    }

    private static void enableWarnings(Map options, Set warnings) {
        Iterator it = warnings.iterator();
        while (it.hasNext()) {
            String thisWarning = (String)it.next();
            if (thisWarning.equals("assertIdentifier")) {
                options.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "warning");
                continue;
            }
            if (thisWarning.equals("constructorName")) {
                options.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", "warning");
                continue;
            }
            if (thisWarning.equals("deprecation")) {
                options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                continue;
            }
            if (thisWarning.equals("maskedCatchBlocks")) {
                options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", "warning");
                continue;
            }
            if (thisWarning.equals("packageDefaultMethod")) {
                options.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", "warning");
                continue;
            }
            if (thisWarning.equals("syntheticAccess")) {
                options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "warning");
                continue;
            }
            if (thisWarning.equals("unusedArguments")) {
                options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
                continue;
            }
            if (thisWarning.equals("unusedImports")) {
                options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "warning");
                continue;
            }
            if (thisWarning.equals("unusedLocals")) {
                options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
                continue;
            }
            if (!thisWarning.equals("nonExternalisedString")) continue;
            options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        }
    }

    private static boolean configureNonStandardOptions(AjBuildConfig config, String nonStdOptions, IMessageHandler messageHandler) {
        if (LangUtil.isEmpty(nonStdOptions)) {
            return true;
        }
        StringTokenizer tok = new StringTokenizer(nonStdOptions);
        String[] args = new String[tok.countTokens()];
        int argCount = 0;
        while (tok.hasMoreTokens()) {
            args[argCount++] = tok.nextToken();
        }
        CountingMessageHandler counter = CountingMessageHandler.makeCountingMessageHandler(messageHandler);
        AjBuildConfig altConfig = AjdtCommand.genBuildConfig(args, counter);
        if (counter.hasErrors()) {
            return false;
        }
        config.installGlobals(altConfig);
        return true;
    }

    private void configureProjectOptions(AjBuildConfig config, ProjectPropertiesAdapter properties) {
        String propcp = properties.getClasspath();
        if (!LangUtil.isEmpty(propcp)) {
            StringTokenizer st = new StringTokenizer(propcp, File.pathSeparator);
            List configClasspath = config.getClasspath();
            ArrayList<String> toAdd = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String entry = st.nextToken();
                if (configClasspath.contains(entry)) continue;
                toAdd.add(entry);
            }
            if (0 < toAdd.size()) {
                ArrayList<String> both = new ArrayList<String>(configClasspath.size() + toAdd.size());
                both.addAll(configClasspath);
                both.addAll(toAdd);
                config.setClasspath(both);
                Ajde.getDefault().logEvent("building with classpath: " + both);
            }
        }
        if (null == config.getOutputDir() && null == config.getOutputJar()) {
            String outJar;
            String outPath = properties.getOutputPath();
            if (!LangUtil.isEmpty(outPath)) {
                config.setOutputDir(new File(outPath));
            }
            if (!LangUtil.isEmpty(outJar = properties.getOutJar())) {
                config.setOutputJar(new File(outJar));
            }
        }
        this.join(config.getSourceRoots(), properties.getSourceRoots());
        this.join(config.getInJars(), properties.getInJars());
        this.join(config.getAspectpath(), properties.getAspectPath());
    }

    void join(Collection target, Collection source) {
        if (null == target || null == source) {
            return;
        }
        Iterator iter = source.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (target.contains(next)) continue;
            target.add(next);
        }
    }

    private void init() {
        if (!this.initialized) {
            this.messageHandler = new MessageHandlerAdapter();
            this.buildManager = new AjBuildManager(this.messageHandler);
            this.initialized = true;
        }
    }

    class MessageHandlerAdapter
    extends MessageHandler {
        private TaskListManager taskListManager = Ajde.getDefault().getTaskListManager();
        private BuildNotifierAdapter buildNotifierAdapter;

        public boolean handleMessage(IMessage message) throws AbortException {
            IMessage.Kind kind = message.getKind();
            if (this.isIgnoring(kind) || !CompilerAdapter.this.showInfoMessages && IMessage.INFO.equals(kind)) {
                return true;
            }
            this.taskListManager.addSourcelineTask(message);
            return super.handleMessage(message);
        }

        public void setBuildNotifierAdapter(BuildNotifierAdapter buildNotifierAdapter) {
            this.buildNotifierAdapter = buildNotifierAdapter;
        }
    }
}

