/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.aspectj.ajde.Ajde;
import org.aspectj.asm.LinkNode;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.RelationNode;
import org.aspectj.asm.StructureModel;
import org.aspectj.asm.StructureModelManager;
import org.aspectj.asm.StructureNode;

public class StructureModelUtil {
    public static Map getLinesToAspectMap(String sourceFilePath) {
        HashMap annotationsMap = StructureModelManager.INSTANCE.getInlineAnnotations(sourceFilePath, true, true);
        HashMap aspectMap = new HashMap();
        Set keys = annotationsMap.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            List annotations = (List)annotationsMap.get(key);
            Iterator it2 = annotations.iterator();
            while (it2.hasNext()) {
                ProgramElementNode node = (ProgramElementNode)it2.next();
                List relations = node.getRelations();
                Iterator it3 = relations.iterator();
                while (it3.hasNext()) {
                    RelationNode relationNode = (RelationNode)it3.next();
                    if (!relationNode.getKind().equals("Advice")) continue;
                    List children = relationNode.getChildren();
                    Vector<StructureNode> aspects = new Vector<StructureNode>();
                    Iterator it4 = children.iterator();
                    while (it4.hasNext()) {
                        ProgramElementNode pNode;
                        Object object = it4.next();
                        if (!(object instanceof LinkNode) || (pNode = ((LinkNode)object).getProgramElementNode()).getProgramElementKind() != ProgramElementNode.Kind.ADVICE) continue;
                        StructureNode theAspect = pNode.getParent();
                        aspects.add(theAspect);
                    }
                    if (aspects.isEmpty()) continue;
                    aspectMap.put(key, aspects);
                }
            }
        }
        return aspectMap;
    }

    public static Set getAspectsAffectingPackage(ProgramElementNode packageNode) {
        List files = StructureModelUtil.getFilesInPackage(packageNode);
        HashSet aspects = new HashSet();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            ProgramElementNode fileNode = (ProgramElementNode)it.next();
            Map adviceMap = StructureModelUtil.getLinesToAspectMap(fileNode.getSourceLocation().getSourceFile().getAbsolutePath());
            Collection values = adviceMap.values();
            Iterator it2 = values.iterator();
            while (it2.hasNext()) {
                aspects.add(it2.next());
            }
        }
        return aspects;
    }

    public static List getPackagesInModel() {
        ArrayList packages = new ArrayList();
        StructureModel model = Ajde.getDefault().getStructureModelManager().getStructureModel();
        if (model.equals(StructureModel.NO_STRUCTURE)) {
            return null;
        }
        return StructureModelUtil.getPackagesHelper((ProgramElementNode)model.getRoot(), ProgramElementNode.Kind.PACKAGE, null, packages);
    }

    private static List getPackagesHelper(ProgramElementNode node, ProgramElementNode.Kind kind, String prename, List matches) {
        if (kind == null || node.getProgramElementKind().equals(kind)) {
            prename = prename == null ? new String(node.toString()) : new String(prename + "." + node);
            Object[] o = new Object[]{node, prename};
            matches.add(o);
        }
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            StructureNode nextNode = (StructureNode)it.next();
            if (!(nextNode instanceof ProgramElementNode)) continue;
            StructureModelUtil.getPackagesHelper((ProgramElementNode)nextNode, kind, prename, matches);
        }
        return matches;
    }

    private List sortElements(List oldElements) {
        Object[] temp = oldElements.toArray();
        SortingComparator comparator = new SortingComparator();
        Arrays.sort(temp, comparator);
        List<Object> newResources = Arrays.asList(temp);
        return newResources;
    }

    private static List sortArray(List oldElements) {
        Object[] temp = oldElements.toArray();
        SortArrayComparator comparator = new SortArrayComparator();
        Arrays.sort(temp, comparator);
        List<Object> newElements = Arrays.asList(temp);
        return newElements;
    }

    public static List getFilesInPackage(ProgramElementNode packageNode) {
        if (packageNode == null) {
            return null;
        }
        List packageContents = packageNode.getChildren();
        ArrayList<ProgramElementNode> files = new ArrayList<ProgramElementNode>();
        Iterator it = packageContents.iterator();
        while (it.hasNext()) {
            ProgramElementNode packageItem = (ProgramElementNode)it.next();
            if (packageItem.getProgramElementKind() != ProgramElementNode.Kind.FILE_JAVA && packageItem.getProgramElementKind() != ProgramElementNode.Kind.FILE_ASPECTJ) continue;
            files.add(packageItem);
        }
        return files;
    }

    private static class SortArrayComparator
    implements Comparator {
        private SortArrayComparator() {
        }

        public int compare(Object o1, Object o2) {
            Object[] array1 = (Object[])o1;
            Object[] array2 = (Object[])o2;
            ProgramElementNode p1 = (ProgramElementNode)array1[1];
            ProgramElementNode p2 = (ProgramElementNode)array2[1];
            String name1 = p1.getName();
            String name2 = p2.getName();
            return name1.compareTo(name2);
        }
    }

    private class SortingComparator
    implements Comparator {
        private SortingComparator() {
        }

        public int compare(Object o1, Object o2) {
            ProgramElementNode p1 = (ProgramElementNode)o1;
            ProgramElementNode p2 = (ProgramElementNode)o2;
            String name1 = p1.getName();
            String name2 = p2.getName();
            return name1.compareTo(name2);
        }
    }
}

