/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.util.Iterator;
import org.aspectj.ajde.ui.StructureViewNode;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.ajde.ui.StructureViewRenderer;
import org.aspectj.asm.ProgramElementNode;

public abstract class StructureView {
    private StructureViewNode rootNode = null;
    private StructureViewNode activeNode = null;
    protected StructureViewProperties viewProperties = null;
    protected StructureViewRenderer renderer = null;

    public StructureViewProperties getViewProperties() {
        return this.viewProperties;
    }

    public StructureViewNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(StructureViewNode rootNode) {
        this.rootNode = rootNode;
    }

    public void setViewProperties(StructureViewProperties viewProperties) {
        this.viewProperties = viewProperties;
    }

    public void setRenderer(StructureViewRenderer renderer) {
        this.renderer = renderer;
    }

    protected void notifyViewUpdated() {
        if (this.renderer != null) {
            this.renderer.updateView(this);
        }
    }

    public StructureViewNode getActiveNode() {
        if (this.activeNode != null && this.activeNode.getStructureNode() instanceof ProgramElementNode) {
            return this.activeNode;
        }
        return null;
    }

    public StructureViewNode findCorrespondingViewNode(ProgramElementNode node) {
        return this.findCorrespondingViewNodeHelper(this.rootNode, node);
    }

    private StructureViewNode findCorrespondingViewNodeHelper(StructureViewNode node, ProgramElementNode pNode) {
        if (node != null && node.getStructureNode() != null && node.getStructureNode().equals(pNode)) {
            return node;
        }
        if (node != null && node.getChildren() != null) {
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                StructureViewNode foundNode = this.findCorrespondingViewNodeHelper((StructureViewNode)it.next(), pNode);
                if (foundNode == null) continue;
                return foundNode;
            }
        }
        return null;
    }

    public void setActiveNode(StructureViewNode activeNode) {
        this.activeNode = activeNode;
        if (this.renderer != null) {
            this.renderer.setActiveNode(activeNode);
        }
    }

    public void setActiveNode(StructureViewNode activeNode, int sourceLine) {
        this.activeNode = activeNode;
        if (this.renderer != null) {
            this.renderer.setActiveNode(activeNode, sourceLine);
        }
    }
}

