/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.GlobalStructureView;
import org.aspectj.ajde.ui.StructureView;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.ajde.ui.swing.AJButtonMenuCombo;
import org.aspectj.ajde.ui.swing.AjdeUIManager;
import org.aspectj.ajde.ui.swing.AjdeWidgetStyles;
import org.aspectj.ajde.ui.swing.StructureViewPanel;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.Relation;

public class BrowserStructureViewToolPanel
extends JPanel {
    private StructureView currentView;
    private StructureViewPanel viewPanel;
    protected BorderLayout borderLayout1 = new BorderLayout();
    protected Border border1;
    protected Border border2;
    AJButtonMenuCombo granularityCombo;
    AJButtonMenuCombo filterCombo;
    AJButtonMenuCombo relationsCombo;
    JPanel buttons_panel = new JPanel();
    JPanel spacer_panel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel view_panel = new JPanel();
    JComboBox view_comboBox = null;
    JLabel view_label = new JLabel();
    BorderLayout borderLayout4 = new BorderLayout();

    public BrowserStructureViewToolPanel(List structureViews, StructureView currentView, StructureViewPanel viewPanel) {
        this.currentView = currentView;
        this.viewPanel = viewPanel;
        this.view_comboBox = new JComboBox();
        this.view_comboBox.setFont(AjdeWidgetStyles.DEFAULT_LABEL_FONT);
        Iterator it = structureViews.iterator();
        while (it.hasNext()) {
            this.view_comboBox.addItem(it.next());
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Ajde.getDefault().getErrorHandler().handleError("Could not initialize GUI.", e);
        }
        this.initToolBar();
    }

    private void initToolBar() {
        try {
            this.granularityCombo = new AJButtonMenuCombo("Visible granularity", "Visible granularity", AjdeUIManager.getDefault().getIconRegistry().getGranularityIcon(), this.createGranularityMenu(), false);
            this.filterCombo = new AJButtonMenuCombo("Filter members", "Filter members", AjdeUIManager.getDefault().getIconRegistry().getFilterIcon(), this.createFilterMenu(), false);
            this.relationsCombo = new AJButtonMenuCombo("Filter associations", "Filter associations", AjdeUIManager.getDefault().getIconRegistry().getRelationsIcon(), this.createRelationsMenu(), false);
            this.buttons_panel.add((Component)this.granularityCombo, "West");
            this.buttons_panel.add((Component)this.filterCombo, "Center");
            this.buttons_panel.add((Component)this.relationsCombo, "East");
        }
        catch (Exception e) {
            Ajde.getDefault().getErrorHandler().handleError("Could not initialize GUI.", e);
        }
    }

    private JPopupMenu createFilterMenu() {
        JPopupMenu filterMenu = new JPopupMenu();
        ProgramElementNode.Accessibility[] accessibility = ProgramElementNode.Accessibility.ALL;
        int i = 0;
        while (i < accessibility.length) {
            CheckBoxSelectionMenuButton menuItem = new CheckBoxSelectionMenuButton(accessibility[i]);
            menuItem.setIcon(AjdeUIManager.getDefault().getIconRegistry().getAccessibilitySwingIcon(accessibility[i]));
            filterMenu.add(menuItem);
            ++i;
        }
        filterMenu.add(new JSeparator());
        ProgramElementNode.Kind[] kinds = ProgramElementNode.Kind.ALL;
        int i2 = 0;
        while (i2 < kinds.length) {
            if (kinds[i2].isMemberKind()) {
                CheckBoxSelectionMenuButton menuItem = new CheckBoxSelectionMenuButton(kinds[i2]);
                menuItem.setIcon((Icon)AjdeUIManager.getDefault().getIconRegistry().getStructureIcon(kinds[i2]).getIconResource());
                filterMenu.add(menuItem);
            }
            ++i2;
        }
        filterMenu.add(new JSeparator());
        ProgramElementNode.Modifiers[] modifiers = ProgramElementNode.Modifiers.ALL;
        int i3 = 0;
        while (i3 < modifiers.length) {
            CheckBoxSelectionMenuButton menuItem = new CheckBoxSelectionMenuButton(modifiers[i3]);
            filterMenu.add(menuItem);
            ++i3;
        }
        return filterMenu;
    }

    private JPopupMenu createRelationsMenu() {
        JPopupMenu relationsMenu = new JPopupMenu();
        List relations = Ajde.getDefault().getStructureViewManager().getAvailableRelations();
        Iterator it = relations.iterator();
        while (it.hasNext()) {
            Relation relation = (Relation)it.next();
            CheckBoxSelectionMenuButton menuItem = new CheckBoxSelectionMenuButton(relation);
            menuItem.setIcon((Icon)AjdeUIManager.getDefault().getIconRegistry().getRelationIcon(relation).getIconResource());
            relationsMenu.add(menuItem);
        }
        return relationsMenu;
    }

    private JPopupMenu createGranularityMenu() {
        JPopupMenu orderMenu = new JPopupMenu();
        StructureViewProperties.Granularity[] granularity = StructureViewProperties.Granularity.ALL;
        ButtonGroup group = new ButtonGroup();
        int i = 0;
        while (i < granularity.length) {
            RadioSelectionMenuButton menuItem = new RadioSelectionMenuButton(granularity[i], group);
            orderMenu.add(menuItem);
            if (granularity[i].equals(StructureViewProperties.Granularity.MEMBER)) {
                menuItem.setSelected(true);
            }
            ++i;
        }
        return orderMenu;
    }

    private void order_comboBox_actionPerformed(ActionEvent e) {
        Ajde.getDefault().getStructureViewManager().refreshView(this.currentView);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout2);
        this.buttons_panel.setLayout(this.borderLayout3);
        this.buttons_panel.setMinimumSize(new Dimension(105, 10));
        this.buttons_panel.setPreferredSize(new Dimension(105, 10));
        this.view_comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserStructureViewToolPanel.this.view_comboBox_actionPerformed(e);
            }
        });
        this.view_label.setFont(new Font("Dialog", 0, 11));
        this.view_label.setText("  Global View   ");
        this.view_comboBox.setFont(new Font("SansSerif", 0, 11));
        this.view_comboBox.setPreferredSize(new Dimension(125, 22));
        this.view_panel.setLayout(this.borderLayout4);
        this.view_panel.add((Component)this.view_label, "West");
        this.add((Component)this.buttons_panel, "East");
        this.add((Component)this.spacer_panel, "Center");
        this.add((Component)this.view_panel, "West");
        this.view_panel.add((Component)this.view_comboBox, "Center");
    }

    private void order_button_actionPerformed(ActionEvent e) {
    }

    private void orderPopup_button_actionPerformed(ActionEvent e) {
    }

    void separator_button_actionPerformed(ActionEvent e) {
    }

    void view_comboBox_actionPerformed(ActionEvent e) {
        StructureView view = (StructureView)this.view_comboBox.getSelectedItem();
        this.viewPanel.setCurrentView(view);
        if (((GlobalStructureView)view).getGlobalViewProperties().getHierarchy() == StructureViewProperties.Hierarchy.DECLARATION) {
            this.granularityCombo.setEnabled(true);
            this.relationsCombo.setEnabled(true);
            this.filterCombo.setEnabled(true);
        } else {
            this.granularityCombo.setEnabled(false);
            this.relationsCombo.setEnabled(false);
            this.filterCombo.setEnabled(false);
        }
    }

    private class CheckBoxSelectionMenuActionListener
    implements ActionListener {
        private ProgramElementNode.Accessibility accessibility = null;
        private ProgramElementNode.Kind kind = null;
        private ProgramElementNode.Modifiers modifiers = null;
        private StructureViewProperties.Sorting sorting = null;
        private Relation relation = null;

        public CheckBoxSelectionMenuActionListener(ProgramElementNode.Accessibility accessibility) {
            this.accessibility = accessibility;
        }

        public CheckBoxSelectionMenuActionListener(ProgramElementNode.Kind kind) {
            this.kind = kind;
        }

        public CheckBoxSelectionMenuActionListener(ProgramElementNode.Modifiers modifiers) {
            this.modifiers = modifiers;
        }

        public CheckBoxSelectionMenuActionListener(StructureViewProperties.Sorting sorting) {
            this.sorting = sorting;
        }

        public CheckBoxSelectionMenuActionListener(Relation relation) {
            this.relation = relation;
        }

        public void actionPerformed(ActionEvent e) {
            if (!(e.getSource() instanceof CheckBoxSelectionMenuButton)) {
                return;
            }
            CheckBoxSelectionMenuButton checkMenu = (CheckBoxSelectionMenuButton)e.getSource();
            if (this.accessibility != null) {
                if (checkMenu.isSelected()) {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().addFilteredMemberAccessibility(this.accessibility);
                } else {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().removeFilteredMemberAccessibility(this.accessibility);
                }
            } else if (this.kind != null) {
                if (checkMenu.isSelected()) {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().addFilteredMemberKind(this.kind);
                } else {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().removeFilteredMemberKind(this.kind);
                }
            } else if (this.modifiers != null) {
                if (checkMenu.isSelected()) {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().addFilteredMemberModifiers(this.modifiers);
                } else {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().removeFilteredMemberModifiers(this.modifiers);
                }
            } else if (this.sorting != null) {
                if (checkMenu.isSelected()) {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().setSorting(this.sorting);
                } else {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().setSorting(StructureViewProperties.Sorting.DECLARATIONAL);
                }
            } else if (this.relation != null) {
                if (checkMenu.isSelected()) {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().removeRelation(this.relation);
                } else {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().addRelation(this.relation);
                }
            }
            Ajde.getDefault().getStructureViewManager().refreshView(BrowserStructureViewToolPanel.this.currentView);
        }
    }

    private class CheckBoxSelectionMenuButton
    extends JCheckBoxMenuItem {
        public CheckBoxSelectionMenuButton(String name) {
            super(name);
            this.setFont(AjdeWidgetStyles.DEFAULT_LABEL_FONT);
            this.setBackground(AjdeWidgetStyles.DEFAULT_BACKGROUND_COLOR);
        }

        public CheckBoxSelectionMenuButton(ProgramElementNode.Accessibility accessibility) {
            this(accessibility.toString());
            this.addActionListener(this$0.new CheckBoxSelectionMenuActionListener(accessibility));
        }

        public CheckBoxSelectionMenuButton(ProgramElementNode.Kind kind) {
            this(kind.toString());
            this.addActionListener(this$0.new CheckBoxSelectionMenuActionListener(kind));
        }

        public CheckBoxSelectionMenuButton(ProgramElementNode.Modifiers modifiers) {
            this(modifiers.toString());
            this.addActionListener(this$0.new CheckBoxSelectionMenuActionListener(modifiers));
        }

        public CheckBoxSelectionMenuButton(StructureViewProperties.Sorting sorting) {
            this(sorting.toString());
            this.addActionListener(this$0.new CheckBoxSelectionMenuActionListener(sorting));
        }

        public CheckBoxSelectionMenuButton(Relation relation) {
            this(relation.toString());
            this.addActionListener(this$0.new CheckBoxSelectionMenuActionListener(relation));
        }
    }

    private class RadioSelectionMenuActionListener
    implements ActionListener {
        private StructureViewProperties.Granularity granularity;

        public RadioSelectionMenuActionListener(StructureViewProperties.Granularity granularity) {
            this.granularity = granularity;
        }

        public void actionPerformed(ActionEvent e) {
            BrowserStructureViewToolPanel.this.currentView.getViewProperties().setGranularity(this.granularity);
            Ajde.getDefault().getStructureViewManager().refreshView(BrowserStructureViewToolPanel.this.currentView);
        }
    }

    private class RadioSelectionMenuButton
    extends JRadioButtonMenuItem {
        public RadioSelectionMenuButton(StructureViewProperties.Granularity granularity, ButtonGroup group) {
            super(granularity.toString());
            super.setFont(AjdeWidgetStyles.DEFAULT_LABEL_FONT);
            group.add(this);
            this.addActionListener(new RadioSelectionMenuActionListener(granularity));
        }
    }
}

