/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import javax.swing.SwingUtilities;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.EditorAdapter;

public class GoToLineThread
extends Thread {
    private EditorAdapter editorAdapter = null;
    private int lineNumber = 0;
    private String fileToSeekTo = "";
    private boolean finished = false;

    public boolean isFinished() {
        return this.finished;
    }

    public boolean needsRetry() {
        return !this.isAlive() && !this.finished;
    }

    public GoToLineThread(String fileToSeekTo, int lineNumber, EditorAdapter editorAdapter) {
        this.lineNumber = lineNumber;
        this.fileToSeekTo = fileToSeekTo;
        this.editorAdapter = editorAdapter;
    }

    public void run() {
        while (true) {
            String file;
            if ((file = this.editorAdapter.getCurrFile()) == null) continue;
            if (file.equals(this.fileToSeekTo)) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            GoToLineThread.this.editorAdapter.showSourceLine(GoToLineThread.this.lineNumber, true);
                        }
                    });
                }
                catch (Exception e) {
                    Ajde.getDefault().getErrorHandler().handleError("Could not seek to line.", e);
                }
                break;
            }
            this.shortPause();
        }
        this.finished = true;
    }

    private void shortPause() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

