/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.ajc;

import org.aspectj.ajdt.ajc.BuildArgParser;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.CountingMessageHandler;
import org.aspectj.bridge.ICommand;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.eclipse.jdt.internal.core.builder.MissingSourceFileException;

public class AjdtCommand
implements ICommand {
    public static final String ABORT_MESSAGE = "ABORT";
    private boolean canRepeatCommand = true;
    AjBuildManager buildManager = null;
    String[] savedArgs = null;

    public boolean runCommand(String[] args, IMessageHandler handler) {
        this.buildManager = new AjBuildManager(handler);
        this.savedArgs = new String[args.length];
        System.arraycopy(args, 0, this.savedArgs, 0, this.savedArgs.length);
        int i = 0;
        while (i < args.length) {
            if ("-help".equals(args[i])) {
                MessageUtil.abort(handler, BuildArgParser.getUsage());
                return true;
            }
            ++i;
        }
        return this.doCommand(handler, false);
    }

    public boolean repeatCommand(IMessageHandler handler) {
        if (null == this.buildManager) {
            MessageUtil.abort(handler, "repeatCommand called before runCommand");
            return false;
        }
        return this.doCommand(handler, true);
    }

    protected boolean doCommand(IMessageHandler handler, boolean repeat) {
        try {
            CountingMessageHandler counter = new CountingMessageHandler(handler);
            if (counter.hasErrors()) {
                return false;
            }
            AjBuildConfig config = AjdtCommand.genBuildConfig(this.savedArgs, counter);
            if (!config.hasSources()) {
                MessageUtil.error(counter, "no sources specified");
            }
            if (counter.hasErrors()) {
                String usage = BuildArgParser.getUsage();
                MessageUtil.abort(handler, usage);
                return false;
            }
            return (repeat ? this.buildManager.incrementalBuild(config, handler) : this.buildManager.batchBuild(config, handler)) && !counter.hasErrors();
        }
        catch (AbortException ae) {
            if (ae.isSilent()) {
                throw ae;
            }
            MessageUtil.abort(handler, ABORT_MESSAGE, ae);
        }
        catch (MissingSourceFileException t) {
            MessageUtil.error(handler, t.getMessage());
        }
        catch (Throwable t) {
            MessageUtil.abort(handler, ABORT_MESSAGE, t);
        }
        return false;
    }

    public static AjBuildConfig genBuildConfig(String[] args, CountingMessageHandler handler) {
        Message m;
        IMessage.Kind kind;
        BuildArgParser parser = new BuildArgParser();
        AjBuildConfig config = parser.genBuildConfig(args, handler);
        String message = parser.getOtherMessages(true);
        if (null != message) {
            kind = AjdtCommand.inferKind(message);
            m = new Message(message, kind, null, null);
            handler.handleMessage(m);
        }
        if (null != (message = config.configErrors())) {
            kind = AjdtCommand.inferKind(message);
            m = new Message(message, kind, null, null);
            handler.handleMessage(m);
        }
        return config;
    }

    protected static IMessage.Kind inferKind(String message) {
        if (-1 != message.indexOf("error")) {
            return IMessage.ERROR;
        }
        if (-1 != message.indexOf("info")) {
            return IMessage.INFO;
        }
        return IMessage.WARNING;
    }
}

