/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm;

import java.io.Serializable;

public class Relation
implements Serializable {
    private String forwardNavigationName;
    private String backNavigationName;
    private String associationName;
    private boolean symmetrical;
    private boolean transitive;

    public Relation(String forwardNavigationName, String backNavigationName, String associationName, boolean symmetrical, boolean transitive) {
        this.forwardNavigationName = forwardNavigationName;
        this.backNavigationName = backNavigationName;
        this.associationName = associationName;
        this.symmetrical = symmetrical;
        this.transitive = transitive;
    }

    public Relation(String forwardNavigationName, String associationName, boolean transitive) {
        this(forwardNavigationName, "<no back navigation name>", associationName, false, transitive);
    }

    public String getForwardNavigationName() {
        return this.forwardNavigationName;
    }

    public String getBackNavigationName() {
        return this.backNavigationName;
    }

    public String getAssociationName() {
        return this.associationName;
    }

    public boolean isSymmetrical() {
        return this.symmetrical;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Relation)) {
            return false;
        }
        Relation r = (Relation)o;
        return this.forwardNavigationName.equals(r.getForwardNavigationName()) && this.backNavigationName.equals(r.getBackNavigationName()) && this.associationName.equals(r.getAssociationName()) && this.symmetrical == r.isSymmetrical() && this.transitive == r.isTransitive();
    }

    public String toString() {
        if (this.symmetrical) {
            return this.forwardNavigationName + " / " + this.backNavigationName;
        }
        return this.forwardNavigationName;
    }
}

