/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.StructureNode;
import org.aspectj.bridge.SourceLocation;

public class StructureModel
implements Serializable {
    protected StructureNode root = null;
    protected String configFile = null;
    private Map fileMap = null;
    public static final ProgramElementNode NO_STRUCTURE = new ProgramElementNode("<build to view structure>", ProgramElementNode.Kind.ERROR, null);

    public StructureNode getRoot() {
        return this.root;
    }

    public void setRoot(StructureNode root) {
        this.root = root;
    }

    private Map getFileMap() {
        return this.fileMap;
    }

    public void addToFileMap(Object key, Object value) {
        this.fileMap.put(key, value);
    }

    public Object findInFileMap(Object key) {
        return this.fileMap.get(key);
    }

    public void setFileMap(HashMap fileMap) {
        this.fileMap = fileMap;
    }

    public Set getFileMapEntrySet() {
        return this.fileMap.entrySet();
    }

    public boolean isValid() {
        return this.root != null && this.fileMap != null;
    }

    public ProgramElementNode findNodeForClass(String packageName, String className) {
        Iterator it;
        StructureNode packageNode = null;
        if (packageName == null) {
            packageNode = this.root;
        } else {
            it = this.root.getChildren().iterator();
            while (it.hasNext()) {
                StructureNode node = (StructureNode)it.next();
                if (!packageName.equals(node.getName())) continue;
                packageNode = node;
            }
            if (packageNode == null) {
                return null;
            }
        }
        it = packageNode.getChildren().iterator();
        while (it.hasNext()) {
            ProgramElementNode fileNode = (ProgramElementNode)it.next();
            ProgramElementNode ret = this.findClassInNodes(fileNode.getChildren(), className);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private ProgramElementNode findClassInNodes(Collection nodes, String name) {
        String innerName;
        String baseName;
        int dollar = name.indexOf(36);
        if (dollar == -1) {
            baseName = name;
            innerName = null;
        } else {
            baseName = name.substring(0, dollar);
            innerName = name.substring(dollar + 1);
        }
        Iterator j = nodes.iterator();
        while (j.hasNext()) {
            ProgramElementNode classNode = (ProgramElementNode)j.next();
            if (baseName.equals(classNode.getName())) {
                if (innerName == null) {
                    return classNode;
                }
                return this.findClassInNodes(classNode.getChildren(), innerName);
            }
            if (!name.equals(classNode.getName())) continue;
            return classNode;
        }
        return null;
    }

    public StructureNode findRootNodeForSourceFile(String sourceFile) {
        try {
            if (!this.isValid() || sourceFile == null) {
                return NO_STRUCTURE;
            }
            String correctedPath = new File(sourceFile).getCanonicalPath();
            StructureNode node = (StructureNode)this.findInFileMap(correctedPath);
            if (node != null) {
                return node;
            }
            return this.createFileStructureNode(correctedPath);
        }
        catch (Exception e) {
            return NO_STRUCTURE;
        }
    }

    public StructureNode findNodeForSourceLine(String sourceFilePath, int lineNumber) {
        String correctedPath = sourceFilePath;
        StructureNode node = this.findNodeForSourceLineHelper(this.root, correctedPath, lineNumber);
        if (node != null) {
            return node;
        }
        return this.createFileStructureNode(sourceFilePath);
    }

    private StructureNode createFileStructureNode(String sourceFilePath) {
        String fileName = new File(sourceFilePath).getName();
        ProgramElementNode fileNode = new ProgramElementNode(fileName, ProgramElementNode.Kind.FILE_JAVA, null);
        fileNode.setSourceLocation(new SourceLocation(new File(sourceFilePath), 1, 1));
        fileNode.addChild(NO_STRUCTURE);
        return fileNode;
    }

    private StructureNode findNodeForSourceLineHelper(StructureNode node, String sourceFilePath, int lineNumber) {
        if (this.matches(node, sourceFilePath, lineNumber) && !this.hasMoreSpecificChild(node, sourceFilePath, lineNumber)) {
            return node;
        }
        if (node != null && node.getChildren() != null) {
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                StructureNode foundNode = this.findNodeForSourceLineHelper((StructureNode)it.next(), sourceFilePath, lineNumber);
                if (foundNode == null) continue;
                return foundNode;
            }
        }
        return null;
    }

    private boolean matches(StructureNode node, String sourceFilePath, int lineNumber) {
        try {
            return node != null && node.getSourceLocation() != null && node.getSourceLocation().getSourceFile().getCanonicalPath().equals(sourceFilePath) && (node.getSourceLocation().getLine() <= lineNumber && node.getSourceLocation().getEndLine() >= lineNumber || lineNumber <= 1 && node instanceof ProgramElementNode && ((ProgramElementNode)node).getProgramElementKind().isSourceFileKind());
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private boolean hasMoreSpecificChild(StructureNode node, String sourceFilePath, int lineNumber) {
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            ProgramElementNode child = (ProgramElementNode)it.next();
            if (!this.matches(child, sourceFilePath, lineNumber)) continue;
            return true;
        }
        return false;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }
}

