/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.AdviceAssociation;
import org.aspectj.asm.InheritanceAssociation;
import org.aspectj.asm.IntroductionAssociation;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.ReferenceAssociation;
import org.aspectj.asm.StructureModel;
import org.aspectj.asm.StructureModelListener;
import org.aspectj.asm.StructureNode;
import org.aspectj.bridge.ISourceLocation;

public class StructureModelManager {
    public static StructureModelManager INSTANCE = new StructureModelManager();
    private boolean shouldSaveModel = true;
    protected StructureModel model = new StructureModel();
    private List structureListeners = new ArrayList();
    private List associations = new ArrayList();

    protected StructureModelManager() {
        this.associations.add(new AdviceAssociation());
        this.associations.add(new IntroductionAssociation());
        this.associations.add(new InheritanceAssociation());
        this.associations.add(new ReferenceAssociation());
    }

    public StructureModel getStructureModel() {
        return this.model;
    }

    public void fireModelUpdated() {
        this.notifyListeners();
        if (this.model.getConfigFile() != null) {
            this.writeStructureModel(this.model.getConfigFile());
        }
    }

    public HashMap getInlineAnnotations(String sourceFile, boolean showSubMember, boolean showMemberAndType) {
        if (!this.model.isValid()) {
            return null;
        }
        HashMap annotations = new HashMap();
        StructureNode node = this.model.findRootNodeForSourceFile(sourceFile);
        if (node == StructureModel.NO_STRUCTURE) {
            return null;
        }
        ProgramElementNode fileNode = (ProgramElementNode)node;
        ArrayList peNodes = new ArrayList();
        this.getAllStructureChildren(fileNode, peNodes, showSubMember, showMemberAndType);
        Iterator it = ((AbstractList)peNodes).iterator();
        while (it.hasNext()) {
            ProgramElementNode peNode = (ProgramElementNode)it.next();
            ArrayList<ProgramElementNode> entries = new ArrayList<ProgramElementNode>();
            entries.add(peNode);
            ISourceLocation sourceLoc = peNode.getSourceLocation();
            if (null == sourceLoc) continue;
            Integer hash = new Integer(sourceLoc.getLine());
            List existingEntry = (List)annotations.get(hash);
            if (existingEntry != null) {
                entries.addAll(existingEntry);
            }
            annotations.put(hash, entries);
        }
        return annotations;
    }

    private void getAllStructureChildren(ProgramElementNode node, List result, boolean showSubMember, boolean showMemberAndType) {
        List children = node.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            StructureNode next = (StructureNode)it.next();
            if (!(next instanceof ProgramElementNode)) continue;
            ProgramElementNode pNode = (ProgramElementNode)next;
            if (pNode != null && (pNode.isCode() && showSubMember || !pNode.isCode() && showMemberAndType) && pNode.getRelations() != null && pNode.getRelations().size() > 0) {
                result.add(next);
            }
            this.getAllStructureChildren((ProgramElementNode)next, result, showSubMember, showMemberAndType);
        }
    }

    public void addListener(StructureModelListener listener) {
        this.structureListeners.add(listener);
    }

    public void removeStructureListener(StructureModelListener listener) {
        this.structureListeners.remove(listener);
    }

    private void notifyListeners() {
        Iterator it = this.structureListeners.iterator();
        while (it.hasNext()) {
            ((StructureModelListener)it.next()).modelUpdated(this.model);
        }
    }

    public List getAssociations() {
        return this.associations;
    }

    public void writeStructureModel(String configFilePath) {
        try {
            String filePath = this.genExternFilePath(configFilePath);
            ObjectOutputStream s = new ObjectOutputStream(new FileOutputStream(filePath));
            s.writeObject(this.model);
            s.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readStructureModel(String configFilePath) {
        try {
            block5: {
                try {
                    if (configFilePath == null) {
                        this.model.setRoot(StructureModel.NO_STRUCTURE);
                        break block5;
                    }
                    String filePath = this.genExternFilePath(configFilePath);
                    FileInputStream in = new FileInputStream(filePath);
                    ObjectInputStream s = new ObjectInputStream(in);
                    this.model = (StructureModel)s.readObject();
                }
                catch (Exception e) {
                    this.model.setRoot(StructureModel.NO_STRUCTURE);
                    Object var6_7 = null;
                    this.notifyListeners();
                }
            }
            Object var6_6 = null;
            this.notifyListeners();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.notifyListeners();
            throw throwable;
        }
    }

    private String genExternFilePath(String configFilePath) {
        return configFilePath.substring(0, configFilePath.lastIndexOf(".lst")) + ".ajsym";
    }

    public void setShouldSaveModel(boolean shouldSaveModel) {
        this.shouldSaveModel = shouldSaveModel;
    }
}

