/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.bridge;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.IMessageHolder;

public class MessageHandler
implements IMessageHolder {
    protected final ArrayList messages = new ArrayList();
    protected final ArrayList ignoring = new ArrayList();
    protected boolean handleMessageResult;
    protected IMessageHandler interceptor;

    public MessageHandler() {
        this(false);
    }

    public MessageHandler(boolean accumulateOnly) {
        this.init(accumulateOnly);
    }

    public void init() {
        this.init(false);
    }

    public void init(boolean accumulateOnly) {
        this.handleMessageResult = accumulateOnly;
        if (0 < this.messages.size()) {
            this.messages.clear();
        }
        if (0 < this.ignoring.size()) {
            this.ignoring.clear();
        }
        if (null != this.interceptor) {
            this.interceptor = null;
        }
    }

    public void clearMessages() {
        if (0 < this.messages.size()) {
            this.messages.clear();
        }
    }

    public boolean handleMessage(IMessage message) {
        if (null != this.interceptor && this.interceptor.handleMessage(message)) {
            return true;
        }
        if (null == message) {
            throw new IllegalArgumentException("null message");
        }
        if (!this.ignoring.contains(message.getKind())) {
            this.messages.add(message);
        }
        return this.handleMessageResult;
    }

    public boolean isIgnoring(IMessage.Kind kind) {
        return null != kind && this.ignoring.contains(kind);
    }

    public void ignore(IMessage.Kind kind) {
        if (null != kind && !this.ignoring.contains(kind)) {
            this.ignoring.add(kind);
        }
    }

    public void dontIgnore(IMessage.Kind kind) {
        if (null != kind) {
            ((AbstractCollection)this.ignoring).remove(kind);
        }
    }

    public boolean hasAnyMessage(IMessage.Kind kind, boolean orGreater) {
        if (null == kind) {
            return 0 < this.messages.size();
        }
        if (!orGreater) {
            Iterator iter = ((AbstractList)this.messages).iterator();
            while (iter.hasNext()) {
                if (kind != ((IMessage)iter.next()).getKind()) continue;
                return true;
            }
        } else {
            Iterator iter = ((AbstractList)this.messages).iterator();
            while (iter.hasNext()) {
                IMessage m = (IMessage)iter.next();
                if (!kind.isSameOrLessThan(m.getKind())) continue;
                return true;
            }
        }
        return false;
    }

    public int numMessages(IMessage.Kind kind, boolean orGreater) {
        if (null == kind) {
            return this.messages.size();
        }
        int result = 0;
        if (!orGreater) {
            Iterator iter = ((AbstractList)this.messages).iterator();
            while (iter.hasNext()) {
                if (kind != ((IMessage)iter.next()).getKind()) continue;
                ++result;
            }
        } else {
            Iterator iter = ((AbstractList)this.messages).iterator();
            while (iter.hasNext()) {
                IMessage m = (IMessage)iter.next();
                if (!kind.isSameOrLessThan(m.getKind())) continue;
                ++result;
            }
        }
        return result;
    }

    public List getUnmodifiableListView() {
        return Collections.unmodifiableList(this.messages);
    }

    public IMessage[] getMessages(IMessage.Kind kind, boolean orGreater) {
        if (null == kind) {
            return this.messages.toArray(IMessage.RA_IMessage);
        }
        ArrayList<IMessage> result = new ArrayList<IMessage>();
        if (!orGreater) {
            Iterator iter = ((AbstractList)this.messages).iterator();
            while (iter.hasNext()) {
                IMessage m = (IMessage)iter.next();
                if (kind != m.getKind()) continue;
                result.add(m);
            }
        } else {
            Iterator iter = ((AbstractList)this.messages).iterator();
            while (iter.hasNext()) {
                IMessage m = (IMessage)iter.next();
                if (!kind.isSameOrLessThan(m.getKind())) continue;
                result.add(m);
            }
        }
        if (0 == result.size()) {
            return IMessage.RA_IMessage;
        }
        return result.toArray(IMessage.RA_IMessage);
    }

    public IMessage[] getErrors() {
        return this.getMessages(IMessage.ERROR, false);
    }

    public IMessage[] getWarnings() {
        return this.getMessages(IMessage.WARNING, false);
    }

    public void setInterceptor(IMessageHandler interceptor) {
        this.interceptor = interceptor;
    }

    public String toString() {
        if (0 == this.messages.size()) {
            return "MessageHandler: no messages";
        }
        return "MessageHandler: " + this.messages;
    }
}

