/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.ajde.ui.swing.CompilerMessage;
import org.aspectj.ajde.ui.swing.CompilerMessagesCellRenderer;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.tools.ajbrowser.BrowserManager;

public class CompilerMessagesPanel
extends JPanel
implements TaskListManager {
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JList list = new JList();
    private DefaultListModel listModel = new DefaultListModel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private boolean hasWarning = false;

    public CompilerMessagesPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.list.setModel(this.listModel);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 1) {
                    CompilerMessage cm;
                    int index = CompilerMessagesPanel.this.list.locationToIndex(e.getPoint());
                    if (CompilerMessagesPanel.this.listModel.getSize() >= index && index != -1 && null != (cm = (CompilerMessage)CompilerMessagesPanel.this.listModel.getElementAt(index)) && null != cm.message) {
                        CompilerMessagesPanel.this.displayMessage(cm.message);
                    }
                }
            }
        };
        this.list.addMouseListener(mouseListener);
        this.list.setCellRenderer(new CompilerMessagesCellRenderer());
    }

    public void addSourcelineTask(String message, ISourceLocation sourceLocation, IMessage.Kind kind) {
        this.addSourcelineTask(new Message(message, kind, null, sourceLocation));
    }

    protected void displayMessage(IMessage message) {
        ISourceLocation loc = message.getISourceLocation();
        Ajde.getDefault().getEditorManager().showSourceLine(loc, true);
        Throwable thrown = message.getThrown();
        if (null != thrown) {
            Ajde.getDefault().getErrorHandler().handleError(message.getMessage(), thrown);
        }
    }

    public void addSourcelineTask(IMessage message) {
        this.listModel.addElement(new CompilerMessage(message));
        if (!this.hasWarning && IMessage.WARNING.isSameOrLessThan(message.getKind())) {
            this.hasWarning = true;
        }
        BrowserManager.getDefault().showMessages();
    }

    public void addProjectTask(String message, IMessage.Kind kind) {
        Message m = new Message(message, kind, null, null);
        this.listModel.addElement(new CompilerMessage(m));
        if (!this.hasWarning && IMessage.WARNING.isSameOrLessThan(kind)) {
            this.hasWarning = true;
        }
        BrowserManager.getDefault().showMessages();
    }

    public boolean hasWarning() {
        return this.hasWarning;
    }

    public void clearTasks() {
        this.listModel.clear();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.list, null);
    }
}

