/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.Iterator;
import org.aspectj.asm.AdviceAssociation;
import org.aspectj.asm.LinkNode;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.Relation;
import org.aspectj.asm.RelationNode;
import org.aspectj.asm.StructureModel;
import org.aspectj.asm.StructureNode;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.Lint;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;

public class AsmAdaptor {
    public static void noteMunger(StructureModel model, Shadow shadow, ShadowMunger munger) {
        if (munger instanceof Advice) {
            Relation relation;
            Advice a = (Advice)munger;
            if (a.getKind().isPerEntry() || a.getKind().isCflow()) {
                return;
            }
            ProgramElementNode targetNode = AsmAdaptor.getNode(model, shadow);
            ProgramElementNode adviceNode = AsmAdaptor.getNode(model, a);
            if (shadow.getKind().equals(Shadow.FieldGet) || shadow.getKind().equals(Shadow.FieldSet)) {
                relation = AdviceAssociation.FIELD_ACCESS_RELATION;
            } else if (shadow.getKind().equals(Shadow.Initialization) || shadow.getKind().equals(Shadow.StaticInitialization)) {
                relation = AdviceAssociation.INITIALIZER_RELATION;
            } else if (shadow.getKind().equals(Shadow.ExceptionHandler)) {
                relation = AdviceAssociation.HANDLER_RELATION;
            } else if (shadow.getKind().equals(Shadow.MethodCall)) {
                relation = AdviceAssociation.METHOD_CALL_SITE_RELATION;
            } else if (shadow.getKind().equals(Shadow.ConstructorCall)) {
                relation = AdviceAssociation.CONSTRUCTOR_CALL_SITE_RELATION;
            } else if (shadow.getKind().equals(Shadow.MethodExecution) || shadow.getKind().equals(Shadow.AdviceExecution)) {
                relation = AdviceAssociation.METHOD_RELATION;
            } else if (shadow.getKind().equals(Shadow.ConstructorExecution)) {
                relation = AdviceAssociation.CONSTRUCTOR_RELATION;
            } else if (shadow.getKind().equals(Shadow.PreInitialization)) {
                relation = AdviceAssociation.INITIALIZER_RELATION;
            } else {
                System.err.println("> unmatched relation: " + shadow.getKind());
                relation = AdviceAssociation.METHOD_RELATION;
            }
            AsmAdaptor.createAppropriateLinks(targetNode, adviceNode, relation);
        }
    }

    private static void createAppropriateLinks(ProgramElementNode target, ProgramElementNode advice, Relation relation) {
        if (target == null || advice == null) {
            return;
        }
        AsmAdaptor.addLink(target, new LinkNode(advice), relation, true);
        AsmAdaptor.addLink(advice, new LinkNode(target), relation, false);
    }

    private static void addLink(ProgramElementNode onNode, LinkNode linkNode, Relation relation, boolean isBack) {
        StructureNode node = null;
        String relationName = isBack ? relation.getBackNavigationName() : relation.getForwardNavigationName();
        Iterator i = onNode.getRelations().iterator();
        while (i.hasNext()) {
            RelationNode relationNode = (RelationNode)i.next();
            if (!relationName.equals(relationNode.getName())) continue;
            node = relationNode;
            break;
        }
        if (node == null) {
            node = new RelationNode(relation, relationName, new ArrayList());
            onNode.getRelations().add(node);
        }
        node.getChildren().add(linkNode);
    }

    private static ProgramElementNode getNode(StructureModel model, Advice a) {
        Member member = a.getSignature();
        if (a.getSignature() == null) {
            return null;
        }
        return AsmAdaptor.lookupMember(model, member);
    }

    private static ProgramElementNode getNode(StructureModel model, Shadow shadow) {
        Member enclosingMember = shadow.getEnclosingCodeSignature();
        ProgramElementNode enclosingNode = AsmAdaptor.lookupMember(model, enclosingMember);
        if (enclosingNode == null) {
            Lint.Kind err = shadow.getIWorld().getLint().shadowNotInStructure;
            if (err.isEnabled()) {
                err.signal(shadow.toString(), shadow.getSourceLocation());
            }
            return null;
        }
        Member shadowSig = shadow.getSignature();
        if (!shadowSig.equals(enclosingMember)) {
            ProgramElementNode bodyNode = AsmAdaptor.findOrCreateBodyNode(enclosingNode, shadowSig, shadow);
            return bodyNode;
        }
        return enclosingNode;
    }

    private static ProgramElementNode findOrCreateBodyNode(ProgramElementNode enclosingNode, Member shadowSig, Shadow shadow) {
        Iterator it = enclosingNode.getChildren().iterator();
        while (it.hasNext()) {
            ProgramElementNode node = (ProgramElementNode)it.next();
            if (!shadowSig.getName().equals(node.getBytecodeName()) || !shadowSig.getSignature().equals(node.getBytecodeSignature())) continue;
            return node;
        }
        ISourceLocation sl = shadow.getSourceLocation();
        ProgramElementNode peNode = new ProgramElementNode(shadow.toString(), ProgramElementNode.Kind.CODE, new SourceLocation(enclosingNode.getSourceLocation().getSourceFile(), sl.getLine()), 0, "", new ArrayList());
        peNode.setBytecodeName(shadowSig.getName());
        peNode.setBytecodeSignature(shadowSig.getSignature());
        enclosingNode.addChild(peNode);
        return peNode;
    }

    public static ProgramElementNode lookupMember(StructureModel model, Member member) {
        TypeX declaringType = member.getDeclaringType();
        ProgramElementNode classNode = model.findNodeForClass(declaringType.getPackageName(), declaringType.getClassName());
        return AsmAdaptor.findMemberInClass(classNode, member);
    }

    private static ProgramElementNode findMemberInClass(ProgramElementNode classNode, Member member) {
        if (classNode == null) {
            return null;
        }
        Iterator it = classNode.getChildren().iterator();
        while (it.hasNext()) {
            ProgramElementNode node = (ProgramElementNode)it.next();
            if (!member.getName().equals(node.getBytecodeName()) || !member.getSignature().equals(node.getBytecodeSignature())) continue;
            return node;
        }
        return classNode;
    }
}

