/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.patterns.Pointcut;

public class ResolvedPointcutDefinition
extends ResolvedMember {
    private Pointcut pointcut;
    public static final ResolvedPointcutDefinition DUMMY = new ResolvedPointcutDefinition(TypeX.OBJECT, 0, "missing", TypeX.NONE, Pointcut.makeMatchesNothing(Pointcut.RESOLVED));

    public ResolvedPointcutDefinition(TypeX declaringType, int modifiers, String name, TypeX[] parameterTypes, Pointcut pointcut) {
        super(Member.POINTCUT, declaringType, modifiers, ResolvedTypeX.VOID, name, parameterTypes);
        this.pointcut = pointcut;
        this.checkedExceptions = TypeX.NONE;
    }

    public void write(DataOutputStream s) throws IOException {
        this.getDeclaringType().write(s);
        s.writeInt(this.getModifiers());
        s.writeUTF(this.getName());
        TypeX.writeArray(this.getParameterTypes(), s);
        this.pointcut.write(s);
    }

    public static ResolvedPointcutDefinition read(DataInputStream s, ISourceContext context) throws IOException {
        return new ResolvedPointcutDefinition(TypeX.read(s), s.readInt(), s.readUTF(), TypeX.readArray(s), Pointcut.read(s, context));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("pointcut ");
        buf.append(this.getDeclaringType().getName());
        buf.append(".");
        buf.append(this.getName());
        buf.append("(");
        int i = 0;
        while (i < this.getParameterTypes().length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getParameterTypes()[i].toString());
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public boolean isAjSynthetic() {
        return true;
    }
}

