/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.Field;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelAttributes;
import org.aspectj.weaver.bcel.BcelObjectType;

final class BcelField
extends ResolvedMember {
    private Field field;
    private boolean isAjSynthetic;

    BcelField(BcelObjectType declaringType, Field field) {
        super(Member.FIELD, declaringType.getResolvedTypeX(), field.getAccessFlags(), field.getName(), field.getSignature());
        this.field = field;
        this.unpackAttributes(declaringType.getResolvedTypeX().getWorld());
        this.checkedExceptions = TypeX.NONE;
    }

    private void unpackAttributes(World world) {
        List as = BcelAttributes.readAjAttributes(this.field.getAttributes(), this.getSourceContext(world));
        Iterator iter = as.iterator();
        while (iter.hasNext()) {
            AjAttribute a = (AjAttribute)iter.next();
            if (a instanceof AjAttribute.AjSynthetic) {
                this.isAjSynthetic = true;
                continue;
            }
            throw new BCException("weird field attribute " + a);
        }
        this.isAjSynthetic = false;
    }

    public boolean isAjSynthetic() {
        return this.isAjSynthetic;
    }
}

