/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.Type;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.NewConstructorTypeMunger;
import org.aspectj.weaver.NewFieldTypeMunger;
import org.aspectj.weaver.NewMethodTypeMunger;
import org.aspectj.weaver.NewParentTypeMunger;
import org.aspectj.weaver.PerObjectInterfaceTypeMunger;
import org.aspectj.weaver.PrivilegedAccessMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.bcel.BcelClassWeaver;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.LazyMethodGen;
import org.aspectj.weaver.bcel.Utility;
import org.aspectj.weaver.patterns.Pointcut;

public class BcelTypeMunger
extends ConcreteTypeMunger {
    public BcelTypeMunger(ResolvedTypeMunger munger, ResolvedTypeX aspectType) {
        super(munger, aspectType);
    }

    public String toString() {
        return "(BcelTypeMunger " + this.getMunger() + ")";
    }

    public boolean munge(BcelClassWeaver weaver) {
        if (this.munger.getKind() == ResolvedTypeMunger.Field) {
            return this.mungeNewField(weaver, (NewFieldTypeMunger)this.munger);
        }
        if (this.munger.getKind() == ResolvedTypeMunger.Method) {
            return this.mungeNewMethod(weaver, (NewMethodTypeMunger)this.munger);
        }
        if (this.munger.getKind() == ResolvedTypeMunger.PerObjectInterface) {
            return this.mungePerObjectInterface(weaver, (PerObjectInterfaceTypeMunger)this.munger);
        }
        if (this.munger.getKind() == ResolvedTypeMunger.PrivilegedAccess) {
            return this.mungePrivilegedAccess(weaver, (PrivilegedAccessMunger)this.munger);
        }
        if (this.munger.getKind() == ResolvedTypeMunger.Constructor) {
            return this.mungeNewConstructor(weaver, (NewConstructorTypeMunger)this.munger);
        }
        if (this.munger.getKind() == ResolvedTypeMunger.Parent) {
            return this.mungeNewParent(weaver, (NewParentTypeMunger)this.munger);
        }
        throw new RuntimeException("unimplemented");
    }

    private boolean mungeNewParent(BcelClassWeaver weaver, NewParentTypeMunger munger) {
        LazyClassGen gen = weaver.getLazyClassGen();
        ResolvedTypeX newParent = munger.getNewParent();
        if (!newParent.isClass()) {
            gen.addInterface(newParent);
        }
        return true;
    }

    private boolean mungePrivilegedAccess(BcelClassWeaver weaver, PrivilegedAccessMunger munger) {
        LazyClassGen gen = weaver.getLazyClassGen();
        ResolvedMember member = munger.getMember();
        ResolvedTypeX onType = weaver.getWorld().resolve(member.getDeclaringType());
        if (onType.equals(gen.getType())) {
            if (member.getKind() == Member.FIELD) {
                this.addFieldGetter(gen, member, AjcMemberMaker.privilegedAccessMethodForFieldGet(this.aspectType, member));
                this.addFieldSetter(gen, member, AjcMemberMaker.privilegedAccessMethodForFieldSet(this.aspectType, member));
                return true;
            }
            if (member.getKind() == Member.METHOD) {
                this.addMethodDispatch(gen, member, AjcMemberMaker.privilegedAccessMethodForMethod(this.aspectType, member));
                return true;
            }
            if (member.getKind() == Member.CONSTRUCTOR) {
                Iterator i = gen.getMethodGens().iterator();
                while (i.hasNext()) {
                    LazyMethodGen m = (LazyMethodGen)i.next();
                    if (m.getMemberView() == null || m.getMemberView().getKind() != Member.CONSTRUCTOR) continue;
                    m.forcePublic();
                }
                return true;
            }
            if (member.getKind() == Member.STATIC_INITIALIZATION) {
                gen.forcePublic();
                return true;
            }
            throw new RuntimeException("unimplemented");
        }
        return false;
    }

    private void addFieldGetter(LazyClassGen gen, ResolvedMember field, ResolvedMember accessMethod) {
        LazyMethodGen mg = this.makeMethodGen(gen, accessMethod);
        InstructionList il = new InstructionList();
        InstructionFactory fact = gen.getFactory();
        if (field.isStatic()) {
            il.append(fact.createFieldAccess(gen.getClassName(), field.getName(), BcelWorld.makeBcelType(field.getType()), (short)178));
        } else {
            il.append(InstructionConstants.ALOAD_0);
            il.append(fact.createFieldAccess(gen.getClassName(), field.getName(), BcelWorld.makeBcelType(field.getType()), (short)180));
        }
        il.append(InstructionFactory.createReturn(BcelWorld.makeBcelType(field.getType())));
        mg.getBody().insert(il);
        gen.addMethodGen(mg);
    }

    private void addFieldSetter(LazyClassGen gen, ResolvedMember field, ResolvedMember accessMethod) {
        LazyMethodGen mg = this.makeMethodGen(gen, accessMethod);
        InstructionList il = new InstructionList();
        InstructionFactory fact = gen.getFactory();
        Type fieldType = BcelWorld.makeBcelType(field.getType());
        if (field.isStatic()) {
            il.append(InstructionFactory.createLoad(fieldType, 0));
            il.append(fact.createFieldAccess(gen.getClassName(), field.getName(), fieldType, (short)179));
        } else {
            il.append(InstructionConstants.ALOAD_0);
            il.append(InstructionFactory.createLoad(fieldType, 1));
            il.append(fact.createFieldAccess(gen.getClassName(), field.getName(), fieldType, (short)181));
        }
        il.append(InstructionFactory.createReturn(Type.VOID));
        mg.getBody().insert(il);
        gen.addMethodGen(mg);
    }

    private void addMethodDispatch(LazyClassGen gen, ResolvedMember method, ResolvedMember accessMethod) {
        LazyMethodGen mg = this.makeMethodGen(gen, accessMethod);
        InstructionList il = new InstructionList();
        InstructionFactory fact = gen.getFactory();
        Type[] paramTypes = BcelWorld.makeBcelTypes(method.getParameterTypes());
        int pos = 0;
        if (!method.isStatic()) {
            il.append(InstructionConstants.ALOAD_0);
            ++pos;
        }
        int i = 0;
        int len = paramTypes.length;
        while (i < len) {
            Type paramType = paramTypes[i];
            il.append(InstructionFactory.createLoad(paramType, pos));
            pos += paramType.getSize();
            ++i;
        }
        il.append(Utility.createInvoke(fact, (BcelWorld)this.aspectType.getWorld(), method));
        il.append(InstructionFactory.createReturn(BcelWorld.makeBcelType(method.getReturnType())));
        mg.getBody().insert(il);
        gen.addMethodGen(mg);
    }

    private LazyMethodGen makeMethodGen(LazyClassGen gen, ResolvedMember member) {
        return new LazyMethodGen(member.getModifiers(), BcelWorld.makeBcelType(member.getReturnType()), member.getName(), BcelWorld.makeBcelTypes(member.getParameterTypes()), TypeX.getNames(member.getExceptions()), gen);
    }

    private FieldGen makeFieldGen(LazyClassGen gen, ResolvedMember member) {
        return new FieldGen(member.getModifiers(), BcelWorld.makeBcelType(member.getReturnType()), member.getName(), gen.getConstantPoolGen());
    }

    private boolean mungePerObjectInterface(BcelClassWeaver weaver, PerObjectInterfaceTypeMunger munger) {
        LazyClassGen gen = weaver.getLazyClassGen();
        if (this.couldMatch(gen.getBcelObjectType(), munger.getTestPointcut())) {
            FieldGen fg = this.makeFieldGen(gen, AjcMemberMaker.perObjectField(gen.getType(), this.aspectType));
            gen.addField(fg.getField());
            Type fieldType = BcelWorld.makeBcelType(this.aspectType);
            LazyMethodGen mg = new LazyMethodGen(1, fieldType, NameMangler.perObjectInterfaceGet(this.aspectType), new Type[0], new String[0], gen);
            InstructionList il = new InstructionList();
            InstructionFactory fact = gen.getFactory();
            il.append(InstructionConstants.ALOAD_0);
            il.append(fact.createFieldAccess(gen.getClassName(), fg.getName(), fieldType, (short)180));
            il.append(InstructionFactory.createReturn(fieldType));
            mg.getBody().insert(il);
            gen.addMethodGen(mg);
            LazyMethodGen mg1 = new LazyMethodGen(1, Type.VOID, NameMangler.perObjectInterfaceSet(this.aspectType), new Type[]{fieldType}, new String[0], gen);
            InstructionList il1 = new InstructionList();
            il1.append(InstructionConstants.ALOAD_0);
            il1.append(InstructionFactory.createLoad(fieldType, 1));
            il1.append(fact.createFieldAccess(gen.getClassName(), fg.getName(), fieldType, (short)181));
            il1.append(InstructionFactory.createReturn(Type.VOID));
            mg1.getBody().insert(il1);
            gen.addMethodGen(mg1);
            gen.addInterface(munger.getInterfaceType());
            return true;
        }
        return false;
    }

    private boolean couldMatch(BcelObjectType bcelObjectType, Pointcut pointcut) {
        return !bcelObjectType.isInterface();
    }

    private boolean mungeNewMethod(BcelClassWeaver weaver, NewMethodTypeMunger munger) {
        ResolvedMember signature = munger.getSignature();
        ResolvedMember dispatchMethod = munger.getDispatchMethod(this.aspectType);
        LazyClassGen gen = weaver.getLazyClassGen();
        ResolvedTypeX onType = weaver.getWorld().resolve(signature.getDeclaringType());
        boolean onInterface = onType.isInterface();
        if (onType.equals(gen.getType())) {
            ResolvedMember introMethod = AjcMemberMaker.interMethod(signature, this.aspectType, onInterface);
            LazyMethodGen mg = this.makeMethodGen(gen, introMethod);
            if (!onInterface && !Modifier.isAbstract(introMethod.getModifiers())) {
                InstructionList body = mg.getBody();
                InstructionFactory fact = gen.getFactory();
                int pos = 0;
                if (!signature.isStatic()) {
                    body.append(InstructionFactory.createThis());
                    ++pos;
                }
                Type[] paramTypes = BcelWorld.makeBcelTypes(introMethod.getParameterTypes());
                int i = 0;
                int len = paramTypes.length;
                while (i < len) {
                    Type paramType = paramTypes[i];
                    body.append(InstructionFactory.createLoad(paramType, pos));
                    pos += paramType.getSize();
                    ++i;
                }
                body.append(Utility.createInvoke(fact, weaver.getWorld(), dispatchMethod));
                body.append(InstructionFactory.createReturn(BcelWorld.makeBcelType(introMethod.getReturnType())));
            }
            weaver.addLazyMethodGen(mg);
            Set neededSuperCalls = munger.getSuperMethodsCalled();
            Iterator iter = neededSuperCalls.iterator();
            while (iter.hasNext()) {
                ResolvedMember superMethod = (ResolvedMember)iter.next();
                if (!weaver.addDispatchTarget(superMethod)) continue;
                boolean isSuper = !superMethod.getDeclaringType().equals(gen.getType());
                String dispatchName = isSuper ? NameMangler.superDispatchMethod(onType, superMethod.getName()) : NameMangler.protectedDispatchMethod(onType, superMethod.getName());
                LazyMethodGen dispatcher = BcelTypeMunger.makeDispatcher(gen, dispatchName, superMethod, weaver.getWorld(), isSuper);
                weaver.addLazyMethodGen(dispatcher);
            }
            return true;
        }
        if (onInterface && gen.getType().isTopmostImplementor(onType) && !Modifier.isAbstract(signature.getModifiers())) {
            ResolvedMember introMethod = AjcMemberMaker.interMethod(signature, this.aspectType, false);
            LazyMethodGen mg = this.makeMethodGen(gen, introMethod);
            Type[] paramTypes = BcelWorld.makeBcelTypes(introMethod.getParameterTypes());
            Type returnType = BcelWorld.makeBcelType(introMethod.getReturnType());
            InstructionList body = mg.getBody();
            InstructionFactory fact = gen.getFactory();
            int pos = 0;
            if (!introMethod.isStatic()) {
                body.append(InstructionFactory.createThis());
                ++pos;
            }
            int i = 0;
            int len = paramTypes.length;
            while (i < len) {
                Type paramType = paramTypes[i];
                body.append(InstructionFactory.createLoad(paramType, pos));
                pos += paramType.getSize();
                ++i;
            }
            body.append(Utility.createInvoke(fact, weaver.getWorld(), dispatchMethod));
            body.append(InstructionFactory.createReturn(returnType));
            mg.definingType = onType;
            weaver.addOrReplaceLazyMethodGen(mg);
            return true;
        }
        return false;
    }

    private boolean mungeNewConstructor(BcelClassWeaver weaver, NewConstructorTypeMunger newConstructorTypeMunger) {
        LazyClassGen currentClass = weaver.getLazyClassGen();
        InstructionFactory fact = currentClass.getFactory();
        ResolvedMember newConstructorMember = newConstructorTypeMunger.getSyntheticConstructor();
        TypeX onType = newConstructorMember.getDeclaringType();
        if (!onType.equals(currentClass.getType())) {
            return false;
        }
        ResolvedMember explicitConstructor = newConstructorTypeMunger.getExplicitConstructor();
        LazyMethodGen freshConstructor = this.makeMethodGen(currentClass, newConstructorMember);
        currentClass.addMethodGen(freshConstructor);
        InstructionList body = freshConstructor.getBody();
        TypeX[] declaredParams = newConstructorTypeMunger.getSignature().getParameterTypes();
        Type[] paramTypes = freshConstructor.getArgumentTypes();
        int frameIndex = 1;
        int i = 0;
        int len = declaredParams.length;
        while (i < len) {
            body.append(InstructionFactory.createLoad(paramTypes[i], frameIndex));
            frameIndex += paramTypes[i].getSize();
            ++i;
        }
        ResolvedMember preMethod = AjcMemberMaker.preIntroducedConstructor(this.aspectType, onType, declaredParams);
        body.append(Utility.createInvoke(fact, null, preMethod));
        int arraySlot = freshConstructor.allocateLocal(1);
        body.append(InstructionFactory.createStore(Type.OBJECT, arraySlot));
        body.append(InstructionConstants.ALOAD_0);
        TypeX[] superParamTypes = explicitConstructor.getParameterTypes();
        int i2 = 0;
        int len2 = superParamTypes.length;
        while (i2 < len2) {
            body.append(InstructionFactory.createLoad(Type.OBJECT, arraySlot));
            body.append(Utility.createConstant(fact, i2));
            body.append(InstructionFactory.createArrayLoad(Type.OBJECT));
            body.append(Utility.createConversion(fact, Type.OBJECT, BcelWorld.makeBcelType(superParamTypes[i2])));
            ++i2;
        }
        body.append(Utility.createInvoke(fact, null, explicitConstructor));
        body.append(InstructionConstants.ALOAD_0);
        ResolvedMember postMethod = AjcMemberMaker.postIntroducedConstructor(this.aspectType, onType, declaredParams);
        TypeX[] postParamTypes = postMethod.getParameterTypes();
        int i3 = 1;
        int len3 = postParamTypes.length;
        while (i3 < len3) {
            body.append(InstructionFactory.createLoad(Type.OBJECT, arraySlot));
            body.append(Utility.createConstant(fact, superParamTypes.length + i3 - 1));
            body.append(InstructionFactory.createArrayLoad(Type.OBJECT));
            body.append(Utility.createConversion(fact, Type.OBJECT, BcelWorld.makeBcelType(postParamTypes[i3])));
            ++i3;
        }
        body.append(Utility.createInvoke(fact, null, postMethod));
        body.append(InstructionConstants.RETURN);
        return true;
    }

    private static LazyMethodGen makeDispatcher(LazyClassGen onGen, String dispatchName, ResolvedMember superMethod, BcelWorld world, boolean isSuper) {
        Type[] paramTypes = BcelWorld.makeBcelTypes(superMethod.getParameterTypes());
        Type returnType = BcelWorld.makeBcelType(superMethod.getReturnType());
        LazyMethodGen mg = new LazyMethodGen(1, returnType, dispatchName, paramTypes, TypeX.getNames(superMethod.getExceptions()), onGen);
        InstructionList body = mg.getBody();
        InstructionFactory fact = onGen.getFactory();
        int pos = 0;
        body.append(InstructionFactory.createThis());
        ++pos;
        int i = 0;
        int len = paramTypes.length;
        while (i < len) {
            Type paramType = paramTypes[i];
            body.append(InstructionFactory.createLoad(paramType, pos));
            pos += paramType.getSize();
            ++i;
        }
        if (isSuper) {
            body.append(Utility.createSuperInvoke(fact, world, superMethod));
        } else {
            body.append(Utility.createInvoke(fact, world, superMethod));
        }
        body.append(InstructionFactory.createReturn(returnType));
        return mg;
    }

    private boolean mungeNewField(BcelClassWeaver weaver, NewFieldTypeMunger munger) {
        ResolvedMember initMethod = munger.getInitMethod(this.aspectType);
        LazyClassGen gen = weaver.getLazyClassGen();
        ResolvedMember field = munger.getSignature();
        ResolvedTypeX onType = weaver.getWorld().resolve(field.getDeclaringType());
        boolean onInterface = onType.isInterface();
        if (onType.equals(gen.getType())) {
            if (onInterface) {
                LazyMethodGen mg = this.makeMethodGen(gen, AjcMemberMaker.interFieldInterfaceGetter(field, onType, this.aspectType));
                gen.addMethodGen(mg);
                LazyMethodGen mg1 = this.makeMethodGen(gen, AjcMemberMaker.interFieldInterfaceSetter(field, onType, this.aspectType));
                gen.addMethodGen(mg1);
            } else {
                weaver.addInitializer(this);
                FieldGen fg = this.makeFieldGen(gen, AjcMemberMaker.interFieldClassField(field, this.aspectType));
                gen.addField(fg.getField());
            }
            return true;
        }
        if (onInterface && gen.getType().isTopmostImplementor(onType)) {
            if (field.isStatic()) {
                throw new RuntimeException("unimplemented");
            }
            weaver.addInitializer(this);
            Type fieldType = BcelWorld.makeBcelType(field.getType());
            FieldGen fg = this.makeFieldGen(gen, AjcMemberMaker.interFieldInterfaceField(field, onType, this.aspectType));
            gen.addField(fg.getField());
            LazyMethodGen mg = this.makeMethodGen(gen, AjcMemberMaker.interFieldInterfaceGetter(field, gen.getType(), this.aspectType));
            InstructionList il = new InstructionList();
            InstructionFactory fact = gen.getFactory();
            if (field.isStatic()) {
                il.append(fact.createFieldAccess(gen.getClassName(), fg.getName(), fieldType, (short)178));
            } else {
                il.append(InstructionConstants.ALOAD_0);
                il.append(fact.createFieldAccess(gen.getClassName(), fg.getName(), fieldType, (short)180));
            }
            il.append(InstructionFactory.createReturn(fieldType));
            mg.getBody().insert(il);
            gen.addMethodGen(mg);
            LazyMethodGen mg1 = this.makeMethodGen(gen, AjcMemberMaker.interFieldInterfaceSetter(field, gen.getType(), this.aspectType));
            InstructionList il1 = new InstructionList();
            if (field.isStatic()) {
                il1.append(InstructionFactory.createLoad(fieldType, 0));
                il1.append(fact.createFieldAccess(gen.getClassName(), fg.getName(), fieldType, (short)179));
            } else {
                il1.append(InstructionConstants.ALOAD_0);
                il1.append(InstructionFactory.createLoad(fieldType, 1));
                il1.append(fact.createFieldAccess(gen.getClassName(), fg.getName(), fieldType, (short)181));
            }
            il1.append(InstructionFactory.createReturn(Type.VOID));
            mg1.getBody().insert(il1);
            gen.addMethodGen(mg1);
            return true;
        }
        return false;
    }
}

