/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TargetLostException;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.bcel.BcelShadow;
import org.aspectj.weaver.bcel.LazyMethodGen;
import org.aspectj.weaver.bcel.LocalVariableTag;
import org.aspectj.weaver.bcel.Range;

final class ShadowRange
extends Range {
    private BcelShadow shadow;

    public ShadowRange(InstructionList body) {
        super(body);
    }

    protected void associateWithTargets(InstructionHandle start, InstructionHandle end) {
        this.start = start;
        this.end = end;
        start.addTargeter(this);
        end.addTargeter(this);
    }

    public void associateWithShadow(BcelShadow shadow) {
        this.shadow = shadow;
        shadow.setRange(this);
    }

    public Shadow.Kind getKind() {
        return this.shadow.getKind();
    }

    public String toString() {
        return this.shadow.toString();
    }

    void extractInstructionsInto(LazyMethodGen freshMethod, IntMap remap, boolean addReturn) {
        InstructionTargeter[] ts;
        LazyMethodGen.assertGoodBody(this.getBody(), this.toString());
        freshMethod.assertGoodBody();
        InstructionList freshBody = freshMethod.getBody();
        InstructionHandle oldIh = this.start.getNext();
        while (oldIh != this.end) {
            InstructionHandle freshIh;
            Instruction freshI;
            Instruction oldI = oldIh.getInstruction();
            Instruction instruction = freshI = oldI == Range.RANGEINSTRUCTION ? oldI : oldI.copy();
            if (freshI instanceof BranchInstruction) {
                BranchInstruction oldBranch = (BranchInstruction)oldI;
                BranchInstruction freshBranch = (BranchInstruction)freshI;
                InstructionHandle oldTarget = oldBranch.getTarget();
                oldTarget.removeTargeter(oldBranch);
                oldTarget.addTargeter(freshBranch);
                if (freshBranch instanceof Select) {
                    Select oldSelect = (Select)oldI;
                    Select freshSelect = (Select)freshI;
                    InstructionHandle[] oldTargets = freshSelect.getTargets();
                    int k = oldTargets.length - 1;
                    while (k >= 0) {
                        oldTargets[k].removeTargeter(oldSelect);
                        oldTargets[k].addTargeter(freshSelect);
                        --k;
                    }
                }
                freshIh = freshBody.append(freshBranch);
            } else {
                freshIh = freshBody.append(freshI);
            }
            InstructionTargeter[] sources = oldIh.getTargeters();
            if (sources != null) {
                int j = sources.length - 1;
                while (j >= 0) {
                    InstructionTargeter source = sources[j];
                    if (source instanceof LocalVariableTag) {
                        source.updateTarget(oldIh, null);
                    } else if (source instanceof Range) {
                        ((Range)source).updateTarget(oldIh, freshIh, freshBody);
                    } else {
                        source.updateTarget(oldIh, freshIh);
                    }
                    --j;
                }
            }
            if (freshI instanceof LocalVariableInstruction || freshI instanceof RET) {
                int freshIndex;
                IndexedInstruction indexedI = (IndexedInstruction)((Object)freshI);
                int oldIndex = indexedI.getIndex();
                if (!remap.hasKey(oldIndex)) {
                    freshIndex = freshMethod.allocateLocal(2);
                    remap.put(oldIndex, freshIndex);
                } else {
                    freshIndex = remap.get(oldIndex);
                }
                indexedI.setIndex(freshIndex);
            }
            oldIh = oldIh.getNext();
        }
        try {
            InstructionHandle oldIh2 = this.start.getNext();
            while (oldIh2 != this.end) {
                InstructionHandle next = oldIh2.getNext();
                this.body.delete(oldIh2);
                oldIh2 = next;
            }
        }
        catch (TargetLostException e) {
            throw new BCException("shouldn't have gotten a target lost");
        }
        InstructionHandle ret = null;
        if (addReturn) {
            new InstructionFactory(freshMethod.getEnclosingClass().getConstantPoolGen());
            ret = freshBody.append(InstructionFactory.createReturn(freshMethod.getReturnType()));
        }
        if ((ts = this.end.getTargeters()) != null) {
            int j = ts.length - 1;
            while (j >= 0) {
                InstructionTargeter t = ts[j];
                if (t != this) {
                    if (!addReturn) {
                        throw new BCException("range has target, but we aren't adding a return");
                    }
                    t.updateTarget(this.end, ret);
                }
                --j;
            }
        }
        LazyMethodGen.assertGoodBody(this.getBody(), this.toString());
        freshMethod.assertGoodBody();
    }

    public BcelShadow getShadow() {
        return this.shadow;
    }
}

