/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.JavaClass;
import org.aspectj.util.FileUtil;
import org.aspectj.weaver.bcel.Utility;

public class UnwovenClassFile {
    protected String filename;
    protected byte[] bytes;
    protected List writtenChildClasses = new ArrayList(0);
    protected String className = null;

    public UnwovenClassFile(String filename, byte[] bytes) {
        this.filename = filename;
        this.bytes = bytes;
    }

    public String getFilename() {
        return this.filename;
    }

    public String makeInnerFileName(String innerName) {
        String prefix = this.filename.substring(0, this.filename.length() - 6);
        return prefix + "$" + innerName + ".class";
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public JavaClass getJavaClass() {
        if (this.getBytes() == null) {
            System.out.println("no bytes for: " + this.getFilename());
            Thread.currentThread();
            Thread.dumpStack();
        }
        return Utility.makeJavaClass(this.filename, this.getBytes());
    }

    public boolean exists() {
        return this.getBytes() != null;
    }

    public void writeUnchangedBytes() throws IOException {
        this.writeWovenBytes(this.getBytes(), Collections.EMPTY_LIST);
    }

    public void writeWovenBytes(byte[] bytes, List childClasses) throws IOException {
        this.writeChildClasses(childClasses);
        BufferedOutputStream os = FileUtil.makeOutputStream(new File(this.filename));
        os.write(bytes);
        os.close();
    }

    private void writeChildClasses(List childClasses) throws IOException {
        this.deleteAllChildClasses();
        childClasses.removeAll(this.writtenChildClasses);
        Iterator iter = childClasses.iterator();
        while (iter.hasNext()) {
            ChildClass childClass = (ChildClass)iter.next();
            this.writeChildClassFile(childClass.name, childClass.bytes);
        }
        this.writtenChildClasses = childClasses;
    }

    private void writeChildClassFile(String innerName, byte[] bytes) throws IOException {
        BufferedOutputStream os = FileUtil.makeOutputStream(new File(this.makeInnerFileName(innerName)));
        os.write(bytes);
        os.close();
    }

    protected void deleteAllChildClasses() {
        Iterator iter = this.writtenChildClasses.iterator();
        while (iter.hasNext()) {
            ChildClass childClass = (ChildClass)iter.next();
            this.deleteChildClassFile(childClass.name);
        }
    }

    protected void deleteChildClassFile(String innerName) {
        File childClassFile = new File(this.makeInnerFileName(innerName));
        childClassFile.delete();
    }

    private static boolean unchanged(byte[] b1, byte[] b2) {
        int len = b1.length;
        if (b2.length != len) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (b1[i] != b2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getClassName() {
        if (this.className == null) {
            this.className = this.getJavaClass().getClassName();
        }
        return this.className;
    }

    public String toString() {
        return "UnwovenClassFile(" + this.filename + ", " + this.getClassName() + ")";
    }

    public void deleteRealFile() throws IOException {
        new File(this.filename).delete();
    }

    public static class ChildClass {
        public final String name;
        public final byte[] bytes;

        ChildClass(String name, byte[] bytes) {
            this.name = name;
            this.bytes = bytes;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ChildClass)) {
                return false;
            }
            ChildClass o = (ChildClass)other;
            return o.name.equals(this.name) && UnwovenClassFile.unchanged(o.bytes, this.bytes);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "(ChildClass " + this.name + ")";
        }
    }
}

