/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.Pointcut;

public class OrPointcut
extends Pointcut {
    private Pointcut left;
    private Pointcut right;

    public OrPointcut(Pointcut left, Pointcut right) {
        this.left = left;
        this.right = right;
        this.setLocation(left.getSourceContext(), left.getStart(), right.getEnd());
    }

    public FuzzyBoolean fastMatch(ResolvedTypeX type) {
        return this.left.fastMatch(type).or(this.right.fastMatch(type));
    }

    public FuzzyBoolean match(Shadow shadow) {
        return this.left.match(shadow).or(this.right.match(shadow));
    }

    public String toString() {
        return "(" + this.left.toString() + " || " + this.right.toString() + ")";
    }

    public boolean equals(Object other) {
        if (!(other instanceof OrPointcut)) {
            return false;
        }
        OrPointcut o = (OrPointcut)other;
        return o.left.equals(this.left) && o.right.equals(this.right);
    }

    public int hashCode() {
        int result = 31;
        result = 37 * result + this.left.hashCode();
        result = 37 * result + this.right.hashCode();
        return result;
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        Bindings old = bindings == null ? null : bindings.copy();
        this.left.resolveBindings(scope, bindings);
        this.right.resolveBindings(scope, old);
        if (bindings != null) {
            bindings.checkEquals(old, scope);
        }
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(6);
        this.left.write(s);
        this.right.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(DataInputStream s, ISourceContext context) throws IOException {
        OrPointcut ret = new OrPointcut(Pointcut.read(s, context), Pointcut.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        return Test.makeOr(this.left.findResidue(shadow, state), this.right.findResidue(shadow, state));
    }

    public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        return new OrPointcut(this.left.concretize1(inAspect, bindings), this.right.concretize1(inAspect, bindings));
    }
}

