/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.util.TypeSafeEnum;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.AndPointcut;
import org.aspectj.weaver.patterns.ArgsPointcut;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.CflowPointcut;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.HandlerPointcut;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.IfPointcut;
import org.aspectj.weaver.patterns.KindedPointcut;
import org.aspectj.weaver.patterns.NotPointcut;
import org.aspectj.weaver.patterns.OrPointcut;
import org.aspectj.weaver.patterns.PatternNode;
import org.aspectj.weaver.patterns.PatternParser;
import org.aspectj.weaver.patterns.ReferencePointcut;
import org.aspectj.weaver.patterns.ThisOrTargetPointcut;
import org.aspectj.weaver.patterns.WithinPointcut;
import org.aspectj.weaver.patterns.WithincodePointcut;

public abstract class Pointcut
extends PatternNode {
    public static final State SYMBOLIC = new State("symbolic", 0);
    public static final State RESOLVED = new State("resolved", 1);
    public static final State CONCRETE = new State("concrete", 2);
    public State state = SYMBOLIC;
    public static final byte KINDED = 1;
    public static final byte WITHIN = 2;
    public static final byte THIS_OR_TARGET = 3;
    public static final byte ARGS = 4;
    public static final byte AND = 5;
    public static final byte OR = 6;
    public static final byte NOT = 7;
    public static final byte REFERENCE = 8;
    public static final byte IF = 9;
    public static final byte CFLOW = 10;
    public static final byte WITHINCODE = 12;
    public static final byte HANDLER = 13;
    public static final byte NONE = 20;

    public abstract FuzzyBoolean fastMatch(ResolvedTypeX var1);

    public abstract FuzzyBoolean match(Shadow var1);

    protected abstract void resolveBindings(IScope var1, Bindings var2);

    public Pointcut resolve(IScope scope) {
        this.assertState(SYMBOLIC);
        Bindings bindingTable = new Bindings(scope.getFormalCount());
        this.resolveBindings(scope, bindingTable);
        bindingTable.checkAllBound(scope);
        this.state = RESOLVED;
        return this;
    }

    public Pointcut concretize(ResolvedTypeX inAspect, int arity) {
        return this.concretize(inAspect, IntMap.idMap(arity));
    }

    public Pointcut concretize(ResolvedTypeX inAspect, int arity, ShadowMunger advice) {
        IntMap map = IntMap.idMap(arity);
        map.setEnclosingAdvice(advice);
        map.setConcreteAspect(inAspect);
        return this.concretize(inAspect, map);
    }

    public Pointcut concretize(ResolvedTypeX inAspect, IntMap bindings) {
        this.assertState(RESOLVED);
        Pointcut ret = this.concretize1(inAspect, bindings);
        ret.state = CONCRETE;
        return ret;
    }

    protected abstract Pointcut concretize1(ResolvedTypeX var1, IntMap var2);

    public abstract Test findResidue(Shadow var1, ExposedState var2);

    public void postRead(ResolvedTypeX enclosingType) {
    }

    public static Pointcut read(DataInputStream s, ISourceContext context) throws IOException {
        Pointcut ret;
        byte kind = s.readByte();
        switch (kind) {
            case 1: {
                ret = KindedPointcut.read(s, context);
                break;
            }
            case 2: {
                ret = WithinPointcut.read(s, context);
                break;
            }
            case 3: {
                ret = ThisOrTargetPointcut.read(s, context);
                break;
            }
            case 4: {
                ret = ArgsPointcut.read(s, context);
                break;
            }
            case 5: {
                ret = AndPointcut.read(s, context);
                break;
            }
            case 6: {
                ret = OrPointcut.read(s, context);
                break;
            }
            case 7: {
                ret = NotPointcut.read(s, context);
                break;
            }
            case 8: {
                ret = ReferencePointcut.read(s, context);
                break;
            }
            case 9: {
                ret = IfPointcut.read(s, context);
                break;
            }
            case 10: {
                ret = CflowPointcut.read(s, context);
                break;
            }
            case 12: {
                ret = WithincodePointcut.read(s, context);
                break;
            }
            case 13: {
                ret = HandlerPointcut.read(s, context);
                break;
            }
            case 20: {
                ret = Pointcut.makeMatchesNothing(RESOLVED);
                break;
            }
            default: {
                throw new BCException("unknown kind: " + kind);
            }
        }
        ret.state = RESOLVED;
        return ret;
    }

    public static Pointcut fromString(String str) {
        PatternParser parser = new PatternParser(str);
        return parser.parsePointcut();
    }

    public static Pointcut makeMatchesNothing(State state) {
        MatchesNothingPointcut ret = new MatchesNothingPointcut();
        ret.state = state;
        return ret;
    }

    public void assertState(State state) {
        if (this.state != state) {
            throw new BCException("expected state: " + state + " got: " + this.state);
        }
    }

    private static class MatchesNothingPointcut
    extends Pointcut {
        private MatchesNothingPointcut() {
        }

        public Test findResidue(Shadow shadow, ExposedState state) {
            return Literal.FALSE;
        }

        public FuzzyBoolean fastMatch(ResolvedTypeX type) {
            return FuzzyBoolean.NO;
        }

        public FuzzyBoolean match(Shadow shadow) {
            return FuzzyBoolean.NO;
        }

        public void resolveBindings(IScope scope, Bindings bindings) {
        }

        public void postRead(ResolvedTypeX enclosingType) {
        }

        public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
            return Pointcut.makeMatchesNothing(this.state);
        }

        public void write(DataOutputStream s) throws IOException {
            s.writeByte(20);
        }

        public String toString() {
            return "";
        }
    }

    public static final class State
    extends TypeSafeEnum {
        public State(String name, int key) {
            super(name, key);
        }
    }
}

