/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import org.eclipse.core.internal.plugins.PluginParser;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.Factory;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.core.runtime.model.PluginRegistryModel;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class RegistryLoader {
    private Factory factory;
    private boolean debug = false;
    private long startTick;
    private long lastTick = this.startTick = new Date().getTime();

    private RegistryLoader(Factory factory, boolean debug) {
        this.debug = debug;
        this.factory = factory;
    }

    private void debug(String msg) {
        long thisTick = System.currentTimeMillis();
        System.out.println("RegistryLoader: " + msg + " [+" + (thisTick - this.lastTick) + "ms]");
        this.lastTick = thisTick;
    }

    private String[] getPathMembers(URL path) {
        String[] list = null;
        String protocol = path.getProtocol();
        if (protocol.equals("file")) {
            list = new File(path.getFile()).list();
        }
        return list == null ? new String[]{} : list;
    }

    private boolean parseProblem(String message) {
        this.factory.error(new Status(2, "org.eclipse.core.runtime", 1, message, null));
        return true;
    }

    private PluginRegistryModel parseRegistry(URL[] pluginPath) {
        long startTick = System.currentTimeMillis();
        PluginRegistryModel result = this.processManifestFiles(pluginPath);
        if (InternalPlatform.DEBUG) {
            long endTick = System.currentTimeMillis();
            this.debug("Parsed Registry: " + (endTick - startTick) + "ms");
        }
        return result;
    }

    public static PluginRegistryModel parseRegistry(URL[] pluginPath, Factory factory, boolean debug) {
        return new RegistryLoader(factory, debug).parseRegistry(pluginPath);
    }

    private PluginModel processManifestFile(URL manifest) {
        InputStream is = null;
        try {
            is = manifest.openStream();
        }
        catch (IOException iOException) {
            if (this.debug) {
                this.debug("No plugin found for: " + manifest);
            }
            return null;
        }
        PluginModel result = null;
        try {
            try {
                InputSource in = new InputSource(is);
                in.setSystemId(manifest.getFile());
                result = new PluginParser(this.factory).parsePlugin(in);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                is.close();
                throw throwable;
            }
            Object var5_8 = null;
            is.close();
        }
        catch (SAXParseException sAXParseException) {
            this.factory.error(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("parse.errorProcessing", manifest.toString()), null));
        }
        catch (Exception e) {
            this.factory.error(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("parse.errorProcessing", String.valueOf(manifest.toString()) + ":  " + e.getMessage()), null));
        }
        return result;
    }

    private PluginRegistryModel processManifestFiles(URL[] pluginPath) {
        PluginRegistryModel result = this.factory.createPluginRegistry();
        int i = 0;
        while (i < pluginPath.length) {
            this.processPluginPathEntry(result, pluginPath[i]);
            ++i;
        }
        return result;
    }

    private void processPluginPathEntry(PluginRegistryModel registry, URL location) {
        if (this.debug) {
            this.debug("Path - " + location);
        }
        if (location.getFile().endsWith("/")) {
            String[] members = this.getPathMembers(location);
            int j = 0;
            while (j < members.length) {
                boolean found = false;
                try {
                    found = this.processPluginPathFile(registry, new URL(location, String.valueOf(members[j]) + "/plugin.xml"));
                    if (!found) {
                        found = this.processPluginPathFile(registry, new URL(location, String.valueOf(members[j]) + "/fragment.xml"));
                    }
                }
                catch (MalformedURLException malformedURLException) {}
                if (this.debug) {
                    this.debug(found ? "Processed - " : "Processed (not found) - " + members[j]);
                }
                ++j;
            }
        } else {
            boolean found = this.processPluginPathFile(registry, location);
            if (this.debug) {
                this.debug(found ? "Processed - " : "Processed (not found) - " + location);
            }
        }
    }

    private boolean processPluginPathFile(PluginRegistryModel registry, URL location) {
        PluginModel entry = this.processManifestFile(location);
        if (entry == null) {
            return false;
        }
        if (!this.requiredPluginModel(entry, location)) {
            entry = null;
            return false;
        }
        entry.setVersion(this.getQualifiedVersion(entry, location));
        if (entry instanceof PluginDescriptorModel) {
            if (entry.getId() == null || entry.getVersion() == null) {
                return this.parseProblem(Policy.bind("parse.nullPluginIdentifier", location.toString()));
            }
            if (registry.getPlugin(entry.getId(), entry.getVersion()) != null) {
                return this.parseProblem(Policy.bind("parse.duplicatePlugin", entry.getId(), location.toString()));
            }
            registry.addPlugin((PluginDescriptorModel)entry);
        } else {
            if (entry.getId() == null || entry.getVersion() == null) {
                return this.parseProblem(Policy.bind("parse.nullFragmentIdentifier", location.toString()));
            }
            if (entry instanceof PluginFragmentModel) {
                registry.addFragment((PluginFragmentModel)entry);
            } else {
                return this.parseProblem(Policy.bind("parse.unknownEntry", location.toString()));
            }
        }
        String url = location.toString();
        url = url.substring(0, 1 + url.lastIndexOf(47));
        entry.setRegistry(registry);
        entry.setLocation(url);
        InternalPlatform.addLastModifiedTime(location.getFile(), new File(location.getFile()).lastModified());
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getQualifiedVersion(PluginModel entry, URL base) {
        String string;
        InputStream is;
        block15: {
            String string2;
            block14: {
                String string3;
                block13: {
                    if (entry == null) return null;
                    if (entry.getVersion() == null) return null;
                    if (entry.getId() == null) {
                        return null;
                    }
                    is = null;
                    try {
                        try {
                            URL manifest = null;
                            manifest = new URL(base, "buildmanifest.properties");
                            Properties props = new Properties();
                            is = manifest.openStream();
                            props.load(is);
                            String key = "plugin@" + entry.getId();
                            String qualifier = props.getProperty(key);
                            if (qualifier == null) {
                                string3 = entry.getVersion();
                                Object var9_12 = null;
                                if (is == null) return string3;
                                break block13;
                            }
                            PluginVersionIdentifier v = new PluginVersionIdentifier(entry.getVersion());
                            if (!v.getQualifierComponent().equals("")) {
                                string2 = entry.getVersion();
                                break block14;
                            }
                            string = new PluginVersionIdentifier(v.getMajorComponent(), v.getMinorComponent(), v.getServiceComponent(), qualifier).toString();
                            break block15;
                        }
                        catch (Exception exception) {
                            String string4 = entry.getVersion();
                            Object var9_15 = null;
                            if (is == null) return string4;
                            try {
                                is.close();
                                return string4;
                            }
                            catch (IOException iOException) {}
                            return string4;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_16 = null;
                        if (is == null) throw throwable;
                        try {}
                        catch (IOException iOException) {
                            throw throwable;
                        }
                        is.close();
                        throw throwable;
                    }
                }
                try {}
                catch (IOException iOException) {}
                is.close();
                return string3;
            }
            Object var9_13 = null;
            if (is == null) return string2;
            try {}
            catch (IOException iOException) {}
            is.close();
            return string2;
        }
        Object var9_14 = null;
        if (is == null) return string;
        try {}
        catch (IOException iOException) {}
        is.close();
        return string;
    }

    private boolean requiredPluginModel(PluginModel plugin, URL location) {
        int versionLength;
        String name = plugin.getName();
        String id = plugin.getId();
        String version = plugin.getVersion();
        int nameLength = name == null ? 0 : name.length();
        int idLength = id == null ? 0 : id.length();
        int n = versionLength = version == null ? 0 : version.length();
        if (nameLength <= 0) {
            this.parseProblem(Policy.bind("parse.missingPluginName", location.toString()));
            return false;
        }
        if (idLength <= 0) {
            this.parseProblem(Policy.bind("parse.missingPluginId", location.toString()));
            return false;
        }
        if (versionLength <= 0) {
            this.parseProblem(Policy.bind("parse.missingPluginVersion", location.toString()));
            return false;
        }
        if (plugin instanceof PluginFragmentModel) {
            int pNameVersion;
            String pluginName = ((PluginFragmentModel)plugin).getPlugin();
            String pluginVersion = ((PluginFragmentModel)plugin).getPluginVersion();
            int pNameLength = pluginName == null ? 0 : pluginName.length();
            int n2 = pNameVersion = pluginVersion == null ? 0 : pluginVersion.length();
            if (pNameLength <= 0) {
                this.parseProblem(Policy.bind("parse.missingFPName", location.toString()));
                return false;
            }
            if (pNameVersion <= 0) {
                this.parseProblem(Policy.bind("parse.missingFPVersion", location.toString()));
                return false;
            }
        }
        return true;
    }
}

