/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.SaveManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class DelayedSnapshotRunnable
implements Runnable {
    private boolean canceled;
    private SaveManager saveManager;
    private long delay;
    private static final long MIN_DELAY = 30000L;

    public DelayedSnapshotRunnable(SaveManager manager, long delay) {
        this.saveManager = manager;
        if (delay < 30000L) {
            delay = 30000L;
        }
        this.delay = delay;
        this.canceled = false;
    }

    public void run() {
        DelayedSnapshotRunnable delayedSnapshotRunnable = this;
        synchronized (delayedSnapshotRunnable) {
            try {
                this.wait(this.delay);
            }
            catch (InterruptedException interruptedException) {
                this.canceled = true;
            }
        }
        if (!this.canceled) {
            this.runSnapshot();
        }
    }

    public synchronized void cancel() {
        this.canceled = true;
        this.notifyAll();
    }

    private void runSnapshot() {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor m) throws CoreException {
                Workspace workspace;
                if (!DelayedSnapshotRunnable.this.canceled && (workspace = (Workspace)ResourcesPlugin.getWorkspace()) != null) {
                    workspace.getWorkManager().avoidAutoBuild();
                    DelayedSnapshotRunnable.this.saveManager.requestSnapshot();
                }
            }
        };
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (workspace != null) {
                workspace.run(runnable, null);
            }
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
    }
}

