/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.internal.events.ResourceDeltaFactory;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.SafeFileTable;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SavedState
implements ISavedState {
    ElementTree oldTree;
    ElementTree newTree;
    SafeFileTable fileTable;
    String pluginId;
    Workspace workspace;

    SavedState(Workspace workspace, String pluginId, ElementTree oldTree, ElementTree newTree) throws CoreException {
        this.workspace = workspace;
        this.pluginId = pluginId;
        this.newTree = newTree;
        this.oldTree = oldTree;
        this.fileTable = this.restoreFileTable();
    }

    void forgetTrees() {
        this.newTree = null;
        this.oldTree = null;
    }

    public int getSaveNumber() {
        return this.workspace.getSaveManager().getSaveNumber(this.pluginId);
    }

    protected SafeFileTable getFileTable() {
        return this.fileTable;
    }

    protected SafeFileTable restoreFileTable() throws CoreException {
        if (this.fileTable == null) {
            this.fileTable = new SafeFileTable(this.pluginId);
        }
        return this.fileTable;
    }

    public IPath lookup(IPath file) {
        return this.getFileTable().lookup(file);
    }

    public IPath[] getFiles() {
        return this.getFileTable().getFiles();
    }

    public void processResourceChangeEvents(IResourceChangeListener listener) {
        try {
            try {
                block6: {
                    this.workspace.prepareOperation();
                    if (this.oldTree == null) break block6;
                    if (this.newTree != null) break block7;
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.workspace.endOperation(false, null);
                throw throwable;
            }
            this.workspace.endOperation(false, null);
            {
                block7: {
                    return;
                }
                this.workspace.beginOperation(true);
                ResourceDelta delta = ResourceDeltaFactory.computeDelta(this.workspace, this.oldTree, this.newTree, Path.ROOT, false);
                this.forgetTrees();
                this.workspace.getNotificationManager().broadcastChanges(listener, 16, delta, false);
            }
            Object var3_4 = null;
            this.workspace.endOperation(false, null);
        }
        catch (CoreException e) {
            ResourceStatus status = new ResourceStatus(2, null, e.getMessage(), e);
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
    }
}

