/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.ModelObject;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IWorkspaceDescription;

public class WorkspaceDescription
extends ModelObject
implements IWorkspaceDescription {
    protected Workspace workspace;
    protected boolean autoBuilding = true;
    protected volatile long fileStateLongevity = 604800000L;
    protected volatile long maxFileStateSize = 0x100000L;
    protected int maxBuildIterations = 10;
    protected int maxFileStates = 50;
    protected String[] buildOrder = null;
    private volatile long snapshotInterval = 300000L;

    public WorkspaceDescription(String name) {
        super(name);
    }

    public String[] getBuildOrder() {
        return this.getBuildOrder(true);
    }

    public String[] getBuildOrder(boolean makeCopy) {
        if (this.buildOrder == null) {
            return null;
        }
        return makeCopy ? (String[])this.buildOrder.clone() : this.buildOrder;
    }

    public long getDeltaExpiration() {
        return 2592000000L;
    }

    public long getFileStateLongevity() {
        return this.fileStateLongevity;
    }

    public int getMaxBuildIterations() {
        return this.maxBuildIterations;
    }

    public int getMaxFileStates() {
        return this.maxFileStates;
    }

    public long getMaxFileStateSize() {
        return this.maxFileStateSize;
    }

    public int getOperationsPerSnapshot() {
        return 100;
    }

    public long getSnapshotInterval() {
        return this.snapshotInterval;
    }

    public void internalSetBuildOrder(String[] value) {
        this.buildOrder = value;
    }

    public boolean isAutoBuilding() {
        return this.autoBuilding;
    }

    public boolean isSnapshotEnabled() {
        return true;
    }

    public void setAutoBuilding(boolean value) {
        this.autoBuilding = value;
    }

    public void setBuildOrder(String[] value) {
        this.buildOrder = value == null ? null : (String[])value.clone();
    }

    public void setFileStateLongevity(long time) {
        this.fileStateLongevity = time;
    }

    public void setMaxBuildIterations(int number) {
        this.maxBuildIterations = number;
    }

    public void setMaxFileStates(int number) {
        this.maxFileStates = number;
    }

    public void setMaxFileStateSize(long size) {
        this.maxFileStateSize = size;
    }

    public void setSnapshotInterval(long snapshotInterval) {
        this.snapshotInterval = snapshotInterval;
    }
}

