/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.internal.runtime.SafeFileInputStream;
import org.eclipse.core.internal.runtime.SafeFileOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class PlatformMetaArea {
    IPath location;
    static final String F_DESCRIPTION = ".platform";
    static final String F_META_AREA = ".metadata";
    static final String F_PLUGIN_PATH = ".plugin-path";
    static final String F_PLUGIN_DATA = ".plugins";
    static final String F_REGISTRY = ".registry";
    static final String F_SNAP = ".snap";
    static final String F_LOG = ".log";
    static final String F_BACKUP = ".bak";
    static final String F_OPTIONS = ".options";
    static final String F_KEYRING = ".keyring";
    static final String F_LOCK_FILE = ".lock";
    static final String F_VERSION = "version.ini";
    static final String PREFERENCES_FILE_NAME = "pref_store.ini";

    public PlatformMetaArea(IPath location) {
        this.location = location;
    }

    private Properties buildPathProperties(Hashtable paths) {
        Properties result = new Properties();
        Enumeration keys = paths.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            StringBuffer entry = new StringBuffer(100);
            IPath[] list = (IPath[])paths.get(key);
            int i = 0;
            while (i < list.length) {
                entry.append(list[i].toOSString());
                entry.append(";");
                ++i;
            }
            ((Hashtable)result).put(key, entry.toString());
        }
        return result;
    }

    public void createLocation() throws CoreException {
        File file = this.getLocation().toFile();
        try {
            file.mkdirs();
        }
        catch (Exception e) {
            String message = Policy.bind("meta.couldNotCreate", file.getAbsolutePath());
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, message, e));
        }
        if (!file.canWrite()) {
            String message = Policy.bind("meta.readonly", file.getAbsolutePath());
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, message, null));
        }
    }

    public IPath getBackupFilePathFor(IPath file) {
        return file.removeLastSegments(1).append(String.valueOf(file.lastSegment()) + F_BACKUP);
    }

    public IPath getLocation() {
        return this.location.append(F_META_AREA);
    }

    public IPath getLogLocation() {
        return this.getLocation().append(F_LOG);
    }

    public IPath getOptionsLocation() {
        return this.getLocation().append(F_OPTIONS);
    }

    public IPath getPluginPreferenceLocation(IPluginDescriptor descriptor, boolean create) {
        IPath result = this.getPluginStateLocation(descriptor);
        if (create) {
            result.toFile().mkdirs();
        }
        return result.append(PREFERENCES_FILE_NAME);
    }

    public IPath getPluginStateLocation(IPluginDescriptor descriptor) {
        return this.getLocation().append(F_PLUGIN_DATA).append(descriptor.getUniqueIdentifier());
    }

    public IPath getRegistryPath() {
        return this.getLocation().append(F_REGISTRY);
    }

    public IPath getVersionPath() {
        return this.getLocation().append(F_VERSION);
    }

    public IPath getSnapshotPath() {
        return this.getLocation().append(F_SNAP);
    }

    private Hashtable parsePathProperties(Properties props) {
        Hashtable<String, Object[]> result = new Hashtable<String, Object[]>(5);
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String entry = props.getProperty(key);
            Vector<Path> list = new Vector<Path>(4);
            StringTokenizer tokens = new StringTokenizer(entry, ";");
            while (tokens.hasMoreTokens()) {
                list.addElement(new Path(tokens.nextToken()));
            }
            Object[] paths = new IPath[list.size()];
            list.copyInto(paths);
            result.put(key, paths);
        }
        return result;
    }

    public Hashtable readPluginPath(IPath location) throws CoreException {
        Properties props = new Properties();
        location = location.append(F_PLUGIN_PATH);
        IPath tempLocation = this.getBackupFilePathFor(location);
        SafeFileInputStream stream = null;
        try {
            try {
                stream = new SafeFileInputStream(location.toOSString(), tempLocation.toOSString());
                props.load(stream);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (stream != null) {
                    stream.close();
                }
                throw throwable;
            }
            Object var5_8 = null;
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            String message = Policy.bind("meta.readPlatformMeta", location.toString());
            Status status = new Status(4, "org.eclipse.core.runtime", 4, message, e);
            throw new CoreException(status);
        }
        return this.parsePathProperties(props);
    }

    public void writePluginPath(Hashtable paths, IPath location) throws CoreException {
        Properties props = this.buildPathProperties(paths);
        location = location.append(F_PLUGIN_PATH);
        IPath tempLocation = this.getBackupFilePathFor(location);
        SafeFileOutputStream stream = null;
        try {
            try {
                stream = new SafeFileOutputStream(location.toOSString(), tempLocation.toOSString());
                props.store(stream, null);
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (stream != null) {
                    stream.close();
                }
                throw throwable;
            }
            Object var6_9 = null;
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            String message = Policy.bind("meta.writePlatformMeta", location.toString());
            Status status = new Status(4, "org.eclipse.core.runtime", 5, message, e);
            throw new CoreException(status);
        }
    }
}

