/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.watson;

import org.eclipse.core.internal.dtree.NodeComparison;
import org.eclipse.core.internal.watson.ElementTreeDelta;
import org.eclipse.core.internal.watson.IDeltaFilter;
import org.eclipse.core.runtime.IPath;

public class ElementDelta {
    protected ElementTreeDelta treeDelta;
    protected IPath pathInDelta;
    protected IPath pathInTrees;
    protected NodeComparison comparison;

    ElementDelta(ElementTreeDelta treeDelta, IPath pathInTrees, IPath pathInDelta, NodeComparison comparison) {
        this.treeDelta = treeDelta;
        this.pathInDelta = pathInDelta;
        this.pathInTrees = pathInTrees;
        this.comparison = comparison;
    }

    public void destroy() {
        this.treeDelta.destroy();
        this.treeDelta = null;
        this.pathInDelta = null;
        this.pathInTrees = null;
        this.comparison = null;
    }

    protected ElementDelta[] getAddedChildren(IDeltaFilter filter) {
        IPath[] children = this.treeDelta.getElementTree().getChildren(this.pathInTrees);
        ElementDelta[] deltas = new ElementDelta[children.length];
        int i = children.length;
        while (--i >= 0) {
            deltas[i] = new ElementDelta(this.treeDelta, children[i], this.pathInDelta.append(children[i].lastSegment()), this.comparison);
        }
        return deltas;
    }

    public ElementDelta[] getAffectedChildren(IDeltaFilter filter) {
        switch (this.comparison.getComparison()) {
            case 4: {
                return this.treeDelta.getAffectedElements(this.pathInDelta, filter);
            }
            case 1: {
                if (!filter.includeElement(this.comparison.getUserComparison())) break;
                return this.getAddedChildren(filter);
            }
            case 2: {
                if (!filter.includeElement(this.comparison.getUserComparison())) break;
                return this.getRemovedChildren(filter);
            }
        }
        return new ElementDelta[0];
    }

    public int getComparison() {
        return this.comparison.getUserComparison();
    }

    public IPath getPath() {
        return this.pathInTrees;
    }

    protected ElementDelta[] getRemovedChildren(IDeltaFilter filter) {
        IPath[] children = this.treeDelta.getParent().getChildren(this.pathInTrees);
        ElementDelta[] deltas = new ElementDelta[children.length];
        int i = children.length;
        while (--i >= 0) {
            deltas[i] = new ElementDelta(this.treeDelta, children[i], this.pathInDelta.append(children[i].lastSegment()), this.comparison);
        }
        return deltas;
    }

    public ElementTreeDelta getTreeDelta() {
        return this.treeDelta;
    }

    public boolean hasAffectedChildren(IDeltaFilter filter) {
        int compare = this.comparison.getComparison();
        if (compare == 4) {
            return this.treeDelta.hasAffectedElements(this.pathInDelta, filter);
        }
        if (filter.includeElement(this.comparison.getUserComparison())) {
            if (compare == 1) {
                return this.treeDelta.getElementTree().getChildCount(this.pathInTrees) > 0;
            }
            return this.treeDelta.getParent().getChildCount(this.pathInTrees) > 0;
        }
        return false;
    }

    public String toString() {
        return "ElementDelta(" + this.pathInTrees + ")";
    }
}

