/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.watson;

import java.util.HashMap;
import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.DataTreeLookup;
import org.eclipse.core.internal.dtree.DataTreeNode;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.ObjectNotFoundException;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.DefaultElementComparator;
import org.eclipse.core.internal.watson.ElementSubtree;
import org.eclipse.core.internal.watson.ElementTreeDelta;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementComparator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IElementTreeData;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ElementTree {
    protected DeltaDataTree tree;
    protected IElementTreeData userData;
    ChildIDsCache childIDsCache = null;
    DataTreeLookup lookupCache = null;
    private static int treeCounter = 0;
    private int treeStamp;

    public ElementTree() {
        this.initialize(new DeltaDataTree());
    }

    public ElementTree(ElementTree[] children) {
        DataTreeNode node = this.nodeForElement(null, null, children);
        this.initialize(new DeltaDataTree(node));
    }

    public ElementTree(String name, Object data) {
        DataTreeNode node = this.nodeForElement(name, data, null);
        this.initialize(node);
    }

    public ElementTree(String name, Object data, ElementTree[] children) {
        DataTreeNode node = this.nodeForElement(name, data, children);
        this.initialize(node);
    }

    protected ElementTree(DataTreeNode rootNode) {
        this.initialize(rootNode);
    }

    protected ElementTree(DeltaDataTree tree) {
        this.initialize(tree);
    }

    ElementTree(ElementSubtree subtree) {
        DataTreeNode rootNode = this.nodeFor(null, null, subtree.getChildren());
        DeltaDataTree tree = new DeltaDataTree(rootNode);
        this.initialize(tree);
    }

    protected ElementTree(ElementTree parent) {
        IElementTreeData data;
        if (!parent.isImmutable()) {
            parent.immutable();
        }
        if ((data = parent.getTreeData()) != null) {
            this.userData = (IElementTreeData)data.clone();
        }
        this.initialize(parent.tree.newEmptyDeltaTree());
    }

    public ElementTree collapseTo(ElementTree parent) {
        Assert.isTrue(this.tree.isImmutable());
        if (this == parent) {
            return this;
        }
        this.tree.collapseTo(parent.tree, DefaultElementComparator.getComparator());
        return this;
    }

    private ElementTree collapsing(int depth) {
        return this;
    }

    public ElementTreeDelta computeDeltaWith(ElementTree olderTree, IElementComparator comparator) {
        if (olderTree == null || comparator == null) {
            throw new IllegalArgumentException(Policy.bind("watson.nullArg", "ElementTree.computeDeltaWith"));
        }
        return new ElementTreeDelta(olderTree, this, comparator);
    }

    public ElementTreeDelta computeDeltaWith(ElementTree olderTree, IElementComparator comparator, IPath path) {
        if (olderTree == null || comparator == null) {
            throw new IllegalArgumentException(Policy.bind("watson.nullArg", "ElementTree.computeDeltaWith"));
        }
        if (path.isRoot()) {
            return new ElementTreeDelta(olderTree, this, comparator);
        }
        return new ElementTreeDelta(olderTree, this, comparator, path);
    }

    public void createElement(IPath key, Object data) {
        if (key.isRoot()) {
            return;
        }
        this.childIDsCache = null;
        this.lookupCache = null;
        IPath parent = key.removeLastSegments(1);
        try {
            this.tree.createChild(parent, key.lastSegment(), data);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.elementNotFound(parent);
        }
    }

    public void createSubtree(IPath key, ElementTree subtree) {
        if (key.isRoot()) {
            throw new IllegalArgumentException(Policy.bind("watson.noModify"));
        }
        this.childIDsCache = null;
        this.lookupCache = null;
        try {
            IPath[] children = subtree.getChildren(subtree.getRoot());
            if (children.length != 1) {
                throw new IllegalArgumentException(Policy.bind("watson.illegalSubtree"));
            }
            DataTreeNode node = (DataTreeNode)subtree.tree.copyCompleteSubtree(children[0]);
            this.tree.createSubtree(key, node);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.elementNotFound(key);
        }
    }

    public void deleteElement(IPath key) {
        if (key.isRoot()) {
            return;
        }
        this.childIDsCache = null;
        this.lookupCache = null;
        try {
            this.tree.deleteChild(key.removeLastSegments(1), key.lastSegment());
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.elementNotFound(key);
        }
    }

    public int deltaDepth() {
        int d = 0;
        DeltaDataTree t = this.tree;
        while (t.getParent() != null) {
            ++d;
            t = t.getParent();
        }
        return d;
    }

    protected void elementNotFound(IPath key) {
        throw new IllegalArgumentException(Policy.bind("watson.elementNotFound", key.toString()));
    }

    public static int findOldest(ElementTree[] trees) {
        HashMap<ElementTree, ElementTree> candidates = new HashMap<ElementTree, ElementTree>((int)((double)trees.length * 1.5 + 1.0));
        int i = 0;
        while (i < trees.length) {
            candidates.put(trees[i], trees[i]);
            ++i;
        }
        ElementTree oldestSoFar = null;
        while (candidates.size() > 0) {
            ElementTree current = (ElementTree)candidates.values().iterator().next();
            candidates.remove(current);
            ElementTree parent = current.getParent();
            while (parent != null && parent != oldestSoFar) {
                candidates.remove(parent);
                parent = parent.getParent();
            }
            oldestSoFar = current;
        }
        Assert.isNotNull(oldestSoFar);
        int i2 = 0;
        while (i2 < trees.length) {
            if (trees[i2] == oldestSoFar) {
                return i2;
            }
            ++i2;
        }
        Assert.isTrue(false, "Should not get here");
        return -1;
    }

    public IPath getChild(IPath key, int childIndex) {
        Assert.isNotNull(key);
        return this.getChildIDs(key)[childIndex];
    }

    public int getChildCount(IPath key) {
        Assert.isNotNull(key);
        return this.getChildIDs(key).length;
    }

    protected IPath[] getChildIDs(IPath key) {
        ChildIDsCache cache = this.childIDsCache;
        if (cache != null && cache.path == key) {
            return cache.childPaths;
        }
        try {
            if (key == null) {
                return new IPath[]{this.tree.rootKey()};
            }
            IPath[] children = this.tree.getChildren(key);
            this.childIDsCache = new ChildIDsCache(key, children);
            return children;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.elementNotFound(key);
            return null;
        }
    }

    public IPath[] getChildren(IPath key) {
        Assert.isNotNull(key);
        return this.getChildIDs(key);
    }

    public DeltaDataTree getDataTree() {
        return this.tree;
    }

    public ElementTreeDelta getDelta() {
        ElementTree parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return new ElementTreeDelta(parent, this, DefaultElementComparator.getComparator());
    }

    public Object getElementData(IPath key) {
        if (key.isRoot()) {
            return null;
        }
        DataTreeLookup lookup = this.lookupCache;
        if (lookup == null || lookup.key != key) {
            this.lookupCache = lookup = this.tree.lookup(key);
        }
        if (lookup.isPresent) {
            return lookup.data;
        }
        this.elementNotFound(key);
        return null;
    }

    ElementSubtree getElementSubtree() {
        DataTreeNode elementNode = (DataTreeNode)this.tree.copyCompleteSubtree(this.tree.rootKey());
        return new ElementSubtree(elementNode);
    }

    public String[] getNamesOfChildren(IPath key) {
        try {
            if (key == null) {
                return new String[]{""};
            }
            return this.tree.getNamesOfChildren(key);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.elementNotFound(key);
            return null;
        }
    }

    public ElementTree getParent() {
        DeltaDataTree parentTree = this.tree.getParent();
        if (parentTree == null) {
            return null;
        }
        return (ElementTree)parentTree.getData(this.tree.rootKey());
    }

    public IPath getRoot() {
        return this.getChildIDs(null)[0];
    }

    public ElementTree getSubtree(IPath key) {
        if (key.isRoot()) {
            return this;
        }
        try {
            DataTreeNode elementNode = (DataTreeNode)this.tree.copyCompleteSubtree(key);
            return new ElementTree(elementNode);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.elementNotFound(key);
            return null;
        }
    }

    public IElementTreeData getTreeData() {
        return this.userData;
    }

    public boolean hasAncestor(ElementTree oldTree) {
        if (this == oldTree) {
            return false;
        }
        if (this.tree.isImmutable()) {
            ElementTree tree = oldTree.getParent();
            while (tree != null) {
                if (tree == this) {
                    return true;
                }
                tree = tree.getParent();
            }
        } else {
            ElementTree tree = this.getParent();
            while (tree != null) {
                if (tree == oldTree) {
                    return true;
                }
                tree = tree.getParent();
            }
        }
        return false;
    }

    public static boolean hasChanges(ElementTree newLayer, ElementTree oldLayer, IElementComparator comparator, boolean inclusive) {
        ElementTree layer;
        if (newLayer == null || oldLayer == null) {
            return true;
        }
        if (newLayer == oldLayer) {
            return false;
        }
        if (comparator.compare(newLayer.getTreeData(), oldLayer.getTreeData()) != 0) {
            return true;
        }
        ElementTree stopLayer = null;
        if (newLayer.isImmutable()) {
            stopLayer = newLayer.getParent();
        } else {
            layer = newLayer;
            while (layer != null && layer.getParent() != null) {
                if (!layer.getDataTree().isEmptyDelta()) {
                    return true;
                }
                layer = layer.getParent();
            }
        }
        layer = inclusive ? oldLayer : oldLayer.getParent();
        while (layer != null && layer.getParent() != stopLayer) {
            if (!layer.getDataTree().isEmptyDelta()) {
                return true;
            }
            layer = layer.getParent();
        }
        return false;
    }

    public void immutable() {
        if (!this.tree.isImmutable()) {
            this.tree.immutable();
            this.lookupCache = null;
            this.tree.reroot();
        }
    }

    public boolean includes(IPath key) {
        DataTreeLookup lookup = this.lookupCache;
        if (lookup == null || lookup.key != key) {
            this.lookupCache = lookup = this.tree.lookup(key);
        }
        return lookup.isPresent;
    }

    protected void initialize(DataTreeNode rootNode) {
        this.initialize(new DeltaDataTree(new DataTreeNode(null, null, new AbstractDataTreeNode[]{rootNode})));
    }

    protected void initialize(DeltaDataTree tree) {
        this.treeStamp = treeCounter++;
        tree.setData(tree.rootKey(), this);
        this.tree = tree;
    }

    public boolean isImmutable() {
        return this.tree.isImmutable();
    }

    public void makeComplete() {
        this.lookupCache = null;
        this.tree.makeComplete();
    }

    public ElementTree mergeDeltaChain(IPath path, ElementTree[] trees) {
        if (path == null || trees == null) {
            throw new IllegalArgumentException(Policy.bind("watson.nullArg", "ElementTree.mergeDeltaChain"));
        }
        if (this.isImmutable()) {
            throw new IllegalArgumentException(Policy.bind("watson.immutable"));
        }
        ElementTree current = this;
        if (trees.length > 0) {
            ElementTree toMerge = trees[ElementTree.findOldest(trees)];
            while (toMerge != null) {
                if (path.isRoot()) {
                    IPath[] children = toMerge.getChildren(Path.ROOT);
                    int i = 0;
                    while (i < children.length) {
                        current.createSubtree(children[i], toMerge.getSubtree(children[i]));
                        ++i;
                    }
                } else {
                    current.createSubtree(path, toMerge.getSubtree(path));
                }
                current.immutable();
                int i = 0;
                while (i < trees.length) {
                    if (trees[i] == toMerge) {
                        trees[i] = current;
                    }
                    ++i;
                }
                current = current.newEmptyDelta();
                toMerge = toMerge.getParent();
            }
        }
        return current;
    }

    public ElementTree newEmptyDelta() {
        this.lookupCache = null;
        return new ElementTree(this);
    }

    private DataTreeNode nodeFor(String elementName, Object elementInfo, ElementSubtree[] subtrees) {
        if (subtrees == null || subtrees.length == 0) {
            return new DataTreeNode(elementName, elementInfo);
        }
        AbstractDataTreeNode[] childNodes = new DataTreeNode[subtrees.length];
        int i = subtrees.length;
        while (--i >= 0) {
            childNodes[i] = this.nodeFor(subtrees[i]);
        }
        AbstractDataTreeNode.sort(childNodes);
        return new DataTreeNode(elementName, elementInfo, childNodes);
    }

    private DataTreeNode nodeFor(ElementSubtree subtree) {
        return this.nodeFor(subtree.elementName, subtree.elementData, subtree.getChildren());
    }

    protected DataTreeNode nodeForElement(String elementName, Object element, ElementTree[] children) {
        if (children == null || children.length == 0) {
            return new DataTreeNode(elementName, element, null);
        }
        int childCount = 0;
        int i = 0;
        while (i < children.length) {
            childCount += children[i].getChildCount(children[i].getRoot());
            ++i;
        }
        if (childCount == 0) {
            return new DataTreeNode(elementName, element, null);
        }
        AbstractDataTreeNode[] childNodes = new AbstractDataTreeNode[childCount];
        int next = 0;
        int i2 = 0;
        while (i2 < children.length) {
            IPath[] rootChildren = children[i2].getChildren(children[i2].getRoot());
            int j = 0;
            while (j < rootChildren.length) {
                childNodes[next++] = children[i2].tree.copyCompleteSubtree(rootChildren[j]);
                ++j;
            }
            ++i2;
        }
        Assert.isTrue(next == childCount);
        return new DataTreeNode(elementName, element, childNodes);
    }

    public Object openElementData(IPath key) {
        Assert.isTrue(!this.isImmutable());
        if (key.isRoot()) {
            return null;
        }
        DataTreeLookup lookup = this.lookupCache;
        if (lookup == null || lookup.key != key) {
            this.lookupCache = lookup = this.tree.lookup(key);
        }
        if (lookup.isPresent) {
            if (lookup.foundInFirstDelta) {
                return lookup.data;
            }
            IElementTreeData oldData = (IElementTreeData)lookup.data;
            if (oldData != null) {
                try {
                    Object newData = oldData.clone();
                    this.tree.setData(key, newData);
                    this.lookupCache = null;
                    return newData;
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    this.elementNotFound(key);
                }
            }
        } else {
            this.elementNotFound(key);
        }
        return null;
    }

    public void setElementData(IPath key, Object data) {
        if (key.isRoot()) {
            return;
        }
        Assert.isNotNull(key);
        this.lookupCache = null;
        try {
            this.tree.setData(key, data);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.elementNotFound(key);
        }
    }

    public void setTreeData(IElementTreeData data) {
        this.userData = data;
    }

    public String toDebugString() {
        final StringBuffer buffer = new StringBuffer("\n");
        IElementContentVisitor visitor = new IElementContentVisitor(){

            public boolean visitElement(ElementTree tree, IPathRequestor elementID, Object elementContents) {
                buffer.append(elementID.requestPath() + " " + elementContents + "\n");
                return true;
            }
        };
        new ElementTreeIterator(this, Path.ROOT).iterate(visitor);
        return buffer.toString();
    }

    public String toString() {
        return "ElementTree(" + this.treeStamp + ")";
    }

    private class ChildIDsCache {
        IPath path;
        IPath[] childPaths;

        ChildIDsCache(IPath path, IPath[] childPaths) {
            this.path = path;
            this.childPaths = childPaths;
        }
    }
}

