/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources;

import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Semaphore;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;

public class WorkspaceLock {
    private WorkManager workManager;

    public WorkspaceLock(IWorkspace workspace) throws CoreException {
        this.workManager = ((Workspace)workspace).getWorkManager();
    }

    public boolean acquire() throws InterruptedException {
        Semaphore semaphore = this.workManager.acquire();
        if (semaphore == null) {
            return true;
        }
        if (Workspace.DEBUG) {
            System.out.println("[" + Thread.currentThread() + "] Operation waiting to be executed... :-/");
        }
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            if (Workspace.DEBUG) {
                System.out.println("[" + Thread.currentThread() + "] Operation interrupted while waiting... :-|");
            }
            throw e;
        }
        this.workManager.updateCurrentOperation();
        if (Workspace.DEBUG) {
            System.out.println("[" + Thread.currentThread() + "] Operation started... :-)");
        }
        return true;
    }

    protected Thread getCurrentOperationThread() {
        return this.workManager.getCurrentOperationThread();
    }

    public void release() {
        this.workManager.release();
    }

    protected boolean isTreeLocked() {
        return this.workManager.isTreeLocked();
    }
}

