/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.internal.runtime.SafeFileInputStream;
import org.eclipse.core.internal.runtime.SafeFileOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;

public abstract class Plugin {
    private boolean debug = false;
    private IPluginDescriptor descriptor;
    public static final String PREFERENCES_DEFAULT_OVERRIDE_BASE_NAME = "preferences";
    public static final String PREFERENCES_DEFAULT_OVERRIDE_FILE_NAME = "preferences.ini";
    private Preferences preferences = null;
    static /* synthetic */ Class class$0;

    public Plugin(IPluginDescriptor descriptor) {
        Assert.isNotNull(descriptor);
        Assert.isTrue(!descriptor.isPluginActivated(), Policy.bind("plugin.deactivatedLoad", this.getClass().getName(), String.valueOf(descriptor.getUniqueIdentifier()) + " is not activated"));
        String className = ((PluginDescriptor)descriptor).getPluginClass();
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.internal.plugins.DefaultPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            Assert.isTrue(className == null || className.equals(""), Policy.bind("plugin.mismatchRuntime", descriptor.getUniqueIdentifier()));
        } else {
            Assert.isTrue(this.getClass().getName().equals(className), Policy.bind("plugin.mismatchRuntime", descriptor.getUniqueIdentifier()));
        }
        this.descriptor = descriptor;
        String key = String.valueOf(descriptor.getUniqueIdentifier()) + "/debug";
        String value = Platform.getDebugOption(key);
        this.debug = value == null ? false : value.equalsIgnoreCase("true");
    }

    public final URL find(IPath path) {
        return this.getDescriptor().find(path);
    }

    public final URL find(IPath path, Map override) {
        return this.getDescriptor().find(path, override);
    }

    private String getFileFromURL(URL target) {
        String protocol = target.getProtocol();
        if (protocol.equals("file")) {
            return target.getFile();
        }
        if (protocol.equals("jar")) {
            String file = target.getFile();
            file = file.substring(0, file.length() - "!/".length());
            try {
                return this.getFileFromURL(new URL(file));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public final IPluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final ILog getLog() {
        return InternalPlatform.getLog(this);
    }

    public final IPath getStateLocation() {
        return InternalPlatform.getPluginStateLocation(this.descriptor, true);
    }

    public final Preferences getPluginPreferences() {
        if (this.preferences != null) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Plugin preferences already loaded for " + this.getDescriptor().getUniqueIdentifier());
            }
            return this.preferences;
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Loading preferences for plugin " + this.getDescriptor().getUniqueIdentifier());
        }
        this.preferences = new Preferences();
        this.loadPluginPreferences();
        this.initializeDefaultPluginPreferences();
        this.applyInternalPluginDefaultOverrides();
        this.applyExternalPluginDefaultOverrides();
        if (InternalPlatform.DEBUG_PREFERENCES) {
            System.out.println("Completed loading preferences for plugin " + this.getDescriptor().getUniqueIdentifier());
        }
        return this.preferences;
    }

    private void loadPluginPreferences() {
        block17: {
            File prefFile = InternalPlatform.getMetaArea().getPluginPreferenceLocation(this.descriptor, false).toFile();
            if (!prefFile.exists()) {
                if (InternalPlatform.DEBUG_PREFERENCES) {
                    System.out.println("Plugin preference file " + prefFile + " not found.");
                }
                return;
            }
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Loading preferences from " + prefFile);
            }
            SafeFileInputStream in = null;
            try {
                try {
                    in = new SafeFileInputStream(prefFile);
                    this.preferences.load(in);
                }
                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES) {
                        System.out.println("IOException encountered loading preference file " + prefFile);
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                block16: {
                    Object var4_7 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            if (!InternalPlatform.DEBUG_PREFERENCES) break block16;
                            System.out.println("IOException encountered closing preference file " + prefFile);
                            e.printStackTrace();
                        }
                    }
                }
                throw throwable;
            }
            Object var4_8 = null;
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    if (!InternalPlatform.DEBUG_PREFERENCES) break block17;
                    System.out.println("IOException encountered closing preference file " + prefFile);
                    e.printStackTrace();
                }
            }
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            String value;
            System.out.println("Preferences now set as follows:");
            String[] prefNames = this.preferences.propertyNames();
            int i = 0;
            while (i < prefNames.length) {
                value = this.preferences.getString(prefNames[i]);
                System.out.println("\t" + prefNames[i] + " = " + value);
                ++i;
            }
            prefNames = this.preferences.defaultPropertyNames();
            i = 0;
            while (i < prefNames.length) {
                value = this.preferences.getDefaultString(prefNames[i]);
                System.out.println("\tDefault values: " + prefNames[i] + " = " + value);
                ++i;
            }
        }
    }

    public final void savePluginPreferences() {
        block14: {
            if (this.preferences == null || !this.preferences.needsSaving()) {
                return;
            }
            File prefFile = InternalPlatform.getMetaArea().getPluginPreferenceLocation(this.descriptor, true).toFile();
            if (this.preferences.propertyNames().length == 0) {
                if (InternalPlatform.DEBUG_PREFERENCES) {
                    System.out.println("Removing saved preferences from " + prefFile);
                }
                if (prefFile.exists()) {
                    prefFile.delete();
                }
                return;
            }
            SafeFileOutputStream out = null;
            try {
                try {
                    out = new SafeFileOutputStream(prefFile);
                    this.preferences.store(out, null);
                }
                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES) {
                        System.out.println("IOException writing to preference file " + prefFile);
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                block13: {
                    Object var4_5 = null;
                    if (out != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (IOException e) {
                            if (!InternalPlatform.DEBUG_PREFERENCES) break block13;
                            System.out.println("IOException closing preference file " + prefFile);
                            e.printStackTrace();
                        }
                    }
                }
                throw throwable;
            }
            Object var4_6 = null;
            if (out == null) break block14;
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                if (!InternalPlatform.DEBUG_PREFERENCES) break block14;
                System.out.println("IOException closing preference file " + prefFile);
                e.printStackTrace();
            }
        }
    }

    protected void initializeDefaultPluginPreferences() {
    }

    private void applyExternalPluginDefaultOverrides() {
        InternalPlatform.applyPrimaryFeaturePluginDefaultOverrides(this.getDescriptor().getUniqueIdentifier(), this.preferences);
        InternalPlatform.applyCommandLinePluginDefaultOverrides(this.getDescriptor().getUniqueIdentifier(), this.preferences);
    }

    private void applyInternalPluginDefaultOverrides() {
        Properties overrides;
        IPluginDescriptor pluginDescriptor;
        block25: {
            pluginDescriptor = this.getDescriptor();
            URL baseURL = pluginDescriptor.find(new Path(PREFERENCES_DEFAULT_OVERRIDE_FILE_NAME));
            if (baseURL == null) {
                if (InternalPlatform.DEBUG_PREFERENCES) {
                    System.out.println("Plugin preference file preferences.ini not found.");
                }
                return;
            }
            File iniFile = new File(this.getFileFromURL(baseURL));
            if (!iniFile.exists()) {
                if (InternalPlatform.DEBUG_PREFERENCES) {
                    System.out.println("Plugin preference file " + iniFile + " not found.");
                }
                return;
            }
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Loading preferences from " + iniFile);
            }
            overrides = new Properties();
            SafeFileInputStream in = null;
            try {
                try {
                    in = new SafeFileInputStream(iniFile);
                    overrides.load(in);
                }
                catch (IOException e) {
                    block23: {
                        if (InternalPlatform.DEBUG_PREFERENCES) {
                            System.out.println("IOException encountered loading preference file " + iniFile);
                            e.printStackTrace();
                        }
                        Object var7_8 = null;
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException e2) {
                            if (!InternalPlatform.DEBUG_PREFERENCES) break block23;
                            System.out.println("IOException encountered closing preference file " + iniFile);
                            e2.printStackTrace();
                        }
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                block24: {
                    Object var7_9 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e2) {
                        if (!InternalPlatform.DEBUG_PREFERENCES) break block24;
                        System.out.println("IOException encountered closing preference file " + iniFile);
                        e2.printStackTrace();
                    }
                }
                throw throwable;
            }
            Object var7_10 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e2) {
                if (!InternalPlatform.DEBUG_PREFERENCES) break block25;
                System.out.println("IOException encountered closing preference file " + iniFile);
                e2.printStackTrace();
            }
        }
        Properties props = null;
        if (!((Hashtable)overrides).isEmpty()) {
            props = InternalPlatform.getPreferenceTranslator(pluginDescriptor, PREFERENCES_DEFAULT_OVERRIDE_BASE_NAME);
        }
        Iterator it = ((Hashtable)overrides).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            value = InternalPlatform.translatePreference(value, props);
            this.preferences.setDefault(key, value);
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            String value;
            System.out.println("Preferences now set as follows:");
            String[] prefNames = this.preferences.propertyNames();
            int i = 0;
            while (i < prefNames.length) {
                value = this.preferences.getString(prefNames[i]);
                System.out.println("\t" + prefNames[i] + " = " + value);
                ++i;
            }
            prefNames = this.preferences.defaultPropertyNames();
            i = 0;
            while (i < prefNames.length) {
                value = this.preferences.getDefaultString(prefNames[i]);
                System.out.println("\tDefault values: " + prefNames[i] + " = " + value);
                ++i;
            }
        }
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public final InputStream openStream(IPath file) throws IOException {
        return this.openStream(file, false);
    }

    public final InputStream openStream(IPath file, boolean localized) throws IOException {
        URL target = new URL(this.getDescriptor().getInstallURL() + file.toString());
        return target.openStream();
    }

    public void setDebugging(boolean value) {
        this.debug = value;
    }

    public void shutdown() throws CoreException {
    }

    public void startup() throws CoreException {
    }

    public String toString() {
        return this.descriptor.toString();
    }
}

