/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.model;

import org.eclipse.core.runtime.model.ConfigurationPropertyModel;
import org.eclipse.core.runtime.model.ExtensionModel;
import org.eclipse.core.runtime.model.PluginModelObject;

public class ConfigurationElementModel
extends PluginModelObject {
    private String value = null;
    private ConfigurationPropertyModel[] properties = null;
    private ConfigurationElementModel[] children = null;
    private Object parent = null;

    public Object getParent() {
        return this.parent;
    }

    public ExtensionModel getParentExtension() {
        Object p = this.getParent();
        while (p != null && p instanceof ConfigurationElementModel) {
            p = ((ConfigurationElementModel)p).getParent();
        }
        return (ExtensionModel)p;
    }

    public ConfigurationPropertyModel[] getProperties() {
        return this.properties;
    }

    public ConfigurationElementModel[] getSubElements() {
        return this.children;
    }

    public String getValue() {
        return this.value;
    }

    public String getValueAsIs() {
        return this.value;
    }

    public void markReadOnly() {
        int i;
        super.markReadOnly();
        if (this.children != null) {
            i = 0;
            while (i < this.children.length) {
                this.children[i].markReadOnly();
                ++i;
            }
        }
        if (this.properties != null) {
            i = 0;
            while (i < this.properties.length) {
                this.properties[i].markReadOnly();
                ++i;
            }
        }
    }

    public void setParent(Object value) {
        this.assertIsWriteable();
        this.parent = value;
    }

    public void setProperties(ConfigurationPropertyModel[] value) {
        this.assertIsWriteable();
        this.properties = value;
    }

    public void setSubElements(ConfigurationElementModel[] value) {
        this.assertIsWriteable();
        this.children = value;
    }

    public void setValue(String value) {
        this.assertIsWriteable();
        this.value = value;
    }
}

