/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTSyntaxErrorPropagator;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.AnonymousLocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.Break;
import org.eclipse.jdt.internal.compiler.ast.Case;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Continue;
import org.eclipse.jdt.internal.compiler.ast.DefaultCase;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.IntLiteralMinValue;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.LongLiteralMinValue;
import org.eclipse.jdt.internal.compiler.ast.MemberTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.OR_OR_Expression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.parser.Scanner;

class ASTConverter {
    private AST ast;
    private char[] compilationUnitSource;
    private Scanner scanner;
    private boolean resolveBindings;
    private Set pendingThisExpressionScopeResolution;
    private Set pendingNameScopeResolution;

    public ASTConverter(Map options, boolean resolveBindings) {
        this.resolveBindings = resolveBindings;
        this.scanner = new Scanner(true, false, false, "1.4".equals(options.get("org.eclipse.jdt.core.compiler.source")), null, null);
    }

    public void setAST(AST ast) {
        this.ast = ast;
    }

    public CompilationUnit convert(CompilationUnitDeclaration unit, char[] source) {
        org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[] types;
        ImportReference[] imports;
        this.compilationUnitSource = source;
        this.scanner.setSource(source);
        CompilationUnit compilationUnit = this.ast.newCompilationUnit();
        if (this.resolveBindings) {
            this.recordNodes(compilationUnit, unit);
        }
        if (unit.currentPackage != null) {
            PackageDeclaration packageDeclaration = this.convertPackage(unit);
            compilationUnit.setPackage(packageDeclaration);
        }
        if ((imports = unit.imports) != null) {
            int importLength = imports.length;
            int i = 0;
            while (i < importLength) {
                compilationUnit.imports().add(this.convertImport(imports[i]));
                ++i;
            }
        }
        if ((types = unit.types) != null) {
            int typesLength = types.length;
            int i = 0;
            while (i < typesLength) {
                compilationUnit.types().add(this.convert(types[i]));
                ++i;
            }
        }
        compilationUnit.setSourceRange(unit.sourceStart, unit.sourceEnd - unit.sourceStart + 1);
        if (unit.compilationResult.problemCount != 0) {
            this.propagateErrors(compilationUnit, unit.compilationResult.problems, unit.compilationResult.problemCount);
        }
        if (this.resolveBindings) {
            this.lookupForScopes();
        }
        return compilationUnit;
    }

    public PackageDeclaration convertPackage(CompilationUnitDeclaration compilationUnitDeclaration) {
        ImportReference importReference = compilationUnitDeclaration.currentPackage;
        PackageDeclaration packageDeclaration = this.ast.newPackageDeclaration();
        char[][] tokens = importReference.tokens;
        int length = importReference.tokens.length;
        long[] positions = importReference.sourcePositions;
        int start = (int)(positions[0] >>> 32);
        int end = (int)(positions[length - 1] & 0xFFFFFFFFFFFFFFFFL);
        Name name = null;
        if (length > 1) {
            name = this.setQualifiedNameNameAndSourceRanges(tokens, positions, importReference);
        } else {
            name = this.ast.newSimpleName(new String(tokens[0]));
            name.setSourceRange(start, end - start + 1);
        }
        packageDeclaration.setSourceRange(importReference.declarationSourceStart, importReference.declarationEnd - importReference.declarationSourceStart + 1);
        packageDeclaration.setName(name);
        if (this.resolveBindings) {
            this.recordNodes(packageDeclaration, importReference);
            this.recordNodes(name, compilationUnitDeclaration);
        }
        return packageDeclaration;
    }

    public ImportDeclaration convertImport(ImportReference importReference) {
        ImportDeclaration importDeclaration = this.ast.newImportDeclaration();
        boolean onDemand = importReference.onDemand;
        char[][] tokens = importReference.tokens;
        int length = importReference.tokens.length;
        long[] positions = importReference.sourcePositions;
        Name name = null;
        if (length > 1) {
            name = this.setQualifiedNameNameAndSourceRanges(tokens, positions, importReference);
        } else {
            name = this.ast.newSimpleName(new String(tokens[0]));
            int start = (int)(positions[0] >>> 32);
            int end = (int)(positions[0] & 0xFFFFFFFFFFFFFFFFL);
            name.setSourceRange(start, end - start + 1);
        }
        importDeclaration.setSourceRange(importReference.declarationSourceStart, importReference.declarationEnd - importReference.declarationSourceStart + 1);
        importDeclaration.setName(name);
        importDeclaration.setOnDemand(onDemand);
        if (this.resolveBindings) {
            this.recordNodes(importDeclaration, importReference);
        }
        return importDeclaration;
    }

    public TypeDeclaration convert(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDeclaration) {
        TypeReference[] superInterfaces;
        TypeDeclaration typeDecl = this.ast.newTypeDeclaration();
        int modifiers = typeDeclaration.modifiers;
        modifiers &= 0xFFFFFDFF;
        modifiers &= 0xFFFF;
        try {
            typeDecl.setModifiers(modifiers);
        }
        catch (IllegalArgumentException e) {
            int legalModifiers = 3103;
            typeDecl.setModifiers(modifiers & legalModifiers);
            typeDecl.setFlags(1);
        }
        typeDecl.setInterface(typeDeclaration.isInterface());
        SimpleName typeName = this.ast.newSimpleName(new String(typeDeclaration.name));
        typeName.setSourceRange(typeDeclaration.sourceStart, typeDeclaration.sourceEnd - typeDeclaration.sourceStart + 1);
        typeDecl.setName(typeName);
        typeDecl.setSourceRange(typeDeclaration.declarationSourceStart, typeDeclaration.bodyEnd - typeDeclaration.declarationSourceStart + 1);
        if (typeDeclaration.superclass != null) {
            typeDecl.setSuperclass(this.convert(typeDeclaration.superclass));
        }
        if ((superInterfaces = typeDeclaration.superInterfaces) != null) {
            int index = 0;
            int length = superInterfaces.length;
            while (index < length) {
                typeDecl.superInterfaces().add(this.convert(superInterfaces[index]));
                ++index;
            }
        }
        this.buildBodyDeclarations(typeDeclaration, typeDecl);
        this.setJavaDocComment(typeDecl);
        if (this.resolveBindings) {
            this.recordNodes(typeDecl, typeDeclaration);
            this.recordNodes(typeName, typeDeclaration);
            typeDecl.resolveBinding();
        }
        return typeDecl;
    }

    private void buildBodyDeclarations(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDeclaration, TypeDeclaration typeDecl) {
        MemberTypeDeclaration[] members = typeDeclaration.memberTypes;
        org.eclipse.jdt.internal.compiler.ast.FieldDeclaration[] fields = typeDeclaration.fields;
        AbstractMethodDeclaration[] methods = typeDeclaration.methods;
        int fieldsLength = fields == null ? 0 : fields.length;
        int methodsLength = methods == null ? 0 : methods.length;
        int membersLength = members == null ? 0 : members.length;
        int fieldsIndex = 0;
        int methodsIndex = 0;
        int membersIndex = 0;
        block5: while (fieldsIndex < fieldsLength || membersIndex < membersLength || methodsIndex < methodsLength) {
            org.eclipse.jdt.internal.compiler.ast.FieldDeclaration nextFieldDeclaration = null;
            AbstractMethodDeclaration nextMethodDeclaration = null;
            MemberTypeDeclaration nextMemberDeclaration = null;
            int position = Integer.MAX_VALUE;
            int nextDeclarationType = -1;
            if (fieldsIndex < fieldsLength) {
                nextFieldDeclaration = fields[fieldsIndex];
                if (nextFieldDeclaration.declarationSourceStart < position) {
                    position = nextFieldDeclaration.declarationSourceStart;
                    nextDeclarationType = 0;
                }
            }
            if (methodsIndex < methodsLength) {
                nextMethodDeclaration = methods[methodsIndex];
                if (nextMethodDeclaration.declarationSourceStart < position) {
                    position = nextMethodDeclaration.declarationSourceStart;
                    nextDeclarationType = 1;
                }
            }
            if (membersIndex < membersLength) {
                nextMemberDeclaration = members[membersIndex];
                if (nextMemberDeclaration.declarationSourceStart < position) {
                    position = nextMemberDeclaration.declarationSourceStart;
                    nextDeclarationType = 2;
                }
            }
            switch (nextDeclarationType) {
                case 0: {
                    this.checkAndAddMultipleFieldDeclaration(fields, fieldsIndex, typeDecl.bodyDeclarations());
                    ++fieldsIndex;
                    break;
                }
                case 1: {
                    ++methodsIndex;
                    if (nextMethodDeclaration.isDefaultConstructor() || nextMethodDeclaration.isClinit()) continue block5;
                    typeDecl.bodyDeclarations().add(this.convert(nextMethodDeclaration));
                    break;
                }
                case 2: {
                    ++membersIndex;
                    typeDecl.bodyDeclarations().add(this.convert(nextMemberDeclaration));
                }
            }
        }
    }

    private void checkAndAddMultipleFieldDeclaration(org.eclipse.jdt.internal.compiler.ast.FieldDeclaration[] fields, int index, List bodyDeclarations) {
        if (fields[index] instanceof org.eclipse.jdt.internal.compiler.ast.Initializer) {
            org.eclipse.jdt.internal.compiler.ast.Initializer oldInitializer = (org.eclipse.jdt.internal.compiler.ast.Initializer)fields[index];
            Initializer initializer = this.ast.newInitializer();
            initializer.setBody(this.convert(oldInitializer.block));
            initializer.setModifiers(oldInitializer.modifiers);
            initializer.setSourceRange(oldInitializer.declarationSourceStart, oldInitializer.sourceEnd - oldInitializer.declarationSourceStart + 1);
            this.setJavaDocComment(initializer);
            bodyDeclarations.add(initializer);
            return;
        }
        if (index > 0 && fields[index - 1].declarationSourceStart == fields[index].declarationSourceStart) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclarations.get(bodyDeclarations.size() - 1);
            fieldDeclaration.fragments().add(this.convertToVariableDeclarationFragment(fields[index]));
        } else {
            bodyDeclarations.add(this.convertToFieldDeclaration(fields[index]));
        }
    }

    private void checkAndAddMultipleLocalDeclaration(org.eclipse.jdt.internal.compiler.ast.Statement[] stmts, int index, List blockStatements) {
        if (index > 0 && stmts[index - 1] instanceof LocalDeclaration) {
            LocalDeclaration local1 = (LocalDeclaration)stmts[index - 1];
            LocalDeclaration local2 = (LocalDeclaration)stmts[index];
            if (local1.declarationSourceStart == local2.declarationSourceStart) {
                VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)blockStatements.get(blockStatements.size() - 1);
                variableDeclarationStatement.fragments().add(this.convertToVariableDeclarationFragment((LocalDeclaration)stmts[index]));
            } else {
                blockStatements.add(this.convertToVariableDeclarationStatement((LocalDeclaration)stmts[index]));
            }
        } else {
            blockStatements.add(this.convertToVariableDeclarationStatement((LocalDeclaration)stmts[index]));
        }
    }

    public Name convert(TypeReference typeReference) {
        char[][] typeName = typeReference.getTypeName();
        int length = typeName.length;
        Name name = null;
        if (length > 1) {
            QualifiedTypeReference qualifiedTypeReference = (QualifiedTypeReference)typeReference;
            long[] positions = qualifiedTypeReference.sourcePositions;
            name = this.setQualifiedNameNameAndSourceRanges(typeName, positions, typeReference);
        } else {
            name = this.ast.newSimpleName(new String(typeName[0]));
            name.setSourceRange(typeReference.sourceStart, typeReference.sourceEnd - typeReference.sourceStart + 1);
        }
        if (this.resolveBindings) {
            this.recordNodes(name, typeReference);
        }
        return name;
    }

    public SimpleName convert(SingleNameReference nameReference) {
        SimpleName name = this.ast.newSimpleName(new String(nameReference.token));
        if (this.resolveBindings) {
            this.recordNodes(name, nameReference);
        }
        name.setSourceRange(nameReference.sourceStart, nameReference.sourceEnd - nameReference.sourceStart + 1);
        return name;
    }

    public Name convert(QualifiedNameReference nameReference) {
        char[][] typeName = nameReference.tokens;
        long[] positions = this.scanAllIdentifiersPositions(nameReference.sourceStart, nameReference.sourceEnd, typeName.length);
        return this.setQualifiedNameNameAndSourceRanges(typeName, positions, nameReference);
    }

    private QualifiedName setQualifiedNameNameAndSourceRanges(char[][] typeName, long[] positions, AstNode node) {
        int start0;
        int length = typeName.length;
        SimpleName firstToken = this.ast.newSimpleName(new String(typeName[0]));
        firstToken.index = length - 1;
        int start = start0 = (int)(positions[0] >>> 32);
        int end = (int)(positions[0] & 0xFFFFFFFFFFFFFFFFL);
        firstToken.setSourceRange(start, end - start + 1);
        SimpleName secondToken = this.ast.newSimpleName(new String(typeName[1]));
        secondToken.index = length - 2;
        start = (int)(positions[1] >>> 32);
        end = (int)(positions[1] & 0xFFFFFFFFFFFFFFFFL);
        secondToken.setSourceRange(start, end - start + 1);
        QualifiedName qualifiedName = this.ast.newQualifiedName(firstToken, secondToken);
        if (this.resolveBindings) {
            this.recordNodes(qualifiedName, node);
            this.recordPendingNameScopeResolution(qualifiedName);
            this.recordNodes(firstToken, node);
            this.recordNodes(secondToken, node);
            this.recordPendingNameScopeResolution(firstToken);
            this.recordPendingNameScopeResolution(secondToken);
        }
        qualifiedName.index = length - 2;
        qualifiedName.setSourceRange(start0, end - start0 + 1);
        SimpleName newPart = null;
        int i = 2;
        while (i < length) {
            newPart = this.ast.newSimpleName(new String(typeName[i]));
            newPart.index = length - i - 1;
            start = (int)(positions[i] >>> 32);
            end = (int)(positions[i] & 0xFFFFFFFFFFFFFFFFL);
            newPart.setSourceRange(start, end - start + 1);
            qualifiedName = this.ast.newQualifiedName(qualifiedName, newPart);
            qualifiedName.index = newPart.index;
            qualifiedName.setSourceRange(start0, end - start0 + 1);
            if (this.resolveBindings) {
                this.recordNodes(qualifiedName, node);
                this.recordNodes(newPart, node);
                this.recordPendingNameScopeResolution(qualifiedName);
                this.recordPendingNameScopeResolution(newPart);
            }
            ++i;
        }
        QualifiedName name = qualifiedName;
        if (this.resolveBindings) {
            this.recordNodes(name, node);
            this.recordPendingNameScopeResolution(name);
        }
        return name;
    }

    public Expression convert(ThisReference reference) {
        if (reference.isImplicitThis()) {
            return null;
        }
        if (reference instanceof QualifiedSuperReference) {
            return this.convert((QualifiedSuperReference)reference);
        }
        if (reference instanceof QualifiedThisReference) {
            return this.convert((QualifiedThisReference)reference);
        }
        ThisExpression thisExpression = this.ast.newThisExpression();
        thisExpression.setSourceRange(reference.sourceStart, reference.sourceEnd - reference.sourceStart + 1);
        if (this.resolveBindings) {
            this.recordNodes(thisExpression, reference);
            this.recordPendingThisExpressionScopeResolution(thisExpression);
        }
        return thisExpression;
    }

    public ThisExpression convert(QualifiedThisReference reference) {
        ThisExpression thisExpression = this.ast.newThisExpression();
        thisExpression.setSourceRange(reference.sourceStart, reference.sourceEnd - reference.sourceStart + 1);
        thisExpression.setQualifier(this.convert(reference.qualification));
        if (this.resolveBindings) {
            this.recordNodes(thisExpression, reference);
            this.recordPendingThisExpressionScopeResolution(thisExpression);
        }
        return thisExpression;
    }

    public Name convert(QualifiedSuperReference reference) {
        return this.convert(reference.qualification);
    }

    public ArrayAccess convert(ArrayReference reference) {
        ArrayAccess arrayAccess = this.ast.newArrayAccess();
        if (this.resolveBindings) {
            this.recordNodes(arrayAccess, reference);
        }
        arrayAccess.setSourceRange(reference.sourceStart, reference.sourceEnd - reference.sourceStart + 1);
        arrayAccess.setArray(this.convert(reference.receiver));
        arrayAccess.setIndex(this.convert(reference.position));
        return arrayAccess;
    }

    public Expression convert(FieldReference reference) {
        if (reference.receiver.isSuper()) {
            SuperFieldAccess superFieldAccess = this.ast.newSuperFieldAccess();
            if (this.resolveBindings) {
                this.recordNodes(superFieldAccess, reference);
            }
            if (reference.receiver instanceof QualifiedSuperReference) {
                Name qualifier = this.convert((QualifiedSuperReference)reference.receiver);
                superFieldAccess.setQualifier(qualifier);
                if (this.resolveBindings) {
                    this.recordNodes(qualifier, reference.receiver);
                }
            }
            SimpleName simpleName = this.ast.newSimpleName(new String(reference.token));
            int sourceStart = (int)(reference.nameSourcePosition >>> 32);
            int length = (int)(reference.nameSourcePosition & 0xFFFFFFFFFFFFFFFFL) - sourceStart + 1;
            simpleName.setSourceRange(sourceStart, length);
            superFieldAccess.setName(simpleName);
            if (this.resolveBindings) {
                this.recordNodes(simpleName, reference);
            }
            superFieldAccess.setSourceRange(reference.receiver.sourceStart, reference.sourceEnd - reference.receiver.sourceStart + 1);
            return superFieldAccess;
        }
        FieldAccess fieldAccess = this.ast.newFieldAccess();
        if (this.resolveBindings) {
            this.recordNodes(fieldAccess, reference);
        }
        Expression receiver = this.convert(reference.receiver);
        fieldAccess.setExpression(receiver);
        SimpleName simpleName = this.ast.newSimpleName(new String(reference.token));
        int sourceStart = (int)(reference.nameSourcePosition >>> 32);
        int length = (int)(reference.nameSourcePosition & 0xFFFFFFFFFFFFFFFFL) - sourceStart + 1;
        simpleName.setSourceRange(sourceStart, length);
        fieldAccess.setName(simpleName);
        if (this.resolveBindings) {
            this.recordNodes(simpleName, reference);
        }
        fieldAccess.setSourceRange(receiver.getStartPosition(), reference.sourceEnd - receiver.getStartPosition() + 1);
        return fieldAccess;
    }

    public Expression convert(Reference reference) {
        if (reference instanceof NameReference) {
            return this.convert((NameReference)reference);
        }
        if (reference instanceof ThisReference) {
            return this.convert((ThisReference)reference);
        }
        if (reference instanceof ArrayReference) {
            return this.convert((ArrayReference)reference);
        }
        if (reference instanceof FieldReference) {
            return this.convert((FieldReference)reference);
        }
        throw new IllegalArgumentException("Not yet implemented: convert(" + reference.getClass() + ")");
    }

    public Name convert(NameReference reference) {
        if (reference instanceof QualifiedNameReference) {
            return this.convert((QualifiedNameReference)reference);
        }
        if (reference instanceof SingleNameReference) {
            return this.convert((SingleNameReference)reference);
        }
        throw new IllegalArgumentException("Not yet implemented: convert(" + reference.getClass() + ")");
    }

    public TypeDeclaration convert(MemberTypeDeclaration typeDeclaration) {
        TypeReference[] superInterfaces;
        TypeDeclaration typeDecl = this.ast.newTypeDeclaration();
        int modifiers = typeDeclaration.modifiers;
        modifiers &= 0xFFFFFDFF;
        modifiers &= 0xFFFF;
        try {
            typeDecl.setModifiers(modifiers);
        }
        catch (IllegalArgumentException e) {
            int legalModifiers = 3103;
            typeDecl.setModifiers(modifiers & legalModifiers);
            typeDecl.setFlags(1);
        }
        typeDecl.setInterface(typeDeclaration.isInterface());
        SimpleName typeName = this.ast.newSimpleName(new String(typeDeclaration.name));
        typeName.setSourceRange(typeDeclaration.sourceStart, typeDeclaration.sourceEnd - typeDeclaration.sourceStart + 1);
        typeDecl.setName(typeName);
        typeDecl.setSourceRange(typeDeclaration.declarationSourceStart, typeDeclaration.bodyEnd - typeDeclaration.declarationSourceStart + 1);
        if (typeDeclaration.superclass != null) {
            typeDecl.setSuperclass(this.convert(typeDeclaration.superclass));
        }
        if ((superInterfaces = typeDeclaration.superInterfaces) != null) {
            int index = 0;
            int length = superInterfaces.length;
            while (index < length) {
                typeDecl.superInterfaces().add(this.convert(superInterfaces[index]));
                ++index;
            }
        }
        this.buildBodyDeclarations(typeDeclaration, typeDecl);
        this.setJavaDocComment(typeDecl);
        if (this.resolveBindings) {
            this.recordNodes(typeDecl, typeDeclaration);
            this.recordNodes(typeName, typeDeclaration);
            typeDecl.resolveBinding();
        }
        return typeDecl;
    }

    private void completeRecord(ArrayType arrayType, AstNode astNode) {
        ArrayType array = arrayType;
        int dimensions = array.getDimensions();
        int i = 0;
        while (i < dimensions) {
            Type componentType = array.getComponentType();
            this.recordNodes(componentType, astNode);
            if (componentType.isArrayType()) {
                array = (ArrayType)componentType;
            }
            ++i;
        }
    }

    public Type convertType(TypeReference typeReference) {
        Type type = null;
        int sourceStart = -1;
        int length = 0;
        int dimensions = typeReference.dimensions();
        if (typeReference instanceof SingleTypeReference) {
            char[] name = ((SingleTypeReference)typeReference).getTypeName()[0];
            sourceStart = typeReference.sourceStart;
            length = typeReference.sourceEnd - typeReference.sourceStart + 1;
            if (dimensions != 0) {
                if (this.isPrimitiveType(name)) {
                    int end = this.retrieveEndOfElementTypeNamePosition(sourceStart, sourceStart + length);
                    if (end == -1) {
                        end = sourceStart + length - 1;
                    }
                    PrimitiveType primitiveType = this.ast.newPrimitiveType(this.getPrimitiveTypeCode(name));
                    primitiveType.setSourceRange(sourceStart, end - sourceStart + 1);
                    type = this.ast.newArrayType(primitiveType, dimensions);
                    if (this.resolveBindings) {
                        this.completeRecord((ArrayType)type, typeReference);
                    }
                    type.setSourceRange(sourceStart, length);
                } else {
                    SimpleName simpleName = this.ast.newSimpleName(new String(name));
                    int end = this.retrieveEndOfElementTypeNamePosition(sourceStart, sourceStart + length);
                    if (end == -1) {
                        end = sourceStart + length - 1;
                    }
                    simpleName.setSourceRange(sourceStart, end - sourceStart + 1);
                    SimpleType simpleType = this.ast.newSimpleType(simpleName);
                    simpleType.setSourceRange(sourceStart, end - sourceStart + 1);
                    type = this.ast.newArrayType(simpleType, dimensions);
                    type.setSourceRange(sourceStart, length);
                    if (this.resolveBindings) {
                        this.completeRecord((ArrayType)type, typeReference);
                        this.recordNodes(simpleName, typeReference);
                    }
                }
            } else if (this.isPrimitiveType(name)) {
                type = this.ast.newPrimitiveType(this.getPrimitiveTypeCode(name));
                type.setSourceRange(sourceStart, length);
            } else {
                SimpleName simpleName = this.ast.newSimpleName(new String(name));
                simpleName.setSourceRange(sourceStart, length);
                type = this.ast.newSimpleType(simpleName);
                type.setSourceRange(sourceStart, length);
                if (this.resolveBindings) {
                    this.recordNodes(simpleName, typeReference);
                }
            }
        } else {
            char[][] name = ((QualifiedTypeReference)typeReference).getTypeName();
            int nameLength = name.length;
            long[] positions = ((QualifiedTypeReference)typeReference).sourcePositions;
            sourceStart = (int)(positions[0] >>> 32);
            length = (int)(positions[nameLength - 1] & 0xFFFFFFFFFFFFFFFFL) - sourceStart + 1;
            QualifiedName qualifiedName = this.setQualifiedNameNameAndSourceRanges(name, positions, typeReference);
            if (dimensions != 0) {
                int end;
                SimpleType simpleType = this.ast.newSimpleType(qualifiedName);
                simpleType.setSourceRange(sourceStart, length);
                type = this.ast.newArrayType(simpleType, dimensions);
                if (this.resolveBindings) {
                    this.completeRecord((ArrayType)type, typeReference);
                }
                if ((end = this.retrieveEndOfDimensionsPosition(sourceStart + length, this.compilationUnitSource.length)) != -1) {
                    type.setSourceRange(sourceStart, end - sourceStart + 1);
                } else {
                    type.setSourceRange(sourceStart, length);
                }
            } else {
                type = this.ast.newSimpleType(qualifiedName);
                type.setSourceRange(sourceStart, length);
            }
        }
        if (this.resolveBindings) {
            this.recordNodes(type, typeReference);
        }
        return type;
    }

    public MethodDeclaration convert(AbstractMethodDeclaration methodDeclaration) {
        Argument[] parameters;
        MethodDeclaration methodDecl = this.ast.newMethodDeclaration();
        try {
            methodDecl.setModifiers(methodDeclaration.modifiers & 0xFFFF);
        }
        catch (IllegalArgumentException e) {
            int legalModifiers = 3391;
            methodDecl.setModifiers(methodDeclaration.modifiers & legalModifiers);
            methodDecl.setFlags(1);
        }
        boolean isConstructor = methodDeclaration.isConstructor();
        methodDecl.setConstructor(isConstructor);
        SimpleName methodName = this.ast.newSimpleName(new String(methodDeclaration.selector));
        int start = methodDeclaration.sourceStart;
        int end = this.retrieveIdentifierEndPosition(start, methodDeclaration.sourceEnd);
        methodName.setSourceRange(start, end - start + 1);
        methodDecl.setName(methodName);
        TypeReference[] thrownExceptions = methodDeclaration.thrownExceptions;
        if (thrownExceptions != null) {
            int thrownExceptionsLength = thrownExceptions.length;
            int i = 0;
            while (i < thrownExceptionsLength) {
                methodDecl.thrownExceptions().add(this.convert(thrownExceptions[i]));
                ++i;
            }
        }
        if ((parameters = methodDeclaration.arguments) != null) {
            int parametersLength = parameters.length;
            int i = 0;
            while (i < parametersLength) {
                methodDecl.parameters().add(this.convert(parameters[i]));
                ++i;
            }
        }
        ExplicitConstructorCall explicitConstructorCall = null;
        if (isConstructor) {
            PrimitiveType returnType = this.ast.newPrimitiveType(PrimitiveType.VOID);
            returnType.setSourceRange(methodDeclaration.sourceStart, 0);
            methodDecl.setReturnType(returnType);
            ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)methodDeclaration;
            explicitConstructorCall = constructorDeclaration.constructorCall;
        } else {
            org.eclipse.jdt.internal.compiler.ast.MethodDeclaration method = (org.eclipse.jdt.internal.compiler.ast.MethodDeclaration)methodDeclaration;
            TypeReference typeReference = method.returnType;
            if (typeReference != null) {
                Type returnType = this.convertType(typeReference);
                int rightParenthesisPosition = this.retrieveEndOfRightParenthesisPosition(end, method.bodyEnd);
                int extraDimensions = this.retrieveExtraDimension(rightParenthesisPosition, method.bodyEnd);
                methodDecl.setExtraDimensions(extraDimensions);
                this.setTypeForMethodDeclaration(methodDecl, returnType, extraDimensions);
            }
        }
        int declarationSourceStart = methodDeclaration.declarationSourceStart;
        int declarationSourceEnd = methodDeclaration.bodyEnd;
        methodDecl.setSourceRange(declarationSourceStart, declarationSourceEnd - declarationSourceStart + 1);
        this.retrieveRightBraceOrSemiColonPosition(methodDecl);
        org.eclipse.jdt.internal.compiler.ast.Statement[] statements = methodDeclaration.statements;
        if (statements != null || explicitConstructorCall != null) {
            Block block = this.ast.newBlock();
            start = this.retrieveStartBlockPosition(methodDeclaration.sourceStart, declarationSourceEnd);
            end = this.retrieveEndBlockPosition(methodDeclaration.sourceStart, this.compilationUnitSource.length);
            block.setSourceRange(start, end - start + 1);
            if (explicitConstructorCall != null && explicitConstructorCall.accessMode != 1) {
                block.statements().add(this.convert(explicitConstructorCall));
            }
            int statementsLength = statements == null ? 0 : statements.length;
            int i = 0;
            while (i < statementsLength) {
                if (statements[i] instanceof LocalDeclaration) {
                    this.checkAndAddMultipleLocalDeclaration(statements, i, block.statements());
                } else {
                    block.statements().add(this.convert(statements[i]));
                }
                ++i;
            }
            methodDecl.setBody(block);
        } else if (!methodDeclaration.isNative() && !methodDeclaration.isAbstract()) {
            start = this.retrieveStartBlockPosition(methodDeclaration.sourceStart, declarationSourceEnd);
            end = this.retrieveEndBlockPosition(methodDeclaration.sourceStart, this.compilationUnitSource.length);
            if (start != -1 && end != -1) {
                Block block = this.ast.newBlock();
                block.setSourceRange(start, end - start + 1);
                methodDecl.setBody(block);
            }
        }
        this.setJavaDocComment(methodDecl);
        if (this.resolveBindings) {
            this.recordNodes(methodDecl, methodDeclaration);
            this.recordNodes(methodName, methodDeclaration);
            methodDecl.resolveBinding();
        }
        return methodDecl;
    }

    public Expression convert(org.eclipse.jdt.internal.compiler.ast.Expression expression) {
        if ((expression.bits & 0x1FE00000) != 0) {
            return this.convertToParenthesizedExpression(expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.CastExpression) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.CastExpression)expression);
        }
        if (expression instanceof ArrayAllocationExpression) {
            return this.convert((ArrayAllocationExpression)expression);
        }
        if (expression instanceof QualifiedAllocationExpression) {
            return this.convert((QualifiedAllocationExpression)expression);
        }
        if (expression instanceof AllocationExpression) {
            return this.convert((AllocationExpression)expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.ArrayInitializer) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.ArrayInitializer)expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.PrefixExpression) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.PrefixExpression)expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.PostfixExpression) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.PostfixExpression)expression);
        }
        if (expression instanceof CompoundAssignment) {
            return this.convert((CompoundAssignment)expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.Assignment) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.Assignment)expression);
        }
        if (expression instanceof ClassLiteralAccess) {
            return this.convert((ClassLiteralAccess)expression);
        }
        if (expression instanceof FalseLiteral) {
            return this.convert((FalseLiteral)expression);
        }
        if (expression instanceof TrueLiteral) {
            return this.convert((TrueLiteral)expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.NullLiteral) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.NullLiteral)expression);
        }
        if (expression instanceof CharLiteral) {
            return this.convert((CharLiteral)expression);
        }
        if (expression instanceof DoubleLiteral) {
            return this.convert((DoubleLiteral)expression);
        }
        if (expression instanceof FloatLiteral) {
            return this.convert((FloatLiteral)expression);
        }
        if (expression instanceof IntLiteralMinValue) {
            return this.convert((IntLiteralMinValue)expression);
        }
        if (expression instanceof IntLiteral) {
            return this.convert((IntLiteral)expression);
        }
        if (expression instanceof LongLiteralMinValue) {
            return this.convert((LongLiteralMinValue)expression);
        }
        if (expression instanceof LongLiteral) {
            return this.convert((LongLiteral)expression);
        }
        if (expression instanceof ExtendedStringLiteral) {
            return this.convert((ExtendedStringLiteral)expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.StringLiteral) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.StringLiteral)expression);
        }
        if (expression instanceof AND_AND_Expression) {
            return this.convert((AND_AND_Expression)expression);
        }
        if (expression instanceof OR_OR_Expression) {
            return this.convert((OR_OR_Expression)expression);
        }
        if (expression instanceof EqualExpression) {
            return this.convert((EqualExpression)expression);
        }
        if (expression instanceof BinaryExpression) {
            return this.convert((BinaryExpression)expression);
        }
        if (expression instanceof InstanceOfExpression) {
            return this.convert((InstanceOfExpression)expression);
        }
        if (expression instanceof UnaryExpression) {
            return this.convert((UnaryExpression)expression);
        }
        if (expression instanceof org.eclipse.jdt.internal.compiler.ast.ConditionalExpression) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.ConditionalExpression)expression);
        }
        if (expression instanceof MessageSend) {
            return this.convert((MessageSend)expression);
        }
        if (expression instanceof Reference) {
            return this.convert((Reference)expression);
        }
        if (expression instanceof TypeReference) {
            return this.convert((TypeReference)expression);
        }
        throw new IllegalArgumentException("Not yet implemented: convert(" + expression.getClass() + ")");
    }

    public ParenthesizedExpression convertToParenthesizedExpression(org.eclipse.jdt.internal.compiler.ast.Expression expression) {
        ParenthesizedExpression parenthesizedExpression = this.ast.newParenthesizedExpression();
        if (this.resolveBindings) {
            this.recordNodes(parenthesizedExpression, expression);
        }
        parenthesizedExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        this.adjustSourcePositionsForParent(expression);
        this.removeExtraBlanks(expression);
        int numberOfParenthesis = (expression.bits & 0x1FE00000) >> 21;
        expression.bits &= 0xE01FFFFF;
        expression.bits |= numberOfParenthesis - 1 << 21;
        parenthesizedExpression.setExpression(this.convert(expression));
        return parenthesizedExpression;
    }

    public ClassInstanceCreation convert(AllocationExpression expression) {
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        if (this.resolveBindings) {
            this.recordNodes(classInstanceCreation, expression);
        }
        classInstanceCreation.setName(this.convert(expression.type));
        classInstanceCreation.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.eclipse.jdt.internal.compiler.ast.Expression[] arguments = expression.arguments;
        if (arguments != null) {
            int length = arguments.length;
            int i = 0;
            while (i < length) {
                classInstanceCreation.arguments().add(this.convert(arguments[i]));
                ++i;
            }
        }
        this.removeTrailingCommentFromExpressionEndingWithAParen(classInstanceCreation);
        return classInstanceCreation;
    }

    public ClassInstanceCreation convert(AnonymousLocalTypeDeclaration expression) {
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        classInstanceCreation.setName(this.convert(expression.allocation.type));
        if (expression.allocation.enclosingInstance != null) {
            classInstanceCreation.setExpression(this.convert(expression.allocation.enclosingInstance));
        }
        int declarationSourceStart = expression.allocation.sourceStart;
        classInstanceCreation.setSourceRange(declarationSourceStart, expression.bodyEnd - declarationSourceStart + 1);
        org.eclipse.jdt.internal.compiler.ast.Expression[] arguments = expression.allocation.arguments;
        if (arguments != null) {
            int length = arguments.length;
            int i = 0;
            while (i < length) {
                classInstanceCreation.arguments().add(this.convert(arguments[i]));
                ++i;
            }
        }
        AnonymousClassDeclaration anonymousClassDeclaration = this.ast.newAnonymousClassDeclaration();
        int start = this.retrieveStartBlockPosition(declarationSourceStart, expression.bodyEnd);
        anonymousClassDeclaration.setSourceRange(start, expression.bodyEnd - start + 1);
        classInstanceCreation.setAnonymousClassDeclaration(anonymousClassDeclaration);
        this.buildBodyDeclarations(expression, anonymousClassDeclaration);
        if (this.resolveBindings) {
            this.recordNodes(classInstanceCreation, expression);
            this.recordNodes(anonymousClassDeclaration, expression);
            classInstanceCreation.resolveTypeBinding();
        }
        return classInstanceCreation;
    }

    private void buildBodyDeclarations(AnonymousLocalTypeDeclaration expression, AnonymousClassDeclaration anonymousClassDeclaration) {
        MemberTypeDeclaration[] members = expression.memberTypes;
        org.eclipse.jdt.internal.compiler.ast.FieldDeclaration[] fields = expression.fields;
        AbstractMethodDeclaration[] methods = expression.methods;
        int fieldsLength = fields == null ? 0 : fields.length;
        int methodsLength = methods == null ? 0 : methods.length;
        int membersLength = members == null ? 0 : members.length;
        int fieldsIndex = 0;
        int methodsIndex = 0;
        int membersIndex = 0;
        block5: while (fieldsIndex < fieldsLength || membersIndex < membersLength || methodsIndex < methodsLength) {
            org.eclipse.jdt.internal.compiler.ast.FieldDeclaration nextFieldDeclaration = null;
            AbstractMethodDeclaration nextMethodDeclaration = null;
            MemberTypeDeclaration nextMemberDeclaration = null;
            int position = Integer.MAX_VALUE;
            int nextDeclarationType = -1;
            if (fieldsIndex < fieldsLength) {
                nextFieldDeclaration = fields[fieldsIndex];
                if (nextFieldDeclaration.declarationSourceStart < position) {
                    position = nextFieldDeclaration.declarationSourceStart;
                    nextDeclarationType = 0;
                }
            }
            if (methodsIndex < methodsLength) {
                nextMethodDeclaration = methods[methodsIndex];
                if (nextMethodDeclaration.declarationSourceStart < position) {
                    position = nextMethodDeclaration.declarationSourceStart;
                    nextDeclarationType = 1;
                }
            }
            if (membersIndex < membersLength) {
                nextMemberDeclaration = members[membersIndex];
                if (nextMemberDeclaration.declarationSourceStart < position) {
                    position = nextMemberDeclaration.declarationSourceStart;
                    nextDeclarationType = 2;
                }
            }
            switch (nextDeclarationType) {
                case 0: {
                    this.checkAndAddMultipleFieldDeclaration(fields, fieldsIndex, anonymousClassDeclaration.bodyDeclarations());
                    ++fieldsIndex;
                    break;
                }
                case 1: {
                    ++methodsIndex;
                    if (nextMethodDeclaration.isDefaultConstructor() || nextMethodDeclaration.isClinit()) continue block5;
                    anonymousClassDeclaration.bodyDeclarations().add(this.convert(nextMethodDeclaration));
                    break;
                }
                case 2: {
                    ++membersIndex;
                    anonymousClassDeclaration.bodyDeclarations().add(this.convert(nextMemberDeclaration));
                }
            }
        }
    }

    public ArrayCreation convert(ArrayAllocationExpression expression) {
        ArrayCreation arrayCreation = this.ast.newArrayCreation();
        if (this.resolveBindings) {
            this.recordNodes(arrayCreation, expression);
        }
        arrayCreation.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.eclipse.jdt.internal.compiler.ast.Expression[] dimensions = expression.dimensions;
        int dimensionsLength = dimensions.length;
        int i = 0;
        while (i < dimensionsLength) {
            if (dimensions[i] != null) {
                Expression dimension = this.convert(dimensions[i]);
                if (this.resolveBindings) {
                    this.recordNodes(dimension, dimensions[i]);
                }
                arrayCreation.dimensions().add(dimension);
            }
            ++i;
        }
        Type type = this.convertType(expression.type);
        if (this.resolveBindings) {
            this.recordNodes(type, expression.type);
        }
        ArrayType arrayType = null;
        if (type.isArrayType()) {
            arrayType = (ArrayType)type;
        } else {
            int end;
            arrayType = this.ast.newArrayType(type, dimensionsLength);
            if (this.resolveBindings) {
                this.completeRecord(arrayType, expression);
            }
            int start = type.getStartPosition();
            int previousSearchStart = end = type.getStartPosition() + type.getLength();
            ArrayType componentType = (ArrayType)type.getParent();
            int i2 = 0;
            while (i2 < dimensionsLength) {
                previousSearchStart = this.retrieveRightBracketPosition(previousSearchStart + 1, this.compilationUnitSource.length);
                componentType.setSourceRange(start, previousSearchStart - start + 1);
                componentType = (ArrayType)componentType.getParent();
                ++i2;
            }
        }
        arrayCreation.setType(arrayType);
        if (this.resolveBindings) {
            this.recordNodes(arrayType, expression);
        }
        if (expression.initializer != null) {
            arrayCreation.setInitializer(this.convert(expression.initializer));
        }
        return arrayCreation;
    }

    public SingleVariableDeclaration convert(Argument argument) {
        SingleVariableDeclaration variableDecl = this.ast.newSingleVariableDeclaration();
        try {
            variableDecl.setModifiers(argument.modifiers);
        }
        catch (IllegalArgumentException e) {
            int legalModifiers = 223;
            variableDecl.setModifiers(argument.modifiers & legalModifiers);
            variableDecl.setFlags(1);
        }
        variableDecl.setModifiers(argument.modifiers);
        SimpleName name = this.ast.newSimpleName(argument.name());
        int start = argument.sourceStart;
        int nameEnd = argument.sourceEnd;
        name.setSourceRange(start, nameEnd - start + 1);
        variableDecl.setName(name);
        int extraDimensions = this.retrieveExtraDimension(nameEnd + 1, argument.type.sourceEnd);
        variableDecl.setExtraDimensions(extraDimensions);
        Type type = this.convertType(argument.type);
        int typeEnd = type.getStartPosition() + type.getLength() - 1;
        int rightEnd = Math.max(typeEnd, argument.declarationSourceEnd);
        this.setTypeForSingleVariableDeclaration(variableDecl, type, extraDimensions);
        variableDecl.setSourceRange(argument.declarationSourceStart, rightEnd - argument.declarationSourceStart + 1);
        if (this.resolveBindings) {
            this.recordNodes(name, argument);
            this.recordNodes(variableDecl, argument);
            variableDecl.resolveBinding();
        }
        return variableDecl;
    }

    public ArrayInitializer convert(org.eclipse.jdt.internal.compiler.ast.ArrayInitializer expression) {
        ArrayInitializer arrayInitializer = this.ast.newArrayInitializer();
        if (this.resolveBindings) {
            this.recordNodes(arrayInitializer, expression);
        }
        arrayInitializer.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.eclipse.jdt.internal.compiler.ast.Expression[] expressions = expression.expressions;
        if (expressions != null) {
            int length = expressions.length;
            int i = 0;
            while (i < length) {
                Expression expr = this.convert(expressions[i]);
                if (this.resolveBindings) {
                    this.recordNodes(expr, expressions[i]);
                }
                arrayInitializer.expressions().add(expr);
                ++i;
            }
        }
        return arrayInitializer;
    }

    public Expression convert(QualifiedAllocationExpression expression) {
        if (expression.anonymousType != null) {
            return this.convert(expression.anonymousType);
        }
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        classInstanceCreation.setExpression(this.convert(expression.enclosingInstance));
        classInstanceCreation.setName(this.convert(expression.type));
        classInstanceCreation.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.eclipse.jdt.internal.compiler.ast.Expression[] arguments = expression.arguments;
        if (arguments != null) {
            int length = arguments.length;
            int i = 0;
            while (i < length) {
                Expression argument = this.convert(arguments[i]);
                if (this.resolveBindings) {
                    this.recordNodes(argument, arguments[i]);
                }
                classInstanceCreation.arguments().add(argument);
                ++i;
            }
        }
        if (this.resolveBindings) {
            this.recordNodes(classInstanceCreation, expression);
        }
        this.removeTrailingCommentFromExpressionEndingWithAParen(classInstanceCreation);
        return classInstanceCreation;
    }

    public Assignment convert(org.eclipse.jdt.internal.compiler.ast.Assignment expression) {
        Assignment assignment = this.ast.newAssignment();
        if (this.resolveBindings) {
            this.recordNodes(assignment, expression);
        }
        Expression lhs = this.convert(expression.lhs);
        assignment.setLeftHandSide(lhs);
        assignment.setOperator(Assignment.Operator.ASSIGN);
        assignment.setRightHandSide(this.convert(expression.expression));
        int start = lhs.getStartPosition();
        assignment.setSourceRange(start, expression.sourceEnd - start + 1);
        return assignment;
    }

    public Assignment convert(CompoundAssignment expression) {
        Assignment assignment = this.ast.newAssignment();
        Expression lhs = this.convert(expression.lhs);
        assignment.setLeftHandSide(lhs);
        int start = lhs.getStartPosition();
        assignment.setSourceRange(start, expression.sourceEnd - start + 1);
        switch (expression.operator) {
            case 14: {
                assignment.setOperator(Assignment.Operator.PLUS_ASSIGN);
                break;
            }
            case 13: {
                assignment.setOperator(Assignment.Operator.MINUS_ASSIGN);
                break;
            }
            case 15: {
                assignment.setOperator(Assignment.Operator.TIMES_ASSIGN);
                break;
            }
            case 9: {
                assignment.setOperator(Assignment.Operator.DIVIDE_ASSIGN);
                break;
            }
            case 2: {
                assignment.setOperator(Assignment.Operator.BIT_AND_ASSIGN);
                break;
            }
            case 3: {
                assignment.setOperator(Assignment.Operator.BIT_OR_ASSIGN);
                break;
            }
            case 8: {
                assignment.setOperator(Assignment.Operator.BIT_XOR_ASSIGN);
                break;
            }
            case 16: {
                assignment.setOperator(Assignment.Operator.REMAINDER_ASSIGN);
                break;
            }
            case 10: {
                assignment.setOperator(Assignment.Operator.LEFT_SHIFT_ASSIGN);
                break;
            }
            case 17: {
                assignment.setOperator(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN);
                break;
            }
            case 19: {
                assignment.setOperator(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN);
            }
        }
        assignment.setRightHandSide(this.convert(expression.expression));
        return assignment;
    }

    public PrefixExpression convert(org.eclipse.jdt.internal.compiler.ast.PrefixExpression expression) {
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        if (this.resolveBindings) {
            this.recordNodes(prefixExpression, expression);
        }
        prefixExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        prefixExpression.setOperand(this.convert(expression.lhs));
        switch (expression.operator) {
            case 14: {
                prefixExpression.setOperator(PrefixExpression.Operator.INCREMENT);
                break;
            }
            case 13: {
                prefixExpression.setOperator(PrefixExpression.Operator.DECREMENT);
            }
        }
        return prefixExpression;
    }

    public PostfixExpression convert(org.eclipse.jdt.internal.compiler.ast.PostfixExpression expression) {
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        if (this.resolveBindings) {
            this.recordNodes(postfixExpression, expression);
        }
        postfixExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        postfixExpression.setOperand(this.convert(expression.lhs));
        switch (expression.operator) {
            case 14: {
                postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
                break;
            }
            case 13: {
                postfixExpression.setOperator(PostfixExpression.Operator.DECREMENT);
            }
        }
        return postfixExpression;
    }

    public CastExpression convert(org.eclipse.jdt.internal.compiler.ast.CastExpression expression) {
        CastExpression castExpression = this.ast.newCastExpression();
        castExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.eclipse.jdt.internal.compiler.ast.Expression type = expression.type;
        this.removeExtraBlanks(type);
        if (type instanceof TypeReference) {
            castExpression.setType(this.convertType((TypeReference)type));
        } else if (type instanceof NameReference) {
            castExpression.setType(this.convertToType((NameReference)type));
        }
        castExpression.setExpression(this.convert(expression.expression));
        if (this.resolveBindings) {
            this.recordNodes(castExpression, expression);
        }
        return castExpression;
    }

    public Type convertToType(NameReference reference) {
        Name name = this.convert(reference);
        SimpleType type = this.ast.newSimpleType(name);
        type.setSourceRange(name.getStartPosition(), name.getLength());
        if (this.resolveBindings) {
            this.recordNodes(type, reference);
        }
        return type;
    }

    public Expression convert(ClassLiteralAccess expression) {
        TypeLiteral typeLiteral = this.ast.newTypeLiteral();
        if (this.resolveBindings) {
            this.recordNodes(typeLiteral, expression);
        }
        typeLiteral.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        typeLiteral.setType(this.convertType(expression.type));
        return typeLiteral;
    }

    public BooleanLiteral convert(FalseLiteral expression) {
        BooleanLiteral literal = this.ast.newBooleanLiteral(false);
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public BooleanLiteral convert(TrueLiteral expression) {
        BooleanLiteral literal = this.ast.newBooleanLiteral(true);
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public NullLiteral convert(org.eclipse.jdt.internal.compiler.ast.NullLiteral expression) {
        NullLiteral literal = this.ast.newNullLiteral();
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public CharacterLiteral convert(CharLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        CharacterLiteral literal = this.ast.newCharacterLiteral();
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setEscapedValue(new String(tokens));
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public NumberLiteral convert(DoubleLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public NumberLiteral convert(FloatLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public NumberLiteral convert(IntLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public NumberLiteral convert(IntLiteralMinValue expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public NumberLiteral convert(LongLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public NumberLiteral convert(LongLiteralMinValue expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public StringLiteral convert(org.eclipse.jdt.internal.compiler.ast.StringLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        StringLiteral literal = this.ast.newStringLiteral();
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setEscapedValue(new String(tokens));
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public StringLiteral convert(ExtendedStringLiteral expression) {
        expression.computeConstant();
        StringLiteral literal = this.ast.newStringLiteral();
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setLiteralValue(expression.constant.stringValue());
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public Expression convert(BinaryExpression expression) {
        InfixExpression infixExpression = this.ast.newInfixExpression();
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        int expressionOperatorID = (expression.bits & 0xFC0) >> 6;
        switch (expressionOperatorID) {
            case 18: {
                infixExpression.setOperator(InfixExpression.Operator.EQUALS);
                break;
            }
            case 5: {
                infixExpression.setOperator(InfixExpression.Operator.LESS_EQUALS);
                break;
            }
            case 7: {
                infixExpression.setOperator(InfixExpression.Operator.GREATER_EQUALS);
                break;
            }
            case 29: {
                infixExpression.setOperator(InfixExpression.Operator.NOT_EQUALS);
                break;
            }
            case 10: {
                infixExpression.setOperator(InfixExpression.Operator.LEFT_SHIFT);
                break;
            }
            case 17: {
                infixExpression.setOperator(InfixExpression.Operator.RIGHT_SHIFT_SIGNED);
                break;
            }
            case 19: {
                infixExpression.setOperator(InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED);
                break;
            }
            case 1: {
                infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_OR);
                break;
            }
            case 0: {
                infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_AND);
                break;
            }
            case 14: {
                infixExpression.setOperator(InfixExpression.Operator.PLUS);
                break;
            }
            case 13: {
                infixExpression.setOperator(InfixExpression.Operator.MINUS);
                break;
            }
            case 16: {
                infixExpression.setOperator(InfixExpression.Operator.REMAINDER);
                break;
            }
            case 8: {
                infixExpression.setOperator(InfixExpression.Operator.XOR);
                break;
            }
            case 2: {
                infixExpression.setOperator(InfixExpression.Operator.AND);
                break;
            }
            case 15: {
                infixExpression.setOperator(InfixExpression.Operator.TIMES);
                break;
            }
            case 3: {
                infixExpression.setOperator(InfixExpression.Operator.OR);
                break;
            }
            case 9: {
                infixExpression.setOperator(InfixExpression.Operator.DIVIDE);
                break;
            }
            case 6: {
                infixExpression.setOperator(InfixExpression.Operator.GREATER);
                break;
            }
            case 4: {
                infixExpression.setOperator(InfixExpression.Operator.LESS);
            }
        }
        if (expression.left instanceof BinaryExpression && (expression.left.bits & 0x1FE00000) == 0) {
            infixExpression.extendedOperands().add(this.convert(expression.right));
            org.eclipse.jdt.internal.compiler.ast.Expression leftOperand = expression.left;
            org.eclipse.jdt.internal.compiler.ast.Expression rightOperand = null;
            do {
                rightOperand = ((BinaryExpression)leftOperand).right;
                if ((leftOperand.bits & 0xFC0) >> 6 != expressionOperatorID && (leftOperand.bits & 0x1FE00000) == 0 || rightOperand instanceof BinaryExpression && (rightOperand.bits & 0xFC0) >> 6 != expressionOperatorID && (rightOperand.bits & 0x1FE00000) == 0) {
                    List extendedOperands = infixExpression.extendedOperands();
                    InfixExpression temp = this.ast.newInfixExpression();
                    if (this.resolveBindings) {
                        this.recordNodes(temp, expression);
                    }
                    temp.setOperator(this.getOperatorFor(expressionOperatorID));
                    Expression leftSide = this.convert(leftOperand);
                    temp.setLeftOperand(leftSide);
                    temp.setSourceRange(leftSide.getStartPosition(), leftSide.getLength());
                    int size = extendedOperands.size();
                    int i = 0;
                    while (i < size - 1) {
                        InfixExpression expr = temp;
                        temp = this.ast.newInfixExpression();
                        if (this.resolveBindings) {
                            this.recordNodes(temp, expression);
                        }
                        temp.setLeftOperand(expr);
                        temp.setOperator(this.getOperatorFor(expressionOperatorID));
                        temp.setSourceRange(expr.getStartPosition(), expr.getLength());
                        ++i;
                    }
                    infixExpression = temp;
                    i = 0;
                    while (i < size) {
                        Expression extendedOperand = (Expression)extendedOperands.remove(size - 1 - i);
                        temp.setRightOperand(extendedOperand);
                        int startPosition = temp.getLeftOperand().getStartPosition();
                        temp.setSourceRange(startPosition, extendedOperand.getStartPosition() + extendedOperand.getLength() - startPosition);
                        if (temp.getLeftOperand().getNodeType() == 27) {
                            temp = (InfixExpression)temp.getLeftOperand();
                        }
                        ++i;
                    }
                    int startPosition = infixExpression.getLeftOperand().getStartPosition();
                    infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
                    if (this.resolveBindings) {
                        this.recordNodes(infixExpression, expression);
                    }
                    return infixExpression;
                }
                infixExpression.extendedOperands().add(0, this.convert(rightOperand));
            } while ((leftOperand = ((BinaryExpression)leftOperand).left) instanceof BinaryExpression && (leftOperand.bits & 0x1FE00000) == 0);
            Expression leftExpression = this.convert(leftOperand);
            infixExpression.setLeftOperand(leftExpression);
            infixExpression.setRightOperand((Expression)infixExpression.extendedOperands().remove(0));
            int startPosition = leftExpression.getStartPosition();
            infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
            return infixExpression;
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        int startPosition = leftExpression.getStartPosition();
        infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        return infixExpression;
    }

    public PrefixExpression convert(UnaryExpression expression) {
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        if (this.resolveBindings) {
            this.recordNodes(prefixExpression, expression);
        }
        prefixExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        prefixExpression.setOperand(this.convert(expression.expression));
        switch ((expression.bits & 0xFC0) >> 6) {
            case 14: {
                prefixExpression.setOperator(PrefixExpression.Operator.PLUS);
                break;
            }
            case 13: {
                prefixExpression.setOperator(PrefixExpression.Operator.MINUS);
                break;
            }
            case 11: {
                prefixExpression.setOperator(PrefixExpression.Operator.NOT);
                break;
            }
            case 12: {
                prefixExpression.setOperator(PrefixExpression.Operator.COMPLEMENT);
            }
        }
        return prefixExpression;
    }

    public InstanceofExpression convert(InstanceOfExpression expression) {
        InstanceofExpression instanceOfExpression = this.ast.newInstanceofExpression();
        if (this.resolveBindings) {
            this.recordNodes(instanceOfExpression, expression);
        }
        Expression leftExpression = this.convert(expression.expression);
        instanceOfExpression.setLeftOperand(leftExpression);
        instanceOfExpression.setRightOperand(this.convertType(expression.type));
        int startPosition = leftExpression.getStartPosition();
        instanceOfExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        return instanceOfExpression;
    }

    public ConditionalExpression convert(org.eclipse.jdt.internal.compiler.ast.ConditionalExpression expression) {
        ConditionalExpression conditionalExpression = this.ast.newConditionalExpression();
        if (this.resolveBindings) {
            this.recordNodes(conditionalExpression, expression);
        }
        conditionalExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        conditionalExpression.setExpression(this.convert(expression.condition));
        conditionalExpression.setThenExpression(this.convert(expression.valueIfTrue));
        conditionalExpression.setElseExpression(this.convert(expression.valueIfFalse));
        return conditionalExpression;
    }

    public Expression convert(MessageSend expression) {
        Expression expr;
        int sourceStart = expression.sourceStart;
        if (expression.isSuperAccess()) {
            org.eclipse.jdt.internal.compiler.ast.Expression[] arguments;
            SuperMethodInvocation superMethodInvocation = this.ast.newSuperMethodInvocation();
            if (this.resolveBindings) {
                this.recordNodes(superMethodInvocation, expression);
            }
            SimpleName name = this.ast.newSimpleName(new String(expression.selector));
            int nameSourceStart = (int)(expression.nameSourcePosition >>> 32);
            int nameSourceLength = (int)(expression.nameSourcePosition & 0xFFFFFFFFFFFFFFFFL) - nameSourceStart + 1;
            name.setSourceRange(nameSourceStart, nameSourceLength);
            if (this.resolveBindings) {
                this.recordNodes(name, expression);
            }
            superMethodInvocation.setName(name);
            if (expression.receiver instanceof QualifiedSuperReference) {
                Name qualifier = this.convert((QualifiedSuperReference)expression.receiver);
                superMethodInvocation.setQualifier(qualifier);
                if (this.resolveBindings) {
                    this.recordNodes(qualifier, expression.receiver);
                }
                if (qualifier != null) {
                    sourceStart = qualifier.getStartPosition();
                }
            }
            if ((arguments = expression.arguments) != null) {
                int argumentsLength = arguments.length;
                int i = 0;
                while (i < argumentsLength) {
                    Expression expri = this.convert(arguments[i]);
                    if (this.resolveBindings) {
                        this.recordNodes(expri, arguments[i]);
                    }
                    superMethodInvocation.arguments().add(expri);
                    ++i;
                }
            }
            expr = superMethodInvocation;
        } else {
            Expression qualifier;
            org.eclipse.jdt.internal.compiler.ast.Expression[] arguments;
            MethodInvocation methodInvocation = this.ast.newMethodInvocation();
            if (this.resolveBindings) {
                this.recordNodes(methodInvocation, expression);
            }
            SimpleName name = this.ast.newSimpleName(new String(expression.selector));
            int nameSourceStart = (int)(expression.nameSourcePosition >>> 32);
            int nameSourceLength = (int)(expression.nameSourcePosition & 0xFFFFFFFFFFFFFFFFL) - nameSourceStart + 1;
            name.setSourceRange(nameSourceStart, nameSourceLength);
            methodInvocation.setName(name);
            if (this.resolveBindings) {
                this.recordNodes(name, expression);
            }
            if ((arguments = expression.arguments) != null) {
                int argumentsLength = arguments.length;
                int i = 0;
                while (i < argumentsLength) {
                    Expression expri = this.convert(arguments[i]);
                    if (this.resolveBindings) {
                        this.recordNodes(expri, arguments[i]);
                    }
                    methodInvocation.arguments().add(expri);
                    ++i;
                }
            }
            if ((qualifier = this.convert(expression.receiver)) instanceof Name && this.resolveBindings) {
                this.recordNodes(qualifier, expression.receiver);
            }
            methodInvocation.setExpression(qualifier);
            if (qualifier != null) {
                sourceStart = qualifier.getStartPosition();
            }
            expr = methodInvocation;
        }
        expr.setSourceRange(sourceStart, expression.sourceEnd - sourceStart + 1);
        this.removeTrailingCommentFromExpressionEndingWithAParen(expr);
        return expr;
    }

    public Expression convert(AND_AND_Expression expression) {
        InfixExpression infixExpression = this.ast.newInfixExpression();
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_AND);
        int startPosition = leftExpression.getStartPosition();
        infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        return infixExpression;
    }

    public Expression convert(EqualExpression expression) {
        InfixExpression infixExpression = this.ast.newInfixExpression();
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        int startPosition = leftExpression.getStartPosition();
        infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        switch ((expression.bits & 0xFC0) >> 6) {
            case 18: {
                infixExpression.setOperator(InfixExpression.Operator.EQUALS);
                break;
            }
            case 29: {
                infixExpression.setOperator(InfixExpression.Operator.NOT_EQUALS);
            }
        }
        return infixExpression;
    }

    public Expression convert(OR_OR_Expression expression) {
        InfixExpression infixExpression = this.ast.newInfixExpression();
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_OR);
        int sourceStart = leftExpression.getStartPosition();
        infixExpression.setSourceRange(sourceStart, expression.sourceEnd - sourceStart + 1);
        return infixExpression;
    }

    public Statement convert(org.eclipse.jdt.internal.compiler.ast.Statement statement) {
        if (statement instanceof LocalDeclaration) {
            return this.convertToVariableDeclarationStatement((LocalDeclaration)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.AssertStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.AssertStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.Block) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.Block)statement);
        }
        if (statement instanceof Break) {
            return this.convert((Break)statement);
        }
        if (statement instanceof Continue) {
            return this.convert((Continue)statement);
        }
        if (statement instanceof Case) {
            return this.convert((Case)statement);
        }
        if (statement instanceof DefaultCase) {
            return this.convert((DefaultCase)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.DoStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.DoStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.EmptyStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.EmptyStatement)statement);
        }
        if (statement instanceof ExplicitConstructorCall) {
            return this.convert((ExplicitConstructorCall)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.ForStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.ForStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.IfStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.IfStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.LabeledStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.LabeledStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.ReturnStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.ReturnStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.SwitchStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.SwitchStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.ThrowStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.ThrowStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.TryStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.TryStatement)statement);
        }
        if (statement instanceof LocalTypeDeclaration) {
            TypeDeclarationStatement typeDeclarationStatement = this.ast.newTypeDeclarationStatement(this.convert((LocalTypeDeclaration)statement));
            TypeDeclaration typeDecl = typeDeclarationStatement.getTypeDeclaration();
            typeDeclarationStatement.setSourceRange(typeDecl.getStartPosition(), typeDecl.getLength());
            return typeDeclarationStatement;
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.TypeDeclaration) {
            TypeDeclarationStatement typeDeclarationStatement = this.ast.newTypeDeclarationStatement(this.convert((org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)statement));
            TypeDeclaration typeDecl = typeDeclarationStatement.getTypeDeclaration();
            typeDeclarationStatement.setSourceRange(typeDecl.getStartPosition(), typeDecl.getLength());
            return typeDeclarationStatement;
        }
        if (statement instanceof AnonymousLocalTypeDeclaration) {
            ClassInstanceCreation expr = this.convert((AnonymousLocalTypeDeclaration)statement);
            ExpressionStatement stmt = this.ast.newExpressionStatement(expr);
            stmt.setSourceRange(expr.getStartPosition(), expr.getLength());
            return stmt;
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.WhileStatement) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.WhileStatement)statement);
        }
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.Expression) {
            Expression expr = this.convert((org.eclipse.jdt.internal.compiler.ast.Expression)statement);
            ExpressionStatement stmt = this.ast.newExpressionStatement(expr);
            stmt.setSourceRange(expr.getStartPosition(), expr.getLength());
            this.retrieveSemiColonPosition(stmt);
            return stmt;
        }
        throw new IllegalArgumentException("Not yet implemented: convert(" + statement.getClass() + ")");
    }

    public AssertStatement convert(org.eclipse.jdt.internal.compiler.ast.AssertStatement statement) {
        AssertStatement assertStatement = this.ast.newAssertStatement();
        assertStatement.setExpression(this.convert(statement.assertExpression));
        int end = statement.assertExpression.sourceEnd + 1;
        org.eclipse.jdt.internal.compiler.ast.Expression exceptionArgument = statement.exceptionArgument;
        if (exceptionArgument != null) {
            assertStatement.setMessage(this.convert(exceptionArgument));
            end = exceptionArgument.sourceEnd + 1;
        }
        int start = statement.sourceStart;
        int sourceEnd = this.retrieveEndingSemiColonPosition(end, this.compilationUnitSource.length);
        assertStatement.setSourceRange(start, sourceEnd - start + 1);
        return assertStatement;
    }

    public Block convert(org.eclipse.jdt.internal.compiler.ast.Block statement) {
        org.eclipse.jdt.internal.compiler.ast.Statement[] statements;
        Block block = this.ast.newBlock();
        if (statement.sourceEnd > 0) {
            block.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        }
        if ((statements = statement.statements) != null) {
            int statementsLength = statements.length;
            int i = 0;
            while (i < statementsLength) {
                if (statements[i] instanceof LocalDeclaration) {
                    this.checkAndAddMultipleLocalDeclaration(statements, i, block.statements());
                } else {
                    block.statements().add(this.convert(statements[i]));
                }
                ++i;
            }
        }
        return block;
    }

    public BreakStatement convert(Break statement) {
        BreakStatement breakStatement = this.ast.newBreakStatement();
        breakStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        if (statement.label != null) {
            SimpleName name = this.ast.newSimpleName(new String(statement.label));
            this.retrieveIdentifierAndSetPositions(statement.sourceStart, statement.sourceEnd, name);
            breakStatement.setLabel(name);
        }
        this.retrieveSemiColonPosition(breakStatement);
        return breakStatement;
    }

    public ContinueStatement convert(Continue statement) {
        ContinueStatement continueStatement = this.ast.newContinueStatement();
        continueStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        if (statement.label != null) {
            SimpleName name = this.ast.newSimpleName(new String(statement.label));
            this.retrieveIdentifierAndSetPositions(statement.sourceStart, statement.sourceEnd, name);
            continueStatement.setLabel(name);
        }
        this.retrieveSemiColonPosition(continueStatement);
        return continueStatement;
    }

    public SwitchCase convert(Case statement) {
        SwitchCase switchCase = this.ast.newSwitchCase();
        switchCase.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        switchCase.setExpression(this.convert(statement.constantExpression));
        this.retrieveColonPosition(switchCase);
        return switchCase;
    }

    public SwitchCase convert(DefaultCase statement) {
        SwitchCase switchCase = this.ast.newSwitchCase();
        switchCase.setExpression(null);
        switchCase.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        this.retrieveColonPosition(switchCase);
        return switchCase;
    }

    public DoStatement convert(org.eclipse.jdt.internal.compiler.ast.DoStatement statement) {
        DoStatement doStatement = this.ast.newDoStatement();
        doStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        doStatement.setExpression(this.convert(statement.condition));
        org.eclipse.jdt.internal.compiler.ast.Statement action = statement.action;
        if (action != null) {
            doStatement.setBody(this.convert(statement.action));
        } else {
            EmptyStatement emptyStatement = this.ast.newEmptyStatement();
            int start = this.retrieveStartingSemiColonPosition(statement.sourceStart, statement.sourceEnd);
            int end = this.retrieveEndingSemiColonPosition(start, statement.sourceEnd);
            emptyStatement.setSourceRange(start, end - start + 1);
            doStatement.setBody(emptyStatement);
        }
        this.retrieveSemiColonPosition(doStatement);
        return doStatement;
    }

    public EmptyStatement convert(org.eclipse.jdt.internal.compiler.ast.EmptyStatement statement) {
        EmptyStatement emptyStatement = this.ast.newEmptyStatement();
        emptyStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        return emptyStatement;
    }

    public Statement convert(ExplicitConstructorCall statement) {
        Statement newStatement;
        if (statement.isSuperAccess() || statement.isSuper()) {
            org.eclipse.jdt.internal.compiler.ast.Expression[] arguments;
            SuperConstructorInvocation superConstructorInvocation = this.ast.newSuperConstructorInvocation();
            if (statement.qualification != null) {
                superConstructorInvocation.setExpression(this.convert(statement.qualification));
            }
            if ((arguments = statement.arguments) != null) {
                int length = arguments.length;
                int i = 0;
                while (i < length) {
                    superConstructorInvocation.arguments().add(this.convert(arguments[i]));
                    ++i;
                }
            }
            newStatement = superConstructorInvocation;
        } else {
            ConstructorInvocation constructorInvocation = this.ast.newConstructorInvocation();
            org.eclipse.jdt.internal.compiler.ast.Expression[] arguments = statement.arguments;
            if (arguments != null) {
                int length = arguments.length;
                int i = 0;
                while (i < length) {
                    constructorInvocation.arguments().add(this.convert(arguments[i]));
                    ++i;
                }
            }
            newStatement = constructorInvocation;
        }
        newStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        this.retrieveSemiColonPosition(newStatement);
        if (this.resolveBindings) {
            this.recordNodes(newStatement, statement);
        }
        return newStatement;
    }

    public ForStatement convert(org.eclipse.jdt.internal.compiler.ast.ForStatement statement) {
        org.eclipse.jdt.internal.compiler.ast.Statement action;
        org.eclipse.jdt.internal.compiler.ast.Statement[] increments;
        int i;
        ForStatement forStatement = this.ast.newForStatement();
        forStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        org.eclipse.jdt.internal.compiler.ast.Statement[] initializations = statement.initializations;
        if (initializations != null) {
            if (initializations[0] instanceof LocalDeclaration) {
                VariableDeclarationExpression variableDeclarationExpression = this.convertToVariableDeclarationExpression((LocalDeclaration)initializations[0]);
                int initializationsLength = initializations.length;
                i = 1;
                while (i < initializationsLength) {
                    variableDeclarationExpression.fragments().add(this.convertToVariableDeclarationFragment((LocalDeclaration)initializations[i]));
                    ++i;
                }
                forStatement.initializers().add(variableDeclarationExpression);
            } else {
                int initializationsLength = initializations.length;
                int i2 = 0;
                while (i2 < initializationsLength) {
                    forStatement.initializers().add(this.convertToExpression(initializations[i2]));
                    ++i2;
                }
            }
        }
        if (statement.condition != null) {
            forStatement.setExpression(this.convert(statement.condition));
        }
        if ((increments = statement.increments) != null) {
            int incrementsLength = increments.length;
            i = 0;
            while (i < incrementsLength) {
                forStatement.updaters().add(this.convertToExpression(increments[i]));
                ++i;
            }
        }
        if ((action = statement.action) != null) {
            forStatement.setBody(this.convert(statement.action));
        } else {
            EmptyStatement emptyStatement = this.ast.newEmptyStatement();
            int start = this.retrieveStartingSemiColonPosition(statement.sourceStart, this.compilationUnitSource.length);
            int end = this.retrieveEndingSemiColonPosition(start, this.compilationUnitSource.length);
            emptyStatement.setSourceRange(start, end - start + 1);
            forStatement.setBody(emptyStatement);
        }
        return forStatement;
    }

    public Expression convertToExpression(org.eclipse.jdt.internal.compiler.ast.Statement statement) {
        if (statement instanceof org.eclipse.jdt.internal.compiler.ast.Expression) {
            return this.convert((org.eclipse.jdt.internal.compiler.ast.Expression)statement);
        }
        throw new IllegalArgumentException("Not yet implemented: convert(" + statement.getClass() + ")");
    }

    public IfStatement convert(org.eclipse.jdt.internal.compiler.ast.IfStatement statement) {
        int end;
        int start;
        EmptyStatement emptyStatement;
        IfStatement ifStatement = this.ast.newIfStatement();
        ifStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        ifStatement.setExpression(this.convert(statement.condition));
        org.eclipse.jdt.internal.compiler.ast.Statement thenStatement = statement.thenStatement;
        org.eclipse.jdt.internal.compiler.ast.Statement elseStatement = statement.elseStatement;
        if (thenStatement != null) {
            if (thenStatement == org.eclipse.jdt.internal.compiler.ast.Block.None) {
                emptyStatement = this.ast.newEmptyStatement();
                start = this.retrieveStartingSemiColonPosition(statement.sourceStart, statement.sourceEnd);
                end = this.retrieveEndingSemiColonPosition(start, statement.sourceEnd);
                emptyStatement.setSourceRange(start, end - start + 1);
                ifStatement.setThenStatement(emptyStatement);
            } else {
                ifStatement.setThenStatement(this.convert(statement.thenStatement));
            }
        }
        if (elseStatement != null) {
            if (elseStatement == org.eclipse.jdt.internal.compiler.ast.Block.None) {
                emptyStatement = this.ast.newEmptyStatement();
                start = this.retrieveElseEndingPosition(statement.sourceStart, statement.sourceEnd);
                start = this.retrieveStartingSemiColonPosition(statement.sourceStart, statement.sourceEnd);
                end = this.retrieveEndingSemiColonPosition(start, statement.sourceEnd);
                emptyStatement.setSourceRange(start, end - start + 1);
                ifStatement.setElseStatement(emptyStatement);
            } else {
                ifStatement.setElseStatement(this.convert(elseStatement));
            }
        }
        return ifStatement;
    }

    public LabeledStatement convert(org.eclipse.jdt.internal.compiler.ast.LabeledStatement statement) {
        LabeledStatement labeledStatement = this.ast.newLabeledStatement();
        labeledStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        org.eclipse.jdt.internal.compiler.ast.Statement body = statement.statement;
        if (body == org.eclipse.jdt.internal.compiler.ast.Block.None) {
            EmptyStatement emptyStatement = this.ast.newEmptyStatement();
            int start = this.retrieveStartingSemiColonPosition(statement.sourceStart, statement.sourceEnd);
            int end = this.retrieveEndingSemiColonPosition(start, statement.sourceEnd);
            emptyStatement.setSourceRange(start, end - start + 1);
            labeledStatement.setBody(emptyStatement);
        } else {
            labeledStatement.setBody(this.convert(body));
        }
        SimpleName name = this.ast.newSimpleName(new String(statement.label));
        this.retrieveIdentifierAndSetPositions(statement.sourceStart, statement.sourceEnd, name);
        labeledStatement.setLabel(name);
        return labeledStatement;
    }

    public ReturnStatement convert(org.eclipse.jdt.internal.compiler.ast.ReturnStatement statement) {
        ReturnStatement returnStatement = this.ast.newReturnStatement();
        returnStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        if (statement.expression != null) {
            returnStatement.setExpression(this.convert(statement.expression));
        }
        this.retrieveSemiColonPosition(returnStatement);
        return returnStatement;
    }

    public SwitchStatement convert(org.eclipse.jdt.internal.compiler.ast.SwitchStatement statement) {
        SwitchStatement switchStatement = this.ast.newSwitchStatement();
        switchStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        switchStatement.setExpression(this.convert(statement.testExpression));
        org.eclipse.jdt.internal.compiler.ast.Statement[] statements = statement.statements;
        if (statements != null) {
            int statementsLength = statements.length;
            int i = 0;
            while (i < statementsLength) {
                switchStatement.statements().add(this.convert(statements[i]));
                ++i;
            }
        }
        return switchStatement;
    }

    public SynchronizedStatement convert(org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement statement) {
        SynchronizedStatement synchronizedStatement = this.ast.newSynchronizedStatement();
        synchronizedStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        synchronizedStatement.setBody(this.convert(statement.block));
        synchronizedStatement.setExpression(this.convert(statement.expression));
        return synchronizedStatement;
    }

    public ThrowStatement convert(org.eclipse.jdt.internal.compiler.ast.ThrowStatement statement) {
        ThrowStatement throwStatement = this.ast.newThrowStatement();
        throwStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        throwStatement.setExpression(this.convert(statement.exception));
        this.retrieveSemiColonPosition(throwStatement);
        return throwStatement;
    }

    public TryStatement convert(org.eclipse.jdt.internal.compiler.ast.TryStatement statement) {
        TryStatement tryStatement = this.ast.newTryStatement();
        tryStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        tryStatement.setBody(this.convert(statement.tryBlock));
        Argument[] catchArguments = statement.catchArguments;
        if (catchArguments != null) {
            int catchArgumentsLength = catchArguments.length;
            org.eclipse.jdt.internal.compiler.ast.Block[] catchBlocks = statement.catchBlocks;
            int start = statement.tryBlock.sourceEnd;
            int i = 0;
            while (i < catchArgumentsLength) {
                CatchClause catchClause = this.ast.newCatchClause();
                int catchClauseSourceStart = this.retrieveStartingCatchPosition(start, catchArguments[i].sourceStart);
                catchClause.setSourceRange(catchClauseSourceStart, catchBlocks[i].sourceEnd - catchClauseSourceStart + 1);
                catchClause.setBody(this.convert(catchBlocks[i]));
                catchClause.setException(this.convert(catchArguments[i]));
                tryStatement.catchClauses().add(catchClause);
                start = catchBlocks[i].sourceEnd;
                ++i;
            }
        }
        if (statement.finallyBlock != null) {
            tryStatement.setFinally(this.convert(statement.finallyBlock));
        }
        return tryStatement;
    }

    public WhileStatement convert(org.eclipse.jdt.internal.compiler.ast.WhileStatement statement) {
        WhileStatement whileStatement = this.ast.newWhileStatement();
        whileStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        whileStatement.setExpression(this.convert(statement.condition));
        org.eclipse.jdt.internal.compiler.ast.Statement action = statement.action;
        if (action != null) {
            whileStatement.setBody(this.convert(action));
            if (!(action instanceof org.eclipse.jdt.internal.compiler.ast.Block)) {
                this.retrieveSemiColonPosition(whileStatement);
            }
        } else {
            EmptyStatement emptyStatement = this.ast.newEmptyStatement();
            this.retrieveSemiColonPosition(whileStatement);
            int start = this.retrieveStartingSemiColonPosition(statement.sourceStart, this.compilationUnitSource.length);
            int end = this.retrieveEndingSemiColonPosition(start, this.compilationUnitSource.length);
            emptyStatement.setSourceRange(start, end - start + 1);
            whileStatement.setBody(emptyStatement);
        }
        return whileStatement;
    }

    private boolean isPrimitiveType(char[] name) {
        switch (name[0]) {
            case 'i': {
                return name.length == 3 && name[1] == 'n' && name[2] == 't';
            }
            case 'l': {
                return name.length == 4 && name[1] == 'o' && name[2] == 'n' && name[3] == 'g';
            }
            case 'd': {
                return name.length == 6 && name[1] == 'o' && name[2] == 'u' && name[3] == 'b' && name[4] == 'l' && name[5] == 'e';
            }
            case 'f': {
                return name.length == 5 && name[1] == 'l' && name[2] == 'o' && name[3] == 'a' && name[4] == 't';
            }
            case 'b': {
                if (name.length == 4 && name[1] == 'y' && name[2] == 't' && name[3] == 'e') {
                    return true;
                }
                return name.length == 7 && name[1] == 'o' && name[2] == 'o' && name[3] == 'l' && name[4] == 'e' && name[5] == 'a' && name[6] == 'n';
            }
            case 'c': {
                return name.length == 4 && name[1] == 'h' && name[2] == 'a' && name[3] == 'r';
            }
            case 's': {
                return name.length == 5 && name[1] == 'h' && name[2] == 'o' && name[3] == 'r' && name[4] == 't';
            }
            case 'v': {
                return name.length == 4 && name[1] == 'o' && name[2] == 'i' && name[3] == 'd';
            }
        }
        return false;
    }

    private PrimitiveType.Code getPrimitiveTypeCode(char[] name) {
        switch (name[0]) {
            case 'i': {
                if (name.length != 3 || name[1] != 'n' || name[2] != 't') break;
                return PrimitiveType.INT;
            }
            case 'l': {
                if (name.length != 4 || name[1] != 'o' || name[2] != 'n' || name[3] != 'g') break;
                return PrimitiveType.LONG;
            }
            case 'd': {
                if (name.length != 6 || name[1] != 'o' || name[2] != 'u' || name[3] != 'b' || name[4] != 'l' || name[5] != 'e') break;
                return PrimitiveType.DOUBLE;
            }
            case 'f': {
                if (name.length != 5 || name[1] != 'l' || name[2] != 'o' || name[3] != 'a' || name[4] != 't') break;
                return PrimitiveType.FLOAT;
            }
            case 'b': {
                if (name.length == 4 && name[1] == 'y' && name[2] == 't' && name[3] == 'e') {
                    return PrimitiveType.BYTE;
                }
                if (name.length != 7 || name[1] != 'o' || name[2] != 'o' || name[3] != 'l' || name[4] != 'e' || name[5] != 'a' || name[6] != 'n') break;
                return PrimitiveType.BOOLEAN;
            }
            case 'c': {
                if (name.length != 4 || name[1] != 'h' || name[2] != 'a' || name[3] != 'r') break;
                return PrimitiveType.CHAR;
            }
            case 's': {
                if (name.length != 5 || name[1] != 'h' || name[2] != 'o' || name[3] != 'r' || name[4] != 't') break;
                return PrimitiveType.SHORT;
            }
            case 'v': {
                if (name.length != 4 || name[1] != 'o' || name[2] != 'i' || name[3] != 'd') break;
                return PrimitiveType.VOID;
            }
        }
        throw new IllegalArgumentException("Not a primitive type");
    }

    private void retrieveSemiColonPosition(ASTNode node) {
        int start = node.getStartPosition();
        int length = node.getLength();
        int end = start + length;
        int count = 0;
        this.scanner.resetTo(end, this.compilationUnitSource.length);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 48: {
                        if (count != 0) break;
                        node.setSourceRange(start, this.scanner.currentPosition - start);
                        return;
                    }
                    case 127: {
                        ++count;
                        break;
                    }
                    case 108: {
                        --count;
                        break;
                    }
                    case 8: {
                        ++count;
                        break;
                    }
                    case 86: {
                        --count;
                        break;
                    }
                    case 13: {
                        ++count;
                        break;
                    }
                    case 125: {
                        --count;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    private void retrieveColonPosition(ASTNode node) {
        int start = node.getStartPosition();
        int length = node.getLength();
        int end = start + length;
        this.scanner.resetTo(end, this.compilationUnitSource.length);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 111: {
                        node.setSourceRange(start, this.scanner.currentPosition - start);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    private int retrieveStartingSemiColonPosition(int start, int end) {
        int count = 0;
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 48: {
                        if (count != 0) break;
                        return this.scanner.startPosition;
                    }
                    case 127: {
                        ++count;
                        break;
                    }
                    case 108: {
                        --count;
                        break;
                    }
                    case 8: {
                        ++count;
                        break;
                    }
                    case 86: {
                        --count;
                        break;
                    }
                    case 13: {
                        ++count;
                        break;
                    }
                    case 125: {
                        --count;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveEndingSemiColonPosition(int start, int end) {
        int count = 0;
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 48: {
                        if (count != 0) break;
                        return this.scanner.currentPosition - 1;
                    }
                    case 127: {
                        ++count;
                        break;
                    }
                    case 108: {
                        --count;
                        break;
                    }
                    case 8: {
                        ++count;
                        break;
                    }
                    case 86: {
                        --count;
                        break;
                    }
                    case 13: {
                        ++count;
                        break;
                    }
                    case 125: {
                        --count;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveElseEndingPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 179: {
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveExtraDimension(int start, int end) {
        this.scanner.resetTo(start, end);
        int dimensions = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 125: {
                        ++dimensions;
                        break;
                    }
                    case 48: 
                    case 86: 
                    case 89: 
                    case 127: 
                    case 171: {
                        return dimensions;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return dimensions;
    }

    private int retrieveEndOfDimensionsPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        int foundPosition = -1;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 13: 
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        break;
                    }
                    case 125: {
                        foundPosition = this.scanner.currentPosition - 1;
                        break;
                    }
                    default: {
                        return foundPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return foundPosition;
    }

    private int retrieveStartingCatchPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 181: {
                        return this.scanner.startPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveEndOfElementTypeNamePosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 6: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: {
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveRightBracketPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 125: {
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveEndOfRightParenthesisPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 86: {
                        return this.scanner.currentPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveProperRightBracketPosition(int bracketNumber, int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            int count = 0;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 125: {
                        if (++count != bracketNumber) break;
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveStartBlockPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 127: {
                        return this.scanner.startPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveIdentifierEndPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 6: {
                        return this.scanner.getCurrentTokenEndPosition();
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private int retrieveEndBlockPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        int count = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 127: {
                        ++count;
                        break;
                    }
                    case 108: {
                        if (--count != 0) break;
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private void retrieveRightBraceOrSemiColonPosition(ASTNode node) {
        int start = node.getStartPosition();
        this.scanner.resetTo(start, this.compilationUnitSource.length);
        try {
            int token;
            int braceCounter = 0;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 127: {
                        ++braceCounter;
                        break;
                    }
                    case 108: {
                        if (--braceCounter != 0) break;
                        node.setSourceRange(start, this.scanner.currentPosition - start);
                        return;
                    }
                    case 48: {
                        if (braceCounter != 0) break;
                        node.setSourceRange(start, this.scanner.currentPosition - start);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    private int retrievePositionBeforeNextCommaOrSemiColon(int start, int end) {
        this.scanner.resetTo(start, end);
        int braceCounter = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 127: {
                        ++braceCounter;
                        break;
                    }
                    case 108: {
                        --braceCounter;
                        break;
                    }
                    case 8: {
                        ++braceCounter;
                        break;
                    }
                    case 86: {
                        --braceCounter;
                        break;
                    }
                    case 13: {
                        ++braceCounter;
                        break;
                    }
                    case 125: {
                        --braceCounter;
                        break;
                    }
                    case 48: 
                    case 89: {
                        if (braceCounter != 0) break;
                        return this.scanner.startPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    private VariableDeclarationFragment convertToVariableDeclarationFragment(org.eclipse.jdt.internal.compiler.ast.FieldDeclaration fieldDeclaration) {
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        SimpleName name = this.ast.newSimpleName(fieldDeclaration.name());
        name.setSourceRange(fieldDeclaration.sourceStart, fieldDeclaration.sourceEnd - fieldDeclaration.sourceStart + 1);
        variableDeclarationFragment.setName(name);
        int end = this.retrievePositionBeforeNextCommaOrSemiColon(fieldDeclaration.sourceEnd, fieldDeclaration.declarationSourceEnd);
        if (end == -1) {
            variableDeclarationFragment.setSourceRange(fieldDeclaration.sourceStart, fieldDeclaration.declarationSourceEnd - fieldDeclaration.sourceStart + 1);
            variableDeclarationFragment.setFlags(1);
        } else {
            variableDeclarationFragment.setSourceRange(fieldDeclaration.sourceStart, end - fieldDeclaration.sourceStart + 1);
        }
        if (fieldDeclaration.initialization != null) {
            variableDeclarationFragment.setInitializer(this.convert(fieldDeclaration.initialization));
        }
        variableDeclarationFragment.setExtraDimensions(this.retrieveExtraDimension(fieldDeclaration.sourceEnd + 1, fieldDeclaration.declarationSourceEnd));
        if (this.resolveBindings) {
            this.recordNodes(name, fieldDeclaration);
            this.recordNodes(variableDeclarationFragment, fieldDeclaration);
            variableDeclarationFragment.resolveBinding();
        }
        return variableDeclarationFragment;
    }

    private VariableDeclarationFragment convertToVariableDeclarationFragment(LocalDeclaration localDeclaration) {
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        SimpleName name = this.ast.newSimpleName(localDeclaration.name());
        name.setSourceRange(localDeclaration.sourceStart, localDeclaration.sourceEnd - localDeclaration.sourceStart + 1);
        variableDeclarationFragment.setName(name);
        int end = this.retrievePositionBeforeNextCommaOrSemiColon(localDeclaration.sourceEnd, this.compilationUnitSource.length);
        if (end == -1) {
            if (localDeclaration.initialization != null) {
                variableDeclarationFragment.setSourceRange(localDeclaration.sourceStart, localDeclaration.initialization.sourceEnd - localDeclaration.sourceStart + 1);
            } else {
                variableDeclarationFragment.setSourceRange(localDeclaration.sourceStart, localDeclaration.sourceEnd - localDeclaration.sourceStart + 1);
            }
        } else {
            variableDeclarationFragment.setSourceRange(localDeclaration.sourceStart, end - localDeclaration.sourceStart + 1);
        }
        if (localDeclaration.initialization != null) {
            variableDeclarationFragment.setInitializer(this.convert(localDeclaration.initialization));
        }
        variableDeclarationFragment.setExtraDimensions(this.retrieveExtraDimension(localDeclaration.sourceEnd + 1, this.compilationUnitSource.length));
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, localDeclaration);
            this.recordNodes(name, localDeclaration);
            variableDeclarationFragment.resolveBinding();
        }
        return variableDeclarationFragment;
    }

    private FieldDeclaration convertToFieldDeclaration(org.eclipse.jdt.internal.compiler.ast.FieldDeclaration fieldDecl) {
        VariableDeclarationFragment variableDeclarationFragment = this.convertToVariableDeclarationFragment(fieldDecl);
        FieldDeclaration fieldDeclaration = this.ast.newFieldDeclaration(variableDeclarationFragment);
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, fieldDecl);
            variableDeclarationFragment.resolveBinding();
        }
        fieldDeclaration.setSourceRange(fieldDecl.declarationSourceStart, fieldDecl.declarationEnd - fieldDecl.declarationSourceStart + 1);
        Type type = this.convertType(fieldDecl.type);
        this.setTypeForField(fieldDeclaration, type, variableDeclarationFragment.getExtraDimensions());
        try {
            fieldDeclaration.setModifiers(fieldDecl.modifiers & 0xFFFF);
        }
        catch (IllegalArgumentException e) {
            int legalModifiers = 223;
            fieldDeclaration.setModifiers(fieldDecl.modifiers & legalModifiers);
            fieldDeclaration.setFlags(1);
        }
        this.setJavaDocComment(fieldDeclaration);
        return fieldDeclaration;
    }

    private VariableDeclarationStatement convertToVariableDeclarationStatement(LocalDeclaration localDeclaration) {
        VariableDeclarationFragment variableDeclarationFragment = this.convertToVariableDeclarationFragment(localDeclaration);
        VariableDeclarationStatement variableDeclarationStatement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, localDeclaration);
        }
        variableDeclarationStatement.setSourceRange(localDeclaration.declarationSourceStart, localDeclaration.declarationSourceEnd - localDeclaration.declarationSourceStart + 1);
        Type type = this.convertType(localDeclaration.type);
        this.setTypeForVariableDeclarationStatement(variableDeclarationStatement, type, variableDeclarationFragment.getExtraDimensions());
        try {
            variableDeclarationStatement.setModifiers(localDeclaration.modifiers & 0xFBFFFFFF);
        }
        catch (IllegalArgumentException e) {
            variableDeclarationStatement.setModifiers(localDeclaration.modifiers & 0x10);
            variableDeclarationStatement.setFlags(1);
        }
        this.retrieveSemiColonPosition(variableDeclarationStatement);
        return variableDeclarationStatement;
    }

    private VariableDeclarationExpression convertToVariableDeclarationExpression(LocalDeclaration localDeclaration) {
        VariableDeclarationFragment variableDeclarationFragment = this.convertToVariableDeclarationFragment(localDeclaration);
        VariableDeclarationExpression variableDeclarationExpression = this.ast.newVariableDeclarationExpression(variableDeclarationFragment);
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, localDeclaration);
        }
        variableDeclarationExpression.setSourceRange(localDeclaration.declarationSourceStart, localDeclaration.declarationSourceEnd - localDeclaration.declarationSourceStart + 1);
        Type type = this.convertType(localDeclaration.type);
        this.setTypeForVariableDeclarationExpression(variableDeclarationExpression, type, variableDeclarationFragment.getExtraDimensions());
        try {
            variableDeclarationExpression.setModifiers(localDeclaration.modifiers & 0xFBFFFFFF);
        }
        catch (IllegalArgumentException e) {
            variableDeclarationExpression.setModifiers(localDeclaration.modifiers & 0x10);
            variableDeclarationExpression.setFlags(1);
        }
        return variableDeclarationExpression;
    }

    private void setTypeForField(FieldDeclaration fieldDeclaration, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    fieldDeclaration.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    int length = type.getLength();
                    ArrayType subarrayType = arrayType;
                    int index = extraDimension;
                    while (index > 0) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                        --index;
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start, start + length);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null);
                    fieldDeclaration.setType(subarrayType);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                fieldDeclaration.setType(type);
            }
        } else {
            fieldDeclaration.setType(type);
        }
    }

    private void setTypeForSingleVariableDeclaration(SingleVariableDeclaration singleVariableDeclaration, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    singleVariableDeclaration.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    int length = type.getLength();
                    ArrayType subarrayType = arrayType;
                    int index = extraDimension;
                    while (index > 0) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                        --index;
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start, start + length);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null);
                    singleVariableDeclaration.setType(subarrayType);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                singleVariableDeclaration.setType(type);
            }
        } else {
            singleVariableDeclaration.setType(type);
        }
    }

    private void setTypeForMethodDeclaration(MethodDeclaration methodDeclaration, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    methodDeclaration.setReturnType(elementType);
                } else {
                    int start = type.getStartPosition();
                    int length = type.getLength();
                    ArrayType subarrayType = arrayType;
                    int index = extraDimension;
                    while (index > 0) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                        --index;
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start, start + length);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null);
                    methodDeclaration.setReturnType(subarrayType);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                methodDeclaration.setReturnType(type);
            }
        } else {
            methodDeclaration.setReturnType(type);
        }
    }

    private void setTypeForVariableDeclarationStatement(VariableDeclarationStatement variableDeclarationStatement, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    variableDeclarationStatement.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    int length = type.getLength();
                    ArrayType subarrayType = arrayType;
                    int index = extraDimension;
                    while (index > 0) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                        --index;
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start, start + length);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null);
                    variableDeclarationStatement.setType(subarrayType);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                variableDeclarationStatement.setType(type);
            }
        } else {
            variableDeclarationStatement.setType(type);
        }
    }

    private void setTypeForVariableDeclarationExpression(VariableDeclarationExpression variableDeclarationExpression, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    variableDeclarationExpression.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    int length = type.getLength();
                    ArrayType subarrayType = arrayType;
                    int index = extraDimension;
                    while (index > 0) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                        --index;
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start, start + length);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null);
                    variableDeclarationExpression.setType(subarrayType);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                variableDeclarationExpression.setType(type);
            }
        } else {
            variableDeclarationExpression.setType(type);
        }
    }

    private void setJavaDocComment(BodyDeclaration bodyDeclaration) {
        this.scanner.resetTo(bodyDeclaration.getStartPosition(), bodyDeclaration.getStartPosition() + bodyDeclaration.getLength());
        try {
            int token = this.scanner.getNextToken();
            if (token != 139) {
                switch (token) {
                    case 1003: {
                        Javadoc javadocComment = this.ast.newJavadoc();
                        int start = this.scanner.startPosition;
                        int length = this.scanner.currentPosition - start;
                        char[] contents = new char[length];
                        System.arraycopy(this.compilationUnitSource, start, contents, 0, length);
                        javadocComment.setComment(new String(contents));
                        javadocComment.setSourceRange(start, length);
                        bodyDeclaration.setJavadoc(javadocComment);
                        return;
                    }
                }
                return;
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    private void propagateErrors(CompilationUnit unit, IProblem[] problems, int problemLength) {
        IProblem[] resizeProblems = null;
        if (problems.length == problemLength) {
            resizeProblems = problems;
        } else {
            resizeProblems = new IProblem[problemLength];
            System.arraycopy(problems, 0, resizeProblems, 0, problemLength);
        }
        ASTSyntaxErrorPropagator syntaxErrorPropagator = new ASTSyntaxErrorPropagator(resizeProblems);
        unit.accept(syntaxErrorPropagator);
        unit.setProblems(resizeProblems);
    }

    private void recordNodes(ASTNode node, AstNode oldASTNode) {
        this.ast.getBindingResolver().store(node, oldASTNode);
    }

    private void removeExtraBlanks(org.eclipse.jdt.internal.compiler.ast.Expression expression) {
        int start = expression.sourceStart;
        int end = expression.sourceEnd;
        int trimLeftPosition = expression.sourceStart;
        int trimRigthPosition = expression.sourceEnd;
        boolean first = true;
        Scanner removeBlankScanner = this.ast.scanner;
        try {
            removeBlankScanner.setSource(this.compilationUnitSource);
            removeBlankScanner.resetTo(start, end);
            while (true) {
                int token = removeBlankScanner.getNextToken();
                switch (token) {
                    case 1000: {
                        if (first) {
                            trimLeftPosition = removeBlankScanner.currentPosition;
                        }
                        trimRigthPosition = removeBlankScanner.startPosition - 1;
                        break;
                    }
                    case 139: {
                        expression.sourceStart = trimLeftPosition;
                        expression.sourceEnd = trimRigthPosition;
                        return;
                    }
                    default: {
                        trimRigthPosition = expression.sourceEnd;
                    }
                }
                first = false;
            }
        }
        catch (InvalidInputException invalidInputException) {
            return;
        }
    }

    private void adjustSourcePositionsForParent(org.eclipse.jdt.internal.compiler.ast.Expression expression) {
        int start = expression.sourceStart;
        int end = expression.sourceEnd;
        int leftParentCount = 1;
        int rightParentCount = 0;
        this.scanner.resetTo(start, end);
        try {
            int token = this.scanner.getNextToken();
            expression.sourceStart = this.scanner.currentPosition;
            boolean stop = false;
            while (!stop && (token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 8: {
                        ++leftParentCount;
                        break;
                    }
                    case 86: {
                        if (++rightParentCount != leftParentCount) break;
                        stop = true;
                    }
                }
            }
            expression.sourceEnd = this.scanner.startPosition - 1;
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    private long[] scanAllIdentifiersPositions(int start, int end, int length) {
        this.scanner.resetTo(start, end);
        long[] positions = new long[length];
        int index = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                if (token != 6) continue;
                positions[index] = ((long)this.scanner.startPosition << 32) + (long)(this.scanner.currentPosition - 1);
                ++index;
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return positions;
    }

    private void retrieveIdentifierAndSetPositions(int start, int end, Name name) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                if (token != 6) continue;
                int startName = this.scanner.startPosition;
                int endName = this.scanner.currentPosition - 1;
                name.setSourceRange(startName, endName - startName + 1);
                return;
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    private void removeTrailingCommentFromExpressionEndingWithAParen(ASTNode node) {
        int start = node.getStartPosition();
        this.scanner.resetTo(start, start + node.getLength());
        int parenCounter = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 8: {
                        ++parenCounter;
                        break;
                    }
                    case 86: {
                        if (--parenCounter != 0) break;
                        int end = this.scanner.currentPosition - 1;
                        node.setSourceRange(start, end - start + 1);
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    private void removeLeadingAndTrailingCommentsFromLiteral(ASTNode node) {
        int start = node.getStartPosition();
        this.scanner.resetTo(start, start + node.getLength());
        int startPosition = -1;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 139) {
                switch (token) {
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: {
                        if (startPosition == -1) {
                            startPosition = this.scanner.startPosition;
                        }
                        int end = this.scanner.currentPosition;
                        node.setSourceRange(startPosition, end - startPosition);
                        return;
                    }
                    case 2: {
                        startPosition = this.scanner.startPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    private void recordPendingThisExpressionScopeResolution(ThisExpression thisExpression) {
        if (this.pendingThisExpressionScopeResolution == null) {
            this.pendingThisExpressionScopeResolution = new HashSet();
        }
        this.pendingThisExpressionScopeResolution.add(thisExpression);
    }

    private void recordPendingNameScopeResolution(Name name) {
        if (this.pendingNameScopeResolution == null) {
            this.pendingNameScopeResolution = new HashSet();
        }
        this.pendingNameScopeResolution.add(name);
    }

    private void lookupForScopes() {
        Iterator iterator;
        if (this.pendingNameScopeResolution != null) {
            iterator = this.pendingNameScopeResolution.iterator();
            while (iterator.hasNext()) {
                Name name = (Name)iterator.next();
                this.ast.getBindingResolver().recordScope(name, name.lookupScope());
            }
        }
        if (this.pendingThisExpressionScopeResolution != null) {
            iterator = this.pendingThisExpressionScopeResolution.iterator();
            while (iterator.hasNext()) {
                ThisExpression thisExpression = (ThisExpression)iterator.next();
                this.ast.getBindingResolver().recordScope(thisExpression, thisExpression.lookupScope());
            }
        }
    }

    private InfixExpression.Operator getOperatorFor(int operatorID) {
        switch (operatorID) {
            case 18: {
                return InfixExpression.Operator.EQUALS;
            }
            case 5: {
                return InfixExpression.Operator.LESS_EQUALS;
            }
            case 7: {
                return InfixExpression.Operator.GREATER_EQUALS;
            }
            case 29: {
                return InfixExpression.Operator.NOT_EQUALS;
            }
            case 10: {
                return InfixExpression.Operator.LEFT_SHIFT;
            }
            case 17: {
                return InfixExpression.Operator.RIGHT_SHIFT_SIGNED;
            }
            case 19: {
                return InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED;
            }
            case 1: {
                return InfixExpression.Operator.CONDITIONAL_OR;
            }
            case 0: {
                return InfixExpression.Operator.CONDITIONAL_AND;
            }
            case 14: {
                return InfixExpression.Operator.PLUS;
            }
            case 13: {
                return InfixExpression.Operator.MINUS;
            }
            case 16: {
                return InfixExpression.Operator.REMAINDER;
            }
            case 8: {
                return InfixExpression.Operator.XOR;
            }
            case 2: {
                return InfixExpression.Operator.AND;
            }
            case 15: {
                return InfixExpression.Operator.TIMES;
            }
            case 3: {
                return InfixExpression.Operator.OR;
            }
            case 9: {
                return InfixExpression.Operator.DIVIDE;
            }
            case 6: {
                return InfixExpression.Operator.GREATER;
            }
            case 4: {
                return InfixExpression.Operator.LESS;
            }
        }
        return null;
    }
}

