/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;

public class ContinueStatement
extends Statement {
    private SimpleName optionalLabel = null;

    ContinueStatement(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 18;
    }

    ASTNode clone(AST target) {
        ContinueStatement result = new ContinueStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        result.setLabel((SimpleName)ASTNode.copySubtree(target, this.getLabel()));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getLabel());
        }
        visitor.endVisit(this);
    }

    public SimpleName getLabel() {
        return this.optionalLabel;
    }

    public void setLabel(SimpleName label) {
        this.replaceChild(this.optionalLabel, label, false);
        this.optionalLabel = label;
    }

    int memSize() {
        return super.memSize() + 4;
    }

    int treeSize() {
        return this.memSize() + (this.optionalLabel == null ? 0 : this.getLabel().treeSize());
    }
}

