/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class AllocationExpression
extends Expression
implements InvocationSite {
    public TypeReference type;
    public Expression[] arguments;
    public MethodBinding binding;
    MethodBinding syntheticAccessor;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.checkCapturedLocalInitializationIfNecessary(this.binding.declaringClass, currentScope, flowInfo);
        if (this.arguments != null) {
            int i = 0;
            int count = this.arguments.length;
            while (i < count) {
                flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                ++i;
            }
        }
        TypeBinding[] thrownExceptions = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            flowContext.checkExceptionHandlers(thrownExceptions, (AstNode)this, flowInfo, currentScope);
        }
        this.manageEnclosingInstanceAccessIfNecessary(currentScope);
        this.manageSyntheticAccessIfNecessary(currentScope);
        return flowInfo;
    }

    public void checkCapturedLocalInitializationIfNecessary(ReferenceBinding checkedType, BlockScope currentScope, FlowInfo flowInfo) {
        NestedTypeBinding nestedType;
        SyntheticArgumentBinding[] syntheticArguments;
        if (checkedType.isLocalType() && !checkedType.isAnonymousType() && !currentScope.isDefinedInType(checkedType) && (syntheticArguments = (nestedType = (NestedTypeBinding)checkedType).syntheticOuterLocalVariables()) != null) {
            int i = 0;
            int count = syntheticArguments.length;
            while (i < count) {
                SyntheticArgumentBinding syntheticArgument = syntheticArguments[i];
                LocalVariableBinding targetLocal = syntheticArgument.actualOuterLocalVariable;
                if (targetLocal != null && targetLocal.declaration != null && !flowInfo.isDefinitelyAssigned(targetLocal)) {
                    currentScope.problemReporter().uninitializedLocalVariable(targetLocal, this);
                }
                ++i;
            }
        }
    }

    public Expression enclosingInstance() {
        return null;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int i;
        int pc = codeStream.position;
        ReferenceBinding allocatedType = this.syntheticAccessor != null ? this.syntheticAccessor.declaringClass : this.binding.declaringClass;
        codeStream.new_(allocatedType);
        if (valueRequired) {
            codeStream.dup();
        }
        codeStream.recordPositionsFrom(pc, this.type.sourceStart);
        if (allocatedType.isNestedType()) {
            codeStream.generateSyntheticEnclosingInstanceValues(currentScope, allocatedType, this.enclosingInstance(), this);
        }
        if (this.arguments != null) {
            i = 0;
            int count = this.arguments.length;
            while (i < count) {
                this.arguments[i].generateCode(currentScope, codeStream, true);
                ++i;
            }
        }
        if (allocatedType.isNestedType()) {
            codeStream.generateSyntheticOuterArgumentValues(currentScope, allocatedType, this);
        }
        if (this.syntheticAccessor == null) {
            codeStream.invokespecial(this.binding);
        } else {
            i = 0;
            int max = this.syntheticAccessor.parameters.length - this.binding.parameters.length;
            while (i < max) {
                codeStream.aconst_null();
                ++i;
            }
            codeStream.invokespecial(this.syntheticAccessor);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public boolean isSuperAccess() {
        return false;
    }

    public boolean isTypeAccess() {
        return true;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope) {
        ReferenceBinding allocatedType = this.binding.declaringClass;
        if (allocatedType.isNestedType() && currentScope.enclosingSourceType().isLocalType()) {
            if (allocatedType.isLocalType()) {
                ((LocalTypeBinding)allocatedType).addInnerEmulationDependent(currentScope, false);
            } else {
                currentScope.propagateInnerEmulation(allocatedType, false);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope) {
        if (this.binding.alwaysNeedsAccessMethod()) {
            this.syntheticAccessor = this.binding.getAccessMethod(true);
            return;
        }
        if (this.binding.isPrivate() && currentScope.enclosingSourceType() != this.binding.declaringClass) {
            if (currentScope.environment().options.isPrivateConstructorAccessChangingVisibility) {
                this.binding.tagForClearingPrivateModifier();
            } else {
                this.syntheticAccessor = ((SourceTypeBinding)this.binding.declaringClass).addSyntheticMethod(this.binding, this.isSuperAccess());
                currentScope.problemReporter().needToEmulateMethodAccess(this.binding, this);
            }
        }
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = AstNode.NotAConstant;
        this.resolvedType = this.type.resolveType(scope);
        TypeBinding[] argumentTypes = TypeConstants.NoParameters;
        if (this.arguments != null) {
            boolean argHasError = false;
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                argumentTypes[i] = this.arguments[i].resolveType(scope);
                if (argumentTypes[i] == null) {
                    argHasError = true;
                }
                ++i;
            }
            if (argHasError) {
                return this.resolvedType;
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        if (!this.resolvedType.canBeInstantiated()) {
            scope.problemReporter().cannotInstantiate(this.type, this.resolvedType);
            return this.resolvedType;
        }
        ReferenceBinding allocatedType = (ReferenceBinding)this.resolvedType;
        this.binding = scope.getConstructor(allocatedType, argumentTypes, this);
        if (!this.binding.isValidBinding()) {
            if (this.binding.declaringClass == null) {
                this.binding.declaringClass = allocatedType;
            }
            scope.problemReporter().invalidConstructor(this, this.binding);
            return this.resolvedType;
        }
        if (this.isMethodUseDeprecated(this.binding, scope)) {
            scope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                this.arguments[i].implicitWidening(this.binding.parameters[i], argumentTypes[i]);
                ++i;
            }
        }
        return allocatedType;
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    public void setDepth(int i) {
    }

    public void setFieldIndex(int i) {
    }

    public String toStringExpression() {
        String s = "new " + this.type.toString(0);
        if (this.arguments == null) {
            s = String.valueOf(s) + "()";
        } else {
            s = String.valueOf(s) + "(";
            int i = 0;
            while (i < this.arguments.length) {
                s = String.valueOf(s) + this.arguments[i].toStringExpression();
                s = i == this.arguments.length - 1 ? String.valueOf(s) + ")" : String.valueOf(s) + ", ";
                ++i;
            }
        }
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.type.traverse(visitor, scope);
            if (this.arguments != null) {
                int argumentsLength = this.arguments.length;
                int i = 0;
                while (i < argumentsLength) {
                    this.arguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }
}

