/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.AbortType;

public class AnonymousLocalTypeDeclaration
extends LocalTypeDeclaration {
    public static final char[] ANONYMOUS_EMPTY_NAME = new char[0];
    public QualifiedAllocationExpression allocation;

    public AnonymousLocalTypeDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
        this.modifiers = 0;
        this.name = ANONYMOUS_EMPTY_NAME;
    }

    public MethodBinding createsInternalConstructorWithBinding(MethodBinding inheritedConstructorBinding) {
        CompilerModifiers[] newMethods;
        int i;
        String baseName = "$anonymous";
        TypeBinding[] argumentTypes = inheritedConstructorBinding.parameters;
        int argumentsLength = argumentTypes.length;
        ConstructorDeclaration cd = new ConstructorDeclaration(this.compilationResult);
        cd.selector = new char[]{'x'};
        cd.sourceStart = this.sourceStart;
        cd.sourceEnd = this.sourceEnd;
        cd.modifiers = this.modifiers & 7;
        cd.isDefaultConstructor = true;
        if (argumentsLength > 0) {
            cd.arguments = new Argument[argumentsLength];
            Argument[] arguments = cd.arguments;
            i = argumentsLength;
            while (--i >= 0) {
                arguments[i] = new Argument((String.valueOf(baseName) + i).toCharArray(), 0L, null, 0);
            }
        }
        cd.constructorCall = SuperReference.implicitSuperConstructorCall();
        cd.constructorCall.sourceStart = this.sourceStart;
        cd.constructorCall.sourceEnd = this.sourceEnd;
        if (argumentsLength > 0) {
            cd.constructorCall.arguments = new Expression[argumentsLength];
            Expression[] args = cd.constructorCall.arguments;
            i = argumentsLength;
            while (--i >= 0) {
                args[i] = new SingleNameReference((String.valueOf(baseName) + i).toCharArray(), 0L);
            }
        }
        if (this.methods == null) {
            this.methods = new AbstractMethodDeclaration[]{cd};
        } else {
            newMethods = new AbstractMethodDeclaration[this.methods.length + 1];
            System.arraycopy(this.methods, 0, newMethods, 1, this.methods.length);
            newMethods[0] = cd;
            this.methods = newMethods;
        }
        cd.binding = new MethodBinding(cd.modifiers, argumentsLength == 0 ? TypeConstants.NoParameters : argumentTypes, inheritedConstructorBinding.thrownExceptions, this.binding);
        cd.scope = new MethodScope(this.scope, cd, true);
        cd.bindArguments();
        cd.constructorCall.resolve(cd.scope);
        if (this.binding.methods == null) {
            this.binding.methods = new MethodBinding[]{cd.binding};
        } else {
            newMethods = new MethodBinding[this.binding.methods.length + 1];
            System.arraycopy(this.binding.methods, 0, newMethods, 1, this.binding.methods.length);
            newMethods[0] = cd.binding;
            this.binding.methods = newMethods;
        }
        return cd.binding;
    }

    public void resolve(BlockScope scope) {
        if (this.binding != null) {
            scope.referenceCompilationUnit().record((LocalTypeBinding)this.binding);
        }
        this.resolve();
        this.updateMaxFieldCount();
    }

    public String toString(int tab) {
        return this.toStringBody(tab);
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope blockScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (visitor.visit(this, blockScope)) {
                int i;
                if (this.memberTypes != null) {
                    int memberTypesLength = this.memberTypes.length;
                    i = 0;
                    while (i < memberTypesLength) {
                        this.memberTypes[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.fields != null) {
                    int fieldsLength = this.fields.length;
                    i = 0;
                    while (i < fieldsLength) {
                        FieldDeclaration field = this.fields[i];
                        if (!field.isStatic()) {
                            field.traverse(visitor, this.initializerScope);
                        }
                        ++i;
                    }
                }
                if (this.methods != null) {
                    int methodsLength = this.methods.length;
                    i = 0;
                    while (i < methodsLength) {
                        this.methods[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
            }
            visitor.endVisit(this, blockScope);
        }
        catch (AbortType abortType) {
            // empty catch block
        }
    }
}

