/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayInitializer
extends Expression {
    public Expression[] expressions;
    public ArrayBinding binding;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.expressions != null) {
            int i = 0;
            int max = this.expressions.length;
            while (i < max) {
                flowInfo = this.expressions[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                ++i;
            }
        }
        return flowInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc;
        block11: {
            pc = codeStream.position;
            int expressionLength = this.expressions == null ? 0 : this.expressions.length;
            codeStream.generateInlinedValue(expressionLength);
            codeStream.newArray(currentScope, this.binding);
            if (this.expressions == null) break block11;
            int elementsTypeID = this.binding.dimensions > 1 ? -1 : this.binding.leafComponentType.id;
            int i = 0;
            while (i < expressionLength) {
                block13: {
                    Expression expr;
                    block12: {
                        expr = this.expressions[i];
                        if (expr.constant == AstNode.NotAConstant) break block12;
                        switch (elementsTypeID) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 7: 
                            case 10: {
                                if (expr.constant.longValue() != 0L) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(i);
                                    expr.generateCode(currentScope, codeStream, true);
                                    codeStream.arrayAtPut(elementsTypeID, false);
                                    break;
                                }
                                break block13;
                            }
                            case 8: 
                            case 9: {
                                double constantValue = expr.constant.doubleValue();
                                if (constantValue == -0.0 || constantValue != 0.0) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(i);
                                    expr.generateCode(currentScope, codeStream, true);
                                    codeStream.arrayAtPut(elementsTypeID, false);
                                    break;
                                }
                                break block13;
                            }
                            case 5: {
                                if (expr.constant.booleanValue()) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(i);
                                    expr.generateCode(currentScope, codeStream, true);
                                    codeStream.arrayAtPut(elementsTypeID, false);
                                    break;
                                }
                                break block13;
                            }
                            default: {
                                if (!(expr instanceof NullLiteral)) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(i);
                                    expr.generateCode(currentScope, codeStream, true);
                                    codeStream.arrayAtPut(elementsTypeID, false);
                                    break;
                                }
                                break block13;
                            }
                        }
                        break block13;
                    }
                    codeStream.dup();
                    codeStream.generateInlinedValue(i);
                    expr.generateCode(currentScope, codeStream, true);
                    codeStream.arrayAtPut(elementsTypeID, false);
                }
                ++i;
            }
        }
        if (!valueRequired) {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public TypeBinding resolveTypeExpecting(BlockScope scope, TypeBinding expectedTb) {
        this.constant = AstNode.NotAConstant;
        if (expectedTb.isArrayType()) {
            this.binding = (ArrayBinding)expectedTb;
            if (this.expressions == null) {
                return this.binding;
            }
            TypeBinding expectedElementsTb = this.binding.elementsType(scope);
            if (expectedElementsTb.isBaseType()) {
                int i = 0;
                int length = this.expressions.length;
                while (i < length) {
                    TypeBinding expressionTb;
                    Expression expression = this.expressions[i];
                    TypeBinding typeBinding = expressionTb = expression instanceof ArrayInitializer ? expression.resolveTypeExpecting(scope, expectedElementsTb) : expression.resolveType(scope);
                    if (expressionTb == null) {
                        return null;
                    }
                    if (expression.isConstantValueOfTypeAssignableToType(expressionTb, expectedElementsTb)) {
                        expression.implicitWidening(expectedElementsTb, expressionTb);
                    } else if (BaseTypeBinding.isWidening(expectedElementsTb.id, expressionTb.id)) {
                        expression.implicitWidening(expectedElementsTb, expressionTb);
                    } else {
                        scope.problemReporter().typeMismatchErrorActualTypeExpectedType(expression, expressionTb, expectedElementsTb);
                        return null;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                int length = this.expressions.length;
                while (i < length) {
                    if (this.expressions[i].resolveTypeExpecting(scope, expectedElementsTb) == null) {
                        return null;
                    }
                    ++i;
                }
            }
            return this.binding;
        }
        TypeBinding leafElementType = null;
        int dim = 1;
        if (this.expressions == null) {
            leafElementType = scope.getJavaLangObject();
        } else {
            Expression currentExpression = this.expressions[0];
            while (currentExpression != null && currentExpression instanceof ArrayInitializer) {
                ++dim;
                Expression[] subExprs = ((ArrayInitializer)currentExpression).expressions;
                if (subExprs == null) {
                    leafElementType = scope.getJavaLangObject();
                    currentExpression = null;
                    break;
                }
                currentExpression = ((ArrayInitializer)currentExpression).expressions[0];
            }
            if (currentExpression != null) {
                leafElementType = currentExpression.resolveType(scope);
            }
        }
        if (leafElementType != null) {
            ArrayBinding probableTb = scope.createArray(leafElementType, dim);
            scope.problemReporter().typeMismatchErrorActualTypeExpectedType(this, probableTb, expectedTb);
        }
        return null;
    }

    public String toStringExpression() {
        String s = "{";
        if (this.expressions != null) {
            int j = 20;
            int i = 0;
            while (i < this.expressions.length) {
                s = String.valueOf(s) + this.expressions[i].toStringExpression() + ",";
                if (--j == 0) {
                    s = String.valueOf(s) + "\n                ";
                    j = 20;
                }
                ++i;
            }
        }
        s = String.valueOf(s) + "}";
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.expressions != null) {
            int expressionsLength = this.expressions.length;
            int i = 0;
            while (i < expressionsLength) {
                this.expressions[i].traverse(visitor, scope);
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }
}

