/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class LocalDeclaration
extends AbstractVariableDeclaration {
    public LocalVariableBinding binding;

    public LocalDeclaration(Expression expr, char[] name, int sourceStart, int sourceEnd) {
        this.initialization = expr;
        this.name = name;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        if (this.initialization != null) {
            this.declarationSourceEnd = this.initialization.sourceEnd;
            this.declarationEnd = this.initialization.sourceEnd;
        } else {
            this.declarationEnd = sourceEnd;
        }
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (flowInfo.isReachable()) {
            this.bits |= 0x40000000;
        }
        if (this.initialization == null) {
            return flowInfo;
        }
        flowInfo = this.initialization.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        flowInfo.markAsDefinitelyAssigned(this.binding);
        return flowInfo;
    }

    public void checkModifiers() {
        if ((this.modifiers & 0xFFFF & 0xFFFFFFEF) != 0) {
            this.modifiers = this.modifiers & 0xFFBFFFFF | 0x800000;
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if (this.binding.resolvedPosition != -1) {
            codeStream.addVisibleLocalVariable(this.binding);
        }
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.initialization != null) {
            Constant inlinedValue = this.initialization.constant;
            if (inlinedValue != AstNode.NotAConstant) {
                if (this.binding.resolvedPosition != -1) {
                    int initPC = codeStream.position;
                    codeStream.generateConstant(inlinedValue, this.initialization.implicitConversion);
                    codeStream.recordPositionsFrom(initPC, this.initialization.sourceStart);
                    codeStream.store(this.binding, false);
                    this.binding.recordInitializationStartPC(codeStream.position);
                }
            } else {
                this.initialization.generateCode(currentScope, codeStream, true);
                if (this.binding.resolvedPosition != -1) {
                    if (this.binding.type.isArrayType() && (this.initialization.resolvedType == BaseTypes.NullBinding || this.initialization instanceof CastExpression && ((CastExpression)this.initialization).innermostCastedExpression().resolvedType == BaseTypes.NullBinding)) {
                        codeStream.checkcast(this.binding.type);
                    }
                    codeStream.store(this.binding, false);
                    if (this.binding.initializationCount == 0) {
                        this.binding.recordInitializationStartPC(codeStream.position);
                    }
                } else if (this.binding.type == BaseTypes.LongBinding || this.binding.type == BaseTypes.DoubleBinding) {
                    codeStream.pop2();
                } else {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public String name() {
        return String.valueOf(this.name);
    }

    public void resolve(BlockScope scope) {
        TypeBinding tb = this.type.resolveType(scope);
        this.checkModifiers();
        if (tb != null) {
            if (tb == BaseTypes.VoidBinding) {
                scope.problemReporter().variableTypeCannotBeVoid(this);
                return;
            }
            if (tb.isArrayType() && ((ArrayBinding)tb).leafComponentType == BaseTypes.VoidBinding) {
                scope.problemReporter().variableTypeCannotBeVoidArray(this);
                return;
            }
        }
        if ((this.binding = scope.duplicateName(this.name)) != null) {
            scope.problemReporter().redefineLocal(this);
        } else {
            if ((this.modifiers & 0x10) != 0 && this.initialization == null) {
                this.modifiers |= 0x4000000;
            }
            this.binding = new LocalVariableBinding(this, tb, this.modifiers, false);
            scope.addLocalVariable(this.binding);
            this.binding.constant = AstNode.NotAConstant;
        }
        if (tb == null) {
            if (this.initialization != null) {
                this.initialization.resolveType(scope);
            }
            return;
        }
        if (this.initialization != null) {
            if (this.initialization instanceof ArrayInitializer) {
                TypeBinding initTb = this.initialization.resolveTypeExpecting(scope, tb);
                if (initTb != null) {
                    ((ArrayInitializer)this.initialization).binding = (ArrayBinding)initTb;
                    this.initialization.implicitWidening(tb, initTb);
                }
            } else {
                TypeBinding initTb = this.initialization.resolveType(scope);
                if (initTb != null) {
                    if (this.initialization.isConstantValueOfTypeAssignableToType(initTb, tb) || tb.isBaseType() && BaseTypeBinding.isWidening(tb.id, initTb.id) || initTb.isCompatibleWith(tb)) {
                        this.initialization.implicitWidening(tb, initTb);
                    } else {
                        scope.problemReporter().typeMismatchError(initTb, tb, this);
                    }
                }
            }
            this.binding.constant = this.binding.isFinal() ? this.initialization.constant.castTo((tb.id << 4) + this.initialization.constant.typeID()) : AstNode.NotAConstant;
        }
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.type.traverse(visitor, scope);
            if (this.initialization != null) {
                this.initialization.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

