/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class InitializationFlowContext
extends ExceptionHandlingFlowContext {
    public int exceptionCount;
    public TypeBinding[] thrownExceptions = new TypeBinding[5];
    public AstNode[] exceptionThrowers = new AstNode[5];
    public FlowInfo[] exceptionThrowerFlowInfos = new FlowInfo[5];

    public InitializationFlowContext(FlowContext parent, AstNode associatedNode, BlockScope scope) {
        super(parent, associatedNode, TypeConstants.NoExceptions, scope, FlowInfo.DEAD_END);
    }

    public void checkInitializerExceptions(BlockScope currentScope, FlowContext initializerContext, FlowInfo flowInfo) {
        int i = 0;
        while (i < this.exceptionCount) {
            initializerContext.checkExceptionHandlers(this.thrownExceptions[i], this.exceptionThrowers[i], this.exceptionThrowerFlowInfos[i], currentScope);
            ++i;
        }
    }

    public String individualToString() {
        StringBuffer buffer = new StringBuffer("Initialization flow context");
        int i = 0;
        while (i < this.exceptionCount) {
            buffer.append('[').append(this.thrownExceptions[i].readableName());
            buffer.append('-').append(this.exceptionThrowerFlowInfos[i].toString()).append(']');
            ++i;
        }
        return buffer.toString();
    }

    public void recordHandlingException(ReferenceBinding exceptionType, UnconditionalFlowInfo flowInfo, TypeBinding raisedException, AstNode invocationSite, boolean wasMasked) {
        int size = this.thrownExceptions.length;
        if (this.exceptionCount == size) {
            this.thrownExceptions = new TypeBinding[size * 2];
            System.arraycopy(this.thrownExceptions, 0, this.thrownExceptions, 0, size);
            this.exceptionThrowers = new AstNode[size * 2];
            System.arraycopy(this.exceptionThrowers, 0, this.exceptionThrowers, 0, size);
            this.exceptionThrowerFlowInfos = new FlowInfo[size * 2];
            System.arraycopy(this.exceptionThrowerFlowInfos, 0, this.exceptionThrowerFlowInfos, 0, size);
        }
        this.thrownExceptions[this.exceptionCount] = raisedException;
        this.exceptionThrowers[this.exceptionCount] = invocationSite;
        this.exceptionThrowerFlowInfos[this.exceptionCount++] = flowInfo.copy();
    }
}

