/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.Iterator;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.parser.NLSLine;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;

public class Scanner
implements TerminalTokens {
    private boolean assertMode = false;
    public boolean useAssertAsAnIndentifier = false;
    public boolean containsAssertKeyword = false;
    public boolean recordLineSeparator = false;
    public char currentCharacter;
    public int startPosition;
    public int currentPosition;
    public int initialPosition;
    public int eofPosition;
    public boolean tokenizeComments = false;
    public boolean tokenizeWhiteSpace = false;
    public char[] source;
    public char[] withoutUnicodeBuffer;
    public int withoutUnicodePtr;
    public boolean unicodeAsBackSlash = false;
    public boolean scanningFloatLiteral = false;
    public int[] commentStops = new int[10];
    public int[] commentStarts = new int[10];
    public int commentPtr = -1;
    public char[][] foundTaskTags = null;
    public char[][] foundTaskMessages;
    public char[][] foundTaskPriorities = null;
    public int[][] foundTaskPositions;
    public int foundTaskCount = 0;
    public char[][] taskTags = null;
    public char[][] taskPriorities = null;
    public boolean diet = false;
    public int[] lineEnds = new int[250];
    public int linePtr = -1;
    public boolean wasAcr = false;
    public static final String END_OF_SOURCE = "End_Of_Source";
    public static final String INVALID_HEXA = "Invalid_Hexa_Literal";
    public static final String INVALID_OCTAL = "Invalid_Octal_Literal";
    public static final String INVALID_CHARACTER_CONSTANT = "Invalid_Character_Constant";
    public static final String INVALID_ESCAPE = "Invalid_Escape";
    public static final String INVALID_INPUT = "Invalid_Input";
    public static final String INVALID_UNICODE_ESCAPE = "Invalid_Unicode_Escape";
    public static final String INVALID_FLOAT = "Invalid_Float_Literal";
    public static final String NULL_SOURCE_STRING = "Null_Source_String";
    public static final String UNTERMINATED_STRING = "Unterminated_String";
    public static final String UNTERMINATED_COMMENT = "Unterminated_Comment";
    public static final String INVALID_CHAR_IN_STRING = "Invalid_Char_In_String";
    static final char[] charArray_a = new char[]{'a'};
    static final char[] charArray_b = new char[]{'b'};
    static final char[] charArray_c = new char[]{'c'};
    static final char[] charArray_d = new char[]{'d'};
    static final char[] charArray_e = new char[]{'e'};
    static final char[] charArray_f = new char[]{'f'};
    static final char[] charArray_g = new char[]{'g'};
    static final char[] charArray_h = new char[]{'h'};
    static final char[] charArray_i = new char[]{'i'};
    static final char[] charArray_j = new char[]{'j'};
    static final char[] charArray_k = new char[]{'k'};
    static final char[] charArray_l = new char[]{'l'};
    static final char[] charArray_m = new char[]{'m'};
    static final char[] charArray_n = new char[]{'n'};
    static final char[] charArray_o = new char[]{'o'};
    static final char[] charArray_p = new char[]{'p'};
    static final char[] charArray_q = new char[]{'q'};
    static final char[] charArray_r = new char[]{'r'};
    static final char[] charArray_s = new char[]{'s'};
    static final char[] charArray_t = new char[]{'t'};
    static final char[] charArray_u = new char[]{'u'};
    static final char[] charArray_v = new char[]{'v'};
    static final char[] charArray_w = new char[]{'w'};
    static final char[] charArray_x = new char[]{'x'};
    static final char[] charArray_y = new char[]{'y'};
    static final char[] charArray_z = new char[]{'z'};
    static final char[] initCharArray = new char[6];
    static final int TableSize = 30;
    static final int InternalTableSize = 6;
    public static final int OptimizedLength = 6;
    public final char[][][][] charArray_length = new char[6][30][6][];
    int currentLineNr = -1;
    int previousLineNr = -1;
    NLSLine currentLine = null;
    public static final String TAG_PREFIX = "//$NON-NLS-";
    public static final int TAG_PREFIX_LENGTH = "//$NON-NLS-".length();
    public static final String TAG_POSTFIX = "$";
    public static final int TAG_POSTFIX_LENGTH = "$".length();
    public StringLiteral[] nonNLSStrings = null;
    public boolean checkNonExternalizedStringLiterals = false;
    public boolean wasNonExternalizedStringLiteral = false;
    static int newEntry2 = 0;
    static int newEntry3 = 0;
    static int newEntry4 = 0;
    static int newEntry5 = 0;
    static int newEntry6 = 0;
    public static final int RoundBracket = 0;
    public static final int SquareBracket = 1;
    public static final int CurlyBracket = 2;
    public static final int BracketKinds = 3;

    public Scanner() {
        this(false, false, false, false, null, null);
    }

    public Scanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean checkNonExternalizedStringLiterals, boolean assertMode, char[][] taskTags, char[][] taskPriorities) {
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 30) {
                int k = 0;
                while (k < 6) {
                    this.charArray_length[i][j][k] = initCharArray;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.eofPosition = Integer.MAX_VALUE;
        this.tokenizeComments = tokenizeComments;
        this.tokenizeWhiteSpace = tokenizeWhiteSpace;
        this.checkNonExternalizedStringLiterals = checkNonExternalizedStringLiterals;
        this.assertMode = assertMode;
        this.taskTags = taskTags;
        this.taskPriorities = taskPriorities;
    }

    public final boolean atEnd() {
        return this.source.length == this.currentPosition;
    }

    private void checkNonExternalizeString() throws InvalidInputException {
        if (this.currentLine == null) {
            return;
        }
        this.parseTags(this.currentLine);
    }

    public void checkTaskTag(int commentStart, int commentEnd) {
        if (this.foundTaskCount > 0 && this.foundTaskPositions[this.foundTaskCount - 1][0] >= commentStart) {
            return;
        }
        int foundTaskIndex = this.foundTaskCount;
        int i = commentStart;
        while (i < commentEnd && i < this.eofPosition) {
            int nextPos = -1;
            char[] tag = null;
            char[] priority = null;
            int itag = 0;
            while (itag < this.taskTags.length) {
                block17: {
                    tag = this.taskTags[itag];
                    priority = this.taskPriorities != null && itag < this.taskPriorities.length ? this.taskPriorities[itag] : null;
                    int tagLength = tag.length;
                    int t = 0;
                    while (t < tagLength) {
                        if (this.source[i + t] == tag[t]) {
                            ++t;
                            continue;
                        }
                        break block17;
                    }
                    nextPos = i + tagLength;
                    if (this.foundTaskTags == null) {
                        this.foundTaskTags = new char[5][];
                        this.foundTaskMessages = new char[5][];
                        this.foundTaskPriorities = new char[5][];
                        this.foundTaskPositions = new int[5][];
                    } else if (this.foundTaskCount == this.foundTaskTags.length) {
                        this.foundTaskTags = new char[this.foundTaskCount * 2][];
                        System.arraycopy(this.foundTaskTags, 0, this.foundTaskTags, 0, this.foundTaskCount);
                        this.foundTaskMessages = new char[this.foundTaskCount * 2][];
                        System.arraycopy(this.foundTaskMessages, 0, this.foundTaskMessages, 0, this.foundTaskCount);
                        this.foundTaskPriorities = new char[this.foundTaskCount * 2][];
                        System.arraycopy(this.foundTaskPriorities, 0, this.foundTaskPriorities, 0, this.foundTaskCount);
                        this.foundTaskPositions = new int[this.foundTaskCount * 2][];
                        System.arraycopy(this.foundTaskPositions, 0, this.foundTaskPositions, 0, this.foundTaskCount);
                    }
                    this.foundTaskTags[this.foundTaskCount] = tag;
                    this.foundTaskPriorities[this.foundTaskCount] = priority;
                    this.foundTaskPositions[this.foundTaskCount] = new int[]{i, -1};
                    ++this.foundTaskCount;
                    i = nextPos;
                }
                ++itag;
            }
            ++i;
        }
        i = foundTaskIndex;
        while (i < this.foundTaskCount) {
            int msgStart = this.foundTaskPositions[i][0] + this.foundTaskTags[i].length;
            int max_value = i + 1 < this.foundTaskCount ? this.foundTaskPositions[i + 1][0] - 1 : Integer.MAX_VALUE;
            int end = -1;
            int j = msgStart;
            while (j < commentEnd) {
                char c = this.source[j];
                if (c == '\n' || c == '\r') {
                    end = j - 1;
                    break;
                }
                ++j;
            }
            int n = end = end < max_value ? end : max_value;
            if (end < 0) {
                j = commentEnd - 1;
                while (j >= msgStart) {
                    char c = this.source[j];
                    if (c == '*') {
                        end = j - 1;
                        break;
                    }
                    --j;
                }
                if (end < 0) {
                    end = commentEnd - 1;
                }
            }
            while (CharOperation.isWhitespace(this.source[end]) && msgStart <= end) {
                --end;
            }
            while (CharOperation.isWhitespace(this.source[msgStart]) && msgStart <= end) {
                ++msgStart;
            }
            this.foundTaskPositions[i][1] = end;
            int messageLength = end - msgStart + 1;
            char[] message = new char[messageLength];
            System.arraycopy(this.source, msgStart, message, 0, messageLength);
            this.foundTaskMessages[i] = message;
            ++i;
        }
    }

    public char[] getCurrentIdentifierSource() {
        char[] result;
        if (this.withoutUnicodePtr != 0) {
            result = new char[this.withoutUnicodePtr];
            System.arraycopy(this.withoutUnicodeBuffer, 1, result, 0, this.withoutUnicodePtr);
        } else {
            int length = this.currentPosition - this.startPosition;
            switch (length) {
                case 1: {
                    return this.optimizedCurrentTokenSource1();
                }
                case 2: {
                    return this.optimizedCurrentTokenSource2();
                }
                case 3: {
                    return this.optimizedCurrentTokenSource3();
                }
                case 4: {
                    return this.optimizedCurrentTokenSource4();
                }
                case 5: {
                    return this.optimizedCurrentTokenSource5();
                }
                case 6: {
                    return this.optimizedCurrentTokenSource6();
                }
            }
            result = new char[length];
            System.arraycopy(this.source, this.startPosition, result, 0, length);
        }
        return result;
    }

    public int getCurrentTokenEndPosition() {
        return this.currentPosition - 1;
    }

    public final char[] getCurrentTokenSource() {
        char[] result;
        if (this.withoutUnicodePtr != 0) {
            result = new char[this.withoutUnicodePtr];
            System.arraycopy(this.withoutUnicodeBuffer, 1, result, 0, this.withoutUnicodePtr);
        } else {
            int length = this.currentPosition - this.startPosition;
            result = new char[length];
            System.arraycopy(this.source, this.startPosition, result, 0, length);
        }
        return result;
    }

    public final char[] getCurrentTokenSourceString() {
        char[] result;
        if (this.withoutUnicodePtr != 0) {
            result = new char[this.withoutUnicodePtr - 2];
            System.arraycopy(this.withoutUnicodeBuffer, 2, result, 0, this.withoutUnicodePtr - 2);
        } else {
            int length = this.currentPosition - this.startPosition - 2;
            result = new char[length];
            System.arraycopy(this.source, this.startPosition + 1, result, 0, length);
        }
        return result;
    }

    public final char[] getRawTokenSource() {
        int length = this.currentPosition - this.startPosition;
        char[] tokenSource = new char[length];
        System.arraycopy(this.source, this.startPosition, tokenSource, 0, length);
        return tokenSource;
    }

    public int getCurrentTokenStartPosition() {
        return this.startPosition;
    }

    public final int getLineEnd(int lineNumber) {
        if (this.lineEnds == null) {
            return -1;
        }
        if (lineNumber >= this.lineEnds.length) {
            return -1;
        }
        if (lineNumber <= 0) {
            return -1;
        }
        if (lineNumber == this.lineEnds.length - 1) {
            return this.eofPosition;
        }
        return this.lineEnds[lineNumber - 1];
    }

    public final int[] getLineEnds() {
        int[] copy = new int[this.linePtr + 1];
        System.arraycopy(this.lineEnds, 0, copy, 0, this.linePtr + 1);
        return copy;
    }

    public final int getLineStart(int lineNumber) {
        if (this.lineEnds == null) {
            return -1;
        }
        if (lineNumber >= this.lineEnds.length) {
            return -1;
        }
        if (lineNumber <= 0) {
            return -1;
        }
        if (lineNumber == 1) {
            return this.initialPosition;
        }
        return this.lineEnds[lineNumber - 2] + 1;
    }

    public final boolean getNextChar(char testedChar) {
        int temp = this.currentPosition;
        try {
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                int c4;
                int c3;
                int c2;
                int c1;
                int unicodeSize = 6;
                ++this.currentPosition;
                while (this.source[this.currentPosition] == 'u') {
                    ++this.currentPosition;
                    ++unicodeSize;
                }
                if ((c1 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c1 < 0 || (c2 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c2 < 0 || (c3 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c3 < 0 || (c4 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c4 < 0) {
                    this.currentPosition = temp;
                    return false;
                }
                this.currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                if (this.currentCharacter != testedChar) {
                    this.currentPosition = temp;
                    return false;
                }
                boolean bl = this.unicodeAsBackSlash = this.currentCharacter == '\\';
                if (this.withoutUnicodePtr == 0) {
                    this.withoutUnicodePtr = this.currentPosition - unicodeSize - this.startPosition;
                    System.arraycopy(this.source, this.startPosition, this.withoutUnicodeBuffer, 1, this.withoutUnicodePtr);
                }
                this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                return true;
            }
            if (this.currentCharacter != testedChar) {
                this.currentPosition = temp;
                return false;
            }
            this.unicodeAsBackSlash = false;
            if (this.withoutUnicodePtr != 0) {
                this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.unicodeAsBackSlash = false;
            this.currentPosition = temp;
            return false;
        }
    }

    public final int getNextChar(char testedChar1, char testedChar2) {
        int temp = this.currentPosition;
        try {
            int result;
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                int result2;
                int c4;
                int c3;
                int c2;
                int c1;
                int unicodeSize = 6;
                ++this.currentPosition;
                while (this.source[this.currentPosition] == 'u') {
                    ++this.currentPosition;
                    ++unicodeSize;
                }
                if ((c1 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c1 < 0 || (c2 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c2 < 0 || (c3 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c3 < 0 || (c4 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c4 < 0) {
                    this.currentPosition = temp;
                    return 2;
                }
                this.currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                if (this.currentCharacter == testedChar1) {
                    result2 = 0;
                } else if (this.currentCharacter == testedChar2) {
                    result2 = 1;
                } else {
                    this.currentPosition = temp;
                    return -1;
                }
                if (this.withoutUnicodePtr == 0) {
                    this.withoutUnicodePtr = this.currentPosition - unicodeSize - this.startPosition;
                    System.arraycopy(this.source, this.startPosition, this.withoutUnicodeBuffer, 1, this.withoutUnicodePtr);
                }
                this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                return result2;
            }
            if (this.currentCharacter == testedChar1) {
                result = 0;
            } else if (this.currentCharacter == testedChar2) {
                result = 1;
            } else {
                this.currentPosition = temp;
                return -1;
            }
            if (this.withoutUnicodePtr != 0) {
                this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
            }
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            this.currentPosition = temp;
            return -1;
        }
    }

    public final boolean getNextCharAsDigit() {
        int temp = this.currentPosition;
        try {
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                int c4;
                int c3;
                int c2;
                int c1;
                int unicodeSize = 6;
                ++this.currentPosition;
                while (this.source[this.currentPosition] == 'u') {
                    ++this.currentPosition;
                    ++unicodeSize;
                }
                if ((c1 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c1 < 0 || (c2 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c2 < 0 || (c3 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c3 < 0 || (c4 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c4 < 0) {
                    this.currentPosition = temp;
                    return false;
                }
                this.currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                if (!Character.isDigit(this.currentCharacter)) {
                    this.currentPosition = temp;
                    return false;
                }
                if (this.withoutUnicodePtr == 0) {
                    this.withoutUnicodePtr = this.currentPosition - unicodeSize - this.startPosition;
                    System.arraycopy(this.source, this.startPosition, this.withoutUnicodeBuffer, 1, this.withoutUnicodePtr);
                }
                this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                return true;
            }
            if (!Character.isDigit(this.currentCharacter)) {
                this.currentPosition = temp;
                return false;
            }
            if (this.withoutUnicodePtr != 0) {
                this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.currentPosition = temp;
            return false;
        }
    }

    public final boolean getNextCharAsDigit(int radix) {
        int temp = this.currentPosition;
        try {
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                int c4;
                int c3;
                int c2;
                int c1;
                int unicodeSize = 6;
                ++this.currentPosition;
                while (this.source[this.currentPosition] == 'u') {
                    ++this.currentPosition;
                    ++unicodeSize;
                }
                if ((c1 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c1 < 0 || (c2 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c2 < 0 || (c3 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c3 < 0 || (c4 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c4 < 0) {
                    this.currentPosition = temp;
                    return false;
                }
                this.currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                if (Character.digit(this.currentCharacter, radix) == -1) {
                    this.currentPosition = temp;
                    return false;
                }
                if (this.withoutUnicodePtr == 0) {
                    this.withoutUnicodePtr = this.currentPosition - unicodeSize - this.startPosition;
                    System.arraycopy(this.source, this.startPosition, this.withoutUnicodeBuffer, 1, this.withoutUnicodePtr);
                }
                this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                return true;
            }
            if (Character.digit(this.currentCharacter, radix) == -1) {
                this.currentPosition = temp;
                return false;
            }
            if (this.withoutUnicodePtr != 0) {
                this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.currentPosition = temp;
            return false;
        }
    }

    public boolean getNextCharAsJavaIdentifierPart() {
        int temp = this.currentPosition;
        try {
            this.currentCharacter = this.source[this.currentPosition++];
            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                int c4;
                int c3;
                int c2;
                int c1;
                int unicodeSize = 6;
                ++this.currentPosition;
                while (this.source[this.currentPosition] == 'u') {
                    ++this.currentPosition;
                    ++unicodeSize;
                }
                if ((c1 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c1 < 0 || (c2 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c2 < 0 || (c3 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c3 < 0 || (c4 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c4 < 0) {
                    this.currentPosition = temp;
                    return false;
                }
                this.currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                if (!Character.isJavaIdentifierPart(this.currentCharacter)) {
                    this.currentPosition = temp;
                    return false;
                }
                if (this.withoutUnicodePtr == 0) {
                    this.withoutUnicodePtr = this.currentPosition - unicodeSize - this.startPosition;
                    System.arraycopy(this.source, this.startPosition, this.withoutUnicodeBuffer, 1, this.withoutUnicodePtr);
                }
                this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                return true;
            }
            if (!Character.isJavaIdentifierPart(this.currentCharacter)) {
                this.currentPosition = temp;
                return false;
            }
            if (this.withoutUnicodePtr != 0) {
                this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            this.currentPosition = temp;
            return false;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getNextToken() throws InvalidInputException {
        block135: {
            this.wasAcr = false;
            if (this.diet) {
                this.jumpOverMethodBody();
                this.diet = false;
                if (this.currentPosition <= this.source.length) return 108;
                return 139;
            }
            whiteStart = 0;
            try {
                block42: while (true) lbl-1000:
                // 4 sources

                {
                    this.withoutUnicodePtr = 0;
                    whiteStart = this.currentPosition;
                    hasWhiteSpaces = false;
                    offset = 0;
                    do {
                        block134: {
                            this.startPosition = this.currentPosition;
                            checkIfUnicode = false;
                            try {
                                this.currentCharacter = this.source[this.currentPosition++];
                                checkIfUnicode = this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u';
                            }
                            catch (IndexOutOfBoundsException e) {
                                if (this.tokenizeWhiteSpace && whiteStart != this.currentPosition - 1) {
                                    --this.currentPosition;
                                    this.startPosition = whiteStart;
                                    return 1000;
                                }
                                if (this.currentPosition <= this.eofPosition) break block134;
                                return 139;
                            }
                        }
                        if (checkIfUnicode) {
                            isWhiteSpace = this.jumpOverUnicodeWhiteSpace();
                            offset = 6;
                        } else {
                            offset = 1;
                            if (this.currentCharacter == '\r' || this.currentCharacter == '\n') {
                                this.checkNonExternalizeString();
                                if (this.recordLineSeparator) {
                                    this.pushLineSeparator();
                                } else {
                                    this.currentLine = null;
                                }
                            }
                            v0 = isWhiteSpace = this.currentCharacter == ' ' || CharOperation.isWhitespace(this.currentCharacter) != false;
                        }
                        if (!isWhiteSpace) continue;
                        hasWhiteSpaces = true;
                    } while (isWhiteSpace);
                    if (this.tokenizeWhiteSpace && hasWhiteSpaces) {
                        this.currentPosition -= offset;
                        this.startPosition = whiteStart;
                        return 1000;
                    }
                    if (this.currentPosition > this.eofPosition) {
                        return 139;
                    }
                    switch (this.currentCharacter) {
                        case '(': {
                            return 8;
                        }
                        case ')': {
                            return 86;
                        }
                        case '{': {
                            return 127;
                        }
                        case '}': {
                            return 108;
                        }
                        case '[': {
                            return 13;
                        }
                        case ']': {
                            return 125;
                        }
                        case ';': {
                            return 48;
                        }
                        case ',': {
                            return 89;
                        }
                        case '.': {
                            if (this.getNextCharAsDigit() == false) return 5;
                            return this.scanNumber(true);
                        }
                        case '+': {
                            test = this.getNextChar('+', '=');
                            if (test == 0) {
                                return 3;
                            }
                            if (test <= 0) return 1;
                            return 184;
                        }
                        case '-': {
                            test = this.getNextChar('-', '=');
                            if (test == 0) {
                                return 4;
                            }
                            if (test <= 0) return 2;
                            return 185;
                        }
                        case '~': {
                            return 90;
                        }
                        case '!': {
                            if (this.getNextChar('=') == false) return 87;
                            return 47;
                        }
                        case '*': {
                            if (this.getNextChar('=') == false) return 7;
                            return 186;
                        }
                        case '%': {
                            if (this.getNextChar('=') == false) return 9;
                            return 191;
                        }
                        case '<': {
                            test = this.getNextChar('=', '<');
                            if (test == 0) {
                                return 35;
                            }
                            if (test <= 0) return 38;
                            if (this.getNextChar('=') == false) return 21;
                            return 192;
                        }
                        case '>': {
                            test = this.getNextChar('=', '>');
                            if (test == 0) {
                                return 36;
                            }
                            if (test <= 0) return 37;
                            test = this.getNextChar('=', '>');
                            if (test == 0) {
                                return 193;
                            }
                            if (test <= 0) return 19;
                            if (this.getNextChar('=') == false) return 20;
                            return 194;
                        }
                        case '=': {
                            if (this.getNextChar('=') == false) return 171;
                            return 45;
                        }
                        case '&': {
                            test = this.getNextChar('&', '=');
                            if (test == 0) {
                                return 83;
                            }
                            if (test <= 0) return 63;
                            return 188;
                        }
                        case '|': {
                            test = this.getNextChar('|', '=');
                            if (test == 0) {
                                return 84;
                            }
                            if (test <= 0) return 85;
                            return 189;
                        }
                        case '^': {
                            if (this.getNextChar('=') == false) return 80;
                            return 190;
                        }
                        case '?': {
                            return 88;
                        }
                        case ':': {
                            return 111;
                        }
                        case '\'': {
                            test = this.getNextChar('\n', '\r');
                            if (test == 0) {
                                throw new InvalidInputException("Invalid_Character_Constant");
                            }
                            if (test <= 0) ** GOTO lbl140
                            lookAhead = 0;
                            if (true) ** GOTO lbl387
lbl140:
                            // 1 sources

                            if (!this.getNextChar('\'')) ** GOTO lbl143
                            lookAhead = 0;
                            if (true) ** GOTO lbl398
lbl143:
                            // 1 sources

                            if (this.getNextChar('\\')) {
                                this.scanEscapeCharacter();
                            } else {
                                this.unicodeAsBackSlash = false;
                                checkIfUnicode = false;
                                try {
                                    this.currentCharacter = this.source[this.currentPosition++];
                                    checkIfUnicode = this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u';
                                }
                                catch (IndexOutOfBoundsException e) {
                                    if (this.currentPosition <= this.eofPosition) throw new InvalidInputException("Invalid_Character_Constant");
                                    return 139;
                                }
                                if (checkIfUnicode) {
                                    this.getNextUnicodeChar();
                                } else if (this.withoutUnicodePtr != 0) {
                                    this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                                }
                            }
                            if (this.getNextChar('\'')) {
                                return 58;
                            }
                            lookAhead = 0;
                            while (true) {
                                if (lookAhead >= 20) {
                                    throw new InvalidInputException("Invalid_Character_Constant");
                                }
                                if (this.currentPosition + lookAhead == this.source.length) {
                                    throw new InvalidInputException("Invalid_Character_Constant");
                                }
                                if (this.source[this.currentPosition + lookAhead] == '\n') {
                                    throw new InvalidInputException("Invalid_Character_Constant");
                                }
                                if (this.source[this.currentPosition + lookAhead] == '\'') {
                                    this.currentPosition += lookAhead + 1;
                                    throw new InvalidInputException("Invalid_Character_Constant");
                                }
                                ++lookAhead;
                            }
                        }
                        case '\"': {
                            try {
                                this.unicodeAsBackSlash = false;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                } else if (this.withoutUnicodePtr != 0) {
                                    this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                                }
                                while (this.currentCharacter != '\"') {
                                    if (this.currentCharacter != '\n' && this.currentCharacter != '\r') ** GOTO lbl188
                                    lookAhead = 0;
                                    if (true) ** GOTO lbl409
lbl188:
                                    // 1 sources

                                    if (this.currentCharacter == '\\') {
                                        escapeSize = this.currentPosition;
                                        backSlashAsUnicodeInString = this.unicodeAsBackSlash;
                                        this.scanEscapeCharacter();
                                        escapeSize = this.currentPosition - escapeSize;
                                        if (this.withoutUnicodePtr == 0) {
                                            this.withoutUnicodePtr = this.currentPosition - escapeSize - 1 - this.startPosition;
                                            System.arraycopy(this.source, this.startPosition, this.withoutUnicodeBuffer, 1, this.withoutUnicodePtr);
                                            this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                                        } else {
                                            this.withoutUnicodeBuffer[this.withoutUnicodePtr] = this.currentCharacter;
                                            if (backSlashAsUnicodeInString) {
                                                --this.withoutUnicodePtr;
                                            }
                                        }
                                    }
                                    this.unicodeAsBackSlash = false;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        continue;
                                    }
                                    if (this.withoutUnicodePtr == 0) continue;
                                    this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                                }
                            }
                            catch (IndexOutOfBoundsException e) {
                                throw new InvalidInputException("Unterminated_String");
                            }
                            catch (InvalidInputException e) {
                                if (e.getMessage().equals("Invalid_Escape") == false) throw e;
                                lookAhead = 0;
                                if (true) ** GOTO lbl420
                            }
                            if (this.checkNonExternalizedStringLiterals == false) return 59;
                            if (this.currentLine == null) {
                                this.currentLine = new NLSLine();
                            }
                            this.currentLine.add(new StringLiteral(this.getCurrentTokenSourceString(), this.startPosition, this.currentPosition - 1));
                            return 59;
                        }
                        case '/': {
                            test = this.getNextChar('/', '*');
                            if (test != 0) ** GOTO lbl304
                            try {
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    c1 = 0;
                                    c2 = 0;
                                    c3 = 0;
                                    c4 = 0;
                                    ++this.currentPosition;
                                    while (true) {
                                        if (this.source[this.currentPosition] != 'u') {
                                            if ((c1 = Character.getNumericValue(this.source[this.currentPosition++])) > 15) throw new InvalidInputException("Invalid_Unicode_Escape");
                                            if (c1 < 0) throw new InvalidInputException("Invalid_Unicode_Escape");
                                            if ((c2 = Character.getNumericValue(this.source[this.currentPosition++])) > 15) throw new InvalidInputException("Invalid_Unicode_Escape");
                                            if (c2 < 0) throw new InvalidInputException("Invalid_Unicode_Escape");
                                            if ((c3 = Character.getNumericValue(this.source[this.currentPosition++])) > 15) throw new InvalidInputException("Invalid_Unicode_Escape");
                                            if (c3 < 0) throw new InvalidInputException("Invalid_Unicode_Escape");
                                            if ((c4 = Character.getNumericValue(this.source[this.currentPosition++])) > 15) throw new InvalidInputException("Invalid_Unicode_Escape");
                                            if (c4 >= 0) break;
                                            throw new InvalidInputException("Invalid_Unicode_Escape");
                                        }
                                        ++this.currentPosition;
                                    }
                                    this.currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                                }
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                    ++this.currentPosition;
                                }
                                isUnicode = false;
lbl248:
                                // 3 sources

                                while (true) {
                                    if (this.currentCharacter != '\r' && this.currentCharacter != '\n') ** GOTO lbl255
                                    if (this.currentCharacter != '\r' || this.source.length <= this.currentPosition) ** GOTO lbl283
                                    if (this.source[this.currentPosition] != '\n') ** GOTO lbl264
                                    ++this.currentPosition;
                                    this.currentCharacter = (char)10;
                                    ** GOTO lbl283
lbl255:
                                    // 1 sources

                                    isUnicode = false;
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) != '\\' || this.source[this.currentPosition] != 'u') break block135;
                                    isUnicode = true;
                                    c1 = 0;
                                    c2 = 0;
                                    c3 = 0;
                                    c4 = 0;
                                    ++this.currentPosition;
                                    if (true) ** GOTO lbl424
lbl264:
                                    // 1 sources

                                    if (this.source[this.currentPosition] == '\\' && this.source[this.currentPosition + 1] == 'u') {
                                        isUnicode = true;
                                        index = this.currentPosition + 1;
                                        ++index;
                                        while (true) {
                                            if (this.source[index] != 'u') {
                                                c1 = 0;
                                                c2 = 0;
                                                c3 = 0;
                                                c4 = 0;
                                                if ((c1 = Character.getNumericValue(this.source[index++])) <= 15 && c1 >= 0 && (c2 = Character.getNumericValue(this.source[index++])) <= 15 && c2 >= 0 && (c3 = Character.getNumericValue(this.source[index++])) <= 15 && c3 >= 0 && (c4 = Character.getNumericValue(this.source[index++])) <= 15 && c4 >= 0) break;
                                                this.currentPosition = index;
                                                throw new InvalidInputException("Invalid_Unicode_Escape");
                                            }
                                            ++index;
                                        }
                                        unicodeChar = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                                        if (unicodeChar == '\n') {
                                            this.currentPosition = index;
                                            this.currentCharacter = (char)10;
                                        }
                                    }
lbl283:
                                    // 7 sources

                                    this.recordComment(false);
                                    if (this.taskTags != null) {
                                        this.checkTaskTag(this.startPosition, this.currentPosition);
                                    }
                                    if (this.currentCharacter != '\r' && this.currentCharacter != '\n') ** GOTO lbl295
                                    this.checkNonExternalizeString();
                                    if (!this.recordLineSeparator) ** GOTO lbl294
                                    if (isUnicode) {
                                        this.pushUnicodeLineSeparator();
                                    } else {
                                        this.pushLineSeparator();
                                    }
                                    ** GOTO lbl295
lbl294:
                                    // 1 sources

                                    this.currentLine = null;
lbl295:
                                    // 4 sources

                                    if (!this.tokenizeComments) ** GOTO lbl-1000
                                    return 1001;
                                }
                            }
                            catch (IndexOutOfBoundsException e) {
                                this.recordComment(false);
                                if (this.taskTags != null) {
                                    this.checkTaskTag(this.startPosition, this.currentPosition - 1);
                                }
                                if (!this.tokenizeComments) ** GOTO lbl-1000
                                --this.currentPosition;
                                return 1001;
                            }
lbl304:
                            // 1 sources

                            if (test <= 0) {
                                if (this.getNextChar('=') == false) return 10;
                                return 187;
                            }
                            try {
                                isJavadoc = false;
                                star = false;
                                isUnicode = false;
                                this.unicodeAsBackSlash = false;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    isUnicode = true;
                                } else {
                                    isUnicode = false;
                                    if (this.withoutUnicodePtr != 0) {
                                        this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                                    }
                                }
                                if (this.currentCharacter == '*') {
                                    isJavadoc = true;
                                    star = true;
                                }
                                if (this.currentCharacter == '\r' || this.currentCharacter == '\n') {
                                    this.checkNonExternalizeString();
                                    if (this.recordLineSeparator) {
                                        if (!isUnicode) {
                                            this.pushLineSeparator();
                                        }
                                    } else {
                                        this.currentLine = null;
                                    }
                                }
                                isUnicode = false;
                                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                    isUnicode = true;
                                } else {
                                    isUnicode = false;
                                }
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == '\\') {
                                    ++this.currentPosition;
                                }
                                while (true) {
                                    if (this.currentCharacter == '/' && star) {
                                        this.recordComment(isJavadoc);
                                        if (this.taskTags == null) continue block42;
                                        this.checkTaskTag(this.startPosition, this.currentPosition);
                                        if (!this.tokenizeComments) continue block42;
                                        if (isJavadoc == false) return 1002;
                                        return 1003;
                                    }
                                    if (this.currentCharacter == '\r' || this.currentCharacter == '\n') {
                                        this.checkNonExternalizeString();
                                        if (this.recordLineSeparator) {
                                            if (!isUnicode) {
                                                this.pushLineSeparator();
                                            }
                                        } else {
                                            this.currentLine = null;
                                        }
                                    }
                                    star = this.currentCharacter == '*';
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        isUnicode = true;
                                    } else {
                                        isUnicode = false;
                                    }
                                    if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') continue;
                                    ++this.currentPosition;
                                }
                            }
                            catch (IndexOutOfBoundsException e) {
                                throw new InvalidInputException("Unterminated_Comment");
                            }
                        }
                        case '\u001a': {
                            if (this.atEnd() == false) throw new InvalidInputException("Ctrl-Z");
                            return 139;
                        }
                        default: {
                            if (Character.isJavaIdentifierStart(this.currentCharacter)) {
                                return this.scanIdentifierOrKeyword();
                            }
                            if (Character.isDigit(this.currentCharacter) == false) return 354;
                            return this.scanNumber(false);
                        }
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException e) {
                if (this.tokenizeWhiteSpace == false) return 139;
                if (whiteStart == this.currentPosition - 1) return 139;
                --this.currentPosition;
                this.startPosition = whiteStart;
                return 1000;
            }
            do {
                if (this.currentPosition + lookAhead == this.source.length) {
                    throw new InvalidInputException("Invalid_Character_Constant");
                }
                if (this.source[this.currentPosition + lookAhead] == '\n') {
                    throw new InvalidInputException("Invalid_Character_Constant");
                }
                if (this.source[this.currentPosition + lookAhead] == '\'') {
                    this.currentPosition += lookAhead + 1;
                    throw new InvalidInputException("Invalid_Character_Constant");
                }
                ++lookAhead;
lbl387:
                // 2 sources

            } while (lookAhead < 3);
            throw new InvalidInputException("Invalid_Character_Constant");
            do {
                if (this.currentPosition + lookAhead == this.source.length) {
                    throw new InvalidInputException("Invalid_Character_Constant");
                }
                if (this.source[this.currentPosition + lookAhead] == '\n') {
                    throw new InvalidInputException("Invalid_Character_Constant");
                }
                if (this.source[this.currentPosition + lookAhead] == '\'') {
                    this.currentPosition += lookAhead + 1;
                    throw new InvalidInputException("Invalid_Character_Constant");
                }
                ++lookAhead;
lbl398:
                // 2 sources

            } while (lookAhead < 3);
            throw new InvalidInputException("Invalid_Character_Constant");
            do {
                if (this.currentPosition + lookAhead == this.source.length) {
                    throw new InvalidInputException("Invalid_Char_In_String");
                }
                if (this.source[this.currentPosition + lookAhead] == '\n') {
                    throw new InvalidInputException("Invalid_Char_In_String");
                }
                if (this.source[this.currentPosition + lookAhead] == '\"') {
                    this.currentPosition += lookAhead + 1;
                    throw new InvalidInputException("Invalid_Char_In_String");
                }
                ++lookAhead;
lbl409:
                // 2 sources

            } while (lookAhead < 50);
            throw new InvalidInputException("Invalid_Char_In_String");
            do {
                if (this.currentPosition + lookAhead == this.source.length) {
                    throw e;
                }
                if (this.source[this.currentPosition + lookAhead] == '\n') {
                    throw e;
                }
                if (this.source[this.currentPosition + lookAhead] == '\"') {
                    this.currentPosition += lookAhead + 1;
                    throw e;
                }
                ++lookAhead;
lbl420:
                // 2 sources

            } while (lookAhead < 50);
            throw e;
            do {
                ++this.currentPosition;
lbl424:
                // 2 sources

            } while (this.source[this.currentPosition] == 'u');
            if ((c1 = Character.getNumericValue(this.source[this.currentPosition++])) > 15) throw new InvalidInputException("Invalid_Unicode_Escape");
            if (c1 < 0) throw new InvalidInputException("Invalid_Unicode_Escape");
            if ((c2 = Character.getNumericValue(this.source[this.currentPosition++])) > 15) throw new InvalidInputException("Invalid_Unicode_Escape");
            if (c2 < 0) throw new InvalidInputException("Invalid_Unicode_Escape");
            if ((c3 = Character.getNumericValue(this.source[this.currentPosition++])) > 15) throw new InvalidInputException("Invalid_Unicode_Escape");
            if (c3 < 0) throw new InvalidInputException("Invalid_Unicode_Escape");
            if ((c4 = Character.getNumericValue(this.source[this.currentPosition++])) > 15) throw new InvalidInputException("Invalid_Unicode_Escape");
            if (c4 < 0) {
                throw new InvalidInputException("Invalid_Unicode_Escape");
            }
            this.currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
        }
        if (this.currentCharacter != '\\' || this.source[this.currentPosition] != '\\') ** GOTO lbl248
        ++this.currentPosition;
        ** while (true)
    }

    public final void getNextUnicodeChar() throws IndexOutOfBoundsException, InvalidInputException {
        int c1 = 0;
        int c2 = 0;
        int c3 = 0;
        int c4 = 0;
        int unicodeSize = 6;
        ++this.currentPosition;
        while (this.source[this.currentPosition] == 'u') {
            ++this.currentPosition;
            ++unicodeSize;
        }
        if ((c1 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c1 < 0 || (c2 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c2 < 0 || (c3 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c3 < 0 || (c4 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c4 < 0) {
            throw new InvalidInputException(INVALID_UNICODE_ESCAPE);
        }
        this.currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
        if (this.withoutUnicodePtr == 0) {
            this.withoutUnicodePtr = this.currentPosition - unicodeSize - this.startPosition;
            System.arraycopy(this.source, this.startPosition, this.withoutUnicodeBuffer, 1, this.withoutUnicodePtr);
        }
        this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
        this.unicodeAsBackSlash = this.currentCharacter == '\\';
    }

    public char[] getSource() {
        return this.source;
    }

    /*
     * Unable to fully structure code
     */
    public final void jumpOverMethodBody() {
        this.wasAcr = false;
        found = 1;
        block32: while (true) {
            while (true) {
                this.startPosition = ++this.currentPosition;
                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                    isWhiteSpace = this.jumpOverUnicodeWhiteSpace();
                } else {
                    if (this.recordLineSeparator && (this.currentCharacter == '\r' || this.currentCharacter == '\n')) {
                        this.pushLineSeparator();
                    }
                    isWhiteSpace = CharOperation.isWhitespace(this.currentCharacter);
                }
                if (isWhiteSpace) continue;
                block12 : switch (this.currentCharacter) {
                    case '{': {
                        ++found;
                        break;
                    }
                    case '}': {
                        if (--found != 0) continue block32;
                        return;
                    }
                    case '\'': {
                        test = this.getNextChar('\\');
                        if (test) {
                            try {
                                this.scanEscapeCharacter();
                            }
                            catch (InvalidInputException ex) {}
                        } else {
                            try {
                                this.unicodeAsBackSlash = false;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                } else if (this.withoutUnicodePtr != 0) {
                                    this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                                }
                            }
                            catch (InvalidInputException ex) {
                                // empty catch block
                            }
                        }
                        this.getNextChar('\'');
                        break;
                    }
                    case '\"': {
                        try {
                            try {
                                this.unicodeAsBackSlash = false;
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    this.getNextUnicodeChar();
                                } else if (this.withoutUnicodePtr != 0) {
                                    this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                                }
                            }
                            catch (InvalidInputException test) {}
                            while (true) {
                                if (this.currentCharacter == '\"') continue block32;
                                if (this.currentCharacter == '\r') {
                                    if (this.source[this.currentPosition] != '\n') continue block32;
                                    break block12;
                                }
                                if (this.currentCharacter == '\n') continue block32;
                                if (this.currentCharacter == '\\') {
                                    try {
                                        this.scanEscapeCharacter();
                                    }
                                    catch (InvalidInputException test) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    this.unicodeAsBackSlash = false;
                                    this.currentCharacter = this.source[this.currentPosition++];
                                    if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                        this.getNextUnicodeChar();
                                        continue;
                                    }
                                    if (this.withoutUnicodePtr == 0) continue;
                                    this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                                }
                                catch (InvalidInputException test) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            return;
                        }
                    }
                    case '/': {
                        test = this.getNextChar('/', '*');
                        if (test == 0) {
                            try {
                                this.currentCharacter = this.source[this.currentPosition++];
                                if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                    isUnicode = true;
                                    c1 = 0;
                                    c2 = 0;
                                    c3 = 0;
                                    c4 = 0;
                                    ++this.currentPosition;
                                    while (this.source[this.currentPosition] == 'u') {
                                        ++this.currentPosition;
                                    }
                                    this.currentCharacter = (c1 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c1 < 0 || (c2 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c2 < 0 || (c3 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c3 < 0 || (c4 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c4 < 0 ? (char)65 : (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                                } else {
                                    isUnicode = false;
                                }
                                while (this.currentCharacter != '\r' && this.currentCharacter != '\n') {
                                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                        c1 = 0;
                                        c2 = 0;
                                        c3 = 0;
                                        c4 = 0;
                                        ++this.currentPosition;
                                        isUnicode = true;
                                        while (this.source[this.currentPosition] == 'u') {
                                            ++this.currentPosition;
                                        }
                                        if ((c1 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c1 < 0 || (c2 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c2 < 0 || (c3 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c3 < 0 || (c4 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c4 < 0) {
                                            this.currentCharacter = (char)65;
                                            continue;
                                        }
                                        this.currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                                        continue;
                                    }
                                    isUnicode = false;
                                }
                                if (!this.recordLineSeparator || this.currentCharacter != '\r' && this.currentCharacter != '\n' || isUnicode) continue block32;
                                this.pushLineSeparator();
                            }
                            catch (IndexOutOfBoundsException c1) {}
                            continue block32;
                        }
                        if (test <= 0) continue block32;
                        isUnicode = false;
                        star = false;
                        try {
                            this.unicodeAsBackSlash = false;
                            this.currentCharacter = this.source[this.currentPosition++];
                            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                this.getNextUnicodeChar();
                                isUnicode = true;
                            } else {
                                isUnicode = false;
                                if (this.withoutUnicodePtr != 0) {
                                    this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                                }
                            }
                        }
                        catch (InvalidInputException c2) {
                            // empty catch block
                        }
                        if (this.currentCharacter == '*') {
                            star = true;
                        }
                        if (this.recordLineSeparator && (this.currentCharacter == '\r' || this.currentCharacter == '\n') && !isUnicode) {
                            this.pushLineSeparator();
                        }
                        try {
                            this.currentCharacter = this.source[this.currentPosition++];
                            if (this.currentCharacter == '\\' && this.source[this.currentPosition] == 'u') {
                                isUnicode = true;
                                c1 = 0;
                                c2 = 0;
                                c3 = 0;
                                c4 = 0;
                                ++this.currentPosition;
                                while (this.source[this.currentPosition] == 'u') {
                                    ++this.currentPosition;
                                }
                                this.currentCharacter = (c1 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c1 < 0 || (c2 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c2 < 0 || (c3 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c3 < 0 || (c4 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c4 < 0 ? (char)65 : (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                            } else {
                                isUnicode = false;
                            }
                            while (true) {
                                if (this.currentCharacter == '/' && star) continue block32;
                                if (this.recordLineSeparator && (this.currentCharacter == '\r' || this.currentCharacter == '\n') && !isUnicode) {
                                    this.pushLineSeparator();
                                }
                                star = this.currentCharacter == '*';
                                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                                    isUnicode = true;
                                    c1 = 0;
                                    c2 = 0;
                                    c3 = 0;
                                    c4 = 0;
                                    ++this.currentPosition;
                                    while (this.source[this.currentPosition] == 'u') {
                                        ++this.currentPosition;
                                    }
                                    if ((c1 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c1 < 0 || (c2 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c2 < 0 || (c3 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c3 < 0 || (c4 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c4 < 0) {
                                        this.currentCharacter = (char)65;
                                        continue;
                                    }
                                    this.currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                                    continue;
                                }
                                isUnicode = false;
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            return;
                        }
                    }
                    default: {
                        if (Character.isJavaIdentifierStart(this.currentCharacter)) {
                            try {
                                this.scanIdentifierOrKeyword();
                            }
                            catch (InvalidInputException var3_11) {}
                            continue block32;
                        }
                        if (Character.isDigit(this.currentCharacter)) ** break;
                        continue block32;
                        try {
                            this.scanNumber(false);
                            break;
                        }
                        catch (InvalidInputException var3_12) {
                            // empty catch block
                        }
                    }
                }
            }
            break;
        }
        catch (IndexOutOfBoundsException var2_3) {
        }
        catch (InvalidInputException var2_4) {
            // empty catch block
        }
    }

    public final boolean jumpOverUnicodeWhiteSpace() throws InvalidInputException {
        try {
            int c4;
            int c3;
            int c2;
            int c1;
            this.wasAcr = false;
            int unicodeSize = 6;
            ++this.currentPosition;
            while (this.source[this.currentPosition] == 'u') {
                ++this.currentPosition;
                ++unicodeSize;
            }
            if ((c1 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c1 < 0 || (c2 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c2 < 0 || (c3 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c3 < 0 || (c4 = Character.getNumericValue(this.source[this.currentPosition++])) > 15 || c4 < 0) {
                throw new InvalidInputException(INVALID_UNICODE_ESCAPE);
            }
            this.currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
            if (CharOperation.isWhitespace(this.currentCharacter)) {
                return true;
            }
            this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
            return false;
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidInputException(INVALID_UNICODE_ESCAPE);
        }
    }

    final char[] optimizedCurrentTokenSource1() {
        char charOne = this.source[this.startPosition];
        switch (charOne) {
            case 'a': {
                return charArray_a;
            }
            case 'b': {
                return charArray_b;
            }
            case 'c': {
                return charArray_c;
            }
            case 'd': {
                return charArray_d;
            }
            case 'e': {
                return charArray_e;
            }
            case 'f': {
                return charArray_f;
            }
            case 'g': {
                return charArray_g;
            }
            case 'h': {
                return charArray_h;
            }
            case 'i': {
                return charArray_i;
            }
            case 'j': {
                return charArray_j;
            }
            case 'k': {
                return charArray_k;
            }
            case 'l': {
                return charArray_l;
            }
            case 'm': {
                return charArray_m;
            }
            case 'n': {
                return charArray_n;
            }
            case 'o': {
                return charArray_o;
            }
            case 'p': {
                return charArray_p;
            }
            case 'q': {
                return charArray_q;
            }
            case 'r': {
                return charArray_r;
            }
            case 's': {
                return charArray_s;
            }
            case 't': {
                return charArray_t;
            }
            case 'u': {
                return charArray_u;
            }
            case 'v': {
                return charArray_v;
            }
            case 'w': {
                return charArray_w;
            }
            case 'x': {
                return charArray_x;
            }
            case 'y': {
                return charArray_y;
            }
            case 'z': {
                return charArray_z;
            }
        }
        return new char[]{charOne};
    }

    final char[] optimizedCurrentTokenSource2() {
        char c0 = this.source[this.startPosition];
        char c1 = this.source[this.startPosition + 1];
        int hash = ((c0 << 6) + c1) % 30;
        char[][] table = this.charArray_length[0][hash];
        int i = newEntry2;
        while (++i < 6) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1]) continue;
            return charArray;
        }
        i = -1;
        int max = newEntry2;
        while (++i <= max) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1]) continue;
            return charArray;
        }
        if (++max >= 6) {
            max = 0;
        }
        char[] r = new char[]{c0, c1};
        table[max] = r;
        newEntry2 = max;
        return r;
    }

    final char[] optimizedCurrentTokenSource3() {
        char c0 = this.source[this.startPosition];
        char c1 = this.source[this.startPosition + 1];
        char c2 = this.source[this.startPosition + 2];
        int hash = ((c0 << 12) + (c1 << 6) + c2) % 30;
        char[][] table = this.charArray_length[1][hash];
        int i = newEntry3;
        while (++i < 6) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2]) continue;
            return charArray;
        }
        i = -1;
        int max = newEntry3;
        while (++i <= max) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2]) continue;
            return charArray;
        }
        if (++max >= 6) {
            max = 0;
        }
        char[] r = new char[]{c0, c1, c2};
        table[max] = r;
        newEntry3 = max;
        return r;
    }

    final char[] optimizedCurrentTokenSource4() {
        char c0 = this.source[this.startPosition];
        char c1 = this.source[this.startPosition + 1];
        char c2 = this.source[this.startPosition + 2];
        char c3 = this.source[this.startPosition + 3];
        long hash = (((long)c0 << 18) + (long)(c1 << 12) + (long)(c2 << 6) + (long)c3) % 30L;
        char[][] table = this.charArray_length[2][(int)hash];
        int i = newEntry4;
        while (++i < 6) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2] || c3 != charArray[3]) continue;
            return charArray;
        }
        i = -1;
        int max = newEntry4;
        while (++i <= max) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2] || c3 != charArray[3]) continue;
            return charArray;
        }
        if (++max >= 6) {
            max = 0;
        }
        char[] r = new char[]{c0, c1, c2, c3};
        table[max] = r;
        newEntry4 = max;
        return r;
    }

    final char[] optimizedCurrentTokenSource5() {
        char c0 = this.source[this.startPosition];
        char c1 = this.source[this.startPosition + 1];
        char c2 = this.source[this.startPosition + 2];
        char c3 = this.source[this.startPosition + 3];
        char c4 = this.source[this.startPosition + 4];
        long hash = (((long)c0 << 24) + ((long)c1 << 18) + (long)(c2 << 12) + (long)(c3 << 6) + (long)c4) % 30L;
        char[][] table = this.charArray_length[3][(int)hash];
        int i = newEntry5;
        while (++i < 6) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2] || c3 != charArray[3] || c4 != charArray[4]) continue;
            return charArray;
        }
        i = -1;
        int max = newEntry5;
        while (++i <= max) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2] || c3 != charArray[3] || c4 != charArray[4]) continue;
            return charArray;
        }
        if (++max >= 6) {
            max = 0;
        }
        char[] r = new char[]{c0, c1, c2, c3, c4};
        table[max] = r;
        newEntry5 = max;
        return r;
    }

    final char[] optimizedCurrentTokenSource6() {
        char c0 = this.source[this.startPosition];
        char c1 = this.source[this.startPosition + 1];
        char c2 = this.source[this.startPosition + 2];
        char c3 = this.source[this.startPosition + 3];
        char c4 = this.source[this.startPosition + 4];
        char c5 = this.source[this.startPosition + 5];
        long hash = (((long)c0 << 32) + ((long)c1 << 24) + ((long)c2 << 18) + (long)(c3 << 12) + (long)(c4 << 6) + (long)c5) % 30L;
        char[][] table = this.charArray_length[4][(int)hash];
        int i = newEntry6;
        while (++i < 6) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2] || c3 != charArray[3] || c4 != charArray[4] || c5 != charArray[5]) continue;
            return charArray;
        }
        i = -1;
        int max = newEntry6;
        while (++i <= max) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2] || c3 != charArray[3] || c4 != charArray[4] || c5 != charArray[5]) continue;
            return charArray;
        }
        if (++max >= 6) {
            max = 0;
        }
        char[] r = new char[]{c0, c1, c2, c3, c4, c5};
        table[max] = r;
        newEntry6 = max;
        return r;
    }

    private void parseTags(NLSLine line) throws InvalidInputException {
        String s = new String(this.getCurrentTokenSource());
        int pos = s.indexOf(TAG_PREFIX);
        int lineLength = line.size();
        while (pos != -1) {
            int start = pos + TAG_PREFIX_LENGTH;
            int end = s.indexOf(TAG_POSTFIX, start);
            if (end != -1) {
                String index = s.substring(start, end);
                int i = 0;
                try {
                    i = Integer.parseInt(index) - 1;
                }
                catch (NumberFormatException e) {
                    i = -1;
                }
                if (line.exists(i)) {
                    line.set(i, null);
                }
            }
            pos = s.indexOf(TAG_PREFIX, start);
        }
        this.nonNLSStrings = new StringLiteral[lineLength];
        int nonNLSCounter = 0;
        Iterator iterator = line.iterator();
        while (iterator.hasNext()) {
            StringLiteral literal = (StringLiteral)iterator.next();
            if (literal == null) continue;
            this.nonNLSStrings[nonNLSCounter++] = literal;
        }
        if (nonNLSCounter == 0) {
            this.nonNLSStrings = null;
            this.currentLine = null;
            return;
        }
        this.wasNonExternalizedStringLiteral = true;
        if (nonNLSCounter != lineLength) {
            this.nonNLSStrings = new StringLiteral[nonNLSCounter];
            System.arraycopy(this.nonNLSStrings, 0, this.nonNLSStrings, 0, nonNLSCounter);
        }
        this.currentLine = null;
    }

    public final void pushLineSeparator() throws InvalidInputException {
        block15: {
            int INCREMENT = 250;
            if (this.checkNonExternalizedStringLiterals) {
                this.currentLine = null;
            }
            if (this.currentCharacter == '\r') {
                int separatorPos = this.currentPosition - 1;
                if (this.linePtr > 0 && this.lineEnds[this.linePtr] >= separatorPos) {
                    return;
                }
                try {
                    this.lineEnds[++this.linePtr] = separatorPos;
                }
                catch (IndexOutOfBoundsException e) {
                    int oldLength = this.lineEnds.length;
                    int[] old = this.lineEnds;
                    this.lineEnds = new int[oldLength + 250];
                    System.arraycopy(old, 0, this.lineEnds, 0, oldLength);
                    this.lineEnds[this.linePtr] = separatorPos;
                }
                try {
                    if (this.source[this.currentPosition] == '\n') {
                        this.lineEnds[this.linePtr] = this.currentPosition++;
                        this.wasAcr = false;
                        break block15;
                    }
                    this.wasAcr = true;
                }
                catch (IndexOutOfBoundsException e) {
                    this.wasAcr = true;
                }
            } else if (this.currentCharacter == '\n') {
                if (this.wasAcr && this.lineEnds[this.linePtr] == this.currentPosition - 2) {
                    this.lineEnds[this.linePtr] = this.currentPosition - 1;
                } else {
                    int separatorPos = this.currentPosition - 1;
                    if (this.linePtr > 0 && this.lineEnds[this.linePtr] >= separatorPos) {
                        return;
                    }
                    try {
                        this.lineEnds[++this.linePtr] = separatorPos;
                    }
                    catch (IndexOutOfBoundsException e) {
                        int oldLength = this.lineEnds.length;
                        int[] old = this.lineEnds;
                        this.lineEnds = new int[oldLength + 250];
                        System.arraycopy(old, 0, this.lineEnds, 0, oldLength);
                        this.lineEnds[this.linePtr] = separatorPos;
                    }
                }
                this.wasAcr = false;
            }
        }
    }

    public final void pushUnicodeLineSeparator() {
        if (this.checkNonExternalizedStringLiterals) {
            this.currentLine = null;
        }
        if (this.currentCharacter == '\r') {
            this.wasAcr = this.source[this.currentPosition] != '\n';
        } else if (this.currentCharacter == '\n') {
            this.wasAcr = false;
        }
    }

    public final void recordComment(boolean isJavadoc) {
        try {
            this.commentStops[++this.commentPtr] = isJavadoc ? this.currentPosition : -this.currentPosition;
        }
        catch (IndexOutOfBoundsException e) {
            int oldStackLength = this.commentStops.length;
            int[] oldStack = this.commentStops;
            this.commentStops = new int[oldStackLength + 30];
            System.arraycopy(oldStack, 0, this.commentStops, 0, oldStackLength);
            this.commentStops[this.commentPtr] = isJavadoc ? this.currentPosition : -this.currentPosition;
            int[] old = this.commentStarts;
            this.commentStarts = new int[oldStackLength + 30];
            System.arraycopy(old, 0, this.commentStarts, 0, oldStackLength);
        }
        this.commentStarts[this.commentPtr] = this.startPosition;
    }

    public void resetTo(int begin, int end) {
        this.diet = false;
        this.startPosition = this.currentPosition = begin;
        this.initialPosition = this.currentPosition;
        this.eofPosition = end < Integer.MAX_VALUE ? end + 1 : end;
        this.commentPtr = -1;
        this.foundTaskCount = 0;
    }

    public final void scanEscapeCharacter() throws InvalidInputException {
        if (this.unicodeAsBackSlash) {
            this.unicodeAsBackSlash = false;
            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
            } else if (this.withoutUnicodePtr != 0) {
                this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
            }
        } else {
            this.currentCharacter = this.source[this.currentPosition++];
        }
        switch (this.currentCharacter) {
            case 'b': {
                this.currentCharacter = (char)8;
                break;
            }
            case 't': {
                this.currentCharacter = (char)9;
                break;
            }
            case 'n': {
                this.currentCharacter = (char)10;
                break;
            }
            case 'f': {
                this.currentCharacter = (char)12;
                break;
            }
            case 'r': {
                this.currentCharacter = (char)13;
                break;
            }
            case '\"': {
                this.currentCharacter = (char)34;
                break;
            }
            case '\'': {
                this.currentCharacter = (char)39;
                break;
            }
            case '\\': {
                this.currentCharacter = (char)92;
                break;
            }
            default: {
                int number = Character.getNumericValue(this.currentCharacter);
                if (number >= 0 && number <= 7) {
                    boolean zeroToThreeNot = number > 3;
                    if (Character.isDigit(this.currentCharacter = this.source[this.currentPosition++])) {
                        int digit = Character.getNumericValue(this.currentCharacter);
                        if (digit >= 0 && digit <= 7) {
                            number = number * 8 + digit;
                            if (Character.isDigit(this.currentCharacter = this.source[this.currentPosition++])) {
                                if (zeroToThreeNot) {
                                    --this.currentPosition;
                                } else {
                                    digit = Character.getNumericValue(this.currentCharacter);
                                    if (digit >= 0 && digit <= 7) {
                                        number = number * 8 + digit;
                                    } else {
                                        --this.currentPosition;
                                    }
                                }
                            } else {
                                --this.currentPosition;
                            }
                        } else {
                            --this.currentPosition;
                        }
                    } else {
                        --this.currentPosition;
                    }
                    if (number > 255) {
                        throw new InvalidInputException(INVALID_ESCAPE);
                    }
                    this.currentCharacter = (char)number;
                    break;
                }
                throw new InvalidInputException(INVALID_ESCAPE);
            }
        }
    }

    public int scanIdentifierOrKeyword() throws InvalidInputException {
        int index;
        char[] data;
        int length;
        this.useAssertAsAnIndentifier = false;
        while (this.getNextCharAsJavaIdentifierPart()) {
        }
        if (this.withoutUnicodePtr == 0) {
            length = this.currentPosition - this.startPosition;
            if (length == 1) {
                return 6;
            }
            data = this.source;
            index = this.startPosition;
        } else {
            length = this.withoutUnicodePtr;
            if (length == 1) {
                return 6;
            }
            data = this.withoutUnicodeBuffer;
            index = 1;
        }
        char firstLetter = data[index];
        switch (firstLetter) {
            case 'a': {
                switch (length) {
                    case 8: {
                        if (data[++index] == 'b' && data[++index] == 's' && data[++index] == 't' && data[++index] == 'r' && data[++index] == 'a' && data[++index] == 'c' && data[++index] == 't') {
                            return 99;
                        }
                        return 6;
                    }
                    case 6: {
                        if (data[++index] == 's' && data[++index] == 's' && data[++index] == 'e' && data[++index] == 'r' && data[++index] == 't') {
                            if (this.assertMode) {
                                this.containsAssertKeyword = true;
                                return 129;
                            }
                            this.useAssertAsAnIndentifier = true;
                            return 6;
                        }
                        return 6;
                    }
                }
                return 6;
            }
            case 'b': {
                switch (length) {
                    case 4: {
                        if (data[++index] == 'y' && data[++index] == 't' && data[++index] == 'e') {
                            return 26;
                        }
                        return 6;
                    }
                    case 5: {
                        if (data[++index] == 'r' && data[++index] == 'e' && data[++index] == 'a' && data[++index] == 'k') {
                            return 130;
                        }
                        return 6;
                    }
                    case 7: {
                        if (data[++index] == 'o' && data[++index] == 'o' && data[++index] == 'l' && data[++index] == 'e' && data[++index] == 'a' && data[++index] == 'n') {
                            return 25;
                        }
                        return 6;
                    }
                }
                return 6;
            }
            case 'c': {
                switch (length) {
                    case 4: {
                        if (data[++index] == 'a') {
                            if (data[++index] == 's' && data[++index] == 'e') {
                                return 178;
                            }
                            return 6;
                        }
                        if (data[index] == 'h' && data[++index] == 'a' && data[++index] == 'r') {
                            return 27;
                        }
                        return 6;
                    }
                    case 5: {
                        if (data[++index] == 'a') {
                            if (data[++index] == 't' && data[++index] == 'c' && data[++index] == 'h') {
                                return 181;
                            }
                            return 6;
                        }
                        if (data[index] == 'l' && data[++index] == 'a' && data[++index] == 's' && data[++index] == 's') {
                            return 176;
                        }
                        if (data[index] == 'o' && data[++index] == 'n' && data[++index] == 's' && data[++index] == 't') {
                            return 354;
                        }
                        return 6;
                    }
                    case 8: {
                        if (data[++index] == 'o' && data[++index] == 'n' && data[++index] == 't' && data[++index] == 'i' && data[++index] == 'n' && data[++index] == 'u' && data[++index] == 'e') {
                            return 131;
                        }
                        return 6;
                    }
                }
                return 6;
            }
            case 'd': {
                switch (length) {
                    case 2: {
                        if (data[++index] == 'o') {
                            return 132;
                        }
                        return 6;
                    }
                    case 6: {
                        if (data[++index] == 'o' && data[++index] == 'u' && data[++index] == 'b' && data[++index] == 'l' && data[++index] == 'e') {
                            return 28;
                        }
                        return 6;
                    }
                    case 7: {
                        if (data[++index] == 'e' && data[++index] == 'f' && data[++index] == 'a' && data[++index] == 'u' && data[++index] == 'l' && data[++index] == 't') {
                            return 251;
                        }
                        return 6;
                    }
                }
                return 6;
            }
            case 'e': {
                switch (length) {
                    case 4: {
                        if (data[++index] == 'l' && data[++index] == 's' && data[++index] == 'e') {
                            return 179;
                        }
                        return 6;
                    }
                    case 7: {
                        if (data[++index] == 'x' && data[++index] == 't' && data[++index] == 'e' && data[++index] == 'n' && data[++index] == 'd' && data[++index] == 's') {
                            return 182;
                        }
                        return 6;
                    }
                }
                return 6;
            }
            case 'f': {
                switch (length) {
                    case 3: {
                        if (data[++index] == 'o' && data[++index] == 'r') {
                            return 133;
                        }
                        return 6;
                    }
                    case 5: {
                        if (data[++index] == 'i') {
                            if (data[++index] == 'n' && data[++index] == 'a' && data[++index] == 'l') {
                                return 100;
                            }
                            return 6;
                        }
                        if (data[index] == 'l' && data[++index] == 'o' && data[++index] == 'a' && data[++index] == 't') {
                            return 29;
                        }
                        if (data[index] == 'a' && data[++index] == 'l' && data[++index] == 's' && data[++index] == 'e') {
                            return 51;
                        }
                        return 6;
                    }
                    case 7: {
                        if (data[++index] == 'i' && data[++index] == 'n' && data[++index] == 'a' && data[++index] == 'l' && data[++index] == 'l' && data[++index] == 'y') {
                            return 183;
                        }
                        return 6;
                    }
                }
                return 6;
            }
            case 'g': {
                if (length == 4 && data[++index] == 'o' && data[++index] == 't' && data[++index] == 'o') {
                    return 354;
                }
                return 6;
            }
            case 'i': {
                switch (length) {
                    case 2: {
                        if (data[++index] == 'f') {
                            return 134;
                        }
                        return 6;
                    }
                    case 3: {
                        if (data[++index] == 'n' && data[++index] == 't') {
                            return 30;
                        }
                        return 6;
                    }
                    case 6: {
                        if (data[++index] == 'm' && data[++index] == 'p' && data[++index] == 'o' && data[++index] == 'r' && data[++index] == 't') {
                            return 173;
                        }
                        return 6;
                    }
                    case 9: {
                        if (data[++index] == 'n' && data[++index] == 't' && data[++index] == 'e' && data[++index] == 'r' && data[++index] == 'f' && data[++index] == 'a' && data[++index] == 'c' && data[++index] == 'e') {
                            return 206;
                        }
                        return 6;
                    }
                    case 10: {
                        if (data[++index] == 'm') {
                            if (data[++index] == 'p' && data[++index] == 'l' && data[++index] == 'e' && data[++index] == 'm' && data[++index] == 'e' && data[++index] == 'n' && data[++index] == 't' && data[++index] == 's') {
                                return 200;
                            }
                            return 6;
                        }
                        if (data[index] == 'n' && data[++index] == 's' && data[++index] == 't' && data[++index] == 'a' && data[++index] == 'n' && data[++index] == 'c' && data[++index] == 'e' && data[++index] == 'o' && data[++index] == 'f') {
                            return 22;
                        }
                        return 6;
                    }
                }
                return 6;
            }
            case 'l': {
                if (length == 4 && data[++index] == 'o' && data[++index] == 'n' && data[++index] == 'g') {
                    return 31;
                }
                return 6;
            }
            case 'n': {
                switch (length) {
                    case 3: {
                        if (data[++index] == 'e' && data[++index] == 'w') {
                            return 46;
                        }
                        return 6;
                    }
                    case 4: {
                        if (data[++index] == 'u' && data[++index] == 'l' && data[++index] == 'l') {
                            return 52;
                        }
                        return 6;
                    }
                    case 6: {
                        if (data[++index] == 'a' && data[++index] == 't' && data[++index] == 'i' && data[++index] == 'v' && data[++index] == 'e') {
                            return 101;
                        }
                        return 6;
                    }
                }
                return 6;
            }
            case 'p': {
                switch (length) {
                    case 6: {
                        if (data[++index] == 'u' && data[++index] == 'b' && data[++index] == 'l' && data[++index] == 'i' && data[++index] == 'c') {
                            return 104;
                        }
                        return 6;
                    }
                    case 7: {
                        if (data[++index] == 'a') {
                            if (data[++index] == 'c' && data[++index] == 'k' && data[++index] == 'a' && data[++index] == 'g' && data[++index] == 'e') {
                                return 180;
                            }
                            return 6;
                        }
                        if (data[index] == 'r' && data[++index] == 'i' && data[++index] == 'v' && data[++index] == 'a' && data[++index] == 't' && data[++index] == 'e') {
                            return 102;
                        }
                        return 6;
                    }
                    case 9: {
                        if (data[++index] == 'r' && data[++index] == 'o' && data[++index] == 't' && data[++index] == 'e' && data[++index] == 'c' && data[++index] == 't' && data[++index] == 'e' && data[++index] == 'd') {
                            return 103;
                        }
                        return 6;
                    }
                }
                return 6;
            }
            case 'r': {
                if (length == 6 && data[++index] == 'e' && data[++index] == 't' && data[++index] == 'u' && data[++index] == 'r' && data[++index] == 'n') {
                    return 135;
                }
                return 6;
            }
            case 's': {
                switch (length) {
                    case 5: {
                        if (data[++index] == 'h') {
                            if (data[++index] == 'o' && data[++index] == 'r' && data[++index] == 't') {
                                return 32;
                            }
                            return 6;
                        }
                        if (data[index] == 'u' && data[++index] == 'p' && data[++index] == 'e' && data[++index] == 'r') {
                            return 49;
                        }
                        return 6;
                    }
                    case 6: {
                        if (data[++index] == 't') {
                            if (data[++index] == 'a' && data[++index] == 't' && data[++index] == 'i' && data[++index] == 'c') {
                                return 97;
                            }
                            return 6;
                        }
                        if (data[index] == 'w' && data[++index] == 'i' && data[++index] == 't' && data[++index] == 'c' && data[++index] == 'h') {
                            return 136;
                        }
                        return 6;
                    }
                    case 8: {
                        if (data[++index] == 't' && data[++index] == 'r' && data[++index] == 'i' && data[++index] == 'c' && data[++index] == 't' && data[++index] == 'f' && data[++index] == 'p') {
                            return 105;
                        }
                        return 6;
                    }
                    case 12: {
                        if (data[++index] == 'y' && data[++index] == 'n' && data[++index] == 'c' && data[++index] == 'h' && data[++index] == 'r' && data[++index] == 'o' && data[++index] == 'n' && data[++index] == 'i' && data[++index] == 'z' && data[++index] == 'e' && data[++index] == 'd') {
                            return 95;
                        }
                        return 6;
                    }
                }
                return 6;
            }
            case 't': {
                switch (length) {
                    case 3: {
                        if (data[++index] == 'r' && data[++index] == 'y') {
                            return 138;
                        }
                        return 6;
                    }
                    case 4: {
                        if (data[++index] == 'h' && data[++index] == 'i' && data[++index] == 's') {
                            return 50;
                        }
                        if (data[index] == 'r' && data[++index] == 'u' && data[++index] == 'e') {
                            return 53;
                        }
                        return 6;
                    }
                    case 5: {
                        if (data[++index] == 'h' && data[++index] == 'r' && data[++index] == 'o' && data[++index] == 'w') {
                            return 137;
                        }
                        return 6;
                    }
                    case 6: {
                        if (data[++index] == 'h' && data[++index] == 'r' && data[++index] == 'o' && data[++index] == 'w' && data[++index] == 's') {
                            return 170;
                        }
                        return 6;
                    }
                    case 9: {
                        if (data[++index] == 'r' && data[++index] == 'a' && data[++index] == 'n' && data[++index] == 's' && data[++index] == 'i' && data[++index] == 'e' && data[++index] == 'n' && data[++index] == 't') {
                            return 106;
                        }
                        return 6;
                    }
                }
                return 6;
            }
            case 'v': {
                switch (length) {
                    case 4: {
                        if (data[++index] == 'o' && data[++index] == 'i' && data[++index] == 'd') {
                            return 33;
                        }
                        return 6;
                    }
                    case 8: {
                        if (data[++index] == 'o' && data[++index] == 'l' && data[++index] == 'a' && data[++index] == 't' && data[++index] == 'i' && data[++index] == 'l' && data[++index] == 'e') {
                            return 107;
                        }
                        return 6;
                    }
                }
                return 6;
            }
            case 'w': {
                switch (length) {
                    case 5: {
                        if (data[++index] == 'h' && data[++index] == 'i' && data[++index] == 'l' && data[++index] == 'e') {
                            return 128;
                        }
                        return 6;
                    }
                }
                return 6;
            }
        }
        return 6;
    }

    public int scanNumber(boolean dotPrefix) throws InvalidInputException {
        boolean floating = dotPrefix;
        if (!dotPrefix && this.currentCharacter == '0') {
            if (this.getNextChar('x', 'X') >= 0) {
                this.unicodeAsBackSlash = false;
                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                    this.getNextUnicodeChar();
                } else if (this.withoutUnicodePtr != 0) {
                    this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                }
                if (Character.digit(this.currentCharacter, 16) == -1) {
                    throw new InvalidInputException(INVALID_HEXA);
                }
                while (this.getNextCharAsDigit(16)) {
                }
                if (this.getNextChar('l', 'L') >= 0) {
                    return 55;
                }
                return 54;
            }
            if (this.getNextCharAsDigit()) {
                while (this.getNextCharAsDigit()) {
                }
                if (this.getNextChar('l', 'L') >= 0) {
                    return 55;
                }
                if (this.getNextChar('f', 'F') >= 0) {
                    return 56;
                }
                if (this.getNextChar('d', 'D') >= 0) {
                    return 57;
                }
                boolean isInteger = true;
                if (this.getNextChar('.')) {
                    isInteger = false;
                    while (this.getNextCharAsDigit()) {
                    }
                }
                if (this.getNextChar('e', 'E') >= 0) {
                    isInteger = false;
                    this.unicodeAsBackSlash = false;
                    if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                        this.getNextUnicodeChar();
                    } else if (this.withoutUnicodePtr != 0) {
                        this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                    }
                    if (this.currentCharacter == '-' || this.currentCharacter == '+') {
                        this.unicodeAsBackSlash = false;
                        if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                            this.getNextUnicodeChar();
                        } else if (this.withoutUnicodePtr != 0) {
                            this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                        }
                    }
                    if (!Character.isDigit(this.currentCharacter)) {
                        throw new InvalidInputException(INVALID_FLOAT);
                    }
                    while (this.getNextCharAsDigit()) {
                    }
                }
                if (this.getNextChar('f', 'F') >= 0) {
                    return 56;
                }
                if (this.getNextChar('d', 'D') >= 0 || !isInteger) {
                    return 57;
                }
                return 54;
            }
        }
        while (this.getNextCharAsDigit()) {
        }
        if (!dotPrefix && this.getNextChar('l', 'L') >= 0) {
            return 55;
        }
        if (!dotPrefix && this.getNextChar('.')) {
            while (this.getNextCharAsDigit()) {
            }
            floating = true;
        }
        if (this.getNextChar('e', 'E') >= 0) {
            floating = true;
            this.unicodeAsBackSlash = false;
            if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                this.getNextUnicodeChar();
            } else if (this.withoutUnicodePtr != 0) {
                this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
            }
            if (this.currentCharacter == '-' || this.currentCharacter == '+') {
                this.unicodeAsBackSlash = false;
                if ((this.currentCharacter = this.source[this.currentPosition++]) == '\\' && this.source[this.currentPosition] == 'u') {
                    this.getNextUnicodeChar();
                } else if (this.withoutUnicodePtr != 0) {
                    this.withoutUnicodeBuffer[++this.withoutUnicodePtr] = this.currentCharacter;
                }
            }
            if (!Character.isDigit(this.currentCharacter)) {
                throw new InvalidInputException(INVALID_FLOAT);
            }
            while (this.getNextCharAsDigit()) {
            }
        }
        if (this.getNextChar('d', 'D') >= 0) {
            return 57;
        }
        if (this.getNextChar('f', 'F') >= 0) {
            return 56;
        }
        return floating ? 57 : 54;
    }

    public final int getLineNumber(int position) {
        if (this.lineEnds == null) {
            return 1;
        }
        int length = this.linePtr + 1;
        if (length == 0) {
            return 1;
        }
        int g = 0;
        int d = length - 1;
        int m = 0;
        while (g <= d) {
            m = (g + d) / 2;
            if (position < this.lineEnds[m]) {
                d = m - 1;
                continue;
            }
            if (position > this.lineEnds[m]) {
                g = m + 1;
                continue;
            }
            return m + 1;
        }
        if (position < this.lineEnds[m]) {
            return m + 1;
        }
        return m + 2;
    }

    public final void setSource(char[] source) {
        this.source = source == null ? CharOperation.NO_CHAR : source;
        this.startPosition = -1;
        this.eofPosition = source.length;
        this.currentPosition = 0;
        this.initialPosition = 0;
        this.containsAssertKeyword = false;
        this.withoutUnicodeBuffer = new char[this.source.length];
    }

    public String toString() {
        char[] middle;
        if (this.startPosition == this.source.length) {
            return "EOF\n\n" + new String(this.source);
        }
        if (this.currentPosition > this.source.length) {
            return "behind the EOF :-( ....\n\n" + new String(this.source);
        }
        char[] front = new char[this.startPosition];
        System.arraycopy(this.source, 0, front, 0, this.startPosition);
        int middleLength = this.currentPosition - 1 - this.startPosition + 1;
        if (middleLength > -1) {
            middle = new char[middleLength];
            System.arraycopy(this.source, this.startPosition, middle, 0, middleLength);
        } else {
            middle = CharOperation.NO_CHAR;
        }
        char[] end = new char[this.source.length - (this.currentPosition - 1)];
        System.arraycopy(this.source, this.currentPosition - 1 + 1, end, 0, this.source.length - (this.currentPosition - 1) - 1);
        return String.valueOf(new String(front)) + "\n===============================\nStarts here -->" + new String(middle) + "<-- Ends here\n===============================\n" + new String(end);
    }

    public final String toStringAction(int act) {
        switch (act) {
            case 6: {
                return "Identifier(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 99: {
                return "abstract";
            }
            case 25: {
                return "boolean";
            }
            case 130: {
                return "break";
            }
            case 26: {
                return "byte";
            }
            case 178: {
                return "case";
            }
            case 181: {
                return "catch";
            }
            case 27: {
                return "char";
            }
            case 176: {
                return "class";
            }
            case 131: {
                return "continue";
            }
            case 251: {
                return "default";
            }
            case 132: {
                return "do";
            }
            case 28: {
                return "double";
            }
            case 179: {
                return "else";
            }
            case 182: {
                return "extends";
            }
            case 51: {
                return "false";
            }
            case 100: {
                return "final";
            }
            case 183: {
                return "finally";
            }
            case 29: {
                return "float";
            }
            case 133: {
                return "for";
            }
            case 134: {
                return "if";
            }
            case 200: {
                return "implements";
            }
            case 173: {
                return "import";
            }
            case 22: {
                return "instanceof";
            }
            case 30: {
                return "int";
            }
            case 206: {
                return "interface";
            }
            case 31: {
                return "long";
            }
            case 101: {
                return "native";
            }
            case 46: {
                return "new";
            }
            case 52: {
                return "null";
            }
            case 180: {
                return "package";
            }
            case 102: {
                return "private";
            }
            case 103: {
                return "protected";
            }
            case 104: {
                return "public";
            }
            case 135: {
                return "return";
            }
            case 32: {
                return "short";
            }
            case 97: {
                return "static";
            }
            case 49: {
                return "super";
            }
            case 136: {
                return "switch";
            }
            case 95: {
                return "synchronized";
            }
            case 50: {
                return "this";
            }
            case 137: {
                return "throw";
            }
            case 170: {
                return "throws";
            }
            case 106: {
                return "transient";
            }
            case 53: {
                return "true";
            }
            case 138: {
                return "try";
            }
            case 33: {
                return "void";
            }
            case 107: {
                return "volatile";
            }
            case 128: {
                return "while";
            }
            case 54: {
                return "Integer(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 55: {
                return "Long(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 56: {
                return "Float(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 57: {
                return "Double(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 58: {
                return "Char(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 59: {
                return "String(" + new String(this.getCurrentTokenSource()) + ")";
            }
            case 3: {
                return "++";
            }
            case 4: {
                return "--";
            }
            case 45: {
                return "==";
            }
            case 35: {
                return "<=";
            }
            case 36: {
                return ">=";
            }
            case 47: {
                return "!=";
            }
            case 21: {
                return "<<";
            }
            case 19: {
                return ">>";
            }
            case 20: {
                return ">>>";
            }
            case 184: {
                return "+=";
            }
            case 185: {
                return "-=";
            }
            case 186: {
                return "*=";
            }
            case 187: {
                return "/=";
            }
            case 188: {
                return "&=";
            }
            case 189: {
                return "|=";
            }
            case 190: {
                return "^=";
            }
            case 191: {
                return "%=";
            }
            case 192: {
                return "<<=";
            }
            case 193: {
                return ">>=";
            }
            case 194: {
                return ">>>=";
            }
            case 84: {
                return "||";
            }
            case 83: {
                return "&&";
            }
            case 1: {
                return "+";
            }
            case 2: {
                return "-";
            }
            case 87: {
                return "!";
            }
            case 9: {
                return "%";
            }
            case 80: {
                return "^";
            }
            case 63: {
                return "&";
            }
            case 7: {
                return "*";
            }
            case 85: {
                return "|";
            }
            case 90: {
                return "~";
            }
            case 10: {
                return "/";
            }
            case 37: {
                return ">";
            }
            case 38: {
                return "<";
            }
            case 8: {
                return "(";
            }
            case 86: {
                return ")";
            }
            case 127: {
                return "{";
            }
            case 108: {
                return "}";
            }
            case 13: {
                return "[";
            }
            case 125: {
                return "]";
            }
            case 48: {
                return ";";
            }
            case 88: {
                return "?";
            }
            case 111: {
                return ":";
            }
            case 89: {
                return ",";
            }
            case 5: {
                return ".";
            }
            case 171: {
                return "=";
            }
            case 139: {
                return "EOF";
            }
        }
        return "not-a-token";
    }
}

