/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.compiler.SourceElementRequestorAdapter;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.Util;

class BinaryMethod
extends BinaryMember
implements IMethod {
    protected String[] fParameterTypes;
    protected String[] fParameterNames;
    protected static final String[] fgEmptyList = new String[0];
    protected String[] fExceptionTypes;
    protected String fReturnType;

    protected BinaryMethod(IType parent, String name, String[] parameterTypes) {
        super(9, parent, name);
        Assert.isTrue(name.indexOf(46) == -1);
        this.fParameterTypes = parameterTypes == null ? fgEmptyList : parameterTypes;
    }

    public boolean equals(Object o) {
        return super.equals(o) && Util.equalArraysOrNull(this.fParameterTypes, ((BinaryMethod)o).fParameterTypes);
    }

    public String[] getExceptionTypes() throws JavaModelException {
        if (this.fExceptionTypes == null) {
            IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
            char[][] eTypeNames = info.getExceptionTypeNames();
            if (eTypeNames == null || eTypeNames.length == 0) {
                this.fExceptionTypes = fgEmptyList;
            } else {
                eTypeNames = ClassFile.translatedNames(eTypeNames);
                this.fExceptionTypes = new String[eTypeNames.length];
                int j = 0;
                int length = eTypeNames.length;
                while (j < length) {
                    int nameLength = eTypeNames[j].length;
                    char[] convertedName = new char[nameLength + 2];
                    System.arraycopy(eTypeNames[j], 0, convertedName, 1, nameLength);
                    convertedName[0] = 76;
                    convertedName[nameLength + 1] = 59;
                    this.fExceptionTypes[j] = new String(convertedName);
                    ++j;
                }
            }
        }
        return this.fExceptionTypes;
    }

    public int getFlags() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        return info.getModifiers();
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer(((JavaElement)this.getParent()).getHandleMemento());
        buff.append(this.getHandleMementoDelimiter());
        buff.append(this.getElementName());
        int i = 0;
        while (i < this.fParameterTypes.length) {
            buff.append(this.getHandleMementoDelimiter());
            buff.append(this.fParameterTypes[i]);
            ++i;
        }
        return buff.toString();
    }

    protected char getHandleMementoDelimiter() {
        return '~';
    }

    public int getNumberOfParameters() {
        return this.fParameterTypes == null ? 0 : this.fParameterTypes.length;
    }

    public String[] getParameterNames() throws JavaModelException {
        if (this.fParameterNames == null) {
            IType type = (IType)this.getParent();
            SourceMapper mapper = this.getSourceMapper();
            if (mapper != null) {
                char[][] parameterNames = mapper.getMethodParameterNames(this);
                if (parameterNames == null) {
                    char[] source = mapper.findSource(type);
                    if (source != null) {
                        mapper.mapSource(type, source);
                    }
                    parameterNames = mapper.getMethodParameterNames(this);
                }
                if (parameterNames != null) {
                    this.fParameterNames = new String[parameterNames.length];
                    int i = 0;
                    while (i < parameterNames.length) {
                        this.fParameterNames[i] = new String(parameterNames[i]);
                        ++i;
                    }
                }
            }
            if (this.fParameterNames == null) {
                IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
                int paramCount = Signature.getParameterCount(new String(info.getMethodDescriptor()));
                this.fParameterNames = new String[paramCount];
                int i = 0;
                while (i < paramCount) {
                    this.fParameterNames[i] = "arg" + i;
                    ++i;
                }
            }
        }
        return this.fParameterNames;
    }

    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    public String getReturnType() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        if (this.fReturnType == null) {
            String returnType = Signature.getReturnType(new String(info.getMethodDescriptor()));
            this.fReturnType = new String(ClassFile.translatedName(returnType.toCharArray()));
        }
        return this.fReturnType;
    }

    public String getSignature() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        return new String(info.getMethodDescriptor());
    }

    public boolean isConstructor() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        return info.isConstructor();
    }

    public boolean isMainMethod() throws JavaModelException {
        return this.isMainMethod(this);
    }

    public boolean isSimilar(IMethod method) {
        return this.areSimilarMethods(this.getElementName(), this.getParameterTypes(), method.getElementName(), method.getParameterTypes(), null);
    }

    public String readableName() {
        int length;
        StringBuffer buffer = new StringBuffer(super.readableName());
        buffer.append("(");
        String[] parameterTypes = this.getParameterTypes();
        if (parameterTypes != null && (length = parameterTypes.length) > 0) {
            int i = 0;
            while (i < length) {
                buffer.append(Signature.toString(parameterTypes[i]));
                if (i < length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            buffer.append(this.getElementName());
            buffer.append(" (not open)");
        } else if (info == JavaElement.NO_INFO) {
            buffer.append(this.getElementName());
        } else {
            try {
                int length;
                if (Flags.isStatic(this.getFlags())) {
                    buffer.append("static ");
                }
                if (!this.isConstructor()) {
                    buffer.append(Signature.toString(this.getReturnType()));
                    buffer.append(' ');
                }
                buffer.append(this.getElementName());
                buffer.append('(');
                String[] parameterTypes = this.getParameterTypes();
                if (parameterTypes != null && (length = parameterTypes.length) > 0) {
                    int i = 0;
                    while (i < length) {
                        buffer.append(Signature.toString(parameterTypes[i]));
                        if (i < length - 1) {
                            buffer.append(", ");
                        }
                        ++i;
                    }
                }
                buffer.append(')');
            }
            catch (JavaModelException e) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }

    class DecodeParametersNames
    extends SourceElementRequestorAdapter {
        String[] parametersNames;

        DecodeParametersNames() {
        }

        public void enterMethod(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
            if (parameterNames != null) {
                int length = parameterNames.length;
                this.parametersNames = new String[length];
                int i = 0;
                while (i < length) {
                    this.parametersNames[i] = new String(parameterNames[i]);
                    ++i;
                }
            }
        }

        public void enterConstructor(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
            if (parameterNames != null) {
                int length = parameterNames.length;
                this.parametersNames = new String[length];
                int i = 0;
                while (i < length) {
                    this.parametersNames[i] = new String(parameterNames[i]);
                    ++i;
                }
            }
        }

        public String[] getParametersNames() {
            return this.parametersNames;
        }
    }
}

