/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.MultiOperation;
import org.eclipse.jdt.internal.core.Region;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.jdom.DOMNode;

public class DeleteElementsOperation
extends MultiOperation {
    protected Map fChildrenToRemove;
    protected DOMFactory fFactory = new DOMFactory();

    public DeleteElementsOperation(IJavaElement[] elementsToDelete, boolean force) {
        super(elementsToDelete, force);
    }

    protected String getMainTaskName() {
        return Util.bind("operation.deleteElementProgress");
    }

    protected void groupElements() throws JavaModelException {
        this.fChildrenToRemove = new HashMap(1);
        int uniqueCUs = 0;
        int i = 0;
        int length = this.fElementsToProcess.length;
        while (i < length) {
            IJavaElement e = this.fElementsToProcess[i];
            ICompilationUnit cu = this.getCompilationUnitFor(e);
            if (cu == null) {
                throw new JavaModelException(new JavaModelStatus(976, e));
            }
            IRegion region = (IRegion)this.fChildrenToRemove.get(cu);
            if (region == null) {
                region = new Region();
                this.fChildrenToRemove.put(cu, region);
                ++uniqueCUs;
            }
            region.add(e);
            ++i;
        }
        this.fElementsToProcess = new IJavaElement[uniqueCUs];
        Iterator iter = this.fChildrenToRemove.keySet().iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            this.fElementsToProcess[i2++] = (IJavaElement)iter.next();
        }
    }

    protected void processElement(IJavaElement element) throws JavaModelException {
        ICompilationUnit cu = (ICompilationUnit)element;
        int numberOfImports = cu.getImports().length;
        IBuffer buffer = cu.getBuffer();
        if (buffer == null) {
            return;
        }
        JavaElementDelta delta = new JavaElementDelta(cu);
        IJavaElement[] cuElements = ((IRegion)this.fChildrenToRemove.get(cu)).getElements();
        int i = 0;
        int length = cuElements.length;
        while (i < length) {
            char[] contents;
            IJavaElement e = cuElements[i];
            if (e.exists() && (contents = buffer.getCharacters()) != null) {
                IDOMCompilationUnit cuDOM = this.fFactory.createCompilationUnit(contents, cu.getElementName());
                DOMNode node = (DOMNode)((JavaElement)e).findNode(cuDOM);
                if (node == null) {
                    Assert.isTrue(false, "Failed to locate " + e.getElementName() + " in " + cuDOM.getName());
                }
                int startPosition = node.getStartPosition();
                buffer.replace(startPosition, node.getEndPosition() - startPosition + 1, CharOperation.NO_CHAR);
                delta.removed(e);
                if (e.getElementType() == 13 && --numberOfImports == 0) {
                    delta.removed(cu.getImportContainer());
                }
            }
            ++i;
        }
        if (delta.getAffectedChildren().length > 0) {
            cu.save(this.getSubProgressMonitor(1), this.fForce);
            if (!cu.isWorkingCopy()) {
                this.addDelta(delta);
                this.setAttribute("hasModifiedResource", "true");
            }
        }
    }

    protected void processElements() throws JavaModelException {
        this.groupElements();
        super.processElements();
    }

    protected void verify(IJavaElement element) throws JavaModelException {
        IJavaElement[] children = ((IRegion)this.fChildrenToRemove.get(element)).getElements();
        int i = 0;
        while (i < children.length) {
            IJavaElement child = children[i];
            if (child.getCorrespondingResource() != null) {
                this.error(967, child);
            }
            if (child.isReadOnly()) {
                this.error(976, child);
            }
            ++i;
        }
    }
}

