/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.DeltaProcessor;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.JavaProjectElementInfo;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragmentInfo;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.PackageFragmentRootInfo;
import org.eclipse.jdt.internal.core.SetClasspathOperation;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;

public class DeltaProcessor
implements IResourceChangeListener {
    static final int IGNORE = 0;
    static final int SOURCE = 1;
    static final int BINARY = 2;
    static final String EXTERNAL_JAR_ADDED = "external jar added";
    static final String EXTERNAL_JAR_REMOVED = "external jar removed";
    static final String EXTERNAL_JAR_CHANGED = "external jar changed";
    static final String EXTERNAL_JAR_UNCHANGED = "external jar unchanged";
    static final String INTERNAL_JAR_IGNORE = "internal jar ignore";
    static final int NON_JAVA_RESOURCE = -1;
    protected JavaElementDelta currentDelta;
    protected IndexManager indexManager = new IndexManager();
    public Map roots;
    Map otherRoots;
    public boolean rootsAreStale = true;
    public Map oldRoots;
    Map oldOtherRoots;
    Map sourceAttachments;
    Openable currentElement;
    public HashMap externalTimeStamps = new HashMap();
    public HashSet projectsToUpdate = new HashSet();
    public HashSet projectsForDependentNamelookupRefresh = new HashSet();
    JavaModelManager manager;
    Map removedRoots;
    HashSet refreshedElements;
    public static boolean VERBOSE = false;

    DeltaProcessor(JavaModelManager manager) {
        this.manager = manager;
    }

    void addDependentProjects(IPath projectPath, HashSet result) {
        try {
            IJavaProject[] projects = this.manager.getJavaModel().getJavaProjects();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IJavaProject project = projects[i];
                IClasspathEntry[] classpath = ((JavaProject)project).getExpandedClasspath(true);
                int j = 0;
                int length2 = classpath.length;
                while (j < length2) {
                    IClasspathEntry entry = classpath[j];
                    if (entry.getEntryKind() == 2 && entry.getPath().equals(projectPath)) {
                        result.add(project);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    public void addForRefresh(IJavaElement element) {
        if (this.refreshedElements == null) {
            this.refreshedElements = new HashSet();
        }
        this.refreshedElements.add(element);
    }

    void addToProjectsToUpdateWithDependents(IProject project) {
        this.projectsToUpdate.add(JavaCore.create(project));
        this.addDependentProjects(project.getFullPath(), this.projectsToUpdate);
    }

    protected void addToParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                JavaElementInfo info = (JavaElementInfo)parent.getElementInfo();
                info.addChild(child);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    public void checkExternalArchiveChanges(IJavaElement[] refreshedElements, IProgressMonitor monitor) throws JavaModelException {
        block9: {
            try {
                int i = 0;
                int length = refreshedElements.length;
                while (i < length) {
                    this.addForRefresh(refreshedElements[i]);
                    ++i;
                }
                boolean hasDelta = this.createExternalArchiveDelta(monitor);
                if (monitor != null && monitor.isCanceled()) {
                    Object var8_6 = null;
                    this.currentDelta = null;
                    if (monitor != null) {
                        monitor.done();
                    }
                    return;
                }
                if (hasDelta) {
                    JavaModel.flushExternalFileCache();
                    IJavaElementDelta[] projectDeltas = this.currentDelta.getAffectedChildren();
                    int i2 = 0;
                    int length2 = projectDeltas.length;
                    while (i2 < length2) {
                        IJavaElementDelta delta = projectDeltas[i2];
                        ((JavaProject)delta.getElement()).getResolvedClasspath(true, true);
                        ++i2;
                    }
                    if (this.currentDelta != null) {
                        this.manager.fire(this.currentDelta, 0);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.currentDelta = null;
                if (monitor != null) {
                    monitor.done();
                }
                throw throwable;
            }
            Object var8_8 = null;
            this.currentDelta = null;
            if (monitor == null) break block9;
            monitor.done();
        }
    }

    public boolean createExternalArchiveDelta(IProgressMonitor monitor) throws JavaModelException {
        if (this.refreshedElements == null) {
            return false;
        }
        HashMap<IPath, String> externalArchivesStatus = new HashMap<IPath, String>();
        boolean hasDelta = false;
        HashSet<IPath> archivePathsToRefresh = new HashSet<IPath>();
        try {
            Iterator iterator = this.refreshedElements.iterator();
            block7: while (iterator.hasNext()) {
                IJavaElement element = (IJavaElement)iterator.next();
                switch (element.getElementType()) {
                    case 3: {
                        archivePathsToRefresh.add(element.getPath());
                        break;
                    }
                    case 2: {
                        IJavaProject project = (IJavaProject)element;
                        if (!JavaProject.hasJavaNature(project.getProject())) continue block7;
                        IClasspathEntry[] classpath = project.getResolvedClasspath(true);
                        int j = 0;
                        int cpLength = classpath.length;
                        while (j < cpLength) {
                            if (classpath[j].getEntryKind() == 1) {
                                archivePathsToRefresh.add(classpath[j].getPath());
                            }
                            ++j;
                        }
                        continue block7;
                    }
                    case 1: {
                        IClasspathEntry[] classpath;
                        IJavaProject project;
                        IJavaProject[] projects = this.manager.getJavaModel().getOldJavaProjectsList();
                        int j = 0;
                        int projectsLength = projects.length;
                        while (j < projectsLength) {
                            project = projects[j];
                            if (JavaProject.hasJavaNature(project.getProject())) {
                                classpath = project.getResolvedClasspath(true);
                                int k = 0;
                                int cpLength = classpath.length;
                                while (k < cpLength) {
                                    if (classpath[k].getEntryKind() == 1) {
                                        archivePathsToRefresh.add(classpath[k].getPath());
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        continue block7;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var14_25 = null;
            this.refreshedElements = null;
            throw throwable;
        }
        Object var14_26 = null;
        this.refreshedElements = null;
        IJavaProject[] projects = this.manager.getJavaModel().getOldJavaProjectsList();
        IWorkspaceRoot wksRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        int length = projects.length;
        while (i < length) {
            if (monitor != null && monitor.isCanceled()) break;
            IJavaProject project = projects[i];
            if (JavaProject.hasJavaNature(project.getProject())) {
                IClasspathEntry[] entries = project.getResolvedClasspath(true);
                int j = 0;
                while (j < entries.length) {
                    IPath entryPath;
                    if (entries[j].getEntryKind() == 1 && archivePathsToRefresh.contains(entryPath = entries[j].getPath())) {
                        String status = (String)externalArchivesStatus.get(entryPath);
                        if (status == null) {
                            Object targetLibrary = JavaModel.getTarget(wksRoot, entryPath, true);
                            if (targetLibrary == null) {
                                if (this.externalTimeStamps.containsKey(entryPath)) {
                                    this.externalTimeStamps.remove(entryPath);
                                    externalArchivesStatus.put(entryPath, EXTERNAL_JAR_REMOVED);
                                    this.indexManager.removeIndex(entryPath);
                                }
                            } else if (targetLibrary instanceof File) {
                                File externalFile = (File)targetLibrary;
                                Long oldTimestamp = (Long)this.externalTimeStamps.get(entryPath);
                                long newTimeStamp = DeltaProcessor.getTimeStamp(externalFile);
                                if (oldTimestamp != null) {
                                    if (newTimeStamp == 0L) {
                                        externalArchivesStatus.put(entryPath, EXTERNAL_JAR_REMOVED);
                                        this.externalTimeStamps.remove(entryPath);
                                        this.indexManager.removeIndex(entryPath);
                                    } else if (oldTimestamp != newTimeStamp) {
                                        externalArchivesStatus.put(entryPath, EXTERNAL_JAR_CHANGED);
                                        this.externalTimeStamps.put(entryPath, new Long(newTimeStamp));
                                        this.indexManager.removeIndex(entryPath);
                                        this.indexManager.indexLibrary(entryPath, project.getProject());
                                    } else {
                                        externalArchivesStatus.put(entryPath, EXTERNAL_JAR_UNCHANGED);
                                    }
                                } else if (newTimeStamp == 0L) {
                                    externalArchivesStatus.put(entryPath, EXTERNAL_JAR_UNCHANGED);
                                } else {
                                    externalArchivesStatus.put(entryPath, EXTERNAL_JAR_ADDED);
                                    this.externalTimeStamps.put(entryPath, new Long(newTimeStamp));
                                    this.indexManager.indexLibrary(entryPath, project.getProject());
                                }
                            } else {
                                externalArchivesStatus.put(entryPath, INTERNAL_JAR_IGNORE);
                            }
                        }
                        if ((status = (String)externalArchivesStatus.get(entryPath)) != null) {
                            PackageFragmentRoot root;
                            if (status == EXTERNAL_JAR_ADDED) {
                                root = (PackageFragmentRoot)project.getPackageFragmentRoot(entryPath.toString());
                                if (VERBOSE) {
                                    System.out.println("- External JAR ADDED, affecting root: " + root.getElementName());
                                }
                                this.elementAdded(root, null, null);
                                hasDelta = true;
                            } else if (status == EXTERNAL_JAR_CHANGED) {
                                root = (PackageFragmentRoot)project.getPackageFragmentRoot(entryPath.toString());
                                if (VERBOSE) {
                                    System.out.println("- External JAR CHANGED, affecting root: " + root.getElementName());
                                }
                                this.manager.setLastBuiltState(project.getProject(), null);
                                this.contentChanged(root, null);
                                hasDelta = true;
                            } else if (status == EXTERNAL_JAR_REMOVED) {
                                root = (PackageFragmentRoot)project.getPackageFragmentRoot(entryPath.toString());
                                if (VERBOSE) {
                                    System.out.println("- External JAR REMOVED, affecting root: " + root.getElementName());
                                }
                                this.elementRemoved(root, null, null);
                                hasDelta = true;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return hasDelta;
    }

    JavaElementDelta currentDelta() {
        if (this.currentDelta == null) {
            this.currentDelta = new JavaElementDelta(this.manager.getJavaModel());
        }
        return this.currentDelta;
    }

    public void checkProjectsBeingAddedOrRemoved(IResourceDelta delta) {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                if (this.manager.javaProjectsCache == null) {
                    try {
                        this.manager.javaProjectsCache = this.manager.getJavaModel().getJavaProjects();
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
                IResourceDelta[] children = delta.getAffectedChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    this.checkProjectsBeingAddedOrRemoved(children[i]);
                    ++i;
                }
                break;
            }
            case 4: {
                int deltaKind = delta.getKind();
                if (deltaKind == 1) {
                    IProject project = (IProject)resource;
                    this.addToProjectsToUpdateWithDependents(project);
                    if (!JavaProject.hasJavaNature(project)) break;
                    this.addToParentInfo((JavaProject)JavaCore.create(project));
                    break;
                }
                if (deltaKind != 4) break;
                IProject project = (IProject)resource;
                if ((delta.getFlags() & 0x4000) != 0) {
                    this.addToProjectsToUpdateWithDependents(project);
                    if (project.isOpen()) {
                        if (!JavaProject.hasJavaNature(project)) break;
                        this.addToParentInfo((JavaProject)JavaCore.create(project));
                        break;
                    }
                    JavaProject javaProject = (JavaProject)this.manager.getJavaModel().findJavaProject(project);
                    if (javaProject == null) break;
                    try {
                        javaProject.close();
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                    this.removeFromParentInfo(javaProject);
                    break;
                }
                if ((delta.getFlags() & 0x80000) != 0) {
                    boolean isJavaProject;
                    boolean wasJavaProject = this.manager.getJavaModel().findJavaProject(project) != null;
                    if (wasJavaProject != (isJavaProject = JavaProject.hasJavaNature(project))) {
                        this.addToProjectsToUpdateWithDependents(project);
                        if (isJavaProject) {
                            this.addToParentInfo((JavaProject)JavaCore.create(project));
                            break;
                        }
                        JavaProject javaProject = (JavaProject)JavaCore.create(project);
                        javaProject.flushClasspathProblemMarkers(true, true);
                        JavaBuilder.removeProblemsAndTasksFor(project);
                        try {
                            javaProject.close();
                        }
                        catch (JavaModelException javaModelException) {
                            // empty catch block
                        }
                        this.removeFromParentInfo(javaProject);
                        break;
                    }
                    if (!JavaProject.hasJavaNature(project)) break;
                    this.addToParentInfo((JavaProject)JavaCore.create(project));
                    break;
                }
                if (!JavaProject.hasJavaNature(project)) break;
                this.addToParentInfo((JavaProject)JavaCore.create(project));
            }
        }
    }

    private void checkSourceAttachmentChange(IResourceDelta delta, IResource res) {
        RootInfo rootInfo;
        IPath rootPath = (IPath)this.sourceAttachments.get(res.getFullPath());
        if (rootPath != null && (rootInfo = this.rootInfo(rootPath, delta.getKind())) != null) {
            IJavaProject projectOfRoot = rootInfo.project;
            IPackageFragmentRoot root = null;
            try {
                root = projectOfRoot.findPackageFragmentRoot(rootPath);
                if (root != null) {
                    root.close();
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            if (root == null) {
                return;
            }
            switch (delta.getKind()) {
                case 1: {
                    this.currentDelta().sourceAttached(root);
                    break;
                }
                case 4: {
                    this.currentDelta().sourceDetached(root);
                    this.currentDelta().sourceAttached(root);
                    break;
                }
                case 2: {
                    this.currentDelta().sourceDetached(root);
                }
            }
        }
    }

    protected static void close(Openable element) {
        try {
            element.close();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    protected void contentChanged(Openable element, IResourceDelta delta) {
        DeltaProcessor.close(element);
        int flags = 1;
        if (element instanceof JarPackageFragmentRoot) {
            flags |= 0x8000;
        }
        this.currentDelta().changed(element, flags);
    }

    protected Openable createElement(IResource resource, int elementType, RootInfo rootInfo) {
        if (resource == null) {
            return null;
        }
        IPath path = resource.getFullPath();
        IJavaElement element = null;
        switch (elementType) {
            case 2: {
                if (!(resource instanceof IProject)) break;
                this.popUntilPrefixOf(path);
                if (this.currentElement != null && this.currentElement.getElementType() == 2 && ((IJavaProject)((Object)this.currentElement)).getProject().equals(resource)) {
                    return this.currentElement;
                }
                if (rootInfo != null && rootInfo.project.getProject().equals(resource)) {
                    element = (Openable)((Object)rootInfo.project);
                    break;
                }
                IProject proj = (IProject)resource;
                if (JavaProject.hasJavaNature(proj)) {
                    element = JavaCore.create(proj);
                    break;
                }
                element = (Openable)((Object)this.manager.getJavaModel().findJavaProject(proj));
                break;
            }
            case 3: {
                element = rootInfo == null ? JavaCore.create(resource) : rootInfo.project.getPackageFragmentRoot(resource);
                break;
            }
            case 4: {
                this.popUntilPrefixOf(path);
                if (this.currentElement == null) {
                    element = rootInfo == null ? JavaCore.create(resource) : JavaModelManager.create(resource, rootInfo.project);
                    break;
                }
                PackageFragmentRoot root = this.currentElement.getPackageFragmentRoot();
                if (root == null) {
                    element = rootInfo == null ? JavaCore.create(resource) : JavaModelManager.create(resource, rootInfo.project);
                    break;
                }
                if (!((JavaProject)root.getJavaProject()).contains(resource)) break;
                IPath pkgPath = path.removeFirstSegments(root.getPath().segmentCount());
                String pkg = Util.packageName(pkgPath);
                if (pkg == null) {
                    return null;
                }
                element = root.getPackageFragment(pkg);
                break;
            }
            case 5: 
            case 6: {
                String fileName;
                this.popUntilPrefixOf(path);
                if (this.currentElement == null) {
                    element = rootInfo == null ? JavaCore.create(resource) : JavaModelManager.create(resource, rootInfo.project);
                    break;
                }
                IPackageFragment pkgFragment = null;
                switch (this.currentElement.getElementType()) {
                    case 3: {
                        IPackageFragmentRoot root = (IPackageFragmentRoot)((Object)this.currentElement);
                        IPath rootPath = root.getPath();
                        IPath pkgPath = path.removeLastSegments(1);
                        String pkgName = Util.packageName(pkgPath.removeFirstSegments(rootPath.segmentCount()));
                        if (pkgName == null) break;
                        pkgFragment = root.getPackageFragment(pkgName);
                        break;
                    }
                    case 4: {
                        Openable pkg = this.currentElement;
                        if (!pkg.getPath().equals(path.removeLastSegments(1))) break;
                        pkgFragment = (IPackageFragment)((Object)pkg);
                        break;
                    }
                    case 5: 
                    case 6: {
                        pkgFragment = (IPackageFragment)this.currentElement.getParent();
                    }
                }
                if (pkgFragment == null) {
                    element = rootInfo == null ? JavaCore.create(resource) : JavaModelManager.create(resource, rootInfo.project);
                    break;
                }
                if (elementType == 5) {
                    fileName = path.lastSegment();
                    element = pkgFragment.getCompilationUnit(fileName);
                    break;
                }
                fileName = path.lastSegment();
                element = pkgFragment.getClassFile(fileName);
            }
        }
        if (element == null) {
            return null;
        }
        this.currentElement = (Openable)element;
        return this.currentElement;
    }

    public void deleting(IProject project) {
        try {
            this.indexManager.discardJobs(project.getName());
            JavaProject javaProject = (JavaProject)JavaCore.create(project);
            if (this.removedRoots == null) {
                this.removedRoots = new HashMap();
            }
            if (javaProject.isOpen()) {
                this.removedRoots.put(javaProject, javaProject.getPackageFragmentRoots());
            } else {
                this.removedRoots.put(javaProject, javaProject.computePackageFragmentRoots(javaProject.getResolvedClasspath(true), false));
            }
            javaProject.close();
            if (this.manager.javaProjectsCache == null) {
                this.manager.javaProjectsCache = this.manager.getJavaModel().getJavaProjects();
            }
            this.removeFromParentInfo(javaProject);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        this.addDependentProjects(project.getFullPath(), this.projectsToUpdate);
    }

    protected void elementAdded(Openable element, IResourceDelta delta, RootInfo rootInfo) {
        int elementType = element.getElementType();
        if (elementType == 2) {
            if (delta != null && JavaProject.hasJavaNature((IProject)delta.getResource())) {
                this.addToParentInfo(element);
                if ((delta.getFlags() & 0x1000) != 0) {
                    Openable movedFromElement = (Openable)((Object)element.getJavaModel().getJavaProject(delta.getMovedFromPath().lastSegment()));
                    this.currentDelta().movedTo(element, movedFromElement);
                } else {
                    this.currentDelta().added(element);
                }
                this.projectsToUpdate.add(element);
                this.updateRoots(element.getPath(), delta);
                this.projectsForDependentNamelookupRefresh.add((JavaProject)element);
            }
        } else {
            this.addToParentInfo(element);
            DeltaProcessor.close(element);
            if (delta != null && (delta.getFlags() & 0x1000) != 0) {
                Openable movedFromElement;
                IPath movedFromPath = delta.getMovedFromPath();
                IResource res = delta.getResource();
                IResource movedFromRes = res instanceof IFile ? res.getWorkspace().getRoot().getFile(movedFromPath) : res.getWorkspace().getRoot().getFolder(movedFromPath);
                RootInfo movedFromInfo = this.enclosingRootInfo(movedFromPath, 2);
                int movedFromType = this.elementType(movedFromRes, 2, element.getParent().getElementType(), movedFromInfo);
                this.currentElement = null;
                Openable openable = movedFromElement = elementType != 2 && movedFromType == 2 ? null : this.createElement(movedFromRes, movedFromType, movedFromInfo);
                if (movedFromElement == null) {
                    this.currentDelta().added(element);
                } else {
                    this.currentDelta().movedTo(element, movedFromElement);
                }
            } else {
                this.currentDelta().added(element);
            }
            switch (elementType) {
                case 3: {
                    JavaProject project = (JavaProject)element.getJavaProject();
                    this.projectsToUpdate.add(project);
                    this.projectsForDependentNamelookupRefresh.add(project);
                    break;
                }
                case 4: {
                    JavaProject project = (JavaProject)element.getJavaProject();
                    try {
                        project.getJavaProjectElementInfo().setNameLookup(null);
                        this.projectsForDependentNamelookupRefresh.add(project);
                    }
                    catch (JavaModelException res) {
                        // empty catch block
                    }
                    if (delta == null) break;
                    PackageFragmentRoot root = element.getPackageFragmentRoot();
                    String name = element.getElementName();
                    IResourceDelta[] children = delta.getAffectedChildren();
                    int i = 0;
                    int length = children.length;
                    while (i < length) {
                        String folderName;
                        IResourceDelta child = children[i];
                        IResource resource = child.getResource();
                        if (resource instanceof IFolder && Util.isValidFolderNameForPackage(folderName = resource.getName())) {
                            String subpkgName = name.length() == 0 ? folderName : String.valueOf(name) + "." + folderName;
                            Openable subpkg = (Openable)((Object)root.getPackageFragment(subpkgName));
                            this.updateIndex(subpkg, child);
                            this.elementAdded(subpkg, child, rootInfo);
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
    }

    protected void elementRemoved(Openable element, IResourceDelta delta, RootInfo rootInfo) {
        if (element.isOpen()) {
            DeltaProcessor.close(element);
        }
        this.removeFromParentInfo(element);
        int elementType = element.getElementType();
        if (delta != null && (delta.getFlags() & 0x2000) != 0) {
            Openable movedToElement;
            IResource movedToRes;
            IPath movedToPath = delta.getMovedToPath();
            IResource res = delta.getResource();
            switch (res.getType()) {
                case 4: {
                    movedToRes = res.getWorkspace().getRoot().getProject(movedToPath.lastSegment());
                    break;
                }
                case 2: {
                    movedToRes = res.getWorkspace().getRoot().getFolder(movedToPath);
                    break;
                }
                case 1: {
                    movedToRes = res.getWorkspace().getRoot().getFile(movedToPath);
                    break;
                }
                default: {
                    return;
                }
            }
            RootInfo movedToInfo = this.enclosingRootInfo(movedToPath, 1);
            int movedToType = this.elementType(movedToRes, 1, element.getParent().getElementType(), movedToInfo);
            this.currentElement = null;
            Openable openable = movedToElement = elementType != 2 && movedToType == 2 ? null : this.createElement(movedToRes, movedToType, movedToInfo);
            if (movedToElement == null) {
                this.currentDelta().removed(element);
            } else {
                this.currentDelta().movedFrom(element, movedToElement);
            }
        } else {
            this.currentDelta().removed(element);
        }
        switch (elementType) {
            case 1: {
                this.indexManager.reset();
                break;
            }
            case 2: {
                this.manager.removePerProjectInfo((JavaProject)element);
                this.updateRoots(element.getPath(), delta);
                this.projectsForDependentNamelookupRefresh.add((JavaProject)element);
                break;
            }
            case 3: {
                JavaProject project = (JavaProject)element.getJavaProject();
                this.projectsToUpdate.add(project);
                this.projectsForDependentNamelookupRefresh.add(project);
                break;
            }
            case 4: {
                JavaProject project = (JavaProject)element.getJavaProject();
                try {
                    project.getJavaProjectElementInfo().setNameLookup(null);
                    this.projectsForDependentNamelookupRefresh.add(project);
                }
                catch (JavaModelException res) {
                    // empty catch block
                }
                if (delta == null) break;
                PackageFragmentRoot root = element.getPackageFragmentRoot();
                String name = element.getElementName();
                IResourceDelta[] children = delta.getAffectedChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    String folderName;
                    IResourceDelta child = children[i];
                    IResource resource = child.getResource();
                    if (resource instanceof IFolder && Util.isValidFolderNameForPackage(folderName = resource.getName())) {
                        String subpkgName = name.length() == 0 ? folderName : String.valueOf(name) + "." + folderName;
                        Openable subpkg = (Openable)((Object)root.getPackageFragment(subpkgName));
                        this.updateIndex(subpkg, child);
                        this.elementRemoved(subpkg, child, rootInfo);
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private int elementType(IResource res, int kind, int parentType, RootInfo rootInfo) {
        switch (parentType) {
            case 1: {
                return 2;
            }
            case -1: 
            case 2: {
                if (rootInfo == null) {
                    rootInfo = this.enclosingRootInfo(res.getFullPath(), kind);
                }
                if (rootInfo != null && rootInfo.isRootOfProject(res.getFullPath())) {
                    return 3;
                }
                return -1;
            }
            case 3: 
            case 4: {
                if (rootInfo == null) {
                    rootInfo = this.enclosingRootInfo(res.getFullPath(), kind);
                }
                if (rootInfo == null || Util.isExcluded(res, rootInfo.exclusionPatterns)) {
                    return -1;
                }
                if (res instanceof IFolder) {
                    if (Util.isValidFolderNameForPackage(res.getName())) {
                        return 4;
                    }
                    return -1;
                }
                String fileName = res.getName();
                if (Util.isValidCompilationUnitName(fileName)) {
                    return 5;
                }
                if (Util.isValidClassFileName(fileName)) {
                    return 6;
                }
                if (this.rootInfo(res.getFullPath(), kind) != null) {
                    return 3;
                }
                return -1;
            }
        }
        return -1;
    }

    public static long getTimeStamp(File file) {
        return file.lastModified() + file.length();
    }

    public void initializeRoots() {
        IJavaProject[] projects;
        this.oldRoots = this.roots == null ? new HashMap() : this.roots;
        Map map = this.oldOtherRoots = this.otherRoots == null ? new HashMap() : this.otherRoots;
        if (!this.rootsAreStale) {
            return;
        }
        this.roots = new HashMap();
        this.otherRoots = new HashMap();
        this.sourceAttachments = new HashMap();
        JavaModel model = this.manager.getJavaModel();
        try {
            projects = model.getJavaProjects();
        }
        catch (JavaModelException e) {
            return;
        }
        int i = 0;
        int length = projects.length;
        while (i < length) {
            block15: {
                IClasspathEntry[] classpath;
                IJavaProject project = projects[i];
                try {
                    classpath = project.getResolvedClasspath(true);
                }
                catch (JavaModelException e) {
                    break block15;
                }
                int j = 0;
                int classpathLength = classpath.length;
                while (j < classpathLength) {
                    block16: {
                        IClasspathEntry entry = classpath[j];
                        if (entry.getEntryKind() != 2) {
                            IPath path = entry.getPath();
                            if (this.roots.get(path) == null) {
                                this.roots.put(path, new RootInfo(project, path, ((ClasspathEntry)entry).fullExclusionPatternChars()));
                            } else {
                                ArrayList<RootInfo> rootList = (ArrayList<RootInfo>)this.otherRoots.get(path);
                                if (rootList == null) {
                                    rootList = new ArrayList<RootInfo>();
                                    this.otherRoots.put(path, rootList);
                                }
                                rootList.add(new RootInfo(project, path, ((ClasspathEntry)entry).fullExclusionPatternChars()));
                            }
                            if (entry.getEntryKind() == 1) {
                                int index;
                                QualifiedName qName = new QualifiedName("org.eclipse.jdt.core", "sourceattachment: " + path.toOSString());
                                String propertyString = null;
                                try {
                                    propertyString = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(qName);
                                }
                                catch (CoreException e) {
                                    break block16;
                                }
                                IPath sourceAttachmentPath = propertyString != null ? ((index = propertyString.lastIndexOf(42)) < 0 ? new Path(propertyString) : new Path(propertyString.substring(0, index))) : entry.getSourceAttachmentPath();
                                if (sourceAttachmentPath != null) {
                                    this.sourceAttachments.put(sourceAttachmentPath, path);
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.rootsAreStale = false;
    }

    public boolean isAffectedBy(IResourceDelta rootDelta) {
        if (rootDelta != null) {
            class FoundRelevantDeltaException
            extends RuntimeException {
                final /* synthetic */ DeltaProcessor this$0;

                FoundRelevantDeltaException(DeltaProcessor deltaProcessor) {
                    this.this$0 = deltaProcessor;
                }
            }
            try {
                rootDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        switch (delta.getKind()) {
                            case 1: 
                            case 2: {
                                throw new FoundRelevantDeltaException(DeltaProcessor.this);
                            }
                            case 4: {
                                if (delta.getAffectedChildren().length != 0 || (delta.getFlags() & 0xFFFCFFFF) == 0) break;
                                throw new FoundRelevantDeltaException(DeltaProcessor.this);
                            }
                        }
                        return true;
                    }
                });
            }
            catch (FoundRelevantDeltaException e) {
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isResFilteredFromOutput(OutputsInfo info, IResource res, int elementType) {
        if (info != null) {
            IPath resPath = res.getFullPath();
            int i = 0;
            while (i < info.outputCount) {
                if (info.paths[i].isPrefixOf(resPath)) {
                    if (info.traverseModes[i] != 0) {
                        if (info.traverseModes[i] == 1 && elementType == 6) {
                            return true;
                        }
                        if (elementType == 2 && res instanceof IFile && Util.isValidClassFileName(res.getName())) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    protected void nonJavaResourcesChanged(Openable element, IResourceDelta delta) throws JavaModelException {
        JavaElementDelta elementDelta;
        if (element.isOpen()) {
            JavaElementInfo info = (JavaElementInfo)element.getElementInfo();
            switch (element.getElementType()) {
                case 1: {
                    ((JavaModelInfo)info).nonJavaResources = null;
                    this.currentDelta().addResourceDelta(delta);
                    return;
                }
                case 2: {
                    ((JavaProjectElementInfo)info).setNonJavaResources(null);
                    JavaProject project = (JavaProject)element;
                    PackageFragmentRoot projectRoot = (PackageFragmentRoot)project.getPackageFragmentRoot(project.getProject());
                    if (!projectRoot.isOpen()) break;
                    ((PackageFragmentRootInfo)projectRoot.getElementInfo()).setNonJavaResources(null);
                    break;
                }
                case 4: {
                    ((PackageFragmentInfo)info).setNonJavaResources(null);
                    break;
                }
                case 3: {
                    ((PackageFragmentRootInfo)info).setNonJavaResources(null);
                }
            }
        }
        if ((elementDelta = this.currentDelta().find(element)) == null) {
            this.currentDelta().changed(element, 1);
            elementDelta = this.currentDelta().find(element);
        }
        elementDelta.addResourceDelta(delta);
    }

    private OutputsInfo outputsInfo(RootInfo rootInfo, IResource res) {
        try {
            IJavaProject proj;
            IJavaProject iJavaProject = proj = rootInfo == null ? (IJavaProject)((Object)this.createElement(res.getProject(), 2, null)) : rootInfo.project;
            if (proj != null) {
                IPath projectOutput = proj.getOutputLocation();
                int traverseMode = 0;
                if (proj.getProject().getFullPath().equals(projectOutput)) {
                    return new OutputsInfo(new IPath[]{projectOutput}, new int[]{1}, 1);
                }
                IClasspathEntry[] classpath = proj.getResolvedClasspath(true);
                IPath[] outputs = new IPath[classpath.length + 1];
                int[] traverseModes = new int[classpath.length + 1];
                int outputCount = 1;
                outputs[0] = projectOutput;
                traverseModes[0] = traverseMode;
                int i = 0;
                int length = classpath.length;
                while (i < length) {
                    IClasspathEntry entry = classpath[i];
                    IPath entryPath = entry.getPath();
                    IPath output = entry.getOutputLocation();
                    if (output != null) {
                        outputs[outputCount] = output;
                        if (entryPath.equals(output)) {
                            traverseModes[outputCount++] = entry.getEntryKind() == 3 ? 1 : 2;
                        } else {
                            traverseModes[outputCount++] = 0;
                        }
                    }
                    if (entryPath.equals(projectOutput)) {
                        traverseModes[0] = entry.getEntryKind() == 3 ? 1 : 2;
                    }
                    ++i;
                }
                return new OutputsInfo(outputs, traverseModes, outputCount);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    public void performPreBuildCheck(IResourceDelta delta, IJavaElement parent) {
        IResource resource = delta.getResource();
        IJavaElement element = null;
        boolean processChildren = false;
        switch (resource.getType()) {
            case 8: {
                if (delta.getKind() != 4) break;
                element = JavaCore.create(resource);
                processChildren = true;
                break;
            }
            case 4: {
                int kind = delta.getKind();
                switch (kind) {
                    case 4: {
                        IProject project = (IProject)resource;
                        if (JavaProject.hasJavaNature(project)) {
                            element = JavaCore.create(resource);
                            processChildren = true;
                            break;
                        }
                        if (JavaModelManager.getJavaModelManager().getJavaModel().findJavaProject(project) == null) break;
                        this.rootsAreStale = true;
                        this.manager.removePerProjectInfo((JavaProject)JavaCore.create(project));
                        break;
                    }
                    case 1: {
                        this.rootsAreStale = true;
                        break;
                    }
                    case 2: {
                        this.manager.removePerProjectInfo((JavaProject)JavaCore.create(resource));
                        this.rootsAreStale = true;
                    }
                }
                break;
            }
            case 1: {
                if (parent.getElementType() != 2) break;
                IFile file = (IFile)resource;
                JavaProject project = (JavaProject)parent;
                if (!file.getName().equals(".classpath")) break;
                this.reconcileClasspathFileUpdate(delta, file, project);
                this.rootsAreStale = true;
                break;
            }
        }
        if (processChildren) {
            IResourceDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.performPreBuildCheck(children[i], element);
                ++i;
            }
        }
    }

    private void popUntilPrefixOf(IPath path) {
        while (this.currentElement != null) {
            IPath currentElementPath = null;
            if (this.currentElement instanceof IPackageFragmentRoot) {
                currentElementPath = ((IPackageFragmentRoot)((Object)this.currentElement)).getPath();
            } else {
                IResource currentElementResource = this.currentElement.getResource();
                if (currentElementResource != null) {
                    currentElementPath = currentElementResource.getFullPath();
                }
            }
            if (currentElementPath != null) {
                if (this.currentElement instanceof IPackageFragment && this.currentElement.getElementName().length() == 0 && currentElementPath.segmentCount() != path.segmentCount() - 1) {
                    this.currentElement = (Openable)this.currentElement.getParent();
                }
                if (currentElementPath.isPrefixOf(path)) {
                    return;
                }
            }
            this.currentElement = (Openable)this.currentElement.getParent();
        }
    }

    public IJavaElementDelta processResourceDelta(IResourceDelta changes) {
        try {
            JavaModel model = this.manager.getJavaModel();
            if (!model.isOpen()) {
                try {
                    model.open(null);
                }
                catch (JavaModelException e) {
                    if (VERBOSE) {
                        e.printStackTrace();
                    }
                    IJavaElementDelta iJavaElementDelta = null;
                    Object var13_7 = null;
                    this.currentDelta = null;
                    this.projectsToUpdate.clear();
                    this.projectsForDependentNamelookupRefresh.clear();
                    return iJavaElementDelta;
                }
            }
            this.initializeRoots();
            this.currentElement = null;
            IResourceDelta[] deltas = changes.getAffectedChildren();
            int i = 0;
            while (i < deltas.length) {
                IResourceDelta delta = deltas[i];
                IResource res = delta.getResource();
                RootInfo rootInfo = null;
                IProject proj = (IProject)res;
                boolean wasJavaProject = this.manager.getJavaModel().findJavaProject(proj) != null;
                boolean isJavaProject = JavaProject.hasJavaNature(proj);
                int elementType = !wasJavaProject && !isJavaProject ? -1 : ((rootInfo = this.enclosingRootInfo(res.getFullPath(), delta.getKind())) != null && rootInfo.isRootOfProject(res.getFullPath()) ? 3 : 2);
                if (!this.traverseDelta(delta, elementType, rootInfo, null) || wasJavaProject != isJavaProject && delta.getKind() == 4) {
                    try {
                        this.nonJavaResourcesChanged(model, delta);
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            Iterator iterator = this.projectsToUpdate.iterator();
            while (iterator.hasNext()) {
                JavaProject project = (JavaProject)iterator.next();
                project.updatePackageFragmentRoots();
            }
            this.updateDependentNamelookups();
            JavaElementDelta javaElementDelta = this.currentDelta;
            Object var13_8 = null;
            this.currentDelta = null;
            this.projectsToUpdate.clear();
            this.projectsForDependentNamelookupRefresh.clear();
            return javaElementDelta;
        }
        catch (Throwable throwable) {
            Object var13_9 = null;
            this.currentDelta = null;
            this.projectsToUpdate.clear();
            this.projectsForDependentNamelookupRefresh.clear();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void reconcileClasspathFileUpdate(IResourceDelta delta, IFile file, JavaProject project) {
        switch (delta.getKind()) {
            case 2: {
                try {
                    info = JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(project.getProject());
                    if (info.classpath == null) return;
                    project.saveClasspath(info.classpath, info.outputLocation);
                    return;
                }
                catch (JavaModelException e) {
                    if (project.getProject().isAccessible() == false) return;
                    Util.log(e, "Could not save classpath for " + project.getPath());
                    return;
                }
            }
            case 4: {
                if ((delta.getFlags() & 256) == 0 && (delta.getFlags() & 4096) == 0) {
                    return;
                }
            }
            case 1: {
                project.flushClasspathProblemMarkers(false, true);
                wasSuccessful = false;
                try {
                    try {
                        fileEntries = project.readClasspathFile(true, false);
                        if (fileEntries != null) {
                            info = JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(project.getProject());
                            if (info.classpath != null && project.isClasspathEqualsTo(info.classpath, info.outputLocation, fileEntries)) {
                                return;
                            }
                            outputLocation = null;
                            if (fileEntries != null && fileEntries.length > 0 && (entry = fileEntries[fileEntries.length - 1]).getContentKind() == 10) {
                                outputLocation = entry.getPath();
                                copy = new IClasspathEntry[fileEntries.length - 1];
                                System.arraycopy(fileEntries, 0, copy, 0, copy.length);
                                fileEntries = copy;
                            }
                            if (outputLocation == null) {
                                outputLocation = SetClasspathOperation.ReuseOutputLocation;
                            }
                            project.setRawClasspath(fileEntries, outputLocation, null, true, project.getResolvedClasspath(true), true, false);
                            return;
                        }
                        var10_10 = null;
                        if (wasSuccessful != false) return;
                    }
                    catch (RuntimeException e) {
                        if (project.getProject().isAccessible()) {
                            Util.log(e, "Could not set classpath for " + project.getPath());
                        }
                        var10_12 = null;
                        if (wasSuccessful != false) return;
                        try {
                            project.setRawClasspath0(JavaProject.INVALID_CLASSPATH);
                            project.updatePackageFragmentRoots();
                            return;
                        }
                        catch (JavaModelException e) {
                            return;
                        }
                    }
                    catch (JavaModelException e) {
                        if (project.getProject().isAccessible()) {
                            if (e.getJavaModelStatus().getException() instanceof CoreException) {
                                project.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.couldNotWriteClasspathFile", project.getElementName(), e.getMessage())));
                            } else {
                                project.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.invalidClasspathInClasspathFile", project.getElementName(), e.getMessage())));
                            }
                        }
                        var10_13 = null;
                        if (wasSuccessful != false) return;
                        try {}
                        catch (JavaModelException e) {
                            return;
                        }
                        project.setRawClasspath0(JavaProject.INVALID_CLASSPATH);
                        project.updatePackageFragmentRoots();
                        return;
                    }
                }
                catch (Throwable var11_26) {
                    var10_14 = null;
                    if (wasSuccessful != false) throw var11_26;
                    ** try [egrp 3[TRYBLOCK] [4 : 490->504)] { 
lbl73:
                    // 1 sources

                    project.setRawClasspath0(JavaProject.INVALID_CLASSPATH);
                    project.updatePackageFragmentRoots();
                    throw var11_26;
lbl76:
                    // 1 sources

                    catch (JavaModelException e) {
                        // empty catch block
                    }
                    throw var11_26;
                }
                try {}
                catch (JavaModelException e) {
                    return;
                }
                project.setRawClasspath0(JavaProject.INVALID_CLASSPATH);
                project.updatePackageFragmentRoots();
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void reconcilePreferenceFileUpdate(IResourceDelta delta, IFile file, JavaProject project) {
        switch (delta.getKind()) {
            case 2: {
                project.setOptions(null);
                return;
            }
            case 4: {
                if ((delta.getFlags() & 256) == 0 && (delta.getFlags() & 4096) == 0) break;
                filePreferences = project.loadPreferences();
                if (filePreferences == null) {
                    project.setOptions(null);
                    return;
                }
                projectPreferences = project.getPreferences();
                if (projectPreferences == null) {
                    return;
                }
                defaultProjectPropertyNames = projectPreferences.defaultPropertyNames();
                if (defaultProjectPropertyNames.length == (defaultFilePropertyNames = filePreferences.defaultPropertyNames()).length) {
                    i = 0;
                    while (i < defaultProjectPropertyNames.length) {
                        propertyName = defaultProjectPropertyNames[i];
                        if (projectPreferences.getString(propertyName).trim().equals(filePreferences.getString(propertyName).trim())) {
                            ++i;
                            continue;
                        }
                        ** GOTO lbl33
                    }
                    projectPropertyNames = projectPreferences.propertyNames();
                    if (projectPropertyNames.length == (filePropertyNames = filePreferences.propertyNames()).length) {
                        i = 0;
                        while (i < projectPropertyNames.length) {
                            propertyName = projectPropertyNames[i];
                            if (projectPreferences.getString(propertyName).trim().equals(filePreferences.getString(propertyName).trim())) {
                                ++i;
                                continue;
                            }
                            ** GOTO lbl33
                        }
                        return;
                    }
                }
            }
lbl33:
            // 7 sources

            case 1: {
                project.setPreferences(null);
            }
        }
    }

    protected void removeFromParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                JavaElementInfo info = (JavaElementInfo)parent.getElementInfo();
                info.removeChild(child);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getSource() instanceof IWorkspace) {
            IResource resource = event.getResource();
            IResourceDelta delta = event.getDelta();
            switch (event.getType()) {
                case 4: {
                    try {
                        if (resource.getType() == 4 && ((IProject)resource).hasNature("org.eclipse.jdt.core.javanature")) {
                            this.deleting((IProject)resource);
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    return;
                }
                case 8: {
                    if (this.isAffectedBy(delta)) {
                        this.checkProjectsBeingAddedOrRemoved(delta);
                        this.updateClasspathMarkers();
                        try {
                            this.manager.stopDeltas();
                            this.performPreBuildCheck(delta, null);
                        }
                        catch (Throwable throwable) {
                            Object var4_5 = null;
                            this.manager.startDeltas();
                            throw throwable;
                        }
                        Object var4_6 = null;
                        this.manager.startDeltas();
                    }
                    this.manager.fire(null, 2);
                    break;
                }
                case 16: {
                    JavaBuilder.finishedBuilding(event);
                    break;
                }
                case 1: {
                    if (!this.isAffectedBy(delta)) break;
                    try {
                        IJavaElementDelta translatedDelta;
                        if (this.refreshedElements != null) {
                            try {
                                this.createExternalArchiveDelta(null);
                            }
                            catch (JavaModelException e) {
                                e.printStackTrace();
                            }
                        }
                        if ((translatedDelta = this.processResourceDelta(delta)) != null) {
                            this.manager.registerJavaModelDelta(translatedDelta);
                        }
                        this.manager.fire(null, 1);
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        this.manager.javaProjectsCache = null;
                        this.removedRoots = null;
                        throw throwable;
                    }
                    Object var5_11 = null;
                    this.manager.javaProjectsCache = null;
                    this.removedRoots = null;
                    break;
                }
            }
        }
    }

    RootInfo enclosingRootInfo(IPath path, int kind) {
        while (path != null && path.segmentCount() > 0) {
            RootInfo rootInfo = this.rootInfo(path, kind);
            if (rootInfo != null) {
                return rootInfo;
            }
            path = path.removeLastSegments(1);
        }
        return null;
    }

    RootInfo rootInfo(IPath path, int kind) {
        if (kind == 2) {
            return (RootInfo)this.oldRoots.get(path);
        }
        return (RootInfo)this.roots.get(path);
    }

    ArrayList otherRootsInfo(IPath path, int kind) {
        if (kind == 2) {
            return (ArrayList)this.oldOtherRoots.get(path);
        }
        return (ArrayList)this.otherRoots.get(path);
    }

    protected boolean traverseDelta(IResourceDelta delta, int elementType, RootInfo rootInfo, OutputsInfo outputsInfo) {
        IResource res = delta.getResource();
        if (this.currentElement == null && rootInfo != null) {
            this.currentElement = (Openable)((Object)rootInfo.project);
        }
        boolean processChildren = true;
        processChildren = res instanceof IProject ? this.updateCurrentDeltaAndIndex(delta, elementType == 3 ? 2 : elementType, rootInfo) : (rootInfo != null ? this.updateCurrentDeltaAndIndex(delta, elementType, rootInfo) : true);
        if (outputsInfo == null) {
            outputsInfo = this.outputsInfo(rootInfo, res);
        }
        if (processChildren) {
            IProject rscProject;
            JavaProject adoptiveProject;
            IResourceDelta[] children = delta.getAffectedChildren();
            boolean oneChildOnClasspath = false;
            int length = children.length;
            IResourceDelta[] orphanChildren = null;
            Openable parent = null;
            boolean isValidParent = true;
            int i = 0;
            while (i < length) {
                block24: {
                    ArrayList rootList;
                    boolean isNestedRoot;
                    RootInfo childRootInfo;
                    int childKind;
                    IPath childPath;
                    IResourceDelta child;
                    block25: {
                        child = children[i];
                        IResource childRes = child.getResource();
                        this.checkSourceAttachmentChange(child, childRes);
                        childPath = childRes.getFullPath();
                        childKind = child.getKind();
                        childRootInfo = this.rootInfo(childPath, childKind);
                        if (childRootInfo != null && !childRootInfo.isRootOfProject(childPath)) {
                            childRootInfo = null;
                        }
                        int childType = this.elementType(childRes, childKind, elementType, rootInfo == null ? childRootInfo : rootInfo);
                        boolean isResFilteredFromOutput = this.isResFilteredFromOutput(outputsInfo, childRes, childType);
                        boolean bl = isNestedRoot = rootInfo != null && childRootInfo != null;
                        if (!isResFilteredFromOutput && !isNestedRoot) {
                            if (!this.traverseDelta(child, childType, rootInfo == null ? childRootInfo : rootInfo, outputsInfo)) {
                                try {
                                    if (rootInfo != null) {
                                        if (!isValidParent) break block24;
                                        if (parent == null) {
                                            if (this.currentElement == null || !this.currentElement.getJavaProject().equals(rootInfo.project)) {
                                                this.currentElement = (Openable)((Object)rootInfo.project);
                                            }
                                            if ((parent = elementType == 2 || elementType == 3 && res instanceof IProject ? (Openable)((Object)rootInfo.project) : this.createElement(res, elementType, rootInfo)) == null) {
                                                isValidParent = false;
                                                break block24;
                                            }
                                        }
                                        this.nonJavaResourcesChanged(parent, child);
                                        break block25;
                                    }
                                    if (orphanChildren == null) {
                                        orphanChildren = new IResourceDelta[length];
                                    }
                                    orphanChildren[i] = child;
                                }
                                catch (JavaModelException e) {}
                            } else {
                                oneChildOnClasspath = true;
                            }
                        } else {
                            oneChildOnClasspath = true;
                        }
                    }
                    if (isNestedRoot || childRootInfo == null && (childRootInfo = this.rootInfo(childPath, childKind)) != null) {
                        this.traverseDelta(child, 3, childRootInfo, null);
                    }
                    if ((rootList = this.otherRootsInfo(childPath, childKind)) != null) {
                        Iterator iterator = ((AbstractList)rootList).iterator();
                        while (iterator.hasNext()) {
                            childRootInfo = (RootInfo)iterator.next();
                            this.traverseDelta(child, 3, childRootInfo, null);
                        }
                    }
                }
                ++i;
            }
            if (orphanChildren != null && (oneChildOnClasspath || res instanceof IProject) && (adoptiveProject = (JavaProject)JavaCore.create(rscProject = res.getProject())) != null && JavaProject.hasJavaNature(rscProject)) {
                int i2 = 0;
                while (i2 < length) {
                    if (orphanChildren[i2] != null) {
                        try {
                            this.nonJavaResourcesChanged(adoptiveProject, orphanChildren[i2]);
                        }
                        catch (JavaModelException javaModelException) {
                            // empty catch block
                        }
                    }
                    ++i2;
                }
            }
            return elementType != -1;
        }
        return elementType != -1;
    }

    void updateClasspathMarkers() {
        try {
            if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                Iterator iterator = this.projectsToUpdate.iterator();
                while (iterator.hasNext()) {
                    try {
                        JavaProject project = (JavaProject)iterator.next();
                        project.getResolvedClasspath(true, true);
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
            }
            if (!this.projectsToUpdate.isEmpty()) {
                try {
                    JavaProject.updateAllCycleMarkers();
                }
                catch (JavaModelException e) {}
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.projectsToUpdate = new HashSet();
            throw throwable;
        }
        Object var3_7 = null;
        this.projectsToUpdate = new HashSet();
    }

    private boolean updateCurrentDeltaAndIndex(IResourceDelta delta, int elementType, RootInfo rootInfo) {
        switch (delta.getKind()) {
            case 1: {
                IResource deltaRes = delta.getResource();
                Openable element = this.createElement(deltaRes, elementType, rootInfo);
                if (element == null) {
                    this.updateRoots(deltaRes.getFullPath(), delta);
                    return false;
                }
                this.updateIndex(element, delta);
                this.elementAdded(element, delta, rootInfo);
                return false;
            }
            case 2: {
                IResource deltaRes = delta.getResource();
                Openable element = this.createElement(deltaRes, elementType, rootInfo);
                if (element == null) {
                    this.updateRoots(deltaRes.getFullPath(), delta);
                    return false;
                }
                this.updateIndex(element, delta);
                this.elementRemoved(element, delta, rootInfo);
                if (deltaRes.getType() == 4) {
                    this.manager.setLastBuiltState((IProject)deltaRes, null);
                }
                return false;
            }
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x100) != 0) {
                    Openable element = this.createElement(delta.getResource(), elementType, rootInfo);
                    if (element == null) {
                        return false;
                    }
                    this.updateIndex(element, delta);
                    this.contentChanged(element, delta);
                } else if (elementType == 2) {
                    if ((flags & 0x4000) != 0) {
                        IProject res = (IProject)delta.getResource();
                        Openable element = this.createElement(res, elementType, rootInfo);
                        if (element == null) {
                            this.updateRoots(res.getFullPath(), delta);
                            return false;
                        }
                        if (res.isOpen()) {
                            if (JavaProject.hasJavaNature(res)) {
                                this.elementAdded(element, delta, rootInfo);
                                this.indexManager.indexAll(res);
                            }
                        } else {
                            boolean wasJavaProject;
                            JavaModel javaModel = this.manager.getJavaModel();
                            boolean bl = wasJavaProject = javaModel.findJavaProject(res) != null;
                            if (wasJavaProject) {
                                this.elementRemoved(element, delta, rootInfo);
                                this.indexManager.discardJobs(element.getElementName());
                                this.indexManager.removeIndexFamily(res.getFullPath());
                            }
                        }
                        return false;
                    }
                    if ((flags & 0x80000) != 0) {
                        boolean isJavaProject;
                        IProject res = (IProject)delta.getResource();
                        JavaModel javaModel = this.manager.getJavaModel();
                        boolean wasJavaProject = javaModel.findJavaProject(res) != null;
                        if (wasJavaProject != (isJavaProject = JavaProject.hasJavaNature(res))) {
                            Openable element = this.createElement(res, elementType, rootInfo);
                            if (element == null) {
                                return false;
                            }
                            if (isJavaProject) {
                                this.elementAdded(element, delta, rootInfo);
                                this.indexManager.indexAll(res);
                            } else {
                                this.elementRemoved(element, delta, rootInfo);
                                this.indexManager.discardJobs(element.getElementName());
                                this.indexManager.removeIndexFamily(res.getFullPath());
                                this.manager.setLastBuiltState(res, null);
                            }
                            return false;
                        }
                    }
                }
                return true;
            }
        }
        return true;
    }

    public void updateDependentNamelookups() {
        JavaProject project;
        Iterator iterator = this.projectsForDependentNamelookupRefresh.iterator();
        HashSet affectedDependents = new HashSet();
        while (iterator.hasNext()) {
            project = (JavaProject)iterator.next();
            this.addDependentProjects(project.getPath(), affectedDependents);
        }
        iterator = affectedDependents.iterator();
        while (iterator.hasNext()) {
            project = (JavaProject)iterator.next();
            if (!project.isOpen()) continue;
            try {
                ((JavaProjectElementInfo)project.getElementInfo()).setNameLookup(null);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    protected void updateIndex(Openable element, IResourceDelta delta) {
        block45: {
            if (this.indexManager == null) {
                return;
            }
            block1 : switch (element.getElementType()) {
                case 2: {
                    switch (delta.getKind()) {
                        case 1: {
                            this.indexManager.indexAll(element.getJavaProject().getProject());
                            break;
                        }
                        case 2: {
                            this.indexManager.removeIndexFamily(element.getJavaProject().getProject().getFullPath());
                        }
                    }
                    break;
                }
                case 3: {
                    if (element instanceof JarPackageFragmentRoot) {
                        JarPackageFragmentRoot root = (JarPackageFragmentRoot)element;
                        IPath jarPath = root.getPath();
                        switch (delta.getKind()) {
                            case 1: {
                                this.indexManager.indexLibrary(jarPath, root.getJavaProject().getProject());
                                break;
                            }
                            case 4: {
                                this.indexManager.removeIndex(jarPath);
                                this.indexManager.indexLibrary(jarPath, root.getJavaProject().getProject());
                                break;
                            }
                            case 2: {
                                this.indexManager.discardJobs(jarPath.toString());
                                this.indexManager.removeIndex(jarPath);
                            }
                        }
                        break;
                    }
                    int kind = delta.getKind();
                    if (kind == 1 || kind == 2) {
                        IPackageFragmentRoot root = (IPackageFragmentRoot)((Object)element);
                        this.updateRootIndex(root, root.getPackageFragment(""), delta);
                        break;
                    }
                }
                case 4: {
                    switch (delta.getKind()) {
                        case 1: 
                        case 2: {
                            IPackageFragment pkg = null;
                            if (element instanceof IPackageFragmentRoot) {
                                IPackageFragmentRoot root = (IPackageFragmentRoot)((Object)element);
                                pkg = root.getPackageFragment("");
                            } else {
                                pkg = (IPackageFragment)((Object)element);
                            }
                            IResourceDelta[] children = delta.getAffectedChildren();
                            int i = 0;
                            int length = children.length;
                            while (i < length) {
                                IResourceDelta child = children[i];
                                IResource resource = child.getResource();
                                if (resource instanceof IFile) {
                                    String name = resource.getName();
                                    if (Util.isJavaFileName(name)) {
                                        Openable cu = (Openable)((Object)pkg.getCompilationUnit(name));
                                        this.updateIndex(cu, child);
                                    } else if (Util.isClassFileName(name)) {
                                        Openable classFile = (Openable)((Object)pkg.getClassFile(name));
                                        this.updateIndex(classFile, child);
                                    }
                                }
                                ++i;
                            }
                            break block1;
                        }
                    }
                    break;
                }
                case 6: {
                    IFile file = (IFile)delta.getResource();
                    IJavaProject project = element.getJavaProject();
                    IPath binaryFolderPath = element.getPackageFragmentRoot().getPath();
                    try {
                        if (binaryFolderPath.equals(project.getOutputLocation())) {
                            break;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                    switch (delta.getKind()) {
                        case 4: {
                            if ((delta.getFlags() & 0x100) == 0) break block1;
                        }
                        case 1: {
                            this.indexManager.addBinary(file, binaryFolderPath);
                            break;
                        }
                        case 2: {
                            this.indexManager.remove(file.getFullPath().toString(), binaryFolderPath);
                        }
                    }
                    break;
                }
                case 5: {
                    IFile file = (IFile)delta.getResource();
                    switch (delta.getKind()) {
                        case 4: {
                            if ((delta.getFlags() & 0x100) == 0) break block45;
                        }
                        case 1: {
                            this.indexManager.addSource(file, file.getProject().getProject().getFullPath());
                            break block1;
                        }
                        {
                        }
                        case 2: {
                            this.indexManager.remove(file.getFullPath().toString(), file.getProject().getProject().getFullPath());
                        }
                    }
                }
            }
        }
    }

    private void updateRootIndex(IPackageFragmentRoot root, IPackageFragment pkg, IResourceDelta delta) {
        this.updateIndex((Openable)((Object)pkg), delta);
        IResourceDelta[] children = delta.getAffectedChildren();
        String name = pkg.getElementName();
        int i = 0;
        int length = children.length;
        while (i < length) {
            IResourceDelta child = children[i];
            IResource resource = child.getResource();
            if (resource instanceof IFolder) {
                String subpkgName = name.length() == 0 ? resource.getName() : String.valueOf(name) + "." + resource.getName();
                IPackageFragment subpkg = root.getPackageFragment(subpkgName);
                this.updateRootIndex(root, subpkg, child);
            }
            ++i;
        }
    }

    private void updateRoots(IPath containerPath, IResourceDelta containerDelta) {
        Map otherRoots;
        Map roots;
        if (containerDelta.getKind() == 2) {
            roots = this.oldRoots;
            otherRoots = this.oldOtherRoots;
        } else {
            roots = this.roots;
            otherRoots = this.otherRoots;
        }
        Iterator iterator = roots.keySet().iterator();
        while (iterator.hasNext()) {
            ArrayList rootList;
            IResourceDelta rootDelta;
            IPath path = (IPath)iterator.next();
            if (!containerPath.isPrefixOf(path) || containerPath.equals(path) || (rootDelta = containerDelta.findMember(path.removeFirstSegments(1))) == null) continue;
            RootInfo rootInfo = (RootInfo)roots.get(path);
            if (!rootInfo.project.getPath().isPrefixOf(path)) {
                this.updateCurrentDeltaAndIndex(rootDelta, 3, rootInfo);
            }
            if ((rootList = (ArrayList)otherRoots.get(path)) == null) continue;
            Iterator otherProjects = ((AbstractList)rootList).iterator();
            while (otherProjects.hasNext()) {
                rootInfo = (RootInfo)otherProjects.next();
                if (rootInfo.project.getPath().isPrefixOf(path)) continue;
                this.updateCurrentDeltaAndIndex(rootDelta, 3, rootInfo);
            }
        }
    }

    class OutputsInfo {
        IPath[] paths;
        int[] traverseModes;
        int outputCount;

        OutputsInfo(IPath[] paths, int[] traverseModes, int outputCount) {
            this.paths = paths;
            this.traverseModes = traverseModes;
            this.outputCount = outputCount;
        }

        public String toString() {
            if (this.paths == null) {
                return "<none>";
            }
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < this.outputCount) {
                buffer.append("path=");
                buffer.append(this.paths[i].toString());
                buffer.append("\n->traverse=");
                switch (this.traverseModes[i]) {
                    case 2: {
                        buffer.append("BINARY");
                        break;
                    }
                    case 0: {
                        buffer.append("IGNORE");
                        break;
                    }
                    case 1: {
                        buffer.append("SOURCE");
                        break;
                    }
                    default: {
                        buffer.append("<unknown>");
                    }
                }
                if (i + 1 < this.outputCount) {
                    buffer.append('\n');
                }
                ++i;
            }
            return buffer.toString();
        }
    }

    class RootInfo {
        IJavaProject project;
        IPath rootPath;
        char[][] exclusionPatterns;

        RootInfo(IJavaProject project, IPath rootPath, char[][] exclusionPatterns) {
            this.project = project;
            this.rootPath = rootPath;
            this.exclusionPatterns = exclusionPatterns;
        }

        boolean isRootOfProject(IPath path) {
            return this.rootPath.equals(path) && this.project.getProject().getFullPath().isPrefixOf(path);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("project=");
            if (this.project == null) {
                buffer.append("null");
            } else {
                buffer.append(this.project.getElementName());
            }
            buffer.append("\npath=");
            if (this.rootPath == null) {
                buffer.append("null");
            } else {
                buffer.append(this.rootPath.toString());
            }
            buffer.append("\nexcluding=");
            if (this.exclusionPatterns == null) {
                buffer.append("null");
            } else {
                int i = 0;
                int length = this.exclusionPatterns.length;
                while (i < length) {
                    buffer.append(new String(this.exclusionPatterns[i]));
                    if (i < length - 1) {
                        buffer.append("|");
                    }
                    ++i;
                }
            }
            return buffer.toString();
        }
    }
}

