/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.CreateCompilationUnitOperation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragmentInfo;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.Util;

public class PackageFragment
extends Openable
implements IPackageFragment {
    protected static IClassFile[] fgEmptyClassFileList = new IClassFile[0];
    protected static ICompilationUnit[] fgEmptyCompilationUnitList = new ICompilationUnit[0];

    protected PackageFragment(IPackageFragmentRoot root, String name) {
        super(4, root, name);
    }

    protected boolean computeChildren(OpenableElementInfo info, IResource resource) throws JavaModelException {
        ArrayList<ICompilationUnit> vChildren = new ArrayList<ICompilationUnit>();
        int kind = this.getKind();
        String extType = kind == 1 ? "java" : "class";
        try {
            char[][] exclusionPatterns = this.getPackageFragmentRoot().fullExclusionPatternChars();
            IResource[] members = ((IContainer)resource).members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                String extension;
                IResource child = members[i];
                if (child.getType() != 2 && !Util.isExcluded(child, exclusionPatterns) && (extension = child.getProjectRelativePath().getFileExtension()) != null && extension.equalsIgnoreCase(extType)) {
                    ISourceReference childElement;
                    if (kind == 1 && Util.isValidCompilationUnitName(child.getName())) {
                        childElement = this.getCompilationUnit(child.getName());
                        vChildren.add((ICompilationUnit)childElement);
                    } else if (Util.isValidClassFileName(child.getName())) {
                        childElement = this.getClassFile(child.getName());
                        vChildren.add((ICompilationUnit)childElement);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        IJavaElement[] children = new IJavaElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    public boolean containsJavaResources() throws JavaModelException {
        return ((PackageFragmentInfo)this.getElementInfo()).containsJavaResources();
    }

    public void copy(IJavaElement container, IJavaElement sibling, String rename, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (container == null) {
            throw new IllegalArgumentException(Util.bind("operation.nullContainer"));
        }
        IJavaElement[] elements = new IJavaElement[]{this};
        IJavaElement[] containers = new IJavaElement[]{container};
        IJavaElement[] siblings = null;
        if (sibling != null) {
            siblings = new IJavaElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getJavaModel().copy(elements, containers, siblings, renamings, force, monitor);
    }

    public ICompilationUnit createCompilationUnit(String name, String contents, boolean force, IProgressMonitor monitor) throws JavaModelException {
        CreateCompilationUnitOperation op = new CreateCompilationUnitOperation(this, name, contents, force);
        JavaElement.runOperation(op, monitor);
        return this.getCompilationUnit(name);
    }

    protected OpenableElementInfo createElementInfo() {
        return new PackageFragmentInfo();
    }

    public void delete(boolean force, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] elements = new IJavaElement[]{this};
        this.getJavaModel().delete(elements, force, monitor);
    }

    protected boolean generateInfos(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        return this.computeChildren(info, underlyingResource);
    }

    public IClassFile getClassFile(String name) {
        return new ClassFile(this, name);
    }

    public IClassFile[] getClassFiles() throws JavaModelException {
        if (this.getKind() == 1) {
            return fgEmptyClassFileList;
        }
        ArrayList list = this.getChildrenOfType(6);
        IClassFile[] array = new IClassFile[list.size()];
        list.toArray(array);
        return array;
    }

    public ICompilationUnit getCompilationUnit(String name) {
        return new CompilationUnit(this, name);
    }

    public ICompilationUnit[] getCompilationUnits() throws JavaModelException {
        if (this.getKind() == 2) {
            return fgEmptyCompilationUnitList;
        }
        ArrayList list = this.getChildrenOfType(5);
        ICompilationUnit[] array = new ICompilationUnit[list.size()];
        list.toArray(array);
        return array;
    }

    protected char getHandleMementoDelimiter() {
        return '<';
    }

    public int getKind() throws JavaModelException {
        return ((IPackageFragmentRoot)this.getParent()).getKind();
    }

    public Object[] getNonJavaResources() throws JavaModelException {
        if (this.isDefaultPackage()) {
            return JavaElementInfo.NO_NON_JAVA_RESOURCES;
        }
        return ((PackageFragmentInfo)this.getElementInfo()).getNonJavaResources(this.getResource(), this.getPackageFragmentRoot());
    }

    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getPath();
        }
        return root.getPath().append(this.getElementName().replace('.', '/'));
    }

    public IResource getResource() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getResource();
        }
        String elementName = this.getElementName();
        if (elementName.length() == 0) {
            return root.getResource();
        }
        return ((IContainer)root.getResource()).getFolder(new Path(this.getElementName().replace('.', '/')));
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        IResource rootResource = this.fParent.getUnderlyingResource();
        if (rootResource == null) {
            return null;
        }
        if (rootResource.getType() == 2 || rootResource.getType() == 4) {
            IContainer folder = (IContainer)rootResource;
            String[] segs = Signature.getSimpleNames(this.fName);
            int i = 0;
            while (i < segs.length) {
                IResource child = folder.findMember(segs[i]);
                if (child == null || child.getType() != 2) {
                    throw this.newNotPresentException();
                }
                folder = (IFolder)child;
                ++i;
            }
            return folder;
        }
        return rootResource;
    }

    public boolean hasSubpackages() throws JavaModelException {
        IJavaElement[] packages = ((IPackageFragmentRoot)this.getParent()).getChildren();
        String name = this.getElementName();
        int nameLength = name.length();
        String packageName = this.isDefaultPackage() ? name : String.valueOf(name) + ".";
        int i = 0;
        while (i < packages.length) {
            String otherName = packages[i].getElementName();
            if (otherName.length() > nameLength && otherName.startsWith(packageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isDefaultPackage() {
        return this.getElementName().length() == 0;
    }

    public void move(IJavaElement container, IJavaElement sibling, String rename, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (container == null) {
            throw new IllegalArgumentException(Util.bind("operation.nullContainer"));
        }
        IJavaElement[] elements = new IJavaElement[]{this};
        IJavaElement[] containers = new IJavaElement[]{container};
        IJavaElement[] siblings = null;
        if (sibling != null) {
            siblings = new IJavaElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getJavaModel().move(elements, containers, siblings, renamings, force, monitor);
    }

    protected void openWhenClosed(IProgressMonitor pm) throws JavaModelException {
        if (!this.resourceExists()) {
            throw this.newNotPresentException();
        }
        super.openWhenClosed(pm);
    }

    public void refreshChildren() {
        try {
            OpenableElementInfo info = (OpenableElementInfo)this.getElementInfo();
            this.computeChildren(info, this.getResource());
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    public void rename(String name, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (name == null) {
            throw new IllegalArgumentException(Util.bind("element.nullName"));
        }
        IJavaElement[] elements = new IJavaElement[]{this};
        IJavaElement[] dests = new IJavaElement[]{this.getParent()};
        String[] renamings = new String[]{name};
        this.getJavaModel().rename(elements, dests, renamings, force, monitor);
    }

    public IJavaElement rootedAt(IJavaProject project) {
        return new PackageFragment((IPackageFragmentRoot)((JavaElement)this.fParent).rootedAt(project), this.fName);
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (tab == 0) {
            super.toStringChildren(tab, buffer, info);
        }
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (this.getElementName().length() == 0) {
            buffer.append("[default]");
        } else {
            buffer.append(this.getElementName());
        }
        if (info == null) {
            buffer.append(" (not open)");
        } else if (tab > 0) {
            buffer.append(" (...)");
        }
    }
}

