/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.DeltaProcessor;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;

public class SetClasspathOperation
extends JavaModelOperation {
    IClasspathEntry[] oldResolvedPath;
    IClasspathEntry[] newResolvedPath;
    IClasspathEntry[] newRawPath;
    boolean canChangeResource;
    boolean needCycleCheck;
    boolean needValidation;
    boolean needSave;
    IPath newOutputLocation;
    public static final IClasspathEntry[] ReuseClasspath = new IClasspathEntry[0];
    public static final IClasspathEntry[] UpdateClasspath = new IClasspathEntry[0];
    public static final IPath ReuseOutputLocation = new Path("Reuse Existing Output Location");

    public SetClasspathOperation(IJavaProject project, IClasspathEntry[] oldResolvedPath, IClasspathEntry[] newRawPath, IPath newOutputLocation, boolean canChangeResource, boolean needValidation, boolean needSave) {
        super(new IJavaElement[]{project});
        this.oldResolvedPath = oldResolvedPath;
        this.newRawPath = newRawPath;
        this.newOutputLocation = newOutputLocation;
        this.canChangeResource = canChangeResource;
        this.needValidation = needValidation;
        this.needSave = needSave;
    }

    protected void addClasspathDeltas(IPackageFragmentRoot[] roots, int flag, JavaElementDelta delta) {
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            delta.changed(root, flag);
            if ((flag & 0x80) != 0 || (flag & 0x1000) != 0 || (flag & 0x2000) != 0) {
                try {
                    root.close();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                ((PackageFragmentRoot)root).setSourceAttachmentProperty(null);
            }
            ++i;
        }
    }

    protected int classpathContains(IClasspathEntry[] list, IClasspathEntry entry) {
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        int i = 0;
        while (i < list.length) {
            IClasspathEntry other = list[i];
            if (other.getContentKind() == entry.getContentKind() && other.getEntryKind() == entry.getEntryKind() && other.isExported() == entry.isExported() && other.getPath().equals(entry.getPath())) {
                IPath entryOutput = entry.getOutputLocation();
                IPath otherOutput = other.getOutputLocation();
                if (!(entryOutput != null ? !entryOutput.equals(otherOutput) : otherOutput != null)) {
                    IPath[] otherExcludes = other.getExclusionPatterns();
                    if (exclusionPatterns != otherExcludes) {
                        int excludeLength = exclusionPatterns.length;
                        if (otherExcludes.length == excludeLength) {
                            int j = 0;
                            while (j < excludeLength) {
                                if (exclusionPatterns[j].toString().equals(otherExcludes[j].toString())) {
                                    ++j;
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        return i;
                    }
                }
            }
            ++i;
        }
        return -1;
    }

    protected void collectAllSubfolders(IFolder folder, ArrayList collection) throws JavaModelException {
        try {
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource r = members[i];
                if (r.getType() == 2) {
                    collection.add(r);
                    this.collectAllSubfolders((IFolder)r, collection);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    protected ArrayList determineAffectedPackageFragments(IPath location) throws JavaModelException {
        ArrayList<IPackageFragment> fragments = new ArrayList<IPackageFragment>();
        JavaProject project = this.getProject();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResource resource = null;
        if (location != null) {
            resource = workspace.getRoot().findMember(location);
        }
        if (resource != null && resource.getType() == 2) {
            IFolder folder = (IFolder)resource;
            IClasspathEntry[] classpath = project.getExpandedClasspath(true);
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry entry = classpath[i];
                IPath path = classpath[i].getPath();
                if (entry.getEntryKind() != 2 && path.isPrefixOf(location) && !path.equals(location)) {
                    IPackageFragmentRoot[] roots = project.computePackageFragmentRoots(classpath[i]);
                    IPackageFragmentRoot root = roots[0];
                    ArrayList<IFolder> folders = new ArrayList<IFolder>();
                    folders.add(folder);
                    this.collectAllSubfolders(folder, folders);
                    Iterator elements = ((AbstractList)folders).iterator();
                    int segments = path.segmentCount();
                    while (elements.hasNext()) {
                        IFolder f = (IFolder)elements.next();
                        IPath relativePath = f.getFullPath().removeFirstSegments(segments);
                        String name = relativePath.toOSString();
                        if ((name = name.replace(File.pathSeparatorChar, '.')).endsWith(".")) {
                            name = name.substring(0, name.length() - 1);
                        }
                        IPackageFragment pkg = root.getPackageFragment(name);
                        fragments.add(pkg);
                    }
                }
                ++i;
            }
        }
        return fragments;
    }

    protected void executeOperation() throws JavaModelException {
        this.updateProjectReferencesIfNecessary();
        this.saveClasspathIfNecessary();
        JavaModelException originalException = null;
        try {
            try {
                JavaProject project = this.getProject();
                if (this.newRawPath == UpdateClasspath) {
                    this.newRawPath = project.getRawClasspath();
                }
                if (this.newRawPath != ReuseClasspath) {
                    this.updateClasspath();
                    project.updatePackageFragmentRoots();
                    JavaModelManager.getJavaModelManager().deltaProcessor.addForRefresh(project);
                }
            }
            catch (JavaModelException e) {
                originalException = e;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {
                if (this.newOutputLocation != ReuseOutputLocation) {
                    this.updateOutputLocation();
                }
            }
            catch (JavaModelException e) {
                if (originalException != null) {
                    throw originalException;
                }
                throw e;
            }
            throw throwable;
        }
        Object var3_6 = null;
        try {
            if (this.newOutputLocation != ReuseOutputLocation) {
                this.updateOutputLocation();
            }
        }
        catch (JavaModelException e) {
            if (originalException != null) {
                throw originalException;
            }
            throw e;
        }
        this.done();
    }

    protected void generateClasspathChangeDeltas(IClasspathEntry[] oldResolvedPath, IClasspathEntry[] newResolvedPath, final JavaProject project) {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        boolean needToUpdateDependents = false;
        JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
        boolean hasDelta = false;
        int oldLength = oldResolvedPath.length;
        int newLength = newResolvedPath.length;
        final IndexManager indexManager = manager.getIndexManager();
        HashMap<IPath, IPackageFragmentRoot> oldRoots = null;
        IPackageFragmentRoot[] roots = null;
        if (project.isOpen()) {
            try {
                roots = project.getPackageFragmentRoots();
            }
            catch (JavaModelException e) {}
        } else {
            Map allRemovedRoots = manager.deltaProcessor.removedRoots;
            if (allRemovedRoots != null) {
                roots = (IPackageFragmentRoot[])allRemovedRoots.get(project);
            }
        }
        if (roots != null) {
            oldRoots = new HashMap<IPath, IPackageFragmentRoot>();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                oldRoots.put(root.getPath(), root);
                ++i;
            }
        }
        int i = 0;
        while (i < oldLength) {
            int index = this.classpathContains(newResolvedPath, oldResolvedPath[i]);
            if (index == -1) {
                if (oldResolvedPath[i].getEntryKind() == 2) {
                    needToUpdateDependents = true;
                    this.needCycleCheck = true;
                } else {
                    IPackageFragmentRoot oldRoot;
                    Object[] pkgFragmentRoots = null;
                    if (oldRoots != null && (oldRoot = (IPackageFragmentRoot)oldRoots.get(oldResolvedPath[i].getPath())) != null) {
                        pkgFragmentRoots = new IPackageFragmentRoot[]{oldRoot};
                    }
                    if (pkgFragmentRoots == null) {
                        try {
                            ObjectVector accumulatedRoots = new ObjectVector();
                            HashSet<String> rootIDs = new HashSet<String>(5);
                            rootIDs.add(project.rootID());
                            project.computePackageFragmentRoots(oldResolvedPath[i], accumulatedRoots, rootIDs, true, false, false);
                            pkgFragmentRoots = new IPackageFragmentRoot[accumulatedRoots.size()];
                            accumulatedRoots.copyInto(pkgFragmentRoots);
                        }
                        catch (JavaModelException e) {
                            pkgFragmentRoots = new IPackageFragmentRoot[]{};
                        }
                    }
                    this.addClasspathDeltas((IPackageFragmentRoot[])pkgFragmentRoots, 128, delta);
                    int changeKind = oldResolvedPath[i].getEntryKind();
                    needToUpdateDependents |= changeKind == 3 || oldResolvedPath[i].isExported();
                    if (indexManager != null) {
                        IClasspathEntry oldEntry = oldResolvedPath[i];
                        final IPath path = oldEntry.getPath();
                        switch (changeKind) {
                            case 3: {
                                final char[][] exclusionPatterns = ((ClasspathEntry)oldEntry).fullExclusionPatternChars();
                                this.postAction(new JavaModelOperation.IPostAction(){

                                    public String getID() {
                                        return path.toString();
                                    }

                                    public void run() throws JavaModelException {
                                        indexManager.removeSourceFolderFromIndex(project, path, exclusionPatterns);
                                    }
                                }, 2);
                                break;
                            }
                            case 1: {
                                final DeltaProcessor deltaProcessor = manager.deltaProcessor;
                                this.postAction(new JavaModelOperation.IPostAction(){

                                    public String getID() {
                                        return path.toString();
                                    }

                                    public void run() throws JavaModelException {
                                        if (deltaProcessor.otherRoots.get(path) == null) {
                                            indexManager.discardJobs(path.toString());
                                            indexManager.removeIndex(path);
                                        }
                                    }
                                }, 2);
                            }
                        }
                    }
                    hasDelta = true;
                }
            } else if (oldResolvedPath[i].getEntryKind() == 2) {
                this.needCycleCheck |= oldResolvedPath[i].isExported() != newResolvedPath[index].isExported();
            } else {
                int sourceAttachmentRootFlags;
                needToUpdateDependents |= oldResolvedPath[i].isExported() != newResolvedPath[index].isExported();
                if (index != i) {
                    this.addClasspathDeltas(project.computePackageFragmentRoots(oldResolvedPath[i]), 256, delta);
                    int changeKind = oldResolvedPath[i].getEntryKind();
                    needToUpdateDependents |= changeKind == 3;
                    hasDelta = true;
                }
                IPath newSourcePath = newResolvedPath[index].getSourceAttachmentPath();
                int sourceAttachmentFlags = this.getSourceAttachmentDeltaFlag(oldResolvedPath[i].getSourceAttachmentPath(), newSourcePath, null);
                int flags = sourceAttachmentFlags | (sourceAttachmentRootFlags = this.getSourceAttachmentDeltaFlag(oldResolvedPath[i].getSourceAttachmentRootPath(), newResolvedPath[index].getSourceAttachmentRootPath(), newSourcePath));
                if (flags != 0) {
                    this.addClasspathDeltas(project.computePackageFragmentRoots(oldResolvedPath[i]), flags, delta);
                    hasDelta = true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < newLength) {
            int index = this.classpathContains(oldResolvedPath, newResolvedPath[i]);
            if (index == -1) {
                if (newResolvedPath[i].getEntryKind() == 2) {
                    needToUpdateDependents = true;
                    this.needCycleCheck = true;
                } else {
                    this.addClasspathDeltas(project.computePackageFragmentRoots(newResolvedPath[i]), 64, delta);
                    int changeKind = newResolvedPath[i].getEntryKind();
                    if (indexManager != null) {
                        switch (changeKind) {
                            case 1: {
                                boolean pathHasChanged = true;
                                final IPath newPath = newResolvedPath[i].getPath();
                                int j = 0;
                                while (j < oldLength) {
                                    IClasspathEntry oldEntry = oldResolvedPath[j];
                                    if (oldEntry.getPath().equals(newPath)) {
                                        pathHasChanged = false;
                                        break;
                                    }
                                    ++j;
                                }
                                if (!pathHasChanged) break;
                                this.postAction(new JavaModelOperation.IPostAction(){

                                    public String getID() {
                                        return newPath.toString();
                                    }

                                    public void run() throws JavaModelException {
                                        indexManager.indexLibrary(newPath, project.getProject());
                                    }
                                }, 2);
                                break;
                            }
                            case 3: {
                                IClasspathEntry entry = newResolvedPath[i];
                                final IPath path = entry.getPath();
                                final char[][] exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
                                this.postAction(new JavaModelOperation.IPostAction(){

                                    public String getID() {
                                        return path.toString();
                                    }

                                    public void run() throws JavaModelException {
                                        indexManager.indexSourceFolder(project, path, exclusionPatterns);
                                    }
                                }, 1);
                            }
                        }
                    }
                    needToUpdateDependents |= changeKind == 3 || newResolvedPath[i].isExported();
                    hasDelta = true;
                }
            }
            ++i;
        }
        if (hasDelta) {
            this.addDelta(delta);
        }
        if (needToUpdateDependents) {
            this.updateAffectedProjects(project.getProject().getFullPath());
        }
    }

    protected JavaProject getProject() {
        return (JavaProject)this.getElementsToProcess()[0];
    }

    private int getSourceAttachmentDeltaFlag(IPath oldPath, IPath newPath, IPath sourcePath) {
        if (oldPath == null) {
            if (newPath != null) {
                return 4096;
            }
            if (sourcePath != null) {
                return 12288;
            }
            return 0;
        }
        if (newPath == null) {
            return 8192;
        }
        if (!oldPath.equals(newPath)) {
            return 12288;
        }
        return 0;
    }

    public boolean isReadOnly() {
        return !this.canChangeResource;
    }

    protected void saveClasspathIfNecessary() throws JavaModelException {
        IPath outputLocationForSave;
        IClasspathEntry[] classpathForSave;
        if (!this.canChangeResource || !this.needSave) {
            return;
        }
        JavaProject project = this.getProject();
        if (project.saveClasspath(classpathForSave = this.newRawPath == ReuseClasspath || this.newRawPath == UpdateClasspath ? project.getRawClasspath() : this.newRawPath, outputLocationForSave = this.newOutputLocation == ReuseOutputLocation ? project.getOutputLocation() : this.newOutputLocation)) {
            this.setAttribute("hasModifiedResource", "true");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("SetClasspathOperation\n");
        buffer.append(" - classpath : ");
        if (this.newRawPath == ReuseClasspath) {
            buffer.append("<Reuse Existing Classpath>");
        } else {
            buffer.append("{");
            int i = 0;
            while (i < this.newRawPath.length) {
                if (i > 0) {
                    buffer.append(",");
                }
                IClasspathEntry element = this.newRawPath[i];
                buffer.append(" ").append(element.toString());
                ++i;
            }
        }
        buffer.append("\n - output location : ");
        if (this.newOutputLocation == ReuseOutputLocation) {
            buffer.append("<Reuse Existing Output Location>");
        } else {
            buffer.append(this.newOutputLocation.toString());
        }
        return buffer.toString();
    }

    private void updateClasspath() throws JavaModelException {
        JavaProject project = (JavaProject)this.getElementsToProcess()[0];
        this.beginTask(Util.bind("classpath.settingProgress", project.getElementName()), 2);
        project.setRawClasspath0(this.newRawPath);
        if (this.newResolvedPath == null) {
            this.newResolvedPath = project.getResolvedClasspath(true, this.canChangeResource);
        }
        if (this.oldResolvedPath != null) {
            this.generateClasspathChangeDeltas(this.oldResolvedPath, this.newResolvedPath, project);
        } else {
            this.needCycleCheck = true;
            this.updateAffectedProjects(project.getProject().getFullPath());
        }
        this.updateCycleMarkersIfNecessary(this.newResolvedPath);
    }

    protected void updateAffectedProjects(IPath prerequisiteProjectPath) {
        try {
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            JavaProject originatingProject = this.getProject();
            IJavaProject[] projects = model.getJavaProjects();
            int i = 0;
            int projectCount = projects.length;
            while (i < projectCount) {
                block7: {
                    try {
                        JavaProject project = (JavaProject)projects[i];
                        if (project.equals(originatingProject)) break block7;
                        IClasspathEntry[] classpath = project.getExpandedClasspath(true);
                        int j = 0;
                        int entryCount = classpath.length;
                        while (j < entryCount) {
                            IClasspathEntry entry = classpath[j];
                            if (entry.getEntryKind() == 2 && entry.getPath().equals(prerequisiteProjectPath)) {
                                project.setRawClasspath(UpdateClasspath, ReuseOutputLocation, this.fMonitor, this.canChangeResource, project.getResolvedClasspath(true), false, false);
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    protected void updateCycleMarkersIfNecessary(IClasspathEntry[] newResolvedPath) {
        if (!this.needCycleCheck) {
            return;
        }
        if (!this.canChangeResource) {
            return;
        }
        try {
            JavaProject project = this.getProject();
            if (!project.hasCycleMarker() && !project.hasClasspathCycle(project.getResolvedClasspath(true))) {
                return;
            }
            this.postAction(new JavaModelOperation.IPostAction(){

                public String getID() {
                    return "updateCycleMarkers";
                }

                public void run() throws JavaModelException {
                    JavaProject.updateAllCycleMarkers();
                }
            }, 2);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    protected void updateOutputLocation() throws JavaModelException {
        JavaModelManager.PerProjectInfo perProjectInfo;
        JavaProject project = (JavaProject)this.getElementsToProcess()[0];
        this.beginTask(Util.bind("classpath.settingOutputLocationProgress", project.getElementName()), 2);
        IPath oldLocation = project.getOutputLocation();
        boolean deltaToFire = false;
        JavaElementDelta delta = this.newJavaElementDelta();
        ArrayList added = this.determineAffectedPackageFragments(oldLocation);
        Iterator iter = ((AbstractList)added).iterator();
        while (iter.hasNext()) {
            IPackageFragment frag = (IPackageFragment)iter.next();
            ((IPackageFragmentRoot)frag.getParent()).close();
            if (Util.isExcluded(frag)) continue;
            delta.added(frag);
            deltaToFire = true;
        }
        ArrayList removed = this.determineAffectedPackageFragments(this.newOutputLocation);
        iter = ((AbstractList)removed).iterator();
        while (iter.hasNext()) {
            IPackageFragment frag = (IPackageFragment)iter.next();
            ((IPackageFragmentRoot)frag.getParent()).close();
            if (Util.isExcluded(frag)) continue;
            delta.removed(frag);
            deltaToFire = true;
        }
        JavaModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(project.getProject());
        synchronized (perProjectInfo2) {
            perProjectInfo.outputLocation = this.newOutputLocation;
        }
        if (deltaToFire) {
            this.addDelta(delta);
        }
        this.worked(1);
    }

    protected void updateProjectReferencesIfNecessary() throws JavaModelException {
        if (!this.canChangeResource) {
            return;
        }
        if (this.newRawPath == ReuseClasspath || this.newRawPath == UpdateClasspath) {
            return;
        }
        JavaProject jproject = this.getProject();
        String[] oldRequired = jproject.projectPrerequisites(this.oldResolvedPath);
        if (this.newResolvedPath == null) {
            this.newResolvedPath = jproject.getResolvedClasspath(this.newRawPath, null, true, this.needValidation, null);
        }
        String[] newRequired = jproject.projectPrerequisites(this.newResolvedPath);
        try {
            int newSize;
            HashSet newReferences;
            IProjectDescription description;
            IProject project;
            block13: {
                String projectName;
                project = jproject.getProject();
                description = project.getDescription();
                IProject[] projectReferences = description.getReferencedProjects();
                HashSet<String> oldReferences = new HashSet<String>(projectReferences.length);
                int i = 0;
                while (i < projectReferences.length) {
                    String projectName2 = projectReferences[i].getName();
                    oldReferences.add(projectName2);
                    ++i;
                }
                newReferences = (HashSet)oldReferences.clone();
                int i2 = 0;
                while (i2 < oldRequired.length) {
                    projectName = oldRequired[i2];
                    newReferences.remove(projectName);
                    ++i2;
                }
                i2 = 0;
                while (i2 < newRequired.length) {
                    projectName = newRequired[i2];
                    newReferences.add(projectName);
                    ++i2;
                }
                newSize = newReferences.size();
                if (oldReferences.size() == newSize) {
                    Iterator iter = newReferences.iterator();
                    while (iter.hasNext()) {
                        if (oldReferences.contains(iter.next())) {
                            continue;
                        }
                        break block13;
                    }
                    return;
                }
            }
            String[] requiredProjectNames = new String[newSize];
            int index = 0;
            Iterator iter = newReferences.iterator();
            while (iter.hasNext()) {
                requiredProjectNames[index++] = (String)iter.next();
            }
            Util.sort(requiredProjectNames);
            IProject[] requiredProjectArray = new IProject[newSize];
            IWorkspaceRoot wksRoot = project.getWorkspace().getRoot();
            int i = 0;
            while (i < newSize) {
                requiredProjectArray[i] = wksRoot.getProject(requiredProjectNames[i]);
                ++i;
            }
            description.setReferencedProjects(requiredProjectArray);
            project.setDescription(description, this.fMonitor);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.needValidation) {
            IPath outputLocation;
            IJavaProject project = (IJavaProject)this.getElementToProcess();
            IClasspathEntry[] entries = this.newRawPath;
            if (entries == ReuseClasspath) {
                try {
                    entries = project.getRawClasspath();
                }
                catch (JavaModelException e) {
                    return e.getJavaModelStatus();
                }
            }
            if ((outputLocation = this.newOutputLocation) == ReuseOutputLocation) {
                try {
                    outputLocation = project.getOutputLocation();
                }
                catch (JavaModelException e) {
                    return e.getJavaModelStatus();
                }
            }
            return JavaConventions.validateClasspath(project, entries, outputLocation);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

