/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.ISourceField;
import org.eclipse.jdt.internal.compiler.env.ISourceMethod;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.MemberElementInfo;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceType;

public class SourceTypeElementInfo
extends MemberElementInfo
implements ISourceType {
    protected static final ISourceField[] NO_FIELDS = new ISourceField[0];
    protected static final ISourceMethod[] NO_METHODS = new ISourceMethod[0];
    protected static final ISourceType[] NO_TYPES = new ISourceType[0];
    protected char[] fSuperclassName;
    protected char[][] fSuperInterfaceNames;
    protected char[] fEnclosingTypeName = null;
    protected char[] fSourceFileName = null;
    protected char[] fPackageName = null;
    protected char[] fQualifiedName = null;
    protected char[][] fImports = null;
    protected IType fHandle = null;

    protected void addImport(char[] i) {
        if (this.fImports == null) {
            this.fImports = new char[][]{i};
        } else {
            char[][] copy = new char[this.fImports.length + 1][];
            System.arraycopy(this.fImports, 0, copy, 0, this.fImports.length);
            copy[this.fImports.length] = i;
            this.fImports = copy;
        }
    }

    public ISourceType getEnclosingType() {
        IJavaElement parent = this.fHandle.getParent();
        if (parent != null && parent.getElementType() == 7) {
            try {
                return (ISourceType)((JavaElement)parent).getElementInfo();
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        return null;
    }

    public char[] getEnclosingTypeName() {
        return this.fEnclosingTypeName;
    }

    public ISourceField[] getFields() {
        int length = this.fChildren.length;
        if (length == 0) {
            return NO_FIELDS;
        }
        ISourceField[] fields = new ISourceField[length];
        int fieldIndex = 0;
        int i = 0;
        while (i < length) {
            IJavaElement child = this.fChildren[i];
            if (child instanceof SourceField) {
                try {
                    ISourceField field = (ISourceField)((SourceField)child).getElementInfo();
                    fields[fieldIndex++] = field;
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (fieldIndex == 0) {
            return NO_FIELDS;
        }
        ISourceField[] iSourceFieldArray = fields;
        fields = new ISourceField[fieldIndex];
        System.arraycopy(iSourceFieldArray, 0, fields, 0, fieldIndex);
        return fields;
    }

    public char[] getFileName() {
        return this.fSourceFileName;
    }

    public IType getHandle() {
        return this.fHandle;
    }

    public char[][] getImports() {
        return this.fImports;
    }

    public char[][] getInterfaceNames() {
        return this.fSuperInterfaceNames;
    }

    public ISourceType[] getMemberTypes() {
        int length = this.fChildren.length;
        if (length == 0) {
            return NO_TYPES;
        }
        ISourceType[] memberTypes = new ISourceType[length];
        int typeIndex = 0;
        int i = 0;
        while (i < length) {
            IJavaElement child = this.fChildren[i];
            if (child instanceof SourceType) {
                try {
                    ISourceType type = (ISourceType)((SourceType)child).getElementInfo();
                    memberTypes[typeIndex++] = type;
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (typeIndex == 0) {
            return NO_TYPES;
        }
        ISourceType[] iSourceTypeArray = memberTypes;
        memberTypes = new ISourceType[typeIndex];
        System.arraycopy(iSourceTypeArray, 0, memberTypes, 0, typeIndex);
        return memberTypes;
    }

    public ISourceMethod[] getMethods() {
        int length = this.fChildren.length;
        if (length == 0) {
            return NO_METHODS;
        }
        ISourceMethod[] methods = new ISourceMethod[length];
        int methodIndex = 0;
        int i = 0;
        while (i < length) {
            IJavaElement child = this.fChildren[i];
            if (child instanceof SourceMethod) {
                try {
                    ISourceMethod method = (ISourceMethod)((SourceMethod)child).getElementInfo();
                    methods[methodIndex++] = method;
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (methodIndex == 0) {
            return NO_METHODS;
        }
        ISourceMethod[] iSourceMethodArray = methods;
        methods = new ISourceMethod[methodIndex];
        System.arraycopy(iSourceMethodArray, 0, methods, 0, methodIndex);
        return methods;
    }

    public char[] getPackageName() {
        return this.fPackageName;
    }

    public char[] getQualifiedName() {
        return this.fQualifiedName;
    }

    public char[] getSuperclassName() {
        return this.fSuperclassName;
    }

    public boolean isBinaryType() {
        return false;
    }

    public boolean isClass() {
        return (this.flags & 0x200) == 0;
    }

    public boolean isInterface() {
        return (this.flags & 0x200) != 0;
    }

    protected void setEnclosingTypeName(char[] enclosingTypeName) {
        this.fEnclosingTypeName = enclosingTypeName;
    }

    protected void setHandle(IType handle) {
        this.fHandle = handle;
    }

    protected void setPackageName(char[] name) {
        this.fPackageName = name;
    }

    protected void setQualifiedName(char[] name) {
        this.fQualifiedName = name;
    }

    protected void setSourceFileName(char[] name) {
        this.fSourceFileName = name;
    }

    protected void setSuperclassName(char[] superclassName) {
        this.fSuperclassName = superclassName;
    }

    protected void setSuperInterfaceNames(char[][] superInterfaceNames) {
        this.fSuperInterfaceNames = superInterfaceNames;
    }

    public String toString() {
        return "Info for " + this.fHandle.toString();
    }
}

