/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;

public class ClasspathJar
extends ClasspathLocation {
    String zipFilename;
    IFile resource;
    ZipFile zipFile;
    boolean closeZipFileAtEnd;
    SimpleLookupTable packageCache;

    ClasspathJar(String zipFilename) {
        this.zipFilename = zipFilename;
        this.zipFile = null;
        this.packageCache = null;
    }

    ClasspathJar(IFile resource) {
        this.resource = resource;
        IPath location = resource.getLocation();
        this.zipFilename = location != null ? location.toString() : "";
        this.zipFile = null;
        this.packageCache = null;
    }

    public ClasspathJar(ZipFile zipFile) {
        this.zipFilename = zipFile.getName();
        this.zipFile = zipFile;
        this.closeZipFileAtEnd = false;
        this.packageCache = null;
    }

    public void cleanup() {
        if (this.zipFile != null && this.closeZipFileAtEnd) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.zipFile = null;
        }
        this.packageCache = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathJar)) {
            return false;
        }
        return this.zipFilename.equals(((ClasspathJar)o).zipFilename);
    }

    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        try {
            ClassFileReader reader = ClassFileReader.read(this.zipFile, qualifiedBinaryFileName);
            if (reader != null) {
                return new NameEnvironmentAnswer(reader);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public IPath getProjectRelativePath() {
        if (this.resource == null) {
            return null;
        }
        return this.resource.getProjectRelativePath();
    }

    public boolean isPackage(String qualifiedPackageName) {
        if (this.packageCache != null) {
            return this.packageCache.containsKey(qualifiedPackageName);
        }
        this.packageCache = new SimpleLookupTable(41);
        this.packageCache.put("", "");
        try {
            if (this.zipFile == null) {
                this.zipFile = new ZipFile(this.zipFilename);
                this.closeZipFileAtEnd = true;
            }
            Enumeration<? extends ZipEntry> e = this.zipFile.entries();
            block2: while (e.hasMoreElements()) {
                String fileName = e.nextElement().getName();
                int last = fileName.lastIndexOf(47);
                while (last > 0) {
                    String packageName = fileName.substring(0, last);
                    if (this.packageCache.containsKey(packageName)) continue block2;
                    this.packageCache.put(packageName, packageName);
                    last = packageName.lastIndexOf(47);
                }
            }
            return this.packageCache.containsKey(qualifiedPackageName);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return "Classpath jar file " + this.zipFilename;
    }
}

